/*
 * Decompiled with CFR 0.152.
 */
package JaideepSinghHeer.Minecraft.mod;

import JaideepSinghHeer.Minecraft.mod.PropertyManagerClient;
import JaideepSinghHeer.Minecraft.mod.SPLANtransformerPort;
import com.google.common.collect.Lists;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import java.io.File;
import java.util.Map;
import java.util.regex.Pattern;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.DummyModContainer;
import net.minecraftforge.fml.common.LoadController;
import net.minecraftforge.fml.common.ModMetadata;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.relauncher.IFMLLoadingPlugin;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ServerPropertiesLAN
extends DummyModContainer
implements IFMLLoadingPlugin {
    public int port = -1;
    public static final String MODID = "serverpropertieslan";
    public static final String MODNAME = "Server Properties LAN";
    public static final String VERSION = "2";
    private PropertyManagerClient ServerProperties = null;
    private static final Logger LOGGER = LogManager.getLogger();
    public static ServerPropertiesLAN instance;

    public ServerPropertiesLAN() {
        super(new ModMetadata());
        System.out.println("-=-=-=-=-=-=-=ServerPropertiesLAN-Constructed=-=-=-=-=-=-=-");
        instance = this;
        ModMetadata md = this.getMetadata();
        md.modId = MODID;
        md.version = VERSION;
        md.name = MODNAME;
        md.authorList = Lists.newArrayList((Object[])new String[]{"Jaideep Singh Heer"});
        md.description = "MeoW.!";
        md.credits = "by Jaideep Singh Heer";
        md.logoFile = "logo.png";
        md.screenshots = new String[]{"scr1.jpg", "scr2.jpg", "logo2.png"};
        md.url = "https://minecraft.curseforge.com/projects/server-properties-for-lan";
    }

    public boolean registerBus(EventBus bus, LoadController controller) {
        bus.register((Object)this);
        return true;
    }

    @Subscribe
    public void onServerStarting(FMLServerStartingEvent event) {
        System.out.println("========================>> Server Starting !");
        this.ServerProperties = new PropertyManagerClient(new File(DimensionManager.getCurrentSaveRootDirectory() + "\\server.properties"));
        LOGGER.warn(DimensionManager.getCurrentSaveRootDirectory() + "\\server.properties");
        this.port = this.ServerProperties.getIntProperty("port", 25565);
        System.out.println("-------------------> Port Read : " + this.port);
        event.getServer().func_71229_d(this.ServerProperties.getBooleanProperty("online-mode", true));
        event.getServer().func_71251_e(this.ServerProperties.getBooleanProperty("spawn-animals", true));
        event.getServer().func_71257_f(this.ServerProperties.getBooleanProperty("spawn-npcs", true));
        event.getServer().func_71188_g(this.ServerProperties.getBooleanProperty("pvp", true));
        event.getServer().func_71245_h(this.ServerProperties.getBooleanProperty("allow-flight", false));
        event.getServer().func_180507_a_(this.ServerProperties.getStringProperty("resource-pack-sha1", ""), this.loadResourcePackSHA());
        event.getServer().func_71205_p(this.ServerProperties.getStringProperty("motd", "<! " + event.getServer().func_71214_G() + "'s " + event.getServer().field_71305_c[0].func_72912_H().func_76065_j() + " ON LAN !>"));
        event.getServer().func_143006_e(this.ServerProperties.getIntProperty("player-idle-timeout", 0));
        event.getServer().func_71191_d(this.ServerProperties.getIntProperty("max-build-height", 256));
    }

    public String[] getASMTransformerClass() {
        return new String[]{SPLANtransformerPort.class.getCanonicalName()};
    }

    public String getModContainerClass() {
        return ServerPropertiesLAN.class.getCanonicalName();
    }

    public String getSetupClass() {
        return null;
    }

    public void injectData(Map<String, Object> data) {
    }

    public String getAccessTransformerClass() {
        return null;
    }

    private String loadResourcePackSHA() {
        String s;
        if (this.ServerProperties.hasProperty("resource-pack-hash")) {
            if (this.ServerProperties.hasProperty("resource-pack-sha1")) {
                LOGGER.warn("resource-pack-hash is deprecated and found along side resource-pack-sha1. resource-pack-hash will be ignored.");
            } else {
                LOGGER.warn("resource-pack-hash is deprecated. Please use resource-pack-sha1 instead.");
                this.ServerProperties.getStringProperty("resource-pack-sha1", this.ServerProperties.getStringProperty("resource-pack-hash", ""));
                this.ServerProperties.removeProperty("resource-pack-hash");
            }
        }
        if (!(s = this.ServerProperties.getStringProperty("resource-pack-sha1", "")).isEmpty() && !Pattern.compile("^[a-fA-F0-9]{40}$").matcher(s).matches()) {
            LOGGER.warn("Invalid sha1 for ressource-pack-sha1");
        }
        if (!this.ServerProperties.getStringProperty("resource-pack", "").isEmpty() && s.isEmpty()) {
            LOGGER.warn("You specified a resource pack without providing a sha1 hash. Pack will be updated on the client only if you change the name of the pack.");
        }
        return s;
    }
}

