/*
 * Decompiled with CFR 0.152.
 */
package com.tmtravlr.lootplusplus;

import com.tmtravlr.lootplusplus.additions.EntityAddedThrownItem;
import com.tmtravlr.lootplusplus.additions.ItemAddedBow;
import com.tmtravlr.lootplusplus.additions.ItemAddedGun;
import com.tmtravlr.lootplusplus.additions.ItemAddedThrowable;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MathHelper;

public class LPPEntityAIRangedAttack
extends EntityAIBase {
    public final EntityLiving entityHost;
    public final IRangedAttackMob rangedAttackEntityHost;
    public EntityLivingBase attackTarget;
    public int rangedAttackTime = -1;
    public double entityMoveSpeed;
    public int timeSeen;
    public int baseRangedAttackTime;
    public int maxRangedAttackTime;
    public float maxAttackDistance;
    public float maxAttackDistanceSquared;

    public LPPEntityAIRangedAttack(IRangedAttackMob attackMob, double moveSpeedToSet, int attackTimeToSet, float maxDistanceToSet) {
        this(attackMob, moveSpeedToSet, attackTimeToSet, attackTimeToSet, maxDistanceToSet);
    }

    public LPPEntityAIRangedAttack(IRangedAttackMob attackMob, double moveSpeedToSet, int baseAttackTimeToSet, int maxAttackTimeToSet, float maxDistanceToSet) {
        if (!(attackMob instanceof EntityLivingBase)) {
            throw new IllegalArgumentException("ArrowAttackGoal requires Mob implements RangedAttackMob");
        }
        this.rangedAttackEntityHost = attackMob;
        this.entityHost = (EntityLiving)attackMob;
        this.entityMoveSpeed = moveSpeedToSet;
        this.baseRangedAttackTime = baseAttackTimeToSet;
        this.maxRangedAttackTime = maxAttackTimeToSet;
        this.maxAttackDistance = maxDistanceToSet;
        this.maxAttackDistanceSquared = maxDistanceToSet * maxDistanceToSet;
        this.func_75248_a(3);
    }

    public boolean func_75250_a() {
        EntityLivingBase entitylivingbase = this.entityHost.func_70638_az();
        if (entitylivingbase == null) {
            return false;
        }
        this.attackTarget = entitylivingbase;
        return true;
    }

    public boolean func_75253_b() {
        return this.func_75250_a() || !this.entityHost.func_70661_as().func_75500_f();
    }

    public void func_75251_c() {
        this.attackTarget = null;
        this.timeSeen = 0;
        this.rangedAttackTime = -1;
    }

    public void func_75246_d() {
        ItemStack heldStack;
        double d0 = this.entityHost.func_70092_e(this.attackTarget.field_70165_t, this.attackTarget.func_174813_aQ().field_72338_b, this.attackTarget.field_70161_v);
        boolean flag = this.entityHost.func_70635_at().func_75522_a((Entity)this.attackTarget);
        this.timeSeen = flag ? ++this.timeSeen : 0;
        if (d0 <= (double)this.maxAttackDistanceSquared && this.timeSeen >= 20) {
            this.entityHost.func_70661_as().func_75499_g();
        } else {
            this.entityHost.func_70661_as().func_75497_a((Entity)this.attackTarget, this.entityMoveSpeed);
        }
        this.entityHost.func_70671_ap().func_75651_a((Entity)this.attackTarget, 30.0f, 30.0f);
        ItemAddedBow bow = null;
        ItemAddedThrowable throwable = null;
        ItemAddedGun gun = null;
        if (this.rangedAttackEntityHost instanceof EntityLivingBase && (heldStack = ((EntityLivingBase)this.rangedAttackEntityHost).func_70694_bm()) != null && heldStack.func_77973_b() != null) {
            if (heldStack.func_77973_b() instanceof ItemAddedBow) {
                bow = (ItemAddedBow)heldStack.func_77973_b();
                if (bow.ammoItem instanceof ItemAddedThrowable) {
                    throwable = (ItemAddedThrowable)bow.ammoItem;
                }
            } else if (heldStack.func_77973_b() instanceof ItemAddedThrowable) {
                throwable = (ItemAddedThrowable)heldStack.func_77973_b();
            } else if (heldStack.func_77973_b() instanceof ItemAddedGun) {
                gun = (ItemAddedGun)heldStack.func_77973_b();
                throwable = gun.shotItem;
            }
        }
        float speedMultiplier = 1.0f;
        if (bow != null) {
            speedMultiplier = (float)bow.drawTime / 20.0f;
        }
        if (gun != null) {
            speedMultiplier = gun.getWaitTime(((EntityLivingBase)this.rangedAttackEntityHost).func_70694_bm()) / 20;
        }
        if (--this.rangedAttackTime <= 0) {
            if (d0 > (double)this.maxAttackDistanceSquared || !flag) {
                return;
            }
            int arrowCount = 1;
            float baseDamage = 0.0f;
            String customSound = "random.bow";
            if (bow != null) {
                arrowCount = bow.arrowCount;
                if (arrowCount < 1) {
                    arrowCount = 1;
                }
                baseDamage = bow.baseDamage;
                customSound = bow.shootingSound;
            }
            if (gun != null) {
                arrowCount = gun.bulletCount;
                if (arrowCount < 1) {
                    arrowCount = 1;
                }
                baseDamage = gun.baseDamage;
                customSound = gun.shootingSound;
            }
            float f = MathHelper.func_76133_a((double)d0) / this.maxAttackDistance;
            float f1 = MathHelper.func_76131_a((float)f, (float)0.1f, (float)1.0f);
            for (int i = 0; i < arrowCount; ++i) {
                if (bow != null && bow.ammoItem == Items.field_151032_g) {
                    this.rangedAttackEntityHost.func_82196_d(this.attackTarget, f1 + baseDamage / 2.0f);
                    continue;
                }
                if (throwable == null) continue;
                int power = EnchantmentHelper.func_77506_a((int)Enchantment.field_77345_t.field_77352_x, (ItemStack)this.entityHost.func_70694_bm());
                int punch = EnchantmentHelper.func_77506_a((int)Enchantment.field_77344_u.field_77352_x, (ItemStack)this.entityHost.func_70694_bm());
                if (baseDamage > 0.0f && throwable.damage > 0.0f) {
                    if (bow != null) {
                        baseDamage += (float)power * 0.5f + 0.5f;
                    } else if (gun != null) {
                        baseDamage += (float)power * 1.25f;
                    }
                }
                this.attackEntityWithThrown(throwable, baseDamage, punch, customSound);
            }
            this.setRangedAttackTime(speedMultiplier, f, gun);
        } else if (this.rangedAttackTime < 0) {
            float f = MathHelper.func_76133_a((double)d0) / this.maxAttackDistance;
            this.setRangedAttackTime(speedMultiplier, f, gun);
        }
    }

    private void setRangedAttackTime(float speedMultiplier, float distance, ItemAddedGun gun) {
        this.rangedAttackTime = gun != null ? gun.waitTime : MathHelper.func_76141_d((float)(speedMultiplier * (distance * (float)(this.maxRangedAttackTime - this.baseRangedAttackTime) + (float)this.baseRangedAttackTime)));
    }

    public void attackEntityWithThrown(ItemAddedThrowable throwable, float extraDamage, int punch, String customSound) {
        EntityAddedThrownItem.nextVelocity = throwable.velocity;
        EntityAddedThrownItem thrown = new EntityAddedThrownItem(this.entityHost.field_70170_p, (EntityLivingBase)this.entityHost, throwable);
        thrown.damage += extraDamage;
        thrown.punch += (float)punch;
        double d0 = this.attackTarget.field_70165_t - this.entityHost.field_70165_t;
        double d1 = this.attackTarget.field_70163_u + (double)this.attackTarget.func_70047_e() - (double)1.1f - thrown.field_70163_u;
        double d2 = this.attackTarget.field_70161_v - this.entityHost.field_70161_v;
        float f1 = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2)) * 0.2f;
        thrown.func_70186_c(d0, d1 + (double)f1, d2, 1.6f, 12.0f);
        this.entityHost.func_85030_a(customSound, 1.0f, 1.0f / (this.entityHost.func_70681_au().nextFloat() * 0.4f + 0.8f));
        this.entityHost.field_70170_p.func_72838_d((Entity)thrown);
    }
}

