/*
 * Decompiled with CFR 0.152.
 */
package com.tmtravlr.lootplusplus;

import com.tmtravlr.lootplusplus.LootPPHelper;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.EntityList;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.oredict.OreDictionary;

public class LootPPIDFileGenerator {
    public static void generateDimensionIDFile() {
        File dimensionIds = new File(LootPPHelper.idFolder, "Dimension IDs.txt");
        try {
            PrintStream writeStream = new PrintStream(dimensionIds);
            writeStream.println("## Dimension IDs                                                      ##");
            writeStream.println("########################################################################");
            writeStream.println("## In the form:                                                       ##");
            writeStream.println("## <dimension id>                                                     ##");
            writeStream.println("##    - Name: <dimension name>                                        ##");
            writeStream.println("##    - Height: <dimension height>                                    ##");
            writeStream.println("##    - Has Sky? <true if dimension has a sky>                        ##");
            writeStream.println("##    - Cloud Height: <height of dimension's clouds (only on client)> ##");
            writeStream.println("##    - Can Respawn Here? <true if players can respawn here>          ##");
            writeStream.println("##    - Terrain Scale: <distance travelled per block (nether is 8)>   ##");
            writeStream.println("########################################################################");
            if (MinecraftServer.func_71276_C().field_71305_c.length != 0) {
                for (WorldServer world : MinecraftServer.func_71276_C().field_71305_c) {
                    writeStream.println(world.field_73011_w.func_177502_q());
                    writeStream.println("\t- Name: " + world.field_73011_w.func_80007_l());
                    writeStream.println("\t- Height: " + world.field_73011_w.getActualHeight());
                    writeStream.println("\t- Has Sky? " + !world.field_73011_w.func_177495_o());
                    if (MinecraftServer.func_71276_C() != null && MinecraftServer.func_71276_C().func_71264_H()) {
                        writeStream.println("\t- Cloud Height: " + world.field_73011_w.func_76571_f());
                    }
                    writeStream.println("\t- Can Respawn Here? " + world.field_73011_w.func_76567_e());
                    writeStream.println("\t- Terrain Scale: " + world.field_73011_w.getMovementFactor());
                    writeStream.println();
                    writeStream.println();
                }
            }
            writeStream.close();
        }
        catch (IOException x) {
            System.err.format("IOException: %s%n", x);
        }
    }

    public static void generateIDFiles() {
        boolean singleplayer = MinecraftServer.func_71276_C() != null && MinecraftServer.func_71276_C().func_71264_H();
        File blockItemIds = new File(LootPPHelper.idFolder, "Block and Item IDs.txt");
        File biomeIds = new File(LootPPHelper.idFolder, "Biome IDs.txt");
        File entityIds = new File(LootPPHelper.idFolder, "Entity IDs.txt");
        File effectIds = new File(LootPPHelper.idFolder, "Effect IDs.txt");
        File enchantIds = new File(LootPPHelper.idFolder, "Enchantment IDs.txt");
        File foods = new File(LootPPHelper.idFolder, "Food and Drink Info.txt");
        File oreDictionary = new File(LootPPHelper.idFolder, "Ore Dictionary Info.txt");
        try {
            BiomeGenBase[] key32;
            PrintStream writeStream = new PrintStream(blockItemIds);
            writeStream.println("## Item and Block IDs: in the form <string id> - <number id> ##");
            ArrayList itemResources = new ArrayList(Item.field_150901_e.func_148742_b());
            ArrayList<String> itemNames = new ArrayList<String>();
            for (ResourceLocation resourceLocation : itemResources) {
                itemNames.add(resourceLocation.toString());
            }
            Collections.sort(itemNames);
            for (String string : itemNames) {
                if (Item.func_111206_d((String)string) == null) continue;
                writeStream.println(string + " - " + Item.func_150891_b((Item)Item.func_111206_d((String)string)));
            }
            writeStream.close();
            writeStream = new PrintStream(entityIds);
            writeStream.println("## Entity IDs ##");
            ArrayList entityStrings = new ArrayList(EntityList.field_75625_b.keySet());
            Collections.sort(entityStrings);
            for (BiomeGenBase[] key32 : entityStrings) {
                writeStream.println((String)key32);
            }
            writeStream.println("## Spawn Egg IDs: in the form <number id> - <entity string id (which it spawns)> ##");
            ArrayList arrayList = new ArrayList(EntityList.field_75627_a.keySet());
            Collections.sort(arrayList);
            key32 = arrayList.iterator();
            while (key32.hasNext()) {
                int key4 = (Integer)key32.next();
                EntityList.EntityEggInfo info = (EntityList.EntityEggInfo)EntityList.field_75627_a.get(key4);
                writeStream.println("" + key4 + " - " + (String)EntityList.field_75626_c.get(EntityList.field_75623_d.get(key4)));
            }
            writeStream.close();
            writeStream = new PrintStream(biomeIds);
            writeStream.println("## Biome IDs                                           ##");
            writeStream.println("#########################################################");
            writeStream.println("## In the form:                                        ##");
            writeStream.println("## <biome id>                                          ##");
            writeStream.println("##    - Name: <biome name>                             ##");
            writeStream.println("##    - Forge Biome Types: <list of forge biome types> ##");
            writeStream.println("#########################################################");
            for (BiomeGenBase biomeGenBase : BiomeGenBase.func_150565_n()) {
                if (biomeGenBase == null) continue;
                writeStream.println(biomeGenBase.field_76756_M);
                writeStream.println("\t- Name: " + biomeGenBase.field_76791_y);
                writeStream.print("\t- Forge Biome Types: ");
                for (BiomeDictionary.Type type : BiomeDictionary.getTypesForBiome((BiomeGenBase)biomeGenBase)) {
                    writeStream.print(type.name() + " ");
                }
                writeStream.println();
                writeStream.println();
            }
            writeStream.close();
            writeStream = new PrintStream(effectIds);
            writeStream.println("## Effect IDs                                                        ##");
            writeStream.println("#######################################################################");
            writeStream.println("## In the form:                                                      ##");
            writeStream.println("## <effect id>                                                       ##");
            writeStream.println("##    - Name: <effect name>                                          ##");
            writeStream.println("##    - Color: <effect color>                                        ##");
            writeStream.println("##    - Is Instant? <true if an instant effect (like health)>        ##");
            writeStream.println("##    - Is Bad? <true if considered a 'bad' effect (only on client)> ##");
            writeStream.println("#######################################################################");
            for (BiomeGenBase biomeGenBase : Potion.field_76425_a) {
                if (biomeGenBase == null) continue;
                writeStream.println(biomeGenBase.field_76415_H);
                writeStream.println("\t- Name: " + biomeGenBase.func_76393_a());
                writeStream.println("\t- Color: " + biomeGenBase.func_76401_j());
                writeStream.println("\t- Is Instant? " + biomeGenBase.func_76403_b());
                if (singleplayer) {
                    writeStream.println("\t- Is Bad? " + biomeGenBase.func_76398_f());
                }
                writeStream.println();
                writeStream.println();
            }
            writeStream.close();
            writeStream = new PrintStream(enchantIds);
            writeStream.println("## Enchantment IDs                                ##");
            writeStream.println("####################################################");
            writeStream.println("## In the form:                                   ##");
            writeStream.println("## <enchantment id>                               ##");
            writeStream.println("##    - Name: <enchantment name>                  ##");
            writeStream.println("##    - Weight: <enchantment weight (rarity)>     ##");
            writeStream.println("##    - Min Level: <min xp level for enchantment> ##");
            writeStream.println("##    - Max Level: <max xp level for enchantment> ##");
            writeStream.println("####################################################");
            for (int i = 0; i < 256; ++i) {
                Enchantment enchant = Enchantment.func_180306_c((int)i);
                if (enchant == null) continue;
                writeStream.println(enchant.field_77352_x);
                writeStream.println("\t- Name: " + enchant.func_77320_a());
                writeStream.println("\t- Weight: " + enchant.func_77324_c());
                writeStream.println("\t- Min Level: " + enchant.func_77319_d());
                writeStream.println("\t- Max Level: " + enchant.func_77325_b());
                writeStream.println();
                writeStream.println();
            }
            writeStream.close();
            writeStream = new PrintStream(foods);
            writeStream.println("## Foods and Drinks (Note it's still a bit WIP)                ##");
            writeStream.println("#################################################################");
            writeStream.println("## In the form:                                                ##");
            writeStream.println("## <effect id>                                                 ##");
            writeStream.println("##    - Metadata: <item metadata>                              ##");
            writeStream.println("##    - Food or Drink? <Food or Drink (or Unknown)>            ##");
            writeStream.println("##    - Food Amount: <Number of food points restored>          ##");
            writeStream.println("##    - Saturation Amount: <Number of saturation points given> ##");
            writeStream.println("################################################################");
            for (String key5 : itemNames) {
                if (Item.func_111206_d((String)key5) == null) continue;
                Item possibleItem = Item.func_111206_d((String)key5);
                try {
                    possibleItem.func_77614_k();
                    ArrayList<ItemStack> arrayList2 = new ArrayList<ItemStack>();
                    if (singleplayer) {
                        possibleItem.func_150895_a(possibleItem, CreativeTabs.field_78027_g, arrayList2);
                    }
                    if (arrayList2.isEmpty()) {
                        arrayList2.add(new ItemStack(possibleItem));
                    }
                    for (ItemStack itemStack : arrayList2) {
                        EnumAction action = itemStack.func_77975_n();
                        if (itemStack.func_77973_b() instanceof ItemFood) {
                            ItemFood itemFood = (ItemFood)itemStack.func_77973_b();
                            writeStream.println(key5);
                            writeStream.println("\t- Megadata: " + itemStack.func_77952_i());
                            writeStream.println("\t- Food or Drink? " + (action == EnumAction.EAT ? "Food" : (action == EnumAction.DRINK ? "Drink" : "Unknown")));
                            writeStream.println("\t- Food Amount: " + itemFood.func_150905_g(new ItemStack((Item)itemFood)));
                            writeStream.println("\t- Saturation Amount: " + itemFood.func_150906_h(new ItemStack((Item)itemFood)));
                            writeStream.println();
                            writeStream.println();
                            continue;
                        }
                        if (action != EnumAction.EAT && action != EnumAction.DRINK) continue;
                        writeStream.println(key5);
                        writeStream.println("\t- Megadata: " + itemStack.func_77952_i());
                        writeStream.println("\t- Food or Drink? " + (action == EnumAction.EAT ? "Food" : (action == EnumAction.DRINK ? "Drink" : "Unknown")));
                        writeStream.println("\t- Food Info Unknown!");
                        writeStream.println();
                        writeStream.println();
                    }
                }
                catch (Exception exception) {
                    System.out.println("[Loot++] Caught Exception while writing food and drink info file.");
                    exception.printStackTrace();
                }
            }
            writeStream.close();
            writeStream = new PrintStream(oreDictionary);
            writeStream.println("## Ore Dictionary Info                      ##");
            writeStream.println("##############################################");
            writeStream.println("## In the form:                             ##");
            writeStream.println("## <ore dictionary entry>                   ##");
            writeStream.println("##     <item id registered> - <item damage> ##");
            writeStream.println("##     etc...                               ##");
            writeStream.println("##############################################");
            List<String> registeredEntries = Arrays.asList(OreDictionary.getOreNames());
            Collections.sort(registeredEntries);
            for (String entry : registeredEntries) {
                writeStream.println(entry);
                for (ItemStack stack : OreDictionary.getOres((String)entry)) {
                    writeStream.println(Item.field_150901_e.func_177774_c((Object)stack.func_77973_b()) + " - " + (stack.func_77952_i() == Short.MAX_VALUE ? "any" : Integer.valueOf(stack.func_77952_i())));
                }
                writeStream.println();
                writeStream.println();
            }
            writeStream.close();
        }
        catch (IOException x) {
            System.err.format("IOException: %s%n", x);
        }
    }
}

