/*
 * Decompiled with CFR 0.152.
 */
package com.tmtravlr.lootplusplus;

import java.util.ArrayList;
import java.util.List;

public class LootPPNotifier {
    public static List<String> notificationList = new ArrayList<String>();

    public static void notify(boolean comment, String notification) {
        if (!comment) {
            notificationList.add(notification);
        }
    }

    public static void notify(boolean comment, String prefix, String notification) {
        if (!comment) {
            notificationList.add(prefix + ": " + notification);
        }
    }

    public static void notifyNonexistant(boolean comment, String prefix, String nonexistant) {
        if (!comment) {
            notificationList.add(prefix + ": The following block or item doesn't seem to exist: '" + nonexistant + "'.");
        }
    }

    public static void notifyNumber(boolean comment, String prefix, String ... numbers) {
        String numberString = "";
        for (int i = 0; i < numbers.length; ++i) {
            numberString = numberString + numbers[i] + (i == numbers.length - 1 ? "" : ", ");
        }
        LootPPNotifier.notifyNumber(comment, prefix, numberString);
    }

    public static void notifyNumber(boolean comment, String prefix, String numbers) {
        if (!comment) {
            notificationList.add(prefix + ": Problem while loading one of these numbers: " + numbers);
        }
    }

    public static void notifyNBT(boolean comment, String prefix, String nbt, String message) {
        if (!comment) {
            notificationList.add(prefix + ": Problem while loading NBT: '" + message + "' for '" + nbt + "'.");
        }
    }

    public static void notifyWrongNumberOfParts(boolean comment, String prefix, String entry) {
        if (!comment) {
            notificationList.add(prefix + ": Entry had wrong number of parts" + (LootPPNotifier.underscoreProblem(entry) ? " (better check those underscores)" : "") + ": '" + entry + "'.");
        }
    }

    private static boolean underscoreProblem(String entry) {
        if (!entry.contains("____")) {
            return false;
        }
        if (entry.contains("______")) {
            return true;
        }
        int fourCount = 0;
        int index = 0;
        while (index < entry.length() && entry.indexOf("____", index) > 0) {
            ++fourCount;
            index = entry.indexOf("____", index) + 1;
        }
        int fiveCount = 0;
        int index2 = 0;
        while (index2 < entry.length() && entry.indexOf("_____", index2) > 0) {
            ++fiveCount;
            index2 = entry.indexOf("_____", index2) + 1;
        }
        return fourCount != fiveCount * 2;
    }
}

