/*
 * Decompiled with CFR 0.152.
 */
package com.tmtravlr.lootplusplus.additions;

import com.tmtravlr.lootplusplus.additions.BlockAdded;
import com.tmtravlr.lootplusplus.additions.InterfaceBlockAdded;
import com.tmtravlr.lootplusplus.effects.GiveEffects;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockState;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockAddedCake
extends BlockAdded
implements InterfaceBlockAdded {
    public static final PropertyInteger BITES2 = PropertyInteger.func_177719_a((String)"bites", (int)0, (int)1);
    public static final PropertyInteger BITES3 = PropertyInteger.func_177719_a((String)"bites", (int)0, (int)2);
    public static final PropertyInteger BITES4 = PropertyInteger.func_177719_a((String)"bites", (int)0, (int)3);
    public static final PropertyInteger BITES5 = PropertyInteger.func_177719_a((String)"bites", (int)0, (int)4);
    public static final PropertyInteger BITES6 = PropertyInteger.func_177719_a((String)"bites", (int)0, (int)5);
    public static final PropertyInteger BITES7 = PropertyInteger.func_177719_a((String)"bites", (int)0, (int)6);
    public static final PropertyInteger BITES8 = PropertyInteger.func_177719_a((String)"bites", (int)0, (int)7);
    public static final PropertyInteger BITES9 = PropertyInteger.func_177719_a((String)"bites", (int)0, (int)8);
    public static final PropertyInteger BITES10 = PropertyInteger.func_177719_a((String)"bites", (int)0, (int)9);
    public static final PropertyInteger BITES11 = PropertyInteger.func_177719_a((String)"bites", (int)0, (int)10);
    public static final PropertyInteger BITES12 = PropertyInteger.func_177719_a((String)"bites", (int)0, (int)11);
    public static final PropertyInteger BITES13 = PropertyInteger.func_177719_a((String)"bites", (int)0, (int)12);
    public static final PropertyInteger BITES14 = PropertyInteger.func_177719_a((String)"bites", (int)0, (int)13);
    public static final PropertyInteger BITES15 = PropertyInteger.func_177719_a((String)"bites", (int)0, (int)14);
    public static final PropertyInteger BITES16 = PropertyInteger.func_177719_a((String)"bites", (int)0, (int)15);
    public static int nextNumBites = 7;
    public PropertyInteger bites;
    public int numBites = 7;
    public int hunger = 2;
    public float saturation = 0.1f;
    public boolean alwaysEdible = false;
    public ArrayList<GiveEffects.EffectInfo> effects = new ArrayList();
    public double height = 0.5;
    public double width = 0.0625;

    public BlockAddedCake(float slip, int numBites, int hungerRestored, float saturationRestored, boolean alwaysEdible, String display) {
        super(Material.field_151568_F, 0, false, "none", -1, slip, display);
        this.numBites = numBites;
        this.bites = this.getPropertyFromNumBites(numBites);
        this.alwaysEdible = alwaysEdible;
        this.hunger = hungerRestored;
        this.saturation = saturationRestored;
        if (this.bites != null) {
            this.func_180632_j(this.func_176223_P().func_177226_a((IProperty)this.bites, (Comparable)Integer.valueOf(0)));
        }
    }

    private float getBiteDistance(IBlockState state) {
        int currentBites = 0;
        if (this.bites != null) {
            currentBites = (Integer)state.func_177229_b((IProperty)this.bites);
        }
        return (float)currentBites * (float)(1.0 - 2.0 * this.width) / (float)this.numBites;
    }

    public void func_180654_a(IBlockAccess worldIn, BlockPos pos) {
        float biteDistance = this.getBiteDistance(worldIn.func_180495_p(pos));
        this.func_149676_a((float)this.width + biteDistance, 0.0f, (float)this.width, 1.0f - (float)this.width, (float)this.height, 1.0f - (float)this.width);
    }

    public void func_149683_g() {
        this.func_149676_a((float)this.width, 0.0f, (float)this.width, 1.0f - (float)this.width, (float)this.height, 1.0f - (float)this.width);
    }

    public AxisAlignedBB func_180640_a(World worldIn, BlockPos pos, IBlockState state) {
        float biteDistance = this.getBiteDistance(state);
        return new AxisAlignedBB((double)pos.func_177958_n() + this.width + (double)biteDistance, (double)pos.func_177956_o(), (double)pos.func_177952_p() + this.width, (double)pos.func_177958_n() + 1.0 - this.width, (double)pos.func_177956_o() + this.height, (double)pos.func_177952_p() + 1.0 - this.width);
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB func_180646_a(World worldIn, BlockPos pos) {
        return this.func_180640_a(worldIn, pos, worldIn.func_180495_p(pos));
    }

    @Override
    public boolean func_149686_d() {
        return false;
    }

    @Override
    public boolean func_149662_c() {
        return false;
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumFacing side, float hitX, float hitY, float hitZ) {
        this.eatCake(worldIn, pos, state, playerIn);
        return true;
    }

    public void func_180649_a(World worldIn, BlockPos pos, EntityPlayer playerIn) {
        this.eatCake(worldIn, pos, worldIn.func_180495_p(pos), playerIn);
    }

    private void eatCake(World worldIn, BlockPos pos, IBlockState state, EntityPlayer player) {
        if (state.func_177230_c() != this) {
            return;
        }
        if (player.func_71043_e(this.alwaysEdible)) {
            player.func_71024_bL().func_75122_a(this.hunger, this.saturation);
            int bitesTaken = 0;
            if (this.bites != null) {
                bitesTaken = (Integer)state.func_177229_b((IProperty)this.bites);
            }
            if (bitesTaken + 1 < this.numBites) {
                worldIn.func_180501_a(pos, state.func_177226_a((IProperty)this.bites, (Comparable)Integer.valueOf(bitesTaken + 1)), 3);
            } else {
                worldIn.func_175698_g(pos);
            }
            if (!worldIn.field_72995_K) {
                Random rand = new Random();
                for (GiveEffects.EffectInfo info : this.effects) {
                    if (info == null || !(info.probability >= rand.nextFloat())) continue;
                    GiveEffects.addEffectToEntity((EntityLivingBase)player, info, true);
                }
            }
        }
    }

    public void addPotionEffect(PotionEffect potion, float probability, String particleType) {
        this.effects.add(new GiveEffects.EffectInfoPotion(Potion.field_76425_a[potion.func_76456_a()], potion.func_76459_b(), potion.func_76458_c(), probability, particleType));
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        return super.func_176196_c(worldIn, pos) ? this.canBlockStay(worldIn, pos) : false;
    }

    public void func_176204_a(World worldIn, BlockPos pos, IBlockState state, Block neighborBlock) {
        if (!this.canBlockStay(worldIn, pos)) {
            worldIn.func_175698_g(pos);
        }
    }

    private boolean canBlockStay(World worldIn, BlockPos pos) {
        return worldIn.func_180495_p(pos.func_177977_b()).func_177230_c().func_149688_o().func_76220_a();
    }

    public int func_149745_a(Random random) {
        return 0;
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return null;
    }

    public IBlockState func_176203_a(int meta) {
        if (this.bites != null) {
            return this.func_176223_P().func_177226_a((IProperty)this.bites, (Comparable)Integer.valueOf(meta));
        }
        return this.func_176223_P();
    }

    public int func_176201_c(IBlockState state) {
        if (this.bites != null) {
            return (Integer)state.func_177229_b((IProperty)this.bites);
        }
        return 0;
    }

    protected BlockState func_180661_e() {
        IProperty[] iPropertyArray;
        if (this.getPropertyFromNumBites(nextNumBites) == null) {
            iPropertyArray = new IProperty[]{};
        } else {
            IProperty[] iPropertyArray2 = new IProperty[1];
            iPropertyArray = iPropertyArray2;
            iPropertyArray2[0] = this.getPropertyFromNumBites(nextNumBites);
        }
        return new BlockState((Block)this, iPropertyArray);
    }

    public int func_180641_l(World worldIn, BlockPos pos) {
        if (this.bites != null) {
            return this.numBites + 1 - (Integer)worldIn.func_180495_p(pos).func_177229_b((IProperty)this.bites);
        }
        return 0;
    }

    public boolean func_149740_M() {
        return true;
    }

    private PropertyInteger getPropertyFromNumBites(int bitesToSet) {
        switch (bitesToSet) {
            case 1: {
                return null;
            }
            case 2: {
                return BITES2;
            }
            case 3: {
                return BITES3;
            }
            case 4: {
                return BITES4;
            }
            case 5: {
                return BITES5;
            }
            case 6: {
                return BITES6;
            }
            case 7: {
                return BITES7;
            }
            case 8: {
                return BITES8;
            }
            case 9: {
                return BITES9;
            }
            case 10: {
                return BITES10;
            }
            case 11: {
                return BITES11;
            }
            case 12: {
                return BITES12;
            }
            case 13: {
                return BITES13;
            }
            case 14: {
                return BITES14;
            }
            case 15: {
                return BITES15;
            }
            case 16: {
                return BITES16;
            }
        }
        return null;
    }
}

