/*
 * Decompiled with CFR 0.152.
 */
package com.tmtravlr.lootplusplus.additions;

import com.tmtravlr.lootplusplus.additions.BlockAdded;
import net.minecraft.block.material.Material;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumWorldBlockLayer;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockAddedCarpet
extends BlockAdded {
    public BlockAddedCarpet(Material material, int opacity, boolean opaque, boolean isBeaconBase, String harvestTool, int harvestLevel, float slip, String display) {
        super(material, opacity, isBeaconBase, harvestTool, harvestLevel, slip, display);
        this.isOpaque = opaque;
        this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 0.0625f, 1.0f);
        this.func_149713_g(0);
        this.setBlockBoundsFromMeta(0);
    }

    @Override
    public boolean func_149662_c() {
        return false;
    }

    @Override
    public boolean func_149686_d() {
        return false;
    }

    public void func_149683_g() {
        this.setBlockBoundsFromMeta(0);
    }

    public void func_180654_a(IBlockAccess iba, BlockPos pos) {
        this.setBlockBoundsFromMeta(0);
    }

    protected void setBlockBoundsFromMeta(int meta) {
        int b0 = 0;
        float f = (float)(1 * (1 + b0)) / 16.0f;
        this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, f, 1.0f);
    }

    public boolean func_176196_c(World world, BlockPos pos) {
        return super.func_176196_c(world, pos) && this.canBlockStay(world, pos);
    }

    public void onNeighborChange(IBlockAccess world, BlockPos pos, BlockPos neighbour) {
        if (world instanceof World) {
            this.checkIfBlockCanStay((World)world, pos);
        }
    }

    private boolean checkIfBlockCanStay(World world, BlockPos pos) {
        if (!this.canBlockStay(world, pos)) {
            this.func_176226_b(world, pos, world.func_180495_p(pos), 0);
            world.func_175698_g(pos);
            return false;
        }
        return true;
    }

    public boolean canBlockStay(World world, BlockPos pos) {
        return !world.func_175623_d(pos.func_177977_b());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public EnumWorldBlockLayer func_180664_k() {
        return this.isOpaque ? EnumWorldBlockLayer.SOLID : EnumWorldBlockLayer.TRANSLUCENT;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockAccess world, BlockPos pos, EnumFacing side) {
        return side == EnumFacing.UP ? true : super.func_176225_a(world, pos, side);
    }
}

