/*
 * Decompiled with CFR 0.152.
 */
package com.tmtravlr.lootplusplus.additions;

import com.tmtravlr.lootplusplus.LootPPHelper;
import com.tmtravlr.lootplusplus.additions.InterfaceBlockAdded;
import com.tmtravlr.lootplusplus.additions.TileEntityAddedFurnace;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFurnace;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockState;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.EnumWorldBlockLayer;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockAddedFurnace
extends BlockFurnace
implements InterfaceBlockAdded {
    public static final PropertyBool ACTIVE = PropertyBool.func_177716_a((String)"active");
    private Random rand = new Random();
    public static boolean swapping = false;
    public String displayName = "";
    public String harvestTool = "pickaxe";
    public float speedFactor;
    public boolean isOpaque = true;
    public Material furnaceMaterial;

    public BlockAddedFurnace(Material material, float speed, String harvestTool, int opacity, int harvestLevel, float light, float slip, String display) {
        super(false);
        this.func_180632_j(this.func_176223_P().func_177226_a((IProperty)ACTIVE, (Comparable)Boolean.valueOf(false)));
        this.furnaceMaterial = material;
        this.func_149647_a(LootPPHelper.tabLootPPAdditions);
        if (harvestLevel != -1) {
            this.setHarvestLevel(harvestTool, harvestLevel);
        } else {
            this.setHarvestLevel(null, -1);
        }
        if (opacity >= 0) {
            this.func_149713_g(opacity);
            this.isOpaque = false;
        } else {
            this.func_149713_g(255);
        }
        this.harvestTool = harvestTool;
        this.func_149715_a(light);
        this.field_149765_K = slip;
        this.displayName = display;
        this.speedFactor = speed;
    }

    public Material func_149688_o() {
        return this.furnaceMaterial;
    }

    public int getLightValue(IBlockAccess world, BlockPos pos) {
        Block block = world.func_180495_p(pos).func_177230_c();
        if (block != this) {
            return block.getLightValue(world, pos);
        }
        IBlockState state = world.func_180495_p(pos);
        return (Boolean)state.func_177229_b((IProperty)ACTIVE) != false ? 15 : this.func_149750_m();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        if (((Boolean)state.func_177229_b((IProperty)ACTIVE)).booleanValue()) {
            EnumFacing enumfacing = (EnumFacing)state.func_177229_b((IProperty)field_176447_a);
            double d0 = (double)pos.func_177958_n() + 0.5;
            double d1 = (double)pos.func_177956_o() + rand.nextDouble() * 6.0 / 16.0;
            double d2 = (double)pos.func_177952_p() + 0.5;
            double d3 = 0.52;
            double d4 = rand.nextDouble() * 0.6 - 0.3;
            switch (SwitchEnumFacing.FACING_LOOKUP[enumfacing.ordinal()]) {
                case 1: {
                    worldIn.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, d0 - d3, d1, d2 + d4, 0.0, 0.0, 0.0, new int[0]);
                    worldIn.func_175688_a(EnumParticleTypes.FLAME, d0 - d3, d1, d2 + d4, 0.0, 0.0, 0.0, new int[0]);
                    break;
                }
                case 2: {
                    worldIn.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, d0 + d3, d1, d2 + d4, 0.0, 0.0, 0.0, new int[0]);
                    worldIn.func_175688_a(EnumParticleTypes.FLAME, d0 + d3, d1, d2 + d4, 0.0, 0.0, 0.0, new int[0]);
                    break;
                }
                case 3: {
                    worldIn.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, d0 + d4, d1, d2 - d3, 0.0, 0.0, 0.0, new int[0]);
                    worldIn.func_175688_a(EnumParticleTypes.FLAME, d0 + d4, d1, d2 - d3, 0.0, 0.0, 0.0, new int[0]);
                    break;
                }
                case 4: {
                    worldIn.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, d0 + d4, d1, d2 + d3, 0.0, 0.0, 0.0, new int[0]);
                    worldIn.func_175688_a(EnumParticleTypes.FLAME, d0 + d4, d1, d2 + d3, 0.0, 0.0, 0.0, new int[0]);
                }
            }
        }
    }

    public IBlockState func_176203_a(int meta) {
        EnumFacing enumfacing = EnumFacing.func_82600_a((int)meta);
        if (enumfacing.func_176740_k() == EnumFacing.Axis.Y) {
            enumfacing = EnumFacing.NORTH;
        }
        boolean active = false;
        if ((meta & 8) == 8) {
            active = true;
        }
        return this.func_176223_P().func_177226_a((IProperty)field_176447_a, (Comparable)enumfacing).func_177226_a((IProperty)ACTIVE, (Comparable)Boolean.valueOf(active));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)field_176447_a)).func_176745_a() | ((Boolean)state.func_177229_b((IProperty)ACTIVE) != false ? 8 : 0);
    }

    protected BlockState func_180661_e() {
        return new BlockState((Block)this, new IProperty[]{field_176447_a, ACTIVE});
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (worldIn.field_72995_K) {
            return true;
        }
        TileEntity tileentity = worldIn.func_175625_s(pos);
        if (tileentity instanceof TileEntityAddedFurnace) {
            playerIn.func_71007_a((IInventory)((TileEntityAddedFurnace)tileentity));
        }
        return true;
    }

    public static void setState(boolean active, World worldIn, BlockPos pos) {
        IBlockState iblockstate = worldIn.func_180495_p(pos);
        Block block = iblockstate.func_177230_c();
        TileEntity te = worldIn.func_175625_s(pos);
        if (block instanceof BlockAddedFurnace) {
            worldIn.func_180501_a(pos, block.func_176223_P().func_177226_a((IProperty)field_176447_a, iblockstate.func_177229_b((IProperty)field_176447_a)).func_177226_a((IProperty)ACTIVE, (Comparable)Boolean.valueOf(active)), 3);
            if (te != null) {
                te.func_145829_t();
                worldIn.func_175690_a(pos, te);
            }
        }
    }

    public TileEntity func_149915_a(World p_149915_1_, int p_149915_2_) {
        return new TileEntityAddedFurnace(this.displayName, this.speedFactor);
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        TileEntity tileentity;
        if (!swapping && (tileentity = worldIn.func_175625_s(pos)) instanceof TileEntityFurnace) {
            InventoryHelper.func_180175_a((World)worldIn, (BlockPos)pos, (IInventory)((TileEntityFurnace)tileentity));
            worldIn.func_175666_e(pos, (Block)this);
        }
        super.func_180663_b(worldIn, pos, state);
    }

    public boolean func_149662_c() {
        return this.isOpaque;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockAccess iba, BlockPos pos, EnumFacing side) {
        if (!this.isOpaque) {
            Block block = iba.func_180495_p(pos).func_177230_c();
            return block != this;
        }
        return super.func_176225_a(iba, pos, side);
    }

    @SideOnly(value=Side.CLIENT)
    public Item func_180665_b(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        return Item.func_150898_a((Block)this);
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Item.func_150898_a((Block)this);
    }

    public boolean isToolEffective(String type, IBlockState state) {
        return type.equals(this.harvestTool);
    }

    @SideOnly(value=Side.CLIENT)
    public EnumWorldBlockLayer func_180664_k() {
        return this.isOpaque ? EnumWorldBlockLayer.SOLID : EnumWorldBlockLayer.TRANSLUCENT;
    }

    public boolean func_149686_d() {
        return this.isOpaque;
    }

    @Override
    public String getDisplayName(IBlockState state) {
        return this.displayName;
    }

    @SideOnly(value=Side.CLIENT)
    static final class SwitchEnumFacing {
        static final int[] FACING_LOOKUP = new int[EnumFacing.values().length];
        private static final String __OBFID = "CL_00002111";

        SwitchEnumFacing() {
        }

        static {
            try {
                SwitchEnumFacing.FACING_LOOKUP[EnumFacing.WEST.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                SwitchEnumFacing.FACING_LOOKUP[EnumFacing.EAST.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                SwitchEnumFacing.FACING_LOOKUP[EnumFacing.NORTH.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                SwitchEnumFacing.FACING_LOOKUP[EnumFacing.SOUTH.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
        }
    }
}

