/*
 * Decompiled with CFR 0.152.
 */
package com.tmtravlr.lootplusplus.config;

import com.tmtravlr.lootplusplus.LootPPHelper;
import com.tmtravlr.lootplusplus.LootPPItems;
import com.tmtravlr.lootplusplus.LootPPNotifier;
import com.tmtravlr.lootplusplus.LootPlusPlusMod;
import com.tmtravlr.lootplusplus.config.ConfigExtrasLoader;
import com.tmtravlr.lootplusplus.config.ConfigLoader;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MathHelper;
import net.minecraftforge.common.config.Configuration;

public class ConfigLoaderBlockDrops
extends ConfigLoader {
    public static ConfigLoaderBlockDrops instance = new ConfigLoaderBlockDrops();

    ConfigLoaderBlockDrops() {
        this.namesToExtras.put("removing", new ArrayList());
        this.namesToExtras.put("adding", new ArrayList());
    }

    @Override
    public String getFileName() {
        return "block_drops";
    }

    public void loadBlockDrops() {
        String entry;
        int index;
        Configuration blockDropConfig = new Configuration(new File(LootPPHelper.configFolder, this.getFileName() + ".cfg"));
        blockDropConfig.load();
        blockDropConfig.addCustomCategoryComment("removing", "To remove an item drops from a block, add entries, each on a new line\nin the format:\n\n      <Block id>_____<Block metadata (-1 for any)>_____<Item name>_____<Metadata (optional, -1 for any)>_____<NBT tag (optional)>\n\nSo if you wanted to remove coal as a drop from coal ore, you could put\n\n      minecraft:coal_ore_____-1_____minecraft:coal\n\nThis would prevent any coal dropping from coal ore.");
        ArrayList<String> dropsList = ConfigExtrasLoader.combineLists(blockDropConfig.get("removing", "Drops to remove from blocks:", new String[0]).getStringList(), (ArrayList)this.namesToExtras.get("removing"));
        for (index = 0; index < dropsList.size(); ++index) {
            Block block;
            String nbtString;
            int itemMeta;
            String itemName;
            int blockMeta;
            String blockName;
            String title;
            boolean comment;
            String[] parts;
            block32: {
                entry = (String)dropsList.get(index);
                parts = entry.split("_____");
                comment = false;
                title = this.getFileName() + ".cfg 'removing' #" + index + 1;
                if (entry.length() > 0) {
                    boolean bl = comment = entry.charAt(0) == '#';
                }
                if (parts.length < 3) {
                    if (entry.equals("")) continue;
                    LootPPNotifier.notifyWrongNumberOfParts(comment, title, entry);
                    continue;
                }
                blockName = parts[0];
                blockMeta = -1;
                itemName = parts[2];
                itemMeta = -1;
                nbtString = "{}";
                try {
                    blockMeta = Integer.valueOf(parts[1]);
                    if (parts.length > 3) {
                        itemMeta = Integer.valueOf(parts[3]);
                    }
                }
                catch (NumberFormatException e) {
                    if (comment) break block32;
                    System.err.println("[Loot++] Caught an exception while trying to remove a block drop from " + blockName);
                    e.printStackTrace();
                    LootPPNotifier.notifyNumber(comment, title, parts[1] + (parts.length > 3 ? ", " + parts[3] : ""));
                }
            }
            if (blockMeta < 0) {
                blockMeta = Short.MAX_VALUE;
            }
            if (itemMeta < 0) {
                itemMeta = Short.MAX_VALUE;
            }
            if ((block = Block.func_149684_b((String)blockName)) == null || block == Blocks.field_150350_a) {
                LootPPNotifier.notifyNonexistant(comment, title, blockName);
                continue;
            }
            Item item = null;
            if (itemName.equalsIgnoreCase("any") || itemName.equalsIgnoreCase("all")) {
                item = LootPPItems.generalDummyIcon;
            } else {
                item = Item.func_111206_d((String)itemName);
                if (item == null) {
                    LootPPNotifier.notifyNonexistant(comment, title, itemName);
                    continue;
                }
            }
            NBTTagCompound nbt = null;
            if (parts.length > 4) {
                nbtString = parts[4];
            }
            if (nbtString != null && !nbtString.equals("{}")) {
                try {
                    NBTTagCompound nbtBase;
                    nbt = nbtBase = JsonToNBT.func_180713_a((String)nbtString.trim());
                }
                catch (NBTException e) {
                    if (!comment) {
                        e.printStackTrace();
                        LootPPNotifier.notifyNBT(comment, title, nbtString, e.getMessage());
                    }
                    nbt = null;
                }
            }
            ItemStack itemStack = new ItemStack(item, 1, itemMeta);
            if (nbt != null) {
                itemStack.func_77982_d(nbt);
            }
            this.addRemovalForState(new LootPPHelper.BlockMeta(block, blockMeta), itemStack);
        }
        blockDropConfig.addCustomCategoryComment("adding", "There are a few types of drops to add: items, entities, and commands.\n\nIn either case, the first options should be:\n\n      <Block Id>-<Rarity>-<Only player mined (true or false)>-<Drop with silk touch (true or false)>-<Affected by fortune (true or false)>-<Block metadata (optional)>,\n\nWhere:\n- The <Block Id> is the string id for the block as seen in the 'Block and Item IDs.txt' file.\n- The <Rarity> is the rarity of the drop, from 0.0 to 1.0\n- If <Only player mined> is true, drop will only drop if the block is broken by a player.\n- If <Drop with silk touch> is true, the drop will only drop if broken with a tool enchanted\nwith silk touch. If false, it will only drop if not broken with a silk touch tool. So word of\nwarning, if you want it to drop in either case, you need to add 2 entries, with true and false.\n- If <Affected by fortune> is true, the drops will increase if broken with a tool enchanted\nwith fortune.\n\nNext you can specify the items or entities to drop, in a list. The list should be in the formats:\n\n      ..._____i-<Item id>-<Min>-<Max>-<Weight (optional)>-<Metadata (optional)>-<NBT Tag (optional)>_____...\n\nfor items, or:\n\n      ..._____e-<Entity id>-<Weight (optional)>-<NBT tag (optional)>_____...\n\nfor entities, or:\n\n      ..._____c-<Weight>-<Command>_____...\n\nfor commands, where:\n- The <Item id> or<Entity id> is the string id for the item or entity.- The <Weight> is the chance that this drop will be chosen out of all the combined weights.\nMake sure it's bigger than 0. If you don't specify the weight, it will default to 1.\n- And the <Command> is a command you want to run where the block breaks.\n\nAlso, you can put %%%%% between drops to create groups of drops. In a group, only the weight of\nthe first drop will count.\n\n###############################################  Examples  #############################################\nIf you wanted to add charcoal as a drop to coal ore (perhaps after removing coal), you could write:\n\n      minecraft:coal_ore-1.0-false-false-true_____i-minecraft:coal-1-1-1-1\n\nIf you wanted gold ore to drop 1-3 gold nuggets instead of the ore, you could first remove the gold block drop\nin the removing section then add the following entries (for the nuggets, and add the silk touch back in):\n\n      minecraft:gold_ore-1.0-false-false-true_____i-minecraft:gold_nugget-1-3\n      minecraft:gold_ore-1.0-false-true-false_____i-minecraft:gold_ore-1-1\n\nIf you also wanted the gold ore to drop xp when mined, you could also add:\n\n      minecraft:gold_ore-0.7-true-false-false_____e-XPOrb-1-{Value:1}_____e-XPOrb-1-{Value:2}_____e-XPOrb-1-{Value:3}\n\nTo create a group of drops, say for a fictitious 'wolf_ore' that drops a wolf spawn egg\nand plays a barking sound when broken:\n\n      lootplusplus:wolf_ore-1.0-false-false-false_____i-minecraft:spawn_egg-1-1-1-95%%%%%c-1-playsound mob.wolf.bark @a ~ ~ ~");
        dropsList = ConfigExtrasLoader.combineLists(blockDropConfig.get("adding", "Drops to add to blocks:", new String[0]).getStringList(), (ArrayList)this.namesToExtras.get("adding"));
        for (index = 0; index < dropsList.size(); ++index) {
            entry = (String)dropsList.get(index);
            boolean comment = false;
            String title = this.getFileName() + ".cfg 'adding' #" + index + 1;
            if (entry.length() > 0) {
                comment = entry.charAt(0) == '#';
            }
            try {
                ArrayList<ArrayList<LootPPHelper.DropInfo>> blockDrops;
                boolean fortune;
                boolean silk;
                boolean player;
                float rarity;
                Block block;
                int blockMeta;
                String blockName;
                String[] dropStrings;
                block33: {
                    dropStrings = entry.split("_____");
                    if (dropStrings.length < 2) {
                        if (entry.equals("")) continue;
                        LootPPNotifier.notifyWrongNumberOfParts(comment, title, entry);
                        continue;
                    }
                    String[] split = dropStrings[0].split("-");
                    if (split.length < 5) {
                        LootPPNotifier.notifyWrongNumberOfParts(comment, title, dropStrings[0]);
                        continue;
                    }
                    blockName = split[0];
                    String rarityString = split[1];
                    String playerString = split[2];
                    String silkString = split[3];
                    String fortuneString = split[4];
                    blockMeta = -1;
                    block = Block.func_149684_b((String)blockName);
                    if (block == null || block == Blocks.field_150350_a) {
                        LootPPNotifier.notifyNonexistant(comment, title, blockName);
                        continue;
                    }
                    rarity = 1.0f;
                    player = false;
                    silk = true;
                    fortune = true;
                    blockDrops = new ArrayList<ArrayList<LootPPHelper.DropInfo>>();
                    try {
                        rarity = Float.valueOf(rarityString).floatValue();
                        player = Boolean.valueOf(playerString);
                        silk = Boolean.valueOf(silkString);
                        fortune = Boolean.valueOf(fortuneString);
                        if (split.length > 5) {
                            blockMeta = Integer.valueOf(split[5]);
                        }
                    }
                    catch (NumberFormatException e) {
                        if (comment) break block33;
                        System.err.println("[Loot++] Caught an exception while loading a block drop addition.");
                        e.printStackTrace();
                        LootPPNotifier.notifyNumber(comment, title, rarityString + ", " + playerString + ", " + silkString + ", " + fortuneString + (split.length > 5 ? ", " + split[5] : ""));
                    }
                }
                MathHelper.func_76131_a((float)rarity, (float)0.0f, (float)1.0f);
                if (blockMeta < 0) {
                    blockMeta = Short.MAX_VALUE;
                }
                for (int i = 1; i < dropStrings.length; ++i) {
                    String dropString = dropStrings[i];
                    if (dropString.equals("")) continue;
                    String[] subParts = dropString.split("%%%%%");
                    ArrayList<LootPPHelper.DropInfo> infoList = new ArrayList<LootPPHelper.DropInfo>();
                    for (int j = 0; j < subParts.length; ++j) {
                        char type;
                        LootPPHelper.DropInfo info;
                        String subString = subParts[j];
                        int dashIndex = subString.indexOf("-");
                        if (dashIndex < 0 || (info = LootPPHelper.getDropInfo(type = subString.charAt(0), subString.substring(dashIndex + 1), comment, title)) == null) continue;
                        infoList.add(info);
                    }
                    if (infoList.isEmpty()) continue;
                    blockDrops.add(infoList);
                }
                if (!blockDrops.isEmpty()) {
                    this.addAdditionForState(new LootPPHelper.BlockMeta(block, blockMeta), blockDrops, rarity, player, silk, fortune);
                    continue;
                }
                if (!LootPlusPlusMod.debug) continue;
                System.out.println("[Loot++] Drops List was empty for " + blockName + "!");
                continue;
            }
            catch (Exception e) {
                if (comment) continue;
                System.err.println("[Loot++] Caught an exception while loading block drops.");
                e.printStackTrace();
                LootPPNotifier.notify(comment, title, "=( Unexpected problem '" + e.getMessage() + "' while loading block drop additions for: " + entry);
            }
        }
        blockDropConfig.save();
    }

    private void addRemovalForState(LootPPHelper.BlockMeta blockMeta, ItemStack itemStack) {
        Set<ItemStack> itemSet = LootPPHelper.blockDropRemovals.get(blockMeta);
        if (itemSet == null) {
            itemSet = new HashSet<ItemStack>();
        }
        itemSet.add(itemStack);
        LootPPHelper.blockDropRemovals.put(blockMeta, itemSet);
        if (LootPlusPlusMod.debug) {
            System.out.println("[Loot++] Removing drop '" + itemStack + "' for blockstate '" + blockMeta + "'.");
        }
    }

    private void addAdditionForState(LootPPHelper.BlockMeta blockMeta, ArrayList<ArrayList<LootPPHelper.DropInfo>> blockDrops, float rarity, boolean player, boolean silk, boolean fortune) {
        ArrayList<Object> blockDropList = new ArrayList();
        blockDropList = LootPPHelper.blockDropAdditions.get(blockMeta);
        if (blockDropList == null) {
            blockDropList = new ArrayList();
        }
        LootPPHelper.BlockDropInfo toAdd = new LootPPHelper.BlockDropInfo(rarity, player, silk, fortune);
        toAdd.dropList = blockDrops;
        blockDropList.add(toAdd);
        LootPPHelper.blockDropAdditions.put(blockMeta, blockDropList);
        if (LootPlusPlusMod.debug) {
            System.out.println("[Loot++] Adding " + toAdd.dropList.size() + " drop" + (toAdd.dropList.size() == 1 ? "" : "s") + " for blockstate '" + blockMeta + "'.");
        }
    }
}

