/*
 * Decompiled with CFR 0.152.
 */
package com.tmtravlr.lootplusplus.config;

import com.tmtravlr.lootplusplus.LootPPBlocks;
import com.tmtravlr.lootplusplus.LootPPHelper;
import com.tmtravlr.lootplusplus.LootPPItems;
import com.tmtravlr.lootplusplus.LootPPNotifier;
import com.tmtravlr.lootplusplus.LootPlusPlusMod;
import com.tmtravlr.lootplusplus.config.ConfigExtrasLoader;
import com.tmtravlr.lootplusplus.config.ConfigLoader;
import com.tmtravlr.lootplusplus.effects.GiveEffects;
import java.io.File;
import java.util.ArrayList;
import java.util.TreeMap;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraftforge.common.config.Configuration;

public class ConfigLoaderEffects
extends ConfigLoader {
    public static ConfigLoaderEffects instance = new ConfigLoaderEffects();

    ConfigLoaderEffects() {
        this.namesToExtras.put("hitting_entity_to_entity", new ArrayList());
        this.namesToExtras.put("hitting_entity_to_yourself", new ArrayList());
        this.namesToExtras.put("digging_block", new ArrayList());
        this.namesToExtras.put("broke_block", new ArrayList());
        this.namesToExtras.put("right_click", new ArrayList());
        this.namesToExtras.put("wearing_armour", new ArrayList());
        this.namesToExtras.put("in_inventory", new ArrayList());
        this.namesToExtras.put("held", new ArrayList());
        this.namesToExtras.put("standing_on_block", new ArrayList());
        this.namesToExtras.put("inside_block", new ArrayList());
        this.namesToExtras.put("digging_block_block", new ArrayList());
        this.namesToExtras.put("broke_block_block", new ArrayList());
        this.namesToExtras.put("command_hitting_entity_to_entity", new ArrayList());
        this.namesToExtras.put("command_hitting_entity_to_yourself", new ArrayList());
        this.namesToExtras.put("command_digging_block", new ArrayList());
        this.namesToExtras.put("command_broke_block", new ArrayList());
        this.namesToExtras.put("command_right_click", new ArrayList());
        this.namesToExtras.put("command_wearing_armour", new ArrayList());
        this.namesToExtras.put("command_in_inventory", new ArrayList());
        this.namesToExtras.put("command_held", new ArrayList());
        this.namesToExtras.put("command_standing_on_block", new ArrayList());
        this.namesToExtras.put("command_inside_block", new ArrayList());
        this.namesToExtras.put("command_digging_block_block", new ArrayList());
        this.namesToExtras.put("command_broke_block_block", new ArrayList());
    }

    @Override
    public String getFileName() {
        return "item_effects";
    }

    public void loadItemEffects() {
        String entry;
        int index;
        Configuration effectConfig = new Configuration(new File(LootPPHelper.configFolder, this.getFileName() + ".cfg"));
        effectConfig.load();
        effectConfig.addCustomCategoryComment("_instructions", "************   Instructions   *************\nThis is used to make items give you potion effects under certain situations.\nThere are a number of different situations for items, with potion effects and commands:\n\n      Give an entity a potion effect when hitting it.\n      Give yourself a potion effect when hitting an entity.\n      Get a potion effect when digging a block (item-based).\n      Get a potion effect after breaking a block (item-based).\n      Get a potion effect when right clicking an item.\n      Get a potion effect when wearing armor.\n      Get a potion effect when the item is in your inventory.\n      Get a potion effect when holding the item.\n\n      Run a command from an entity's position when hitting it.\n      Run a command from your position when hitting an entity.\n      Run a command when digging a block (item-based).\n      Run a command after breaking a block (item-based).\n      Run a command when right clicking an item.\n      Run a command when wearing armor.\n      Run a command when the item is in your inventory.\n      Run a command when holding the item.\n\nAdd entries for the potion effects in the form:\n      <Item name>_____<Item metadata (-1 for any)>_____<Item NBT ({} for any)>_____<Effect id>_____<Effect duration>_____<Effect strength>_____<Effect probability>_____<Type of Particles>\n\nAdd for the commands in the form:\n      <Item name>_____<Item metadata (-1 for any)>_____<Item NBT ({} for any)>_____<Command probability>_____<Command>\n\nWhere:\n- The item name is the string name of the item,\n- Item metadata is the metadata/damage of the item (-1 is best for tools/armour so it\nworks for any durability),\n- If not {}, the nbt will try to match the nbt on the item giving the effect,\n- The effect id and duration are the effect type and time applied in ticks,\n- The effect strength is the level of the effect, starting at 0,\n- The effect probability is the chance of the effect happening, from 0.0 to 1.0, and\n- The type of particles is either none, faded, or normal.\n\nFor the wearing armor situation, you can also add up to 3 extra armor pieces to it\nto get a 'set bonus' effect, in the format:\n\n      ..._____<Armor Item 1 name>_____<Armor Item 2 name>_____<Armor Item 3 name>\n\n\nThere are also a few events for blocks, which are:\n\n      Get a potion effect while standing on top of a block.\n      Get a potion effect while inside of a block.\n      Get a potion effect when digging a block (block-based).\n      Get a potion effect after breaking a block (block-based).\n\n      Run a command while standing on top of a block.\n      Run a command while inside of a block.\n      Run a command when digging a block (block-based).\n      Run a command after breaking a block (block-based).\n\nAdd entries for the potion effects in the form:\n      <Block name>_____<Block metadata (-1 for any)>_____<Effect id>_____<Effect duration>_____<Effect strength>_____<Effect probability>_____<Type of Particles>\n\nAdd for the commands in the form:\n      <Block name>_____<Block metadata (-1 for any)>_____<Command probability>_____<Command>\n\nWhere:\n- The block name is the string name of the block,\n- Block metadata is the metadata of the block,\n- The effect id and duration are the effect type and time applied in ticks,\n- The effect strength is the level of the effect, starting at 0,\n- The effect probability is the chance of the effect happening, from 0.0 to 1.0, and\n- The type of particles is either none, faded, or normal.\n\n------------------------------------------------------------------------------------\n\nFor instance, if you want a stone sword that has a 50% chance to apply a wither 2 effect for 5\nseconds when named 'Torment', you can put in the hitting entity (give to entity) section:\n\n      minecraft:stone_sword_____-1_____{display:{Name:Torment}}_____20_____100_____1_____0.5_____normal\n\nIf you want to give a regeneration effect to someone wearing full chain\narmor, you can put in the wearing armor section:\n\n      minecraft:chainmail_helmet_____-1_____{}_____10_____60_____0_____1.0_____none_____minecraft:chainmail_chestplate_____minecraft:chainmail_leggings_____minecraft:chainmail_boots\n\nAnd finally, if you wanted to have 'Boots of Flame', that, when named that, give you fire\nresistnace and light the block you are standing on on fire, you would put these two in the wearing\narmor and command wearing armor sections:\n\n      any_____-1_____{display:{Name:\"Boots of Flame\"}}_____1.0_____lppcondition testforblock ~ ~-1 ~ air _if_false_ lppcondition testforblock ~ ~ ~ air _if_true_ setblock ~ ~ ~ fire\n      any_____-1_____{display:{Name:\"Boots of Flame\"}}_____12_____2_____0_____1.0_____none");
        ArrayList<String> entries = ConfigExtrasLoader.combineLists(effectConfig.get("effects", "Hitting Entity (Give to entity)", new String[0]).getStringList(), (ArrayList)this.namesToExtras.get("hitting_entity_to_entity"));
        for (index = 0; index < entries.size(); ++index) {
            entry = entries.get(index);
            this.loadPotionEffect(entry, false, GiveEffects.entityOnHitEntityMap, "Hitting Entity (Give to Entity)", index);
        }
        entries = ConfigExtrasLoader.combineLists(effectConfig.get("effects", "Hitting Entity (Give to yourself)", new String[0]).getStringList(), (ArrayList)this.namesToExtras.get("hitting_entity_to_yourself"));
        for (index = 0; index < entries.size(); ++index) {
            entry = entries.get(index);
            this.loadPotionEffect(entry, false, GiveEffects.youOnHitEntityMap, "Hitting Entity (Give to Yourself)", index);
        }
        entries = ConfigExtrasLoader.combineLists(effectConfig.get("effects", "Digging Block", new String[0]).getStringList(), (ArrayList)this.namesToExtras.get("digging_block"));
        for (index = 0; index < entries.size(); ++index) {
            entry = entries.get(index);
            this.loadPotionEffect(entry, false, GiveEffects.onItemBlockDigMap, "Digging Block", index);
        }
        entries = ConfigExtrasLoader.combineLists(effectConfig.get("effects", "Broke Block", new String[0]).getStringList(), (ArrayList)this.namesToExtras.get("broke_block"));
        for (index = 0; index < entries.size(); ++index) {
            entry = entries.get(index);
            this.loadPotionEffect(entry, false, GiveEffects.onItemBlockBrokeMap, "Broke Block", index);
        }
        entries = ConfigExtrasLoader.combineLists(effectConfig.get("effects", "Right Click", new String[0]).getStringList(), (ArrayList)this.namesToExtras.get("right_click"));
        for (index = 0; index < entries.size(); ++index) {
            entry = entries.get(index);
            this.loadPotionEffect(entry, false, GiveEffects.onRightClickMap, "Right Click", index);
        }
        entries = ConfigExtrasLoader.combineLists(effectConfig.get("effects", "Wearing Armor (This is the one you can add extra item names to)", new String[0]).getStringList(), (ArrayList)this.namesToExtras.get("wearing_armour"));
        for (index = 0; index < entries.size(); ++index) {
            entry = entries.get(index);
            this.loadPotionEffect(entry, true, GiveEffects.onWornMap, "Wearing Armor", index);
        }
        entries = ConfigExtrasLoader.combineLists(effectConfig.get("effects", "In Inventory", new String[0]).getStringList(), (ArrayList)this.namesToExtras.get("in_inventory"));
        for (index = 0; index < entries.size(); ++index) {
            entry = entries.get(index);
            this.loadPotionEffect(entry, false, GiveEffects.onPassiveMap, "In Inventory", index);
        }
        entries = ConfigExtrasLoader.combineLists(effectConfig.get("effects", "Held", new String[0]).getStringList(), (ArrayList)this.namesToExtras.get("held"));
        for (index = 0; index < entries.size(); ++index) {
            entry = entries.get(index);
            this.loadPotionEffect(entry, false, GiveEffects.onHeldMap, "Held", index);
        }
        entries = ConfigExtrasLoader.combineLists(effectConfig.get("effects", "Standing On Block", new String[0]).getStringList(), (ArrayList)this.namesToExtras.get("standing_on_block"));
        for (index = 0; index < entries.size(); ++index) {
            entry = entries.get(index);
            this.loadPotionEffectBlock(entry, GiveEffects.standingOnMap, "Standing On Block", index);
        }
        entries = ConfigExtrasLoader.combineLists(effectConfig.get("effects", "Inside Block", new String[0]).getStringList(), (ArrayList)this.namesToExtras.get("inside_block"));
        for (index = 0; index < entries.size(); ++index) {
            entry = entries.get(index);
            this.loadPotionEffectBlock(entry, GiveEffects.insideMap, "Inside Block", index);
        }
        entries = ConfigExtrasLoader.combineLists(effectConfig.get("effects", "Digging Block (Block)", new String[0]).getStringList(), (ArrayList)this.namesToExtras.get("digging_block_block"));
        for (index = 0; index < entries.size(); ++index) {
            entry = entries.get(index);
            this.loadPotionEffectBlock(entry, GiveEffects.onBlockBlockDigMap, "Digging Block (Block)", index);
        }
        entries = ConfigExtrasLoader.combineLists(effectConfig.get("effects", "Broke Block (Block)", new String[0]).getStringList(), (ArrayList)this.namesToExtras.get("broke_block_block"));
        for (index = 0; index < entries.size(); ++index) {
            entry = entries.get(index);
            this.loadPotionEffectBlock(entry, GiveEffects.onBlockBlockBrokeMap, "Broke Block (Block)", index);
        }
        entries = ConfigExtrasLoader.combineLists(effectConfig.get("command effects", "Hitting Entity (Give to entity)", new String[0]).getStringList(), (ArrayList)this.namesToExtras.get("command_hitting_entity_to_entity"));
        for (index = 0; index < entries.size(); ++index) {
            entry = entries.get(index);
            this.loadCommandEffect(entry, false, GiveEffects.entityOnHitEntityMap, "Hitting Entity (Give to Entity)", index);
        }
        entries = ConfigExtrasLoader.combineLists(effectConfig.get("command effects", "Hitting Entity (Give to yourself)", new String[0]).getStringList(), (ArrayList)this.namesToExtras.get("command_hitting_entity_to_yourself"));
        for (index = 0; index < entries.size(); ++index) {
            entry = entries.get(index);
            this.loadCommandEffect(entry, false, GiveEffects.youOnHitEntityMap, "Hitting Entity (Give to Yourself)", index);
        }
        entries = ConfigExtrasLoader.combineLists(effectConfig.get("command effects", "Digging Block", new String[0]).getStringList(), (ArrayList)this.namesToExtras.get("command_digging_block"));
        for (index = 0; index < entries.size(); ++index) {
            entry = entries.get(index);
            this.loadCommandEffect(entry, false, GiveEffects.onItemBlockDigMap, "Digging Block", index);
        }
        entries = ConfigExtrasLoader.combineLists(effectConfig.get("command effects", "Broke Block", new String[0]).getStringList(), (ArrayList)this.namesToExtras.get("command_broke_block"));
        for (index = 0; index < entries.size(); ++index) {
            entry = entries.get(index);
            this.loadCommandEffect(entry, false, GiveEffects.onItemBlockBrokeMap, "Broke Block", index);
        }
        entries = ConfigExtrasLoader.combineLists(effectConfig.get("command effects", "Right Click", new String[0]).getStringList(), (ArrayList)this.namesToExtras.get("command_right_click"));
        for (index = 0; index < entries.size(); ++index) {
            entry = entries.get(index);
            this.loadCommandEffect(entry, false, GiveEffects.onRightClickMap, "Right Click", index);
        }
        entries = ConfigExtrasLoader.combineLists(effectConfig.get("command effects", "Wearing Armor (This is the one you can add extra item names to)", new String[0]).getStringList(), (ArrayList)this.namesToExtras.get("command_wearing_armour"));
        for (index = 0; index < entries.size(); ++index) {
            entry = entries.get(index);
            this.loadCommandEffect(entry, true, GiveEffects.onWornMap, "Wearing Armor", index);
        }
        entries = ConfigExtrasLoader.combineLists(effectConfig.get("command effects", "In Inventory", new String[0]).getStringList(), (ArrayList)this.namesToExtras.get("command_in_inventory"));
        for (index = 0; index < entries.size(); ++index) {
            entry = entries.get(index);
            this.loadCommandEffect(entry, false, GiveEffects.onPassiveMap, "In Inventory", index);
        }
        entries = ConfigExtrasLoader.combineLists(effectConfig.get("command effects", "Held", new String[0]).getStringList(), (ArrayList)this.namesToExtras.get("command_held"));
        for (index = 0; index < entries.size(); ++index) {
            entry = entries.get(index);
            this.loadCommandEffect(entry, false, GiveEffects.onHeldMap, "Held", index);
        }
        entries = ConfigExtrasLoader.combineLists(effectConfig.get("command effects", "Standing On Block", new String[0]).getStringList(), (ArrayList)this.namesToExtras.get("command_standing_on_block"));
        for (index = 0; index < entries.size(); ++index) {
            entry = entries.get(index);
            this.loadCommandEffectBlock(entry, GiveEffects.standingOnMap, "Standing On Block", index);
        }
        entries = ConfigExtrasLoader.combineLists(effectConfig.get("command effects", "Inside Block", new String[0]).getStringList(), (ArrayList)this.namesToExtras.get("command_inside_block"));
        for (index = 0; index < entries.size(); ++index) {
            entry = entries.get(index);
            this.loadCommandEffectBlock(entry, GiveEffects.insideMap, "Inside Block", index);
        }
        entries = ConfigExtrasLoader.combineLists(effectConfig.get("command effects", "Digging Block (Block)", new String[0]).getStringList(), (ArrayList)this.namesToExtras.get("command_digging_block_block"));
        for (index = 0; index < entries.size(); ++index) {
            entry = entries.get(index);
            this.loadCommandEffectBlock(entry, GiveEffects.onBlockBlockDigMap, "Digging Block (Block)", index);
        }
        entries = ConfigExtrasLoader.combineLists(effectConfig.get("command effects", "Broke Block (Block)", new String[0]).getStringList(), (ArrayList)this.namesToExtras.get("command_broke_block_block"));
        for (index = 0; index < entries.size(); ++index) {
            entry = entries.get(index);
            this.loadCommandEffectBlock(entry, GiveEffects.onBlockBlockBrokeMap, "Broke Block (Block)", index);
        }
        effectConfig.save();
    }

    private void loadPotionEffect(String entry, boolean isWorn, TreeMap<ItemStack, ArrayList<GiveEffects.EffectInfo>> effectMap, String type, int index) {
        String particleType;
        float probability;
        int effectStrength;
        int effectDuration;
        Potion potion;
        String nbtString;
        int meta;
        String itemName;
        String title;
        boolean comment;
        String[] parts;
        block23: {
            parts = entry.split("_____");
            comment = false;
            title = this.getFileName() + ".cfg '" + type + "' #" + (index + 1);
            if (entry.length() > 0) {
                boolean bl = comment = entry.charAt(0) == '#';
            }
            if (parts.length < 8) {
                if (!entry.equals("")) {
                    LootPPNotifier.notifyWrongNumberOfParts(comment, title, entry);
                }
                return;
            }
            itemName = parts[0];
            meta = -1;
            nbtString = parts[2];
            potion = Potion.func_180142_b((String)parts[3]);
            effectDuration = 10;
            effectStrength = 0;
            probability = 1.0f;
            particleType = parts[7];
            if (potion == null) {
                try {
                    int effectId = Integer.valueOf(parts[3]);
                    potion = Potion.field_76425_a[effectId];
                }
                catch (NumberFormatException effectId) {
                    // empty catch block
                }
                if (potion == null) {
                    LootPPNotifier.notify(comment, title, "Couldn't find potion effect '" + parts[3] + "'");
                    return;
                }
            }
            try {
                meta = Integer.valueOf(parts[1]);
                effectDuration = Integer.valueOf(parts[4]);
                effectStrength = Integer.valueOf(parts[5]);
                probability = Float.valueOf(parts[6]).floatValue();
            }
            catch (NumberFormatException e) {
                if (comment) break block23;
                System.err.println("[Loot++] Caught an exception while trying to add an effect for item " + itemName);
                e.printStackTrace();
                LootPPNotifier.notifyNumber(comment, title, parts[1], parts[4], parts[5], parts[6]);
            }
        }
        if (meta < 0) {
            meta = Short.MAX_VALUE;
        }
        Item item = null;
        if (itemName.equalsIgnoreCase("any")) {
            item = LootPPItems.generalDummyIcon;
        } else {
            item = Item.func_111206_d((String)itemName);
            if (item == null) {
                LootPPNotifier.notifyNonexistant(comment, title, itemName);
                return;
            }
        }
        NBTTagCompound nbt = null;
        if (!nbtString.equals("") && !nbtString.equals("{}")) {
            try {
                nbt = JsonToNBT.func_180713_a((String)nbtString.trim());
            }
            catch (Exception e) {
                if (!comment) {
                    LootPPNotifier.notifyNBT(comment, title, nbtString, e.getMessage());
                    e.printStackTrace();
                }
                nbt = null;
            }
        }
        GiveEffects.EffectInfoPotion info = new GiveEffects.EffectInfoPotion(potion, effectDuration, effectStrength, probability, particleType);
        if (isWorn) {
            for (int i = 8; i < 11; ++i) {
                if (parts.length <= i) continue;
                Item extraItem = Item.func_111206_d((String)parts[i]);
                if (extraItem == null) {
                    LootPPNotifier.notifyNonexistant(comment, title, parts[i]);
                    continue;
                }
                ItemStack extraStack = new ItemStack(extraItem, 1, Short.MAX_VALUE);
                info.alsoEquipped.add(extraStack);
            }
        }
        ItemStack stack = new ItemStack(item, 1, meta);
        if (nbt != null) {
            stack.func_77982_d(nbt);
        }
        ArrayList<GiveEffects.EffectInfo> infoList = new ArrayList<GiveEffects.EffectInfoPotion>();
        if (effectMap.containsKey(stack)) {
            infoList = effectMap.get(stack);
        }
        infoList.add(info);
        effectMap.put(stack, infoList);
        if (LootPlusPlusMod.debug) {
            System.out.println("[Loot++] Giving " + (isWorn ? "worn " : "") + "item '" + itemName + "' the effect " + info);
        }
    }

    private void loadCommandEffect(String entry, boolean isWorn, TreeMap<ItemStack, ArrayList<GiveEffects.EffectInfo>> effectMap, String type, int index) {
        String command;
        float probability;
        String nbtString;
        int meta;
        String itemName;
        String title;
        boolean comment;
        String[] parts;
        block19: {
            parts = entry.split("_____");
            comment = false;
            title = this.getFileName() + ".cfg '" + type + "' #" + (index + 1);
            if (entry.length() > 0) {
                boolean bl = comment = entry.charAt(0) == '#';
            }
            if (parts.length < 5) {
                if (!entry.equals("")) {
                    LootPPNotifier.notifyWrongNumberOfParts(comment, title, entry);
                }
                return;
            }
            itemName = parts[0];
            meta = -1;
            nbtString = parts[2];
            probability = 1.0f;
            command = parts[4];
            try {
                meta = Integer.valueOf(parts[1]);
                probability = Float.valueOf(parts[3]).floatValue();
            }
            catch (NumberFormatException e) {
                if (comment) break block19;
                System.err.println("[Loot++] Caught an exception while trying to add an effect for item " + itemName);
                e.printStackTrace();
                LootPPNotifier.notifyNumber(comment, title, parts[1], parts[3]);
            }
        }
        if (meta < 0) {
            meta = Short.MAX_VALUE;
        }
        Item item = null;
        if (itemName.equalsIgnoreCase("any")) {
            item = LootPPItems.generalDummyIcon;
        } else {
            item = Item.func_111206_d((String)itemName);
            if (item == null) {
                LootPPNotifier.notifyNonexistant(comment, title, itemName);
                return;
            }
        }
        NBTTagCompound nbt = null;
        if (!nbtString.equals("") && !nbtString.equals("{}")) {
            try {
                nbt = JsonToNBT.func_180713_a((String)nbtString.trim());
            }
            catch (Exception e) {
                if (!comment) {
                    LootPPNotifier.notifyNBT(comment, title, nbtString, e.getMessage());
                    e.printStackTrace();
                }
                nbt = null;
            }
        }
        GiveEffects.EffectInfoCommand info = new GiveEffects.EffectInfoCommand(probability, command);
        if (isWorn) {
            for (int i = 8; i < 11; ++i) {
                if (parts.length <= i) continue;
                Item extraItem = Item.func_111206_d((String)parts[i]);
                if (extraItem == null) {
                    LootPPNotifier.notifyNonexistant(comment, title, parts[i]);
                    continue;
                }
                ItemStack extraStack = new ItemStack(extraItem, 1, Short.MAX_VALUE);
                info.alsoEquipped.add(extraStack);
            }
        }
        ItemStack stack = new ItemStack(item, 1, meta);
        if (nbt != null) {
            stack.func_77982_d(nbt);
        }
        ArrayList<GiveEffects.EffectInfo> infoList = new ArrayList<GiveEffects.EffectInfoCommand>();
        if (effectMap.containsKey(stack)) {
            infoList = effectMap.get(stack);
        }
        infoList.add(info);
        effectMap.put(stack, infoList);
        if (LootPlusPlusMod.debug) {
            System.out.println("[Loot++] Giving " + (isWorn ? "worn " : "") + "item '" + itemName + "' the effect " + info);
        }
    }

    private void loadPotionEffectBlock(String entry, TreeMap<LootPPHelper.BlockMeta, ArrayList<GiveEffects.EffectInfo>> effectMap, String type, int index) {
        String particleType;
        float probability;
        int effectStrength;
        int effectDuration;
        Potion potion;
        int meta;
        String blockName;
        String title;
        boolean comment;
        block15: {
            String[] parts = entry.split("_____");
            comment = false;
            title = this.getFileName() + ".cfg '" + type + "' #" + (index + 1);
            if (entry.length() > 0) {
                boolean bl = comment = entry.charAt(0) == '#';
            }
            if (parts.length < 7) {
                if (!entry.equals("")) {
                    LootPPNotifier.notifyWrongNumberOfParts(comment, title, entry);
                }
                return;
            }
            blockName = parts[0];
            meta = -1;
            potion = Potion.func_180142_b((String)parts[2]);
            effectDuration = 10;
            effectStrength = 0;
            probability = 1.0f;
            particleType = parts[6];
            if (potion == null) {
                try {
                    int effectId = Integer.valueOf(parts[2]);
                    potion = Potion.field_76425_a[effectId];
                }
                catch (NumberFormatException effectId) {
                    // empty catch block
                }
                if (potion == null) {
                    LootPPNotifier.notify(comment, title, "Couldn't find potion effect '" + parts[2] + "'");
                    return;
                }
            }
            try {
                meta = Integer.valueOf(parts[1]);
                effectDuration = Integer.valueOf(parts[3]);
                effectStrength = Integer.valueOf(parts[4]);
                probability = Float.valueOf(parts[5]).floatValue();
            }
            catch (NumberFormatException e) {
                if (comment) break block15;
                System.err.println("[Loot++] Caught an exception while trying to add an effect for item " + blockName);
                e.printStackTrace();
                LootPPNotifier.notifyNumber(comment, title, parts[1], parts[3], parts[4], parts[5]);
            }
        }
        if (meta < 0) {
            meta = Short.MAX_VALUE;
        }
        Block block = null;
        if (blockName.equalsIgnoreCase("any")) {
            block = LootPPBlocks.blockCommandBlockTrigger;
        } else {
            block = Block.func_149684_b((String)blockName);
            if (block == null || block == Blocks.field_150350_a && !blockName.equals("minecraft:air") && !blockName.equals("air")) {
                LootPPNotifier.notifyNonexistant(comment, title, blockName);
                return;
            }
        }
        GiveEffects.EffectInfoPotion info = new GiveEffects.EffectInfoPotion(potion, effectDuration, effectStrength, probability, particleType);
        LootPPHelper.BlockMeta blockInfo = new LootPPHelper.BlockMeta(block, meta);
        ArrayList<GiveEffects.EffectInfo> infoList = new ArrayList<GiveEffects.EffectInfoPotion>();
        if (effectMap.containsKey(blockInfo)) {
            infoList = effectMap.get(blockInfo);
        }
        infoList.add(info);
        effectMap.put(blockInfo, infoList);
        if (LootPlusPlusMod.debug) {
            System.out.println("[Loot++] Giving block '" + blockName + "' the effect " + info);
        }
    }

    private void loadCommandEffectBlock(String entry, TreeMap<LootPPHelper.BlockMeta, ArrayList<GiveEffects.EffectInfo>> effectMap, String type, int index) {
        String command;
        float probability;
        int meta;
        String blockName;
        String title;
        boolean comment;
        block11: {
            String[] parts = entry.split("_____");
            comment = false;
            title = this.getFileName() + ".cfg '" + type + "' #" + (index + 1);
            if (entry.length() > 0) {
                boolean bl = comment = entry.charAt(0) == '#';
            }
            if (parts.length < 4) {
                if (!entry.equals("")) {
                    LootPPNotifier.notifyWrongNumberOfParts(comment, title, entry);
                }
                return;
            }
            blockName = parts[0];
            meta = -1;
            probability = 1.0f;
            command = parts[3];
            try {
                meta = Integer.valueOf(parts[1]);
                probability = Float.valueOf(parts[2]).floatValue();
            }
            catch (NumberFormatException e) {
                if (comment) break block11;
                System.err.println("[Loot++] Caught an exception while trying to add an effect for item " + blockName);
                e.printStackTrace();
                LootPPNotifier.notifyNumber(comment, title, parts[1], parts[2]);
            }
        }
        if (meta < 0) {
            meta = Short.MAX_VALUE;
        }
        Block block = null;
        if (blockName.equalsIgnoreCase("any")) {
            block = LootPPBlocks.blockCommandBlockTrigger;
        } else {
            block = Block.func_149684_b((String)blockName);
            if (block == null || block == Blocks.field_150350_a && !blockName.equals("minecraft:air") && !blockName.equals("air")) {
                LootPPNotifier.notifyNonexistant(comment, title, blockName);
                return;
            }
        }
        GiveEffects.EffectInfoCommand info = new GiveEffects.EffectInfoCommand(probability, command);
        LootPPHelper.BlockMeta blockInfo = new LootPPHelper.BlockMeta(block, meta);
        ArrayList<GiveEffects.EffectInfo> infoList = new ArrayList<GiveEffects.EffectInfoCommand>();
        if (effectMap.containsKey(blockInfo)) {
            infoList = effectMap.get(blockInfo);
        }
        infoList.add(info);
        effectMap.put(blockInfo, infoList);
        if (LootPlusPlusMod.debug) {
            System.out.println("[Loot++] Giving block '" + blockName + "' the effect " + info);
        }
    }
}

