/*
 * Decompiled with CFR 0.152.
 */
package com.tmtravlr.lootplusplus.config;

import com.google.common.base.Predicate;
import com.tmtravlr.lootplusplus.LootPPHelper;
import com.tmtravlr.lootplusplus.LootPPNotifier;
import com.tmtravlr.lootplusplus.LootPlusPlusMod;
import com.tmtravlr.lootplusplus.config.ConfigExtrasLoader;
import com.tmtravlr.lootplusplus.config.ConfigLoader;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.WeightedRandomFishable;
import net.minecraftforge.common.FishingHooks;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.relauncher.ReflectionHelper;

public class ConfigLoaderFishingLoot
extends ConfigLoader {
    private static HashSet<WeightedRandomFishable> toRemove = new HashSet();
    public static ConfigLoaderFishingLoot instance = new ConfigLoaderFishingLoot();
    public static HashMap<String, ArrayList<String>> extraExisting = new HashMap();

    ConfigLoaderFishingLoot() {
        this.namesToExtras.put("fish_additions", new ArrayList());
        this.namesToExtras.put("junk_additions", new ArrayList());
        this.namesToExtras.put("treasure_additions", new ArrayList());
    }

    @Override
    public String getFileName() {
        return "fishing_loot";
    }

    public void loadFishingLoot() {
        Configuration fishConfig = new Configuration(new File(LootPPHelper.configFolder, this.getFileName() + ".cfg"));
        fishConfig.load();
        String[] recordList = new String[]{};
        fishConfig.addCustomCategoryComment("_instructions", "************   Instructions   *************\nFor the default entries, they are formatted as follows:\n\n      <damage percent>-<enchanted>-<weight>.\n\nDisable them by setting the weights to 0. The damage percent is what percent of\ndurability should be removed from the item. If enchanted is true, the item will be\nenchanted when it gets fished up.\nTo add new things, put items in the lists in the format:\n\n      <name>-<amount>-<damage percent>-<enchanted>-<weight>-<metadata (optional)>-<NBT Tag (optional)>.\n\nSo, say, if you wanted to add 3 slime balls to the junk loot with a weight of\n10, you could put:\n\n      minecraft:slime_ball-3-0.0-false-10\n\nNote the NBT tag is optional, and so is the metadata (defaults to 0), so you don't have\nto include them. Also note that the metadata is affected by the damager percent for tools,\nso if you put, say, an enchanted iron helmet that you want at 50% damage, you could put:\n\n      minecraft:iron_helmet-1-0.5-true-10\n");
        ArrayList<Object> entries = new ArrayList();
        ArrayList fish = (ArrayList)ReflectionHelper.getPrivateValue(FishingHooks.class, null, (String[])new String[]{"fish"});
        if (fish != null) {
            for (WeightedRandomFishable fishable : fish) {
                ConfigLoaderFishingLoot.loadDefaultFishingLoot(fishConfig, "fish", fishable);
            }
        }
        FishingHooks.removeFish((Predicate)new Predicate<WeightedRandomFishable>(){

            public boolean apply(WeightedRandomFishable input) {
                return !toRemove.contains(input);
            }
        });
        toRemove.clear();
        entries = ConfigExtrasLoader.combineLists(fishConfig.get("fish_additions", "Fish Additions:", new String[0]).getStringList(), (ArrayList)this.namesToExtras.get("fish_additions"));
        for (int index = 0; index < entries.size(); ++index) {
            String options = (String)entries.get(index);
            String title = "chest_content.cfg 'fish_additions' #" + (index + 1);
            WeightedRandomFishable content = ConfigLoaderFishingLoot.loadNewFishingLoot(title, options);
            if (content == null) continue;
            FishingHooks.addFish((WeightedRandomFishable)content);
        }
        ArrayList junk = (ArrayList)ReflectionHelper.getPrivateValue(FishingHooks.class, null, (String[])new String[]{"junk"});
        if (fish != null) {
            for (WeightedRandomFishable fishable : junk) {
                ConfigLoaderFishingLoot.loadDefaultFishingLoot(fishConfig, "junk", fishable);
            }
        }
        FishingHooks.removeJunk((Predicate)new Predicate<WeightedRandomFishable>(){

            public boolean apply(WeightedRandomFishable input) {
                return !toRemove.contains(input);
            }
        });
        toRemove.clear();
        entries = ConfigExtrasLoader.combineLists(fishConfig.get("junk_additions", "Junk Additions:", new String[0]).getStringList(), (ArrayList)this.namesToExtras.get("junk_additions"));
        for (int index = 0; index < entries.size(); ++index) {
            String options = (String)entries.get(index);
            String title = "chest_content.cfg 'junk_additions' #" + (index + 1);
            WeightedRandomFishable content = ConfigLoaderFishingLoot.loadNewFishingLoot(title, options);
            if (content == null) continue;
            FishingHooks.addJunk((WeightedRandomFishable)content);
        }
        ArrayList treasure = (ArrayList)ReflectionHelper.getPrivateValue(FishingHooks.class, null, (String[])new String[]{"treasure"});
        if (fish != null) {
            for (WeightedRandomFishable fishable : treasure) {
                ConfigLoaderFishingLoot.loadDefaultFishingLoot(fishConfig, "treasure", fishable);
            }
        }
        FishingHooks.removeTreasure((Predicate)new Predicate<WeightedRandomFishable>(){

            public boolean apply(WeightedRandomFishable input) {
                return !toRemove.contains(input);
            }
        });
        toRemove.clear();
        entries = ConfigExtrasLoader.combineLists(fishConfig.get("treasure_additions", "Treasure Additions:", new String[0]).getStringList(), (ArrayList)this.namesToExtras.get("treasure_additions"));
        for (int index = 0; index < entries.size(); ++index) {
            String options = (String)entries.get(index);
            String title = "chest_content.cfg 'treasure_additions' #" + (index + 1);
            WeightedRandomFishable content = ConfigLoaderFishingLoot.loadNewFishingLoot(title, options);
            if (content == null) continue;
            FishingHooks.addTreasure((WeightedRandomFishable)content);
        }
        fishConfig.save();
    }

    public static void loadDefaultFishingLoot(Configuration fishConfig, String type, WeightedRandomFishable fishable) {
        ItemStack itemStack = (ItemStack)ObfuscationReflectionHelper.getPrivateValue(WeightedRandomFishable.class, (Object)fishable, (String[])new String[]{"returnStack", "field_150711_b"});
        float damagePercent = ((Float)ObfuscationReflectionHelper.getPrivateValue(WeightedRandomFishable.class, (Object)fishable, (String[])new String[]{"maxDamagePercent", "field_150712_c"})).floatValue();
        boolean enchant = (Boolean)ObfuscationReflectionHelper.getPrivateValue(WeightedRandomFishable.class, (Object)fishable, (String[])new String[]{"enchantable", "field_150710_d"});
        int weight = fishable.field_76292_a;
        if (itemStack == null || itemStack.func_77973_b() == null) {
            return;
        }
        String options = "" + damagePercent + "-" + enchant + "-" + weight;
        options = fishConfig.get(type + "_default", Item.field_150901_e.func_177774_c((Object)itemStack.func_77973_b()) + "-" + itemStack.field_77994_a + "-" + itemStack.func_77952_i() + (!itemStack.func_77942_o() ? "" : "-" + itemStack.func_77978_p().toString()), options).getString();
        String[] parts = options.split("-");
        if (parts.length != 3) {
            LootPPNotifier.notifyWrongNumberOfParts(false, "fishing_loot.cfg '" + type + "_default'", options);
            return;
        }
        try {
            damagePercent = Float.valueOf(parts[0]).floatValue();
            enchant = Boolean.valueOf(parts[1]);
            weight = Integer.valueOf(parts[2]);
            if (damagePercent < 0.0f) {
                damagePercent = 0.0f;
            }
            if (weight < 0) {
                weight = 0;
            }
            fishable.field_76292_a = weight;
            ObfuscationReflectionHelper.setPrivateValue(WeightedRandomFishable.class, (Object)fishable, (Object)Float.valueOf(damagePercent), (String[])new String[]{"maxDamagePercent", "field_150712_c"});
            ObfuscationReflectionHelper.setPrivateValue(WeightedRandomFishable.class, (Object)fishable, (Object)enchant, (String[])new String[]{"enchantable", "field_150710_d"});
        }
        catch (NumberFormatException e) {
            LootPPNotifier.notifyNumber(false, "fishing_loot.cfg '" + type + "_default'", parts[0], parts[1], parts[2]);
            e.printStackTrace();
            return;
        }
        if (weight == 0) {
            if (LootPlusPlusMod.debug) {
                System.out.println("[Loot++] Removing fishing loot '" + itemStack + "' with weight " + weight + ", damage percent " + damagePercent + ", and is enchanted? " + enchant);
            }
            toRemove.add(fishable);
        }
    }

    public static WeightedRandomFishable loadNewFishingLoot(String title, String options) {
        Item item;
        NBTTagCompound nbt;
        int meta;
        int weight;
        boolean enchant;
        float damagePercent;
        int amount;
        String name;
        boolean comment;
        String[] parts;
        block19: {
            parts = options.split("-", 7);
            comment = false;
            if (options.isEmpty() || options.charAt(0) == '#') {
                return null;
            }
            if (parts.length < 5) {
                if (!options.equals("")) {
                    LootPPNotifier.notifyWrongNumberOfParts(comment, title, options);
                }
                return null;
            }
            name = parts[0];
            amount = 1;
            damagePercent = 0.0f;
            enchant = false;
            weight = 1;
            meta = 0;
            nbt = null;
            try {
                amount = Integer.valueOf(parts[1]);
                damagePercent = Float.valueOf(parts[2]).floatValue();
                enchant = Boolean.valueOf(parts[3]);
                weight = Integer.valueOf(parts[4]);
                if (parts.length > 5) {
                    meta = Integer.valueOf(parts[5]);
                }
            }
            catch (NumberFormatException e) {
                if (comment) break block19;
                LootPPNotifier.notifyNumber(comment, title, "" + parts[1] + ", " + parts[2] + ", " + parts[3] + ", " + parts[4] + (parts.length > 5 ? ", " + parts[5] : ""));
                e.printStackTrace();
                return null;
            }
        }
        if (amount < 1) {
            amount = 1;
        }
        if (damagePercent < 0.0f) {
            damagePercent = 0.0f;
        }
        if (meta < 0) {
            meta = 0;
        }
        if (weight < 1) {
            weight = 1;
        }
        if (parts.length > 6 && !parts[6].equals("") && !parts[6].equals("{}")) {
            try {
                NBTTagCompound nbtBase = JsonToNBT.func_180713_a((String)parts[6].trim());
                if (nbtBase instanceof NBTTagCompound) {
                    nbt = nbtBase;
                }
            }
            catch (NBTException e) {
                if (!comment) {
                    LootPPNotifier.notifyNBT(comment, title, parts[6], e.getMessage());
                    e.printStackTrace();
                }
                return null;
            }
        }
        if ((item = Item.func_111206_d((String)name)) == null) {
            LootPPNotifier.notifyNonexistant(comment, title, name);
            return null;
        }
        ItemStack itemStack = new ItemStack(item, amount, meta);
        if (nbt != null) {
            itemStack.func_77982_d(nbt);
        }
        WeightedRandomFishable content = new WeightedRandomFishable(itemStack, weight).func_150709_a(damagePercent);
        if (enchant) {
            content.func_150707_a();
        }
        if (LootPlusPlusMod.debug) {
            System.out.println("[Loot++] Added fishing loot '" + itemStack + "' with weight " + weight + ", damage percent " + damagePercent + ", and is enchanted? " + enchant);
        }
        return content;
    }
}

