/*
 * Decompiled with CFR 0.152.
 */
package com.tmtravlr.lootplusplus.config;

import com.tmtravlr.lootplusplus.LootPPHelper;
import com.tmtravlr.lootplusplus.LootPPNotifier;
import com.tmtravlr.lootplusplus.LootPlusPlusMod;
import com.tmtravlr.lootplusplus.config.ConfigExtrasLoader;
import com.tmtravlr.lootplusplus.config.ConfigLoader;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MathHelper;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.registry.GameRegistry;

public class ConfigLoaderFurnaceRecipes
extends ConfigLoader {
    public static ConfigLoaderFurnaceRecipes instance = new ConfigLoaderFurnaceRecipes();

    ConfigLoaderFurnaceRecipes() {
        this.namesToExtras.put("add_furnace_fuels", new ArrayList());
        this.namesToExtras.put("add_smelting_recipes", new ArrayList());
    }

    @Override
    public String getFileName() {
        return "furnace_recipes";
    }

    public void loadFurnaceRecipes() {
        String xpString;
        String[] parts;
        int index;
        Configuration furnaceConfig = new Configuration(new File(LootPPHelper.configFolder, this.getFileName() + ".cfg"));
        furnaceConfig.load();
        FurnaceRecipes furnaceRecipes = FurnaceRecipes.func_77602_a();
        Map smeltingMap = furnaceRecipes.func_77599_b();
        Map<ItemStack, Float> experienceMap = new HashMap();
        if (LootPPHelper.gotFurnaceXP) {
            try {
                experienceMap = (Map)LootPPHelper.experienceMap.get(furnaceRecipes);
            }
            catch (Exception e) {
                System.out.println("[Loot++] Caught Exception while trying to load in furnace xp.");
                e.printStackTrace();
            }
        }
        furnaceConfig.addCustomCategoryComment("_instructions", "************   Instructions   *************\nFor the default entries, they are formatted as follows:\n\n      <number of items>-<amount of xp>. Disable them by setting the number of items to 0.\n\nTo add new smelting recipes, put items in the adding section in the format:\n\n      <input item id>_____<metadata (-1 for any)>_____<output item id>_____<metadata>_____<NBT Tag ({} for blank)>_____<amount>_____<xp given (optional)>\n\nFor instance, if you want to add a recipe where smelting wool of any color gives you charcoal, you can add:\n\n      minecraft:wool_____-1_____minecraft:coal_____1_____{}_____1_____1.0\n\nNote that the nbt data is ignored for smelting recipes, which is why it isn't a parameter for the input item.\n\n\nTo add new furnace fuel items, add them to the add_furnace_fuels section in the format:\n\n      <fuel item id>_____<metadata (-1 for any)>_____<burn time>\n\nFor reference, a furnace operation takes a time of 200. Coal has a burn time of 1600.");
        ArrayList<String> fuelAdditions = ConfigExtrasLoader.combineLists(furnaceConfig.get("add_furnace_fuels", "add_furnace_fuels", new String[0]).getStringList(), (ArrayList)this.namesToExtras.get("add_furnace_fuels"));
        for (index = 0; index < fuelAdditions.size(); ++index) {
            Item item;
            int burnTime;
            int meta;
            String itemName;
            String title;
            boolean comment;
            block36: {
                String entry = fuelAdditions.get(index);
                comment = false;
                title = this.getFileName() + ".cfg 'add_furnace_fuels' #" + (index + 1);
                if (entry.length() > 0) {
                    boolean bl = comment = entry.charAt(0) == '#';
                }
                if ((parts = entry.split("_____")).length != 3) {
                    if (entry.equals("")) continue;
                    LootPPNotifier.notifyWrongNumberOfParts(comment, title, entry);
                    continue;
                }
                itemName = parts[0];
                meta = -1;
                burnTime = 200;
                try {
                    meta = Integer.valueOf(parts[1]);
                    burnTime = Integer.valueOf(parts[2]);
                }
                catch (NumberFormatException e) {
                    if (comment) break block36;
                    System.err.println("[Loot++] Caught an exception while trying to add furnace fuel " + itemName);
                    e.printStackTrace();
                    LootPPNotifier.notifyNumber(comment, title, parts[1], parts[2]);
                }
            }
            if (meta < 0) {
                meta = Short.MAX_VALUE;
            }
            if ((item = Item.func_111206_d((String)itemName)) == null) {
                LootPPNotifier.notifyNonexistant(comment, title, itemName);
                continue;
            }
            LootPPHelper.fuelHandler.addFuel(new ItemStack(item, 1, meta), burnTime);
            if (!LootPlusPlusMod.debug) continue;
            System.out.println("[Loot++] Added furnace fuel " + itemName);
        }
        HashSet<ItemStack> toRemove = new HashSet<ItemStack>();
        for (ItemStack stackInput : smeltingMap.keySet()) {
            ItemStack stackOutput = (ItemStack)smeltingMap.get(stackInput);
            float xp = 0.0f;
            if (experienceMap.containsKey(stackOutput)) {
                xp = ((Float)experienceMap.get(stackOutput)).floatValue();
            }
            if (stackInput == null || stackOutput == null || stackInput.func_77973_b() == null || stackOutput.func_77973_b() == null) continue;
            String title = this.getFileName() + ".cfg 'default_smelting_recipes' input:" + stackInput + ", output:" + stackOutput;
            String result = "" + stackOutput.field_77994_a + "-" + xp;
            String display = "Input: " + Item.field_150901_e.func_177774_c((Object)stackInput.func_77973_b()) + " with damage: " + stackInput.func_77952_i() + ", Output: " + Item.field_150901_e.func_177774_c((Object)stackOutput.func_77973_b()) + " with damage: " + stackOutput.func_77952_i();
            result = furnaceConfig.get("default_smelting_recipes", display, result).getString();
            int dashIndex = result.indexOf(45);
            if (dashIndex == -1) {
                LootPPNotifier.notifyWrongNumberOfParts(false, title, result);
                continue;
            }
            int size = 1;
            float newxp = 0.0f;
            String sizeString = result.substring(0, dashIndex);
            xpString = result.substring(dashIndex + 1);
            try {
                size = Integer.valueOf(sizeString);
                newxp = Float.valueOf(xpString).floatValue();
            }
            catch (NumberFormatException e) {
                System.err.println("[Loot++] Caught exception while reading in furnace recipes.");
                e.printStackTrace();
                LootPPNotifier.notifyNumber(false, title, sizeString, xpString);
            }
            if ((double)MathHelper.func_76135_e((float)(xp - newxp)) > 0.01) {
                experienceMap.put(stackOutput, Float.valueOf(newxp));
            }
            if (size == stackOutput.field_77994_a) continue;
            if (size <= 0) {
                toRemove.add(stackInput);
                continue;
            }
            stackOutput.field_77994_a = size;
        }
        for (ItemStack stack : toRemove) {
            if (LootPlusPlusMod.debug) {
                System.out.println("[Loot++] Removing furnace recipe for " + Item.field_150901_e.func_177774_c((Object)stack.func_77973_b()));
            }
            smeltingMap.remove(stack);
        }
        ArrayList<String> smeltingList = ConfigExtrasLoader.combineLists(furnaceConfig.get("add_smelting_recipes", "add_smelting_recipes", new String[0]).getStringList(), (ArrayList)this.namesToExtras.get("add_smelting_recipes"));
        for (index = 0; index < smeltingList.size(); ++index) {
            float xp;
            int amount;
            int outputMeta;
            int inputMeta;
            Item outputItem;
            Item inputItem;
            String outputNBTString;
            String outputItemName;
            String title;
            boolean comment;
            block37: {
                String toAdd = smeltingList.get(index);
                parts = toAdd.split("_____");
                comment = false;
                title = this.getFileName() + ".cfg 'add_smelting_recipes' #" + (index + 1);
                if (toAdd.length() > 0) {
                    boolean bl = comment = toAdd.charAt(0) == '#';
                }
                if (parts.length < 6) {
                    if (toAdd.equals("")) continue;
                    LootPPNotifier.notifyWrongNumberOfParts(comment, title, toAdd);
                    continue;
                }
                String inputItemName = parts[0];
                String inputMetaString = parts[1];
                outputItemName = parts[2];
                String outputMetaString = parts[3];
                outputNBTString = parts[4];
                String amountString = parts[5];
                xpString = "0";
                if (parts.length >= 7) {
                    xpString = parts[6];
                }
                inputItem = Item.func_111206_d((String)inputItemName);
                outputItem = Item.func_111206_d((String)outputItemName);
                if (inputItem == null) {
                    LootPPNotifier.notifyNonexistant(comment, title, inputItemName);
                    continue;
                }
                if (outputItem == null) {
                    LootPPNotifier.notifyNonexistant(comment, title, outputItemName);
                    continue;
                }
                inputMeta = 0;
                outputMeta = 0;
                amount = 1;
                xp = 0.0f;
                try {
                    inputMeta = Integer.valueOf(inputMetaString);
                    outputMeta = Integer.valueOf(outputMetaString);
                    amount = Integer.valueOf(amountString);
                    xp = Float.valueOf(xpString).floatValue();
                }
                catch (NumberFormatException e) {
                    if (comment) break block37;
                    System.err.println("[Loot++] Caught an exception while trying to add a recipe for " + outputItemName);
                    e.printStackTrace();
                    LootPPNotifier.notifyNumber(comment, title, inputMetaString, outputMetaString, amountString, xpString);
                }
            }
            if (amount < 1) {
                amount = 1;
            }
            if (outputMeta < 0) {
                outputMeta = 0;
            }
            NBTTagCompound outputTag = null;
            if (!outputNBTString.equals("") && !outputNBTString.equals("{}")) {
                try {
                    NBTTagCompound temp = JsonToNBT.func_180713_a((String)outputNBTString);
                    if (temp != null) {
                        outputTag = temp;
                    }
                }
                catch (NBTException e) {
                    if (!comment) {
                        LootPPNotifier.notifyNBT(comment, title, outputNBTString, e.getMessage());
                        e.printStackTrace();
                    }
                    outputTag = null;
                }
            }
            ItemStack inputStack = new ItemStack(inputItem, 1, inputMeta == -1 ? Short.MAX_VALUE : inputMeta);
            ItemStack outputStack = new ItemStack(outputItem, amount, outputMeta);
            if (outputTag != null) {
                outputStack.func_77982_d(outputTag);
            }
            if (LootPlusPlusMod.debug) {
                System.out.println("[Loot++] Adding furnace smelting recipe for " + outputItemName);
            }
            GameRegistry.addSmelting((ItemStack)inputStack, (ItemStack)outputStack, (float)xp);
        }
        furnaceConfig.save();
    }
}

