/*
 * Decompiled with CFR 0.152.
 */
package com.tmtravlr.lootplusplus.config;

import com.tmtravlr.lootplusplus.LootPPHelper;
import com.tmtravlr.lootplusplus.LootPPNotifier;
import com.tmtravlr.lootplusplus.config.ConfigExtrasLoader;
import com.tmtravlr.lootplusplus.config.ConfigLoader;
import java.io.File;
import java.util.ArrayList;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.oredict.OreDictionary;

public class ConfigLoaderOreDict
extends ConfigLoader {
    public static ConfigLoaderOreDict instance = new ConfigLoaderOreDict();

    ConfigLoaderOreDict() {
        this.namesToExtras.put("additions", new ArrayList());
    }

    @Override
    public String getFileName() {
        return "ore_dictionary";
    }

    public void loadOreDict() {
        Configuration oreDictConfig = new Configuration(new File(LootPPHelper.configFolder, this.getFileName() + ".cfg"));
        oreDictConfig.load();
        oreDictConfig.setCategoryComment("additions", "Add items to the ore dictionary in the following format:\n\n      <Ore Dictionary entry name>_____<Item name>_____<Item metadata (-1 for any)>\n\nFor instance, to add the default records to the 'record' category, you could write\nsomething like:\n\n      record_____lootplusplus:creative1_____-1\n\nfor each record.");
        ArrayList<String> additions = ConfigExtrasLoader.combineLists(oreDictConfig.get("additions", "additions", new String[0]).getStringList(), (ArrayList)this.namesToExtras.get("additions"));
        for (int index = 0; index < additions.size(); ++index) {
            int meta;
            Item item;
            String type;
            block6: {
                String[] parts;
                String addition = additions.get(index);
                boolean comment = false;
                String title = this.getFileName() + ".cfg 'additions' #" + (index + 1);
                if (addition.length() > 0) {
                    boolean bl = comment = addition.charAt(0) == '#';
                }
                if ((parts = addition.split("_____")).length != 3) {
                    if (addition.equals("")) continue;
                    LootPPNotifier.notifyWrongNumberOfParts(comment, title, addition);
                    continue;
                }
                type = parts[0];
                String itemName = parts[1];
                String metaString = parts[2];
                item = Item.func_111206_d((String)itemName);
                if (item == null) {
                    LootPPNotifier.notifyNonexistant(comment, title, itemName);
                    continue;
                }
                meta = Short.MAX_VALUE;
                try {
                    meta = Integer.valueOf(metaString);
                }
                catch (NumberFormatException e) {
                    if (comment) break block6;
                    System.err.println("[Loot++] Caught exception while trying to add ore dictionary entry for " + itemName);
                    e.printStackTrace();
                    LootPPNotifier.notifyNumber(comment, title, metaString);
                }
            }
            OreDictionary.registerOre((String)type, (ItemStack)new ItemStack(item, 1, meta < 0 ? Short.MAX_VALUE : meta));
        }
        oreDictConfig.save();
    }
}

