/*
 * Decompiled with CFR 0.152.
 */
package com.tmtravlr.lootplusplus.config;

import com.tmtravlr.lootplusplus.LootPPHelper;
import com.tmtravlr.lootplusplus.LootPPNotifier;
import com.tmtravlr.lootplusplus.LootPlusPlusMod;
import com.tmtravlr.lootplusplus.config.ConfigExtrasLoader;
import com.tmtravlr.lootplusplus.config.ConfigLoader;
import com.tmtravlr.lootplusplus.recipes.LootPPFakeInventoryCrafting;
import com.tmtravlr.lootplusplus.recipes.LootPPShapedRecipe;
import com.tmtravlr.lootplusplus.recipes.LootPPShapelessRecipe;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.RecipeFireworks;
import net.minecraft.item.crafting.RecipesMapExtending;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.registry.GameRegistry;

public class ConfigLoaderRecipes
extends ConfigLoader {
    public static ConfigLoaderRecipes instance = new ConfigLoaderRecipes();

    ConfigLoaderRecipes() {
        this.namesToExtras.put("removing", new ArrayList());
        this.namesToExtras.put("add_shaped", new ArrayList());
        this.namesToExtras.put("add_shapeless", new ArrayList());
    }

    @Override
    public String getFileName() {
        return "recipes";
    }

    public void loadRecipes(World world) {
        String outputNBTString;
        int outputMeta;
        Item outputItem;
        String title;
        boolean comment;
        String entry;
        int index;
        Configuration recipeConfig = new Configuration(new File(LootPPHelper.configFolder, this.getFileName() + ".cfg"));
        recipeConfig.load();
        List recipes = CraftingManager.func_77594_a().func_77592_b();
        recipeConfig.addCustomCategoryComment("removing", "To remove existing recipes, first add the item ID. This will remove every recipe with this item\nas the output. You can also optionally include a damage (metadata) value and nbt tag, in the format:\n\n      <item id>_____<metadata (optional)>_____<nbt tag (optional)>.\n\nIf you want to remove a specific recipe with that item as the output, after the nbt you can write the recipe\nin the format (Note you must include the output item's metadata and nbt if you want to specify the recipe!):\n\n      <output item id>_____<metadata (-1 for any)>_____<nbt tag ({} for any)>_____<recipe>_____<input items>...\n\nwhere the recipe is a set of characters that look like abc,def,ghi which represent crafting slots: \n\n      a  b  c\n      d  e  f\n      g  h  i\n\nand any space is interpereted as a blank spot, so a diamond axe could be represented as 'dd ,ds , s '\n\n      d  d  []\n      d  s  []\n      [] s  []\n\nWhere d represents diamond, s represents stick, and [] is an empty slot. To specify what items the\ncharacters represent, in the input items section, for each character, write an entry in the form:\n\n      ..._____<character>_____<item id>_____<metadata (-1 for any)>_____<nbt data ({} for any>_____...\n\n###############################################  Examples  #############################################\n- For a simple example, 'minecraft:diamond_helmet' will remove any recipes that give you a diamond helmet.\n- Writing 'minecraft:wool_____5' will get rid of all recipes that output lime wool.\n\nTo remove the recipe for torches that uses charcoal and keep the one that uses coal, you could write:\nminecraft:torch_____-1_____{}_____c,s_____c_____minecraft:coal_____1_____{}_____s_____minecraft:stick_____0_____{}\n\nNote the metadata for the coal is 1, which means charcoal, and the metadata for the stick is 0, not -1.\nIf you can't get a recipe to work, it might be good to play around with changing the metadata to 0 or -1.");
        ArrayList<String> recipeList = ConfigExtrasLoader.combineLists(recipeConfig.get("removing", "Recipes to remove:", new String[0]).getStringList(), (ArrayList)this.namesToExtras.get("removing"));
        for (index = 0; index < recipeList.size(); ++index) {
            HashMap<Character, ItemStack> recipeItems;
            String specificRecipe;
            String outputNBTString2;
            block80: {
                entry = recipeList.get(index);
                comment = false;
                title = this.getFileName() + ".cfg 'removing' #" + (index + 1);
                if (entry.length() > 0) {
                    comment = entry.charAt(0) == '#';
                }
                outputItem = null;
                outputMeta = -1;
                outputNBTString2 = "{}";
                specificRecipe = "";
                recipeItems = new HashMap<Character, ItemStack>();
                try {
                    String[] subEntries = entry.split("_____");
                    if (entry.equals("")) continue;
                    outputItem = Item.func_111206_d((String)subEntries[0]);
                    if (outputItem == null) {
                        LootPPNotifier.notifyNonexistant(comment, title, subEntries[0]);
                    }
                    if (subEntries.length > 1) {
                        outputMeta = Integer.parseInt(subEntries[1]);
                    }
                    if (subEntries.length > 2) {
                        outputNBTString2 = subEntries[2];
                    }
                    if (subEntries.length <= 3) break block80;
                    specificRecipe = subEntries[3];
                    int i = 4;
                    while (i + 3 < subEntries.length) {
                        char character = subEntries[i].charAt(0);
                        Item item = Item.func_111206_d((String)subEntries[i + 1]);
                        if (item == null) {
                            LootPPNotifier.notifyNonexistant(comment, title, subEntries[i + 1]);
                        } else {
                            int itemMeta = Integer.parseInt(subEntries[i + 2]);
                            NBTTagCompound tag = null;
                            try {
                                NBTTagCompound tagBase = JsonToNBT.func_180713_a((String)subEntries[i + 3]);
                                if (tagBase != null) {
                                    tag = tagBase;
                                }
                            }
                            catch (NBTException e) {
                                if (!comment) {
                                    e.printStackTrace();
                                    LootPPNotifier.notifyNBT(comment, title, subEntries[i + 3], e.getMessage());
                                }
                                tag = null;
                            }
                            ItemStack stack = new ItemStack(item, 1, itemMeta == -1 ? Short.MAX_VALUE : itemMeta);
                            if (tag != null) {
                                stack.func_77982_d(tag);
                            }
                            recipeItems.put(Character.valueOf(character), stack);
                        }
                        i += 4;
                    }
                }
                catch (Exception e) {
                    if (comment) break block80;
                    System.out.println("[Loot++] Encountered an exception while loading in a recipe to remove!");
                    e.printStackTrace();
                    LootPPNotifier.notify(comment, title, "=( Unexpected problem '" + e.getMessage() + "' while loading a recipe to remove: " + entry);
                }
            }
            if (outputItem == null) continue;
            List currentRecipes = CraftingManager.func_77594_a().func_77592_b();
            NBTTagCompound outputNBT = null;
            if (outputNBTString2 != null && !outputNBTString2.equals("") && !outputNBTString2.equals("{}")) {
                try {
                    NBTTagCompound tagBase = JsonToNBT.func_180713_a((String)outputNBTString2);
                    if (tagBase != null) {
                        outputNBT = tagBase;
                    }
                }
                catch (NBTException e) {
                    if (!comment) {
                        LootPPNotifier.notifyNBT(comment, title, outputNBTString2, e.getMessage());
                        e.printStackTrace();
                    }
                    outputNBT = null;
                }
            }
            int count = 0;
            Iterator it = currentRecipes.iterator();
            while (it.hasNext()) {
                Object obj = it.next();
                try {
                    ItemStack recipeOutput = null;
                    if (!(obj instanceof IRecipe) || obj instanceof RecipesMapExtending || obj instanceof RecipeFireworks) continue;
                    IRecipe recipe = (IRecipe)obj;
                    if (specificRecipe != null && !specificRecipe.equals("")) {
                        LootPPFakeInventoryCrafting fakeCraftingGrid = new LootPPFakeInventoryCrafting(3);
                        String[] craftingParts = specificRecipe.split(",");
                        for (int i = 0; i < craftingParts.length && i < 3; ++i) {
                            for (int j = 0; j < craftingParts[i].length() && j < 3; ++j) {
                                ItemStack toSet = null;
                                if (craftingParts[i].charAt(j) != ' ' && recipeItems.containsKey(Character.valueOf(craftingParts[i].charAt(j)))) {
                                    toSet = (ItemStack)recipeItems.get(Character.valueOf(craftingParts[i].charAt(j)));
                                }
                                fakeCraftingGrid.func_70299_a(i * 3 + j, toSet);
                            }
                        }
                        if (recipe.func_77569_a((InventoryCrafting)fakeCraftingGrid, world)) {
                            recipeOutput = recipe.func_77572_b((InventoryCrafting)fakeCraftingGrid);
                        }
                    } else {
                        recipeOutput = recipe.func_77571_b();
                    }
                    if (recipeOutput == null || recipeOutput.func_77973_b() != outputItem || outputMeta != -1 && recipeOutput.func_77952_i() != outputMeta || outputNBT != null && recipeOutput.func_77978_p() != null && !outputNBT.equals((Object)recipeOutput.func_77978_p())) continue;
                    if (LootPlusPlusMod.debug) {
                        System.out.println("[Loot++] Removing Recipe " + recipe + " giving item " + recipeOutput);
                    }
                    ++count;
                    it.remove();
                }
                catch (Exception e) {
                    if (comment) continue;
                    System.err.println("[Loot++] Caught an exception while trying to remove a crafting recipe.");
                    e.printStackTrace();
                    LootPPNotifier.notify(comment, title, "=( Unexpected problem '" + e.getMessage() + "' while removing a recipe: " + entry);
                }
            }
            if (count != 0) continue;
            if (specificRecipe != null && !specificRecipe.equals("")) {
                LootPPNotifier.notify(comment, title, "Couldn't find a recipe that matched '" + specificRecipe + "'.");
                continue;
            }
            LootPPNotifier.notify(comment, title, "Couldn't find a recipe with object '" + Item.field_150901_e.func_177774_c((Object)outputItem) + "' as the output.");
        }
        recipeConfig.addCustomCategoryComment("add_shaped", "Add each recipe on a new line in the following format: \n      <output item id>_____<amount>_____<metadata>_____<nbt tag ({} for blank)>_____<recipe>_____<input items>...\n\nWhere the recipe is a set of characters that look like abc,def,ghi which represent crafting slots: \n\n      a  b  c\n      d  e  f\n      g  h  i\n\nand any space is interpereted as a blank spot, so a diamond axe could be represented as 'dd ,ds , s '\n\n      d  d  []\n      d  s  []\n      [] s  []\n\nWhere d represents diamond, s represents stick, and [] is an empty slot. To specify what items the\ncharacters represent, in the input items section, for each character, write an entry in the form:\n\n      ..._____<character>_____<item id>_____<metadata (-1 for any)>_____<nbt data ({} for any>_____...\n\nIf you want to add an ore dictionary entry, put the string in quotes in place of the item id,\nso for instance: \n\n      ..._____s_____\"stickWood\"_____-1_____{}_____... \n\n###############################################  Examples  #############################################\nFor example, if you wanted to add a recipe for a diamond axe that used sugar cane instead of sticks,\nyou could write:\n\n      minecraft:diamond_axe_____1_____0_____{}_____dd,ds, s_____d_____minecraft:diamond_____0_____{}_____s_____minecraft:reeds_____0_____{}\n\nAnd if you wanted to add a recipe to add feather falling to diamond boots using feathers, you could write:\n\n      minecraft:diamond_boots_____1_____0_____{ench:[{id:2,lvl:1}]}_____fff,fdf,fff_____d_____minecraft:diamond_boots_____0_____{}_____f_____minecraft:feather_____0_____{}\n");
        recipeList = ConfigExtrasLoader.combineLists(recipeConfig.get("add_shaped", "Recipes to add:", new String[0]).getStringList(), (ArrayList)this.namesToExtras.get("add_shaped"));
        for (index = 0; index < recipeList.size(); ++index) {
            entry = recipeList.get(index);
            comment = false;
            title = this.getFileName() + ".cfg 'add_shaped' #" + (index + 1);
            if (entry.length() > 0) {
                comment = entry.charAt(0) == '#';
            }
            outputItem = null;
            outputMeta = 0;
            int outputAmount = 1;
            outputNBTString = "{}";
            boolean isOreRecipe = false;
            String recipeString = "";
            HashMap<Character, String> recipeItems = new HashMap<Character, String>();
            try {
                Item item;
                String[] subEntries;
                block81: {
                    subEntries = entry.split("_____");
                    if (subEntries.length < 8) {
                        if (entry.equals("")) continue;
                        LootPPNotifier.notifyWrongNumberOfParts(comment, title, entry);
                        continue;
                    }
                    String outputItemName = subEntries[0];
                    String amountString = subEntries[1];
                    String metaString = subEntries[2];
                    outputNBTString = subEntries[3];
                    recipeString = subEntries[4];
                    outputItem = Item.func_111206_d((String)subEntries[0]);
                    if (outputItem == null) {
                        LootPPNotifier.notifyNonexistant(comment, title, subEntries[0]);
                        continue;
                    }
                    try {
                        outputAmount = Integer.parseInt(amountString);
                        outputMeta = Integer.parseInt(metaString);
                    }
                    catch (NumberFormatException e) {
                        if (comment) break block81;
                        e.printStackTrace();
                        LootPPNotifier.notifyNumber(comment, title, amountString, metaString);
                        continue;
                    }
                }
                boolean valid = true;
                int i = 5;
                while (i + 3 < subEntries.length) {
                    char character = subEntries[i].charAt(0);
                    item = null;
                    boolean oreEntry = false;
                    if (subEntries[i + 1].charAt(0) == '\"') {
                        recipeItems.put(Character.valueOf(character), subEntries[i + 1].substring(1, subEntries[i + 1].length() - 1));
                        isOreRecipe = true;
                    } else {
                        item = Item.func_111206_d((String)subEntries[i + 1]);
                    }
                    if (item != null) {
                        int itemMeta = Integer.parseInt(subEntries[i + 2]);
                        NBTTagCompound tag = null;
                        try {
                            NBTTagCompound tagBase = JsonToNBT.func_180713_a((String)subEntries[i + 3]);
                            if (tagBase != null) {
                                tag = tagBase;
                            }
                        }
                        catch (NBTException e) {
                            if (!comment) {
                                e.printStackTrace();
                                LootPPNotifier.notifyNBT(comment, title, subEntries[i + 3], e.getMessage());
                                valid = false;
                            }
                            tag = null;
                        }
                        ItemStack stack = new ItemStack(item, 1, itemMeta < 0 ? Short.MAX_VALUE : itemMeta);
                        if (tag != null) {
                            stack.func_77982_d(tag);
                        }
                        recipeItems.put(Character.valueOf(character), (String)stack);
                    } else if (subEntries[i + 1].charAt(0) != '\"') {
                        LootPPNotifier.notifyNonexistant(comment, title, subEntries[i + 1]);
                        valid = false;
                    }
                    i += 4;
                }
                if (!valid) continue;
                ItemStack outputStack = new ItemStack(outputItem, outputAmount, outputMeta);
                ArrayList<Object> recipe = new ArrayList<Object>();
                recipe.addAll(Arrays.asList(recipeString.split(",")));
                item = recipeItems.keySet().iterator();
                while (item.hasNext()) {
                    char charId = ((Character)item.next()).charValue();
                    recipe.add(Character.valueOf(charId));
                    recipe.add(recipeItems.get(Character.valueOf(charId)));
                }
                NBTTagCompound tag = null;
                if (outputNBTString != null && !outputNBTString.equals("{}") && !outputNBTString.equals("")) {
                    try {
                        NBTTagCompound tagBase = JsonToNBT.func_180713_a((String)outputNBTString);
                        if (tagBase != null) {
                            tag = tagBase;
                        }
                    }
                    catch (NBTException e) {
                        if (!comment) {
                            e.printStackTrace();
                            LootPPNotifier.notifyNBT(comment, title, outputNBTString, e.getMessage());
                            continue;
                        }
                        tag = null;
                    }
                }
                if (tag != null) {
                    outputStack.func_77982_d(tag);
                }
                if (LootPlusPlusMod.debug) {
                    System.out.println("[Loot++] Adding Shaped Recipe giving item " + outputStack);
                }
                GameRegistry.addRecipe((IRecipe)new LootPPShapedRecipe(outputStack, recipe.toArray()));
                continue;
            }
            catch (Exception e) {
                if (comment) continue;
                System.err.println("[Loot++] Caught an exception while trying to add a recipe!");
                e.printStackTrace();
                LootPPNotifier.notify(comment, title, "=( Unexpected problem '" + e.getMessage() + "' while adding a shaped recipe: '" + entry + "'.");
            }
        }
        recipeConfig.addCustomCategoryComment("add_shapeless", "Add each shapeless recipe on a new line in the following format: \n      <output item id>_____<amount>_____<metadata>_____<nbt tag ({} for blank)>_____<input items (up to 9)>...\n\nwhere the input items are in the format:\n\n      ..._____<item id>_____<metadata (-1 for any)>_____<nbt data ({} for any>_____...\n\nIf you want to add an ore dictionary entry, put the string in quotes in place of the item id,\nso for instance \n\n      ..._____\"woodStick\"_____-1_____{}_____... \n\n###############################################  Examples  #############################################\nFor example, if you want to add a recipe for mushroom stew that requires a water bucket, you could write:\n\n      minecraft:mushroom_stew_____1_____0_____{}_____minecraft:red_mushroom_____0_____{}_____minecraft:brown_mushroom_____0_____{}_____minecraft:bowl_____0_____{}_____minecraft:water_bucket_____0_____{}\n\nNote that you will get the bucket back, since it's the container item for the water bucket.\nIf you wanted to add a recipe to add sharpness to a diamond sword using a cactus, you could write:\n\n      minecraft:diamond_sword_____1_____0_____{ench:[{id:16,lvl:1}]}_____minecraft:diamond_sword_____0_____{}_____minecraft:cactus_____0_____{}\n");
        recipeList = ConfigExtrasLoader.combineLists(recipeConfig.get("add_shapeless", "Recipes to add:", new String[0]).getStringList(), (ArrayList)this.namesToExtras.get("add_shapeless"));
        for (index = 0; index < recipeList.size(); ++index) {
            entry = recipeList.get(index);
            comment = false;
            title = this.getFileName() + ".cfg 'add_shapeless' #" + (index + 1);
            if (entry.length() > 0) {
                comment = entry.charAt(0) == '#';
            }
            outputItem = null;
            outputMeta = -1;
            int outputAmount = 1;
            outputNBTString = "{}";
            boolean isOreRecipe = false;
            ArrayList<String> recipeItems = new ArrayList<String>();
            try {
                String[] subEntries = entry.split("_____");
                if (subEntries.length < 7) {
                    if (entry.equals("")) continue;
                    LootPPNotifier.notifyWrongNumberOfParts(comment, title, entry);
                    continue;
                }
                outputItem = Item.func_111206_d((String)subEntries[0]);
                if (outputItem == null) {
                    LootPPNotifier.notifyNonexistant(comment, title, subEntries[0]);
                    continue;
                }
                outputAmount = Integer.parseInt(subEntries[1]);
                outputMeta = Integer.parseInt(subEntries[2]);
                outputNBTString = subEntries[3];
                boolean valid = true;
                for (int i = 4; i + 2 < subEntries.length && i < 32; i += 3) {
                    Item item = null;
                    boolean oreEntry = false;
                    if (subEntries[i].charAt(0) == '\"') {
                        recipeItems.add(subEntries[i].substring(1, subEntries[i].length() - 1));
                        isOreRecipe = true;
                    } else {
                        item = Item.func_111206_d((String)subEntries[i]);
                    }
                    if (item != null) {
                        int itemMeta = Integer.parseInt(subEntries[i + 1]);
                        NBTTagCompound tag = null;
                        try {
                            NBTTagCompound tagBase = JsonToNBT.func_180713_a((String)subEntries[i + 2]);
                            if (tagBase != null) {
                                tag = tagBase;
                            }
                        }
                        catch (NBTException e) {
                            if (!comment) {
                                LootPPNotifier.notifyNBT(comment, title, subEntries[i + 2], e.getMessage());
                                valid = false;
                                e.printStackTrace();
                            }
                            tag = null;
                        }
                        ItemStack stack = new ItemStack(item, 1, itemMeta == -1 ? Short.MAX_VALUE : itemMeta);
                        if (tag != null) {
                            stack.func_77982_d(tag);
                        }
                        recipeItems.add((String)stack);
                        continue;
                    }
                    if (subEntries[i].charAt(0) == '\"') continue;
                    LootPPNotifier.notifyNonexistant(comment, title, subEntries[i + 1]);
                    valid = false;
                }
                if (!valid) continue;
                ItemStack outputStack = new ItemStack(outputItem, outputAmount, outputMeta);
                NBTTagCompound tag = null;
                if (outputNBTString != null && !outputNBTString.equals("{}") && !outputNBTString.equals("")) {
                    try {
                        NBTTagCompound tagBase = JsonToNBT.func_180713_a((String)outputNBTString);
                        if (tagBase != null) {
                            tag = tagBase;
                        }
                    }
                    catch (NBTException e) {
                        if (!comment) {
                            LootPPNotifier.notifyNBT(comment, title, outputNBTString, e.getMessage());
                            e.printStackTrace();
                            continue;
                        }
                        tag = null;
                    }
                }
                if (tag != null) {
                    outputStack.func_77982_d(tag);
                }
                if (LootPlusPlusMod.debug) {
                    System.out.println("[Loot++] Adding Shapeless Recipe giving item " + outputStack);
                }
                GameRegistry.addRecipe((IRecipe)new LootPPShapelessRecipe(outputStack, recipeItems.toArray()));
                continue;
            }
            catch (Exception e) {
                if (comment) continue;
                System.err.println("[Loot++] Caught an exception while trying to add a recipe!");
                e.printStackTrace();
                LootPPNotifier.notify(comment, title, "=( Unexpected problem '" + e.getMessage() + "' while adding a shapeless recipe: '" + entry + "'.");
            }
        }
        recipeConfig.save();
    }
}

