/*
 * Decompiled with CFR 0.152.
 */
package com.tmtravlr.lootplusplus.config;

import com.tmtravlr.lootplusplus.LootPPHelper;
import com.tmtravlr.lootplusplus.LootPPNotifier;
import com.tmtravlr.lootplusplus.LootPlusPlusMod;
import com.tmtravlr.lootplusplus.additions.ItemAddedRecord;
import com.tmtravlr.lootplusplus.config.ConfigExtrasLoader;
import com.tmtravlr.lootplusplus.config.ConfigLoader;
import java.io.File;
import java.util.ArrayList;
import net.minecraft.item.Item;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.registry.GameRegistry;

public class ConfigLoaderRecords
extends ConfigLoader {
    public static ConfigLoaderRecords instance = new ConfigLoaderRecords();

    ConfigLoaderRecords() {
        this.namesToExtras.put("records", new ArrayList());
    }

    @Override
    public String getFileName() {
        return "records";
    }

    public void loadRecordConfig() {
        Configuration recordConfig = new Configuration(new File(LootPPHelper.configFolder, this.getFileName() + ".cfg"));
        recordConfig.load();
        recordConfig.addCustomCategoryComment("records", "To add new records, you will have to do 4 things:\n1.) Add a .ogg sound file to the resource pack in the assets/lootplusplus/sounds/records folder.\n\n2.) Add a .json model file to the resource pack in the assets/lootplusplus/models/item folder.\n\n3.) Edit the sounds.json file in the resource pack, adding a new entry in the form:\n  \"records.<record name>\": {\n    \"category\": \"record\",\n    \"sounds\": [\n      {\n        \"name\": \"records/<record name>\",\n        \"stream\": true\n      }\n    ]\n  }\nwhere <record name> is the name of the ogg file (withough .ogg)\n\n4.) Add an entry to this list in the form <record name>-<description>,\nwhere the record name is the name of the ogg file (without .ogg) and the model file\n(without .json). The description is what will display when the record plays.\n\nThe resource pack you can download has records for all the default music.\nDon't forget to load in and edit the resource pack!\n\nThe following are already set up correctly in the resource pack. You can add each\nline to the list below as examples (delete the # in front of them).\n\ncreative1-C418 - Biome Fest\ncreative2-C418 - Blind Spots\ncreative3-C418 - Haunt Muskie\ncreative4-C418 - Aria Math\ncreative5-C418 - Dreiton\ncreative6-C418 - Taswell\nend-C418 - The End\ncredits-C418 - Alpha\nnether1-C418 - Concrete Halls\nnether2-C418 - Dead Voxel\nnether3-C418 - Warmth\nnether4-C418 - Ballad of the Cats\nmenu1-C418 - Mutation\nmenu2-C418 - Moog City 2\nmenu3-C418 - Beginning 2\nmenu4-C418 - Floating Trees\ncalm1-C418 - Minecraft\ncalm2-C418 - Clark\ncalm3-C418 - Sweden\nhal1-C418 - Subwoofer Lullaby\nhal2-C418 - Living Mice\nhal3-C418 - Haggstrom\nhal4-C418 - Danny\nnuance1-C418 - Key\nnuance2-C418 - Oxyg\u00ef\u00bf\u00bdne\npiano1-C418 - Dry Hands\npiano2-C418 - Wet Hands\npiano3-C418 - Mice on Venus");
        ArrayList<String> additionsList = ConfigExtrasLoader.combineLists(recordConfig.get("records", "List of records:", new String[0]).getStringList(), (ArrayList)this.namesToExtras.get("records"));
        LootPPHelper.creepersDropAllRecords = recordConfig.get("options", "Creepers drop any type of record (vanilla or modded) when killed by skeletons?", true).getBoolean();
        LootPPHelper.creepersDropRecords = recordConfig.get("options", "Creepers can drop records when killed by skeletons?", true).getBoolean();
        for (int index = 0; index < additionsList.size(); ++index) {
            String entry = additionsList.get(index);
            boolean comment = false;
            String title = this.getFileName() + ".cfg #" + (index + 1);
            if (entry.length() > 0) {
                boolean bl = comment = entry.charAt(0) == '#';
            }
            if (comment) continue;
            String[] parts = entry.split("-", 2);
            if (parts.length != 2) {
                if (entry.equals("")) continue;
                LootPPNotifier.notifyWrongNumberOfParts(comment, title, entry);
                continue;
            }
            String recordName = parts[0];
            String description = parts[1];
            Item customRecord = new ItemAddedRecord(recordName, description).func_77655_b(recordName);
            GameRegistry.registerItem((Item)customRecord, (String)recordName);
            LootPlusPlusMod.proxy.registerItemRender(customRecord);
        }
        recordConfig.save();
    }
}

