/*
 * Decompiled with CFR 0.152.
 */
package com.tmtravlr.lootplusplus.config;

import com.tmtravlr.lootplusplus.LootPPHelper;
import com.tmtravlr.lootplusplus.LootPPNotifier;
import com.tmtravlr.lootplusplus.config.ConfigExtrasLoader;
import com.tmtravlr.lootplusplus.config.ConfigLoader;
import java.io.File;
import java.util.ArrayList;
import net.minecraft.item.Item;
import net.minecraftforge.common.config.Configuration;

public class ConfigLoaderStackSize
extends ConfigLoader {
    public static ConfigLoaderStackSize instance = new ConfigLoaderStackSize();

    ConfigLoaderStackSize() {
        this.namesToExtras.put("stack_sizes", new ArrayList());
    }

    @Override
    public String getFileName() {
        return "stack_size";
    }

    public void loadStackSizes() {
        Configuration stackSizeConfig = new Configuration(new File(LootPPHelper.configFolder, this.getFileName() + ".cfg"));
        stackSizeConfig.load();
        stackSizeConfig.setCategoryComment("stack_sizes", "You can change the stack size of any item/block in the following format:\n\n      <Item/Block name>_____<Stack size>\n\nFor instance, if you want to allow potions to stack up to 3, you could put:\n\n      minecraft:potion_____3");
        ArrayList<String> additionsList = ConfigExtrasLoader.combineLists(stackSizeConfig.get("stack_sizes", "stack_sizes", new String[0]).getStringList(), (ArrayList)this.namesToExtras.get("stack_sizes"));
        for (int index = 0; index < additionsList.size(); ++index) {
            int stackSize;
            String itemName;
            String title;
            boolean comment;
            block6: {
                String[] parts;
                String addition = additionsList.get(index);
                comment = false;
                title = this.getFileName() + ".cfg 'stack_sizes' #" + (index + 1);
                if (addition.length() > 0) {
                    boolean bl = comment = addition.charAt(0) == '#';
                }
                if ((parts = addition.split("_____")).length != 2) {
                    if (addition.equals("")) continue;
                    LootPPNotifier.notifyWrongNumberOfParts(comment, title, addition);
                    continue;
                }
                itemName = parts[0];
                stackSize = 64;
                try {
                    stackSize = Integer.valueOf(parts[1]);
                }
                catch (NumberFormatException e) {
                    if (comment) break block6;
                    System.err.println("[Loot++] Caught exception while trying to modify stack size of " + itemName);
                    e.printStackTrace();
                    LootPPNotifier.notifyNumber(comment, title, parts[1]);
                }
            }
            Item item = Item.func_111206_d((String)itemName);
            if (item == null) {
                LootPPNotifier.notifyNonexistant(comment, title, itemName);
                continue;
            }
            item.func_77625_d(stackSize);
        }
        stackSizeConfig.save();
    }
}

