/*
 * Decompiled with CFR 0.152.
 */
package com.tmtravlr.lootplusplus.effects;

import com.tmtravlr.lootplusplus.LootPPBlocks;
import com.tmtravlr.lootplusplus.LootPPHelper;
import com.tmtravlr.lootplusplus.LootPPItems;
import com.tmtravlr.lootplusplus.commands.CommandSenderGeneric;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Random;
import java.util.TreeMap;
import java.util.TreeSet;
import net.minecraft.block.state.IBlockState;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.BlockPos;
import net.minecraft.util.Vec3;

public class GiveEffects {
    private static Random rand = new Random();
    public static TreeMap<ItemStack, ArrayList<EffectInfo>> entityOnHitEntityMap = new TreeMap(LootPPHelper.stackComparatorNBT);
    public static TreeMap<ItemStack, ArrayList<EffectInfo>> youOnHitEntityMap = new TreeMap(LootPPHelper.stackComparatorNBT);
    public static TreeMap<ItemStack, ArrayList<EffectInfo>> onItemBlockDigMap = new TreeMap(LootPPHelper.stackComparatorNBT);
    public static TreeMap<ItemStack, ArrayList<EffectInfo>> onItemBlockBrokeMap = new TreeMap(LootPPHelper.stackComparatorNBT);
    public static TreeMap<ItemStack, ArrayList<EffectInfo>> onRightClickMap = new TreeMap(LootPPHelper.stackComparatorNBT);
    public static TreeMap<ItemStack, ArrayList<EffectInfo>> onWornMap = new TreeMap(LootPPHelper.stackComparatorNBT);
    public static TreeMap<ItemStack, ArrayList<EffectInfo>> onHeldMap = new TreeMap(LootPPHelper.stackComparatorNBT);
    public static TreeMap<ItemStack, ArrayList<EffectInfo>> onPassiveMap = new TreeMap(LootPPHelper.stackComparatorNBT);
    public static TreeMap<LootPPHelper.BlockMeta, ArrayList<EffectInfo>> standingOnMap = new TreeMap(LootPPHelper.blockComparator);
    public static TreeMap<LootPPHelper.BlockMeta, ArrayList<EffectInfo>> insideMap = new TreeMap(LootPPHelper.blockComparator);
    public static TreeMap<LootPPHelper.BlockMeta, ArrayList<EffectInfo>> onBlockBlockDigMap = new TreeMap(LootPPHelper.blockComparator);
    public static TreeMap<LootPPHelper.BlockMeta, ArrayList<EffectInfo>> onBlockBlockBrokeMap = new TreeMap(LootPPHelper.blockComparator);

    public static void giveEntityHitEffects(EntityLivingBase entityHitting, EntityLivingBase entityHit) {
        HashSet<EffectInfo> infoSet;
        ItemStack held = entityHitting.func_70694_bm();
        ItemStack heldWild = held.func_77946_l();
        heldWild.func_77964_b(Short.MAX_VALUE);
        ItemStack dummy = held.func_77946_l();
        dummy.func_150996_a(LootPPItems.generalDummyIcon);
        ItemStack dummyWild = dummy.func_77946_l();
        dummyWild.func_77964_b(Short.MAX_VALUE);
        if (!entityOnHitEntityMap.isEmpty()) {
            infoSet = new HashSet<EffectInfo>();
            GiveEffects.addAllRelevant(dummy, dummyWild, held, heldWild, infoSet, entityOnHitEntityMap);
            for (EffectInfo info : infoSet) {
                if (!(info.probability >= rand.nextFloat())) continue;
                GiveEffects.addEffectToEntity(entityHit, info);
            }
        }
        if (!youOnHitEntityMap.isEmpty()) {
            infoSet = new HashSet();
            GiveEffects.addAllRelevant(dummy, dummyWild, held, heldWild, infoSet, youOnHitEntityMap);
            for (EffectInfo info : infoSet) {
                if (!(info.probability >= rand.nextFloat())) continue;
                GiveEffects.addEffectToEntity(entityHitting, info);
            }
        }
    }

    public static void giveDigEffects(EntityLivingBase entity, IBlockState state) {
        ItemStack held = entity.func_70694_bm();
        if (held != null) {
            ItemStack heldWild = held.func_77946_l();
            heldWild.func_77964_b(Short.MAX_VALUE);
            ItemStack dummy = held.func_77946_l();
            dummy.func_150996_a(LootPPItems.generalDummyIcon);
            ItemStack dummyWild = dummy.func_77946_l();
            dummyWild.func_77964_b(Short.MAX_VALUE);
            if (!onItemBlockDigMap.isEmpty()) {
                HashSet<EffectInfo> infoSet = new HashSet<EffectInfo>();
                GiveEffects.addAllRelevant(dummy, dummyWild, held, heldWild, infoSet, onItemBlockDigMap);
                for (EffectInfo info : infoSet) {
                    if (!(info.probability >= rand.nextFloat())) continue;
                    GiveEffects.addEffectToEntity(entity, info);
                }
            }
        }
        LootPPHelper.BlockMeta info = new LootPPHelper.BlockMeta(state);
        LootPPHelper.BlockMeta infoWild = new LootPPHelper.BlockMeta(info.block, Short.MAX_VALUE);
        LootPPHelper.BlockMeta infoDummy = new LootPPHelper.BlockMeta(LootPPBlocks.blockCommandBlockTrigger, info.meta);
        LootPPHelper.BlockMeta infoDummyWild = new LootPPHelper.BlockMeta(infoDummy.block, Short.MAX_VALUE);
        HashSet<EffectInfo> infoSet = new HashSet<EffectInfo>();
        GiveEffects.addAllRelevantBlocks(infoDummy, infoDummyWild, info, infoWild, infoSet, onBlockBlockDigMap);
        for (EffectInfo effectInfo : infoSet) {
            if (!(effectInfo.probability >= rand.nextFloat())) continue;
            GiveEffects.addEffectToEntity(entity, effectInfo);
        }
    }

    public static void giveBreakEffects(EntityLivingBase entity, IBlockState state) {
        ItemStack held = entity.func_70694_bm();
        if (held != null) {
            ItemStack heldWild = held.func_77946_l();
            heldWild.func_77964_b(Short.MAX_VALUE);
            ItemStack dummy = held.func_77946_l();
            dummy.func_150996_a(LootPPItems.generalDummyIcon);
            ItemStack dummyWild = dummy.func_77946_l();
            dummyWild.func_77964_b(Short.MAX_VALUE);
            if (!onItemBlockBrokeMap.isEmpty()) {
                HashSet<EffectInfo> infoSet = new HashSet<EffectInfo>();
                GiveEffects.addAllRelevant(dummy, dummyWild, held, heldWild, infoSet, onItemBlockBrokeMap);
                for (EffectInfo info : infoSet) {
                    if (!(info.probability >= rand.nextFloat())) continue;
                    GiveEffects.addEffectToEntity(entity, info);
                }
            }
        }
        LootPPHelper.BlockMeta info = new LootPPHelper.BlockMeta(state);
        LootPPHelper.BlockMeta infoWild = new LootPPHelper.BlockMeta(info.block, Short.MAX_VALUE);
        LootPPHelper.BlockMeta infoDummy = new LootPPHelper.BlockMeta(LootPPBlocks.blockCommandBlockTrigger, info.meta);
        LootPPHelper.BlockMeta infoDummyWild = new LootPPHelper.BlockMeta(infoDummy.block, Short.MAX_VALUE);
        HashSet<EffectInfo> infoSet = new HashSet<EffectInfo>();
        GiveEffects.addAllRelevantBlocks(infoDummy, infoDummyWild, info, infoWild, infoSet, onBlockBlockBrokeMap);
        for (EffectInfo effectInfo : infoSet) {
            if (!(effectInfo.probability >= rand.nextFloat())) continue;
            GiveEffects.addEffectToEntity(entity, effectInfo);
        }
    }

    public static void giveRightClickEffects(EntityLivingBase entity) {
        ItemStack held = entity.func_70694_bm();
        ItemStack heldWild = held.func_77946_l();
        heldWild.func_77964_b(Short.MAX_VALUE);
        ItemStack dummy = held.func_77946_l();
        dummy.func_150996_a(LootPPItems.generalDummyIcon);
        ItemStack dummyWild = dummy.func_77946_l();
        dummyWild.func_77964_b(Short.MAX_VALUE);
        if (!onRightClickMap.isEmpty()) {
            HashSet<EffectInfo> infoSet = new HashSet<EffectInfo>();
            GiveEffects.addAllRelevant(dummy, dummyWild, held, heldWild, infoSet, onRightClickMap);
            for (EffectInfo info : infoSet) {
                if (!(info.probability >= rand.nextFloat())) continue;
                GiveEffects.addEffectToEntity(entity, info);
            }
        }
    }

    public static void givePassiveEffects(EntityLivingBase entity) {
        BlockPos maxPos;
        BlockPos minPos;
        EffectInfo info;
        Iterator<EffectInfo> iterator;
        Object infoSet;
        ItemStack dummyWild;
        ItemStack dummy;
        if (!onHeldMap.isEmpty() && entity.func_70694_bm() != null) {
            ItemStack held = entity.func_70694_bm();
            ItemStack heldWild = held.func_77946_l();
            heldWild.func_77964_b(Short.MAX_VALUE);
            ItemStack dummy2 = held.func_77946_l();
            dummy2.func_150996_a(LootPPItems.generalDummyIcon);
            ItemStack dummyWild2 = dummy2.func_77946_l();
            dummyWild2.func_77964_b(Short.MAX_VALUE);
            HashSet<EffectInfo> infoSet2 = new HashSet<EffectInfo>();
            GiveEffects.addAllRelevant(dummy2, dummyWild2, held, heldWild, infoSet2, onHeldMap);
            for (EffectInfo info2 : infoSet2) {
                if (!(info2.probability >= rand.nextFloat())) continue;
                GiveEffects.addEffectToEntity(entity, info2);
            }
        }
        if (!onPassiveMap.isEmpty()) {
            ArrayList<ItemStack> inventory = new ArrayList<ItemStack>();
            if (entity instanceof EntityPlayer) {
                inventory.addAll(Arrays.asList(((EntityPlayer)entity).field_71071_by.field_70462_a));
            }
            if (entity.func_70035_c() != null) {
                inventory.addAll(Arrays.asList(entity.func_70035_c()));
            }
            for (ItemStack stack : inventory) {
                if (stack == null) continue;
                ItemStack passiveWild = stack.func_77946_l();
                passiveWild.func_77964_b(Short.MAX_VALUE);
                dummy = stack.func_77946_l();
                dummy.func_150996_a(LootPPItems.generalDummyIcon);
                dummyWild = dummy.func_77946_l();
                dummyWild.func_77964_b(Short.MAX_VALUE);
                infoSet = new HashSet<EffectInfo>();
                GiveEffects.addAllRelevant(dummy, dummyWild, stack, passiveWild, infoSet, onPassiveMap);
                iterator = ((HashSet)infoSet).iterator();
                while (iterator.hasNext()) {
                    info = iterator.next();
                    if (!(info.probability >= rand.nextFloat())) continue;
                    GiveEffects.addEffectToEntity(entity, info);
                }
            }
        }
        if (!onWornMap.isEmpty()) {
            TreeSet<ItemStack> armor = new TreeSet<ItemStack>(LootPPHelper.stackComparatorWild);
            if (entity instanceof EntityPlayer) {
                armor.addAll(Arrays.asList(entity.func_70035_c()));
            } else {
                for (int i = 1; i < 5; ++i) {
                    armor.add(entity.func_71124_b(i));
                }
            }
            for (ItemStack stack : armor) {
                if (stack == null) continue;
                ItemStack pieceWild = stack.func_77946_l();
                pieceWild.func_77964_b(Short.MAX_VALUE);
                dummy = stack.func_77946_l();
                dummy.func_150996_a(LootPPItems.generalDummyIcon);
                dummyWild = dummy.func_77946_l();
                dummyWild.func_77964_b(Short.MAX_VALUE);
                infoSet = new HashSet();
                GiveEffects.addAllRelevant(dummy, dummyWild, stack, pieceWild, (HashSet<EffectInfo>)infoSet, onWornMap);
                iterator = ((HashSet)infoSet).iterator();
                while (iterator.hasNext()) {
                    info = iterator.next();
                    if (!(info.probability >= rand.nextFloat()) || !info.alsoEquipped.isEmpty() && !armor.containsAll(info.alsoEquipped)) continue;
                    GiveEffects.addEffectToEntity(entity, info);
                }
            }
        }
        if (!standingOnMap.isEmpty()) {
            IBlockState state = entity.field_70170_p.func_180495_p(entity.func_180425_c().func_177977_b());
            LootPPHelper.BlockMeta info3 = new LootPPHelper.BlockMeta(state);
            LootPPHelper.BlockMeta infoWild = new LootPPHelper.BlockMeta(info3.block, Short.MAX_VALUE);
            LootPPHelper.BlockMeta infoDummy = new LootPPHelper.BlockMeta(LootPPBlocks.blockCommandBlockTrigger, info3.meta);
            LootPPHelper.BlockMeta infoDummyWild = new LootPPHelper.BlockMeta(infoDummy.block, Short.MAX_VALUE);
            HashSet<EffectInfo> infoSet3 = new HashSet<EffectInfo>();
            GiveEffects.addAllRelevantBlocks(infoDummy, infoDummyWild, info3, infoWild, infoSet3, standingOnMap);
            for (EffectInfo effectInfo : infoSet3) {
                if (!(effectInfo.probability >= rand.nextFloat())) continue;
                GiveEffects.addEffectToEntity(entity, effectInfo);
            }
        }
        if (!insideMap.isEmpty() && entity.field_70170_p.func_175707_a(minPos = new BlockPos(entity.func_174813_aQ().field_72340_a, entity.func_174813_aQ().field_72338_b, entity.func_174813_aQ().field_72339_c), maxPos = new BlockPos(entity.func_174813_aQ().field_72336_d, entity.func_174813_aQ().field_72337_e, entity.func_174813_aQ().field_72334_f))) {
            for (int i = minPos.func_177958_n(); i <= maxPos.func_177958_n(); ++i) {
                for (int j = minPos.func_177956_o(); j <= maxPos.func_177956_o(); ++j) {
                    for (int k = minPos.func_177952_p(); k <= maxPos.func_177952_p(); ++k) {
                        BlockPos currentPos = new BlockPos(i, j, k);
                        IBlockState state = entity.field_70170_p.func_180495_p(currentPos);
                        LootPPHelper.BlockMeta info4 = new LootPPHelper.BlockMeta(state);
                        LootPPHelper.BlockMeta infoWild = new LootPPHelper.BlockMeta(info4.block, Short.MAX_VALUE);
                        LootPPHelper.BlockMeta infoDummy = new LootPPHelper.BlockMeta(LootPPBlocks.blockCommandBlockTrigger, info4.meta);
                        LootPPHelper.BlockMeta infoDummyWild = new LootPPHelper.BlockMeta(infoDummy.block, Short.MAX_VALUE);
                        HashSet<EffectInfo> infoSet4 = new HashSet<EffectInfo>();
                        GiveEffects.addAllRelevantBlocks(infoDummy, infoDummyWild, info4, infoWild, infoSet4, insideMap);
                        for (EffectInfo effectInfo : infoSet4) {
                            if (!(effectInfo.probability >= rand.nextFloat())) continue;
                            GiveEffects.addEffectToEntity(entity, effectInfo);
                        }
                    }
                }
            }
        }
    }

    public static void addAllRelevant(ItemStack dummy, ItemStack dummyWild, ItemStack current, ItemStack currentWild, HashSet<EffectInfo> infoSet, TreeMap<ItemStack, ArrayList<EffectInfo>> effectMap) {
        GiveEffects.addRelevant(dummy, infoSet, effectMap);
        GiveEffects.addRelevant(dummyWild, infoSet, effectMap);
        GiveEffects.addRelevant(current, infoSet, effectMap);
        GiveEffects.addRelevant(currentWild, infoSet, effectMap);
    }

    public static void addAllRelevantBlocks(LootPPHelper.BlockMeta dummy, LootPPHelper.BlockMeta dummyWild, LootPPHelper.BlockMeta current, LootPPHelper.BlockMeta currentWild, HashSet<EffectInfo> infoSet, TreeMap<LootPPHelper.BlockMeta, ArrayList<EffectInfo>> effectMap) {
        GiveEffects.addRelevantBlocks(dummy, infoSet, effectMap);
        GiveEffects.addRelevantBlocks(dummyWild, infoSet, effectMap);
        GiveEffects.addRelevantBlocks(current, infoSet, effectMap);
        GiveEffects.addRelevantBlocks(currentWild, infoSet, effectMap);
    }

    public static void addRelevant(ItemStack stack, HashSet<EffectInfo> infoSet, TreeMap<ItemStack, ArrayList<EffectInfo>> effectMap) {
        for (ItemStack effectStack : effectMap.keySet()) {
            if (stack == null || effectStack == null || stack.func_77973_b() != effectStack.func_77973_b() || !LootPPHelper.compareNBT((NBTBase)effectStack.func_77978_p(), (NBTBase)stack.func_77978_p()) || effectMap.get(effectStack) == null) continue;
            infoSet.addAll((Collection<EffectInfo>)effectMap.get(effectStack));
        }
    }

    public static void addRelevantBlocks(LootPPHelper.BlockMeta blockInfo, HashSet<EffectInfo> infoSet, TreeMap<LootPPHelper.BlockMeta, ArrayList<EffectInfo>> effectMap) {
        for (LootPPHelper.BlockMeta effectBlock : effectMap.keySet()) {
            if (blockInfo == null || effectBlock == null || blockInfo.block != effectBlock.block || effectBlock.meta != Short.MAX_VALUE && blockInfo.meta != effectBlock.meta || effectMap.get(effectBlock) == null) continue;
            infoSet.addAll((Collection<EffectInfo>)effectMap.get(effectBlock));
        }
    }

    public static void addEffectToEntity(EntityLivingBase entity, EffectInfo info) {
        GiveEffects.addEffectToEntity(entity, info, false);
    }

    public static void addEffectToEntity(EntityLivingBase entity, EffectInfo info, boolean force) {
        if (info.effectType == EffectType.POTION && info.getEffectInfoPotion() != null) {
            GiveEffects.addPotionEffect(entity, info.getEffectInfoPotion(), force);
        }
        if (info.effectType == EffectType.COMMAND && info.getEffectInfoCommand() != null) {
            GiveEffects.addCommandEffect(entity, info.getEffectInfoCommand(), force);
        }
    }

    public static void addPotionEffect(EntityLivingBase entity, EffectInfoPotion info, boolean force) {
        PotionEffect existingEffect = entity.func_70660_b(info.effect);
        PotionEffect effect = new PotionEffect(info.effect.func_76396_c(), info.effectDuration, info.effectStrength, info.particleType.equalsIgnoreCase("faded"), !info.particleType.equalsIgnoreCase("none"));
        if (!(existingEffect == null || existingEffect.func_76458_c() < effect.func_76458_c() || info.effect == Potion.field_76439_r || force && info.effect != Potion.field_180152_w)) {
            if (existingEffect.func_76459_b() <= 1) {
                existingEffect.func_76452_a(effect);
            }
        } else {
            entity.func_70690_d(effect);
        }
    }

    public static void addCommandEffect(EntityLivingBase entity, EffectInfoCommand info, boolean force) {
        MinecraftServer.func_71276_C().func_71187_D().func_71556_a((ICommandSender)new CommandSenderGeneric(entity.func_70005_c_(), entity.field_70170_p, new Vec3(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v)), info.command);
    }

    public static class EffectInfoCommand
    extends EffectInfo {
        public String command;

        public EffectInfoCommand(float probabilityToSet, String commandToSet) {
            this.probability = probabilityToSet;
            this.command = commandToSet;
            this.effectType = EffectType.COMMAND;
        }

        public String toString() {
            String toReturn = "{command: " + this.command + ", probability: " + this.probability;
            if (!this.alsoEquipped.isEmpty()) {
                toReturn = toReturn + ", also:{ ";
                for (ItemStack stack : this.alsoEquipped) {
                    toReturn = toReturn + Item.field_150901_e.func_177774_c((Object)stack.func_77973_b()) + "-" + stack.func_77952_i() + " ";
                }
                toReturn = toReturn + "} ";
            }
            return toReturn + "}";
        }
    }

    public static class EffectInfoPotion
    extends EffectInfo {
        public Potion effect;
        public int effectDuration;
        public int effectStrength;
        public String particleType;

        public EffectInfoPotion() {
            this(Potion.field_76424_c, 0, 0, 0.0f, "normal");
        }

        public EffectInfoPotion(Potion potion, int duration, int strength, float chance, String particles) {
            this.effect = potion;
            this.effectDuration = duration;
            this.effectStrength = strength;
            this.probability = chance;
            this.particleType = particles;
            this.effectType = EffectType.POTION;
        }

        public String toString() {
            String toReturn = "{id: " + this.effect + ", duration: " + this.effectDuration + ", strength: " + this.effectStrength + ", probability: " + this.probability + ", particles: " + this.particleType;
            if (!this.alsoEquipped.isEmpty()) {
                toReturn = toReturn + ", also:{ ";
                for (ItemStack stack : this.alsoEquipped) {
                    toReturn = toReturn + Item.field_150901_e.func_177774_c((Object)stack.func_77973_b()) + "-" + stack.func_77952_i() + " ";
                }
                toReturn = toReturn + "} ";
            }
            return toReturn + "}";
        }
    }

    public static abstract class EffectInfo {
        public float probability;
        public EffectType effectType;
        public ArrayList<ItemStack> alsoEquipped = new ArrayList();

        public EffectInfoPotion getEffectInfoPotion() {
            return this instanceof EffectInfoPotion ? (EffectInfoPotion)this : null;
        }

        public EffectInfoCommand getEffectInfoCommand() {
            return this instanceof EffectInfoCommand ? (EffectInfoCommand)this : null;
        }
    }

    public static enum EffectType {
        POTION,
        COMMAND;

    }
}

