/*
 * Decompiled with CFR 0.152.
 */
package com.tmtravlr.lootplusplus.recipes;

import com.tmtravlr.lootplusplus.LootPPHelper;
import java.util.Iterator;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;

public class LootPPShapedRecipe
extends ShapedOreRecipe {
    public static final int MAX_CRAFT_GRID_WIDTH = 3;
    public static final int MAX_CRAFT_GRID_HEIGHT = 3;

    public LootPPShapedRecipe(Block result, Object ... recipe) {
        super(result, recipe);
    }

    public LootPPShapedRecipe(Item result, Object ... recipe) {
        super(result, recipe);
    }

    public LootPPShapedRecipe(ItemStack result, Object ... recipe) {
        super(result, recipe);
    }

    public ItemStack func_77572_b(InventoryCrafting var1) {
        return this.output.func_77946_l();
    }

    public int func_77570_a() {
        return this.input.length;
    }

    public ItemStack func_77571_b() {
        return this.output;
    }

    public boolean func_77569_a(InventoryCrafting inv, World world) {
        for (int x = 0; x <= 3 - this.width; ++x) {
            for (int y = 0; y <= 3 - this.height; ++y) {
                if (this.checkMatch(inv, x, y, false)) {
                    return true;
                }
                if (!this.mirrored || !this.checkMatch(inv, x, y, true)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean checkMatch(InventoryCrafting inv, int startX, int startY, boolean mirror) {
        for (int x = 0; x < 3; ++x) {
            for (int y = 0; y < 3; ++y) {
                int subX = x - startX;
                int subY = y - startY;
                Object target = null;
                if (subX >= 0 && subY >= 0 && subX < this.width && subY < this.height) {
                    target = mirror ? this.input[this.width - subX - 1 + subY * this.width] : this.input[subX + subY * this.width];
                }
                ItemStack slot = inv.func_70463_b(x, y);
                if (target instanceof ItemStack) {
                    if (!OreDictionary.itemMatches((ItemStack)((ItemStack)target), (ItemStack)slot, (boolean)false)) {
                        return false;
                    }
                    ItemStack targetStack = (ItemStack)target;
                    if (!targetStack.func_77942_o() || targetStack.func_77978_p().func_82582_d() || LootPPHelper.compareNBT((NBTBase)targetStack.func_77978_p(), (NBTBase)slot.func_77978_p())) continue;
                    return false;
                }
                if (target instanceof List) {
                    boolean matched = false;
                    Iterator itr = ((List)target).iterator();
                    while (itr.hasNext() && !matched) {
                        matched = OreDictionary.itemMatches((ItemStack)((ItemStack)itr.next()), (ItemStack)slot, (boolean)false);
                    }
                    if (matched) continue;
                    return false;
                }
                if (target != null || slot == null) continue;
                return false;
            }
        }
        return true;
    }

    public ShapedOreRecipe setMirrored(boolean mirror) {
        this.mirrored = mirror;
        return this;
    }

    public Object[] getInput() {
        return this.input;
    }

    public ItemStack[] func_179532_b(InventoryCrafting inv) {
        return ForgeHooks.defaultRecipeGetRemainingItems((InventoryCrafting)inv);
    }
}

