/*
 * Decompiled with CFR 0.152.
 */
package com.tmtravlr.lootplusplus.testing;

import java.util.Random;
import net.minecraft.block.BlockFence;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemMonsterPlacer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatList;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.ReportedException;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemTestingEntitySpawner
extends ItemMonsterPlacer {
    public ItemTestingEntitySpawner() {
        this.func_77627_a(false);
        this.func_77637_a(null);
    }

    public boolean func_180614_a(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ) {
        Entity entity;
        if (world.field_72995_K) {
            return true;
        }
        if (!player.func_175151_a(pos.func_177972_a(side), side, stack)) {
            return false;
        }
        IBlockState iblockstate = world.func_180495_p(pos);
        pos = pos.func_177972_a(side);
        double d0 = 0.0;
        if (side == EnumFacing.UP && iblockstate instanceof BlockFence) {
            d0 = 0.5;
        }
        if ((entity = ItemTestingEntitySpawner.spawnEntity(world, stack, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + d0, (double)pos.func_177952_p() + 0.5)) != null) {
            if (!player.field_71075_bZ.field_75098_d) {
                --stack.field_77994_a;
            }
            player.func_71029_a(StatList.field_75929_E[Item.func_150891_b((Item)this)]);
        }
        return true;
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        if (world.field_72995_K) {
            return stack;
        }
        MovingObjectPosition movingobjectposition = this.func_77621_a(world, player, true);
        if (movingobjectposition == null) {
            return stack;
        }
        if (movingobjectposition.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
            Entity entity;
            BlockPos blockpos = movingobjectposition.func_178782_a();
            if (!world.func_175660_a(player, blockpos)) {
                return stack;
            }
            if (!player.func_175151_a(blockpos, movingobjectposition.field_178784_b, stack)) {
                return stack;
            }
            if (world.func_180495_p(blockpos).func_177230_c() instanceof BlockLiquid && (entity = ItemTestingEntitySpawner.spawnEntity(world, stack, (double)blockpos.func_177958_n() + 0.5, (double)blockpos.func_177956_o() + 0.5, (double)blockpos.func_177952_p() + 0.5)) != null) {
                if (!player.field_71075_bZ.field_75098_d) {
                    --stack.field_77994_a;
                }
                player.func_71029_a(StatList.field_75929_E[Item.func_150891_b((Item)this)]);
            }
        }
        return stack;
    }

    public static Entity spawnEntity(World world, ItemStack is, double xpos, double ypos, double zpos) {
        if (is.func_77978_p() == null || !is.func_77978_p().func_74764_b("EntityName")) {
            EntityList.EntityEggInfo entityegginfo = (EntityList.EntityEggInfo)EntityList.field_75627_a.get(is.func_77952_i());
            if (entityegginfo != null) {
                boolean hasNoNBT = is.func_77978_p() != null && !is.func_77978_p().func_74764_b("EntityData");
                Entity entity = null;
                if (hasNoNBT) {
                    entity = EntityList.func_75616_a((int)is.func_77952_i(), (World)world);
                } else {
                    NBTTagCompound nbttagcompound = new NBTTagCompound();
                    try {
                        nbttagcompound = (NBTTagCompound)is.func_77978_p().func_74775_l("EntityData").func_74737_b();
                    }
                    catch (Exception e) {
                        System.out.println("[Loot++] Caught Exception while trying to read in NBT data.");
                        e.printStackTrace();
                    }
                    nbttagcompound.func_74778_a("id", EntityList.func_75617_a((int)is.func_77952_i()));
                    entity = EntityList.func_75615_a((NBTTagCompound)nbttagcompound, (World)world);
                }
                if (entity != null) {
                    entity.func_70012_b(xpos, ypos, zpos, MathHelper.func_76142_g((float)(world.field_73012_v.nextFloat() * 360.0f)), 0.0f);
                    if (entity instanceof EntityLiving) {
                        ((EntityLiving)entity).field_70759_as = entity.field_70177_z;
                        ((EntityLiving)entity).field_70761_aq = entity.field_70177_z;
                        if (hasNoNBT) {
                            ((EntityLiving)entity).func_180482_a(world.func_175649_E(entity.func_180425_c()), null);
                        }
                    }
                    world.func_72838_d(entity);
                }
                return entity;
            }
            return null;
        }
        String entityName = is.func_77978_p().func_74779_i("EntityName");
        if (entityName == null || entityName.equals("")) {
            return null;
        }
        boolean hasNoNBT = !is.func_77978_p().func_74764_b("EntityData");
        Entity entity = null;
        if (hasNoNBT) {
            entity = EntityList.func_75620_a((String)entityName, (World)world);
        } else {
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            try {
                nbttagcompound = (NBTTagCompound)is.func_77978_p().func_74775_l("EntityData").func_74737_b();
            }
            catch (ReportedException e) {
                System.out.println("[Loot++] Caught Exception while trying to read in NBT data.");
                e.printStackTrace();
            }
            nbttagcompound.func_74778_a("id", entityName);
            entity = EntityList.func_75615_a((NBTTagCompound)nbttagcompound, (World)world);
        }
        if (entity != null) {
            entity.func_70012_b(xpos, ypos, zpos, MathHelper.func_76142_g((float)(world.field_73012_v.nextFloat() * 360.0f)), 0.0f);
            if (entity instanceof EntityLiving) {
                ((EntityLiving)entity).field_70759_as = entity.field_70177_z;
                ((EntityLiving)entity).field_70761_aq = entity.field_70177_z;
                if (hasNoNBT) {
                    ((EntityLiving)entity).func_180482_a(world.func_175649_E(entity.func_180425_c()), null);
                }
            }
            world.func_72838_d(entity);
        }
        return entity;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_82790_a(ItemStack stack, int layer) {
        NBTTagCompound tag = stack.func_77978_p();
        if (tag != null) {
            if (tag.func_74764_b("Icon")) {
                return 0xFFFFFF;
            }
            if (layer == 0 && tag.func_74764_b("PrimaryColor") || layer != 0 && tag.func_74764_b("SecondaryColor")) {
                return layer == 0 ? tag.func_74762_e("PrimaryColor") : tag.func_74762_e("SecondaryColor");
            }
            int color = 0xFFFFFF;
            try {
                Entity entity = EntityList.func_75620_a((String)tag.func_74779_i("EntityName"), (World)Minecraft.func_71410_x().field_71441_e);
                if (entity == null) {
                    EntityList.EntityEggInfo entityegginfo = (EntityList.EntityEggInfo)EntityList.field_75627_a.get(stack.func_77952_i());
                    return entityegginfo != null ? (layer == 0 ? entityegginfo.field_75611_b : entityegginfo.field_75612_c) : 0xFFFFFF;
                }
                int entityId = EntityList.func_75619_a((Entity)entity);
                EntityList.EntityEggInfo eggInfo = (EntityList.EntityEggInfo)EntityList.field_75627_a.get(entityId);
                if (eggInfo != null) {
                    if (layer == 0) {
                        tag.func_74768_a("PrimaryColor", eggInfo.field_75611_b);
                    } else {
                        tag.func_74768_a("SecondaryColor", eggInfo.field_75612_c);
                    }
                    return layer == 0 ? eggInfo.field_75611_b : eggInfo.field_75612_c;
                }
                Random rand = new Random(tag.func_74779_i("EntityName").hashCode());
                int primary = rand.nextInt(color);
                int secondary = rand.nextInt(color);
                if (layer == 0) {
                    tag.func_74768_a("PrimaryColor", primary);
                } else {
                    tag.func_74768_a("SecondaryColor", secondary);
                }
                return layer == 0 ? primary : secondary;
            }
            catch (Exception e) {
                e.printStackTrace();
                return color;
            }
        }
        EntityList.EntityEggInfo entityegginfo = (EntityList.EntityEggInfo)EntityList.field_75627_a.get(stack.func_77952_i());
        return entityegginfo != null ? (layer == 0 ? entityegginfo.field_75611_b : entityegginfo.field_75612_c) : 0xFFFFFF;
    }

    public String func_77653_i(ItemStack is) {
        String s = ("" + StatCollector.func_74838_a((String)(this.func_77658_a() + ".name"))).trim();
        String s1 = null;
        if (is.func_77978_p() != null && is.func_77978_p().func_74764_b("EntityName")) {
            s1 = is.func_77978_p().func_74779_i("EntityName");
        } else {
            EntityList.EntityEggInfo entityegginfo = (EntityList.EntityEggInfo)EntityList.field_75627_a.get(is.func_77952_i());
            if (entityegginfo != null) {
                s1 = EntityList.func_75617_a((int)is.func_77952_i());
            }
        }
        if (s1 != null) {
            s = s + " " + StatCollector.func_74838_a((String)("entity." + s1 + ".name"));
        }
        return s;
    }
}

