/*
 * Decompiled with CFR 0.152.
 */
package com.tmtravlr.lootplusplus.worldGen;

import com.google.common.base.Predicate;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.block.state.pattern.BlockHelper;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fml.common.IWorldGenerator;

public class WorldGenUndergroundBlocks
implements IWorldGenerator {
    public static ArrayList<UndergroundGenInfo> undergroundGens = new ArrayList();

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        int xPos = chunkX * 16;
        int zPos = chunkZ * 16;
        for (UndergroundGenInfo info : undergroundGens) {
            if (info.dimensionBl.contains(world.field_73011_w.func_177502_q()) || !info.dimensionWl.isEmpty() && !info.dimensionWl.contains(world.field_73011_w.func_177502_q()) || !(info.chancePerChunk >= random.nextFloat())) continue;
            for (int i = 0; i < info.triesPerChunk; ++i) {
                BlockPos tryPos = new BlockPos(xPos + random.nextInt(16), random.nextInt(info.heightMax - info.heightMin) + info.heightMin, zPos + random.nextInt(16));
                BiomeGenBase biome = world.func_180494_b(tryPos);
                if (info.biomeBl.contains(biome.field_76791_y.toLowerCase()) || !info.biomeWl.isEmpty() && info.biomeWl.contains(biome.field_76791_y.toLowerCase())) continue;
                boolean shouldGenerate = false;
                for (BiomeDictionary.Type biomeType : BiomeDictionary.getTypesForBiome((BiomeGenBase)biome)) {
                    if (info.biomeTypeBl.contains(biomeType)) break;
                    if (!info.biomeTypeWl.isEmpty() && !info.biomeTypeWl.contains(biomeType)) continue;
                    shouldGenerate = true;
                    break;
                }
                if (!shouldGenerate || !this.canGenerateInBlock(world, tryPos, info)) continue;
                this.generateVein(world, random, tryPos, info);
            }
        }
    }

    public void generateVein(World world, Random random, BlockPos pos, UndergroundGenInfo info) {
        BlockPos veinPos = pos;
        Vec3i direction = new Vec3i(random.nextInt(3) - 1, random.nextInt(3) - 1, random.nextInt(3) - 1);
        int length = random.nextInt(info.veinLengthMax - info.veinLengthMin + 1) + info.veinLengthMin;
        int thickness = random.nextInt(info.veinThicknessMax - info.veinThicknessMin + 1) + info.veinThicknessMin;
        for (int tries = 1; tries <= length; ++tries) {
            if (this.canGenerateInBlock(world, veinPos, info)) {
                double distFromMiddle = Math.abs((Math.ceil((double)length / 2.0) - (double)tries) / (double)length);
                int thisThickness = MathHelper.func_76143_f((double)((double)thickness * (1.0 - distFromMiddle * 0.5)));
                this.generateSphere(world, random, veinPos, thisThickness, info);
            }
            veinPos = veinPos.func_177971_a(direction);
            direction = this.newDirection(random, direction);
        }
    }

    private Vec3i newDirection(Random random, Vec3i direction) {
        if (random.nextBoolean()) {
            return direction;
        }
        return new Vec3i(MathHelper.func_76125_a((int)(direction.func_177958_n() + (random.nextBoolean() ? 1 : -1)), (int)-1, (int)1), MathHelper.func_76125_a((int)(direction.func_177956_o() + (random.nextBoolean() ? 1 : -1)), (int)-1, (int)1), MathHelper.func_76125_a((int)(direction.func_177952_p() + (random.nextBoolean() ? 1 : -1)), (int)-1, (int)1));
    }

    public void generateSphere(World world, Random random, BlockPos pos, int thickness, UndergroundGenInfo info) {
        double radius = (double)thickness / 2.0;
        for (int dispX = pos.func_177958_n() - MathHelper.func_76128_c((double)radius); dispX <= pos.func_177958_n() + MathHelper.func_76143_f((double)radius); ++dispX) {
            for (int dispY = pos.func_177956_o() - MathHelper.func_76128_c((double)radius); dispY <= pos.func_177956_o() + MathHelper.func_76143_f((double)radius); ++dispY) {
                for (int dispZ = pos.func_177952_p() - MathHelper.func_76128_c((double)radius); dispZ <= pos.func_177952_p() + MathHelper.func_76143_f((double)radius); ++dispZ) {
                    BlockPos genPos = new BlockPos(dispX, dispY, dispZ);
                    if (Math.sqrt(genPos.func_177954_c(0.25 + (double)pos.func_177958_n(), 0.25 + (double)pos.func_177956_o(), 0.25 + (double)pos.func_177952_p())) > radius) continue;
                    this.generateBlock(world, random, genPos, info);
                }
            }
        }
    }

    public void generateBlock(World world, Random random, BlockPos pos, UndergroundGenInfo info) {
        TileEntity te;
        if (!this.canGenerateInBlock(world, pos, info)) {
            return;
        }
        world.func_175656_a(pos, info.toGenerate);
        if (info.blockTag != null && (te = world.func_175625_s(pos)) != null) {
            NBTTagCompound tagToGenerate = (NBTTagCompound)info.blockTag.func_74737_b();
            tagToGenerate.func_74768_a("x", pos.func_177958_n());
            tagToGenerate.func_74768_a("y", pos.func_177956_o());
            tagToGenerate.func_74768_a("z", pos.func_177952_p());
            te.func_145839_a(tagToGenerate);
        }
    }

    private boolean canGenerateInBlock(World world, BlockPos pos, UndergroundGenInfo info) {
        if (pos.func_177956_o() < 0 || pos.func_177956_o() > 255) {
            return false;
        }
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (block == info.toGenerate.func_177230_c() && block.func_176201_c(state) == info.toGenerate.func_177230_c().func_176201_c(info.toGenerate)) {
            return false;
        }
        if (info.blocksBl.contains(block) || info.materialsBl.contains(block.func_149688_o()) || !info.materialsWl.isEmpty() && !info.materialsWl.contains(block.func_149688_o())) {
            return false;
        }
        for (Block replace : info.blocksWl) {
            if (!block.isReplaceableOreGen(world, pos, (Predicate)BlockHelper.func_177642_a((Block)replace))) continue;
            return true;
        }
        return block.isReplaceableOreGen(world, pos, (Predicate)BlockHelper.func_177642_a((Block)Blocks.field_150348_b));
    }

    public static class UndergroundGenInfo {
        public IBlockState toGenerate;
        public NBTTagCompound blockTag;
        public float chancePerChunk;
        public int triesPerChunk;
        public int veinLengthMin;
        public int veinLengthMax;
        public int veinThicknessMin;
        public int veinThicknessMax;
        public int heightMin;
        public int heightMax;
        public HashSet<Block> blocksBl = new HashSet();
        public HashSet<Block> blocksWl = new HashSet();
        public HashSet<Material> materialsBl = new HashSet();
        public HashSet<Material> materialsWl = new HashSet();
        public HashSet<String> biomeBl = new HashSet();
        public HashSet<String> biomeWl = new HashSet();
        public HashSet<BiomeDictionary.Type> biomeTypeBl = new HashSet();
        public HashSet<BiomeDictionary.Type> biomeTypeWl = new HashSet();
        public HashSet<Integer> dimensionBl = new HashSet();
        public HashSet<Integer> dimensionWl = new HashSet();

        public UndergroundGenInfo(IBlockState state, NBTTagCompound tag, float chance, int triesChunk, int lengthMin, int lengthMax, int thicknessMin, int thicknessMax, int heightMin, int heightMax) {
            this.toGenerate = state;
            this.blockTag = tag;
            this.chancePerChunk = chance;
            this.triesPerChunk = triesChunk;
            this.veinLengthMin = lengthMin;
            this.veinLengthMax = lengthMax;
            this.veinThicknessMin = thicknessMin;
            this.veinThicknessMax = thicknessMax;
            this.heightMin = heightMin;
            this.heightMax = heightMax;
        }
    }
}

