/*
 * Decompiled with CFR 0.152.
 */
package modid.imsm.core;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import modid.imsm.core.ICreatorBlock;
import modid.imsm.core.IMSM;
import modid.imsm.core.LiveStructure;
import modid.imsm.core.StructureCreator;
import modid.imsm.core.UpdateThread;
import modid.imsm.livestructures.YSync;
import modid.imsm.structureloader.LightUpdateThread;
import modid.imsm.structureloader.SchematicStructure;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.BlockPos;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class EventHandler {
    public ArrayList<SchematicStructure> postProcessors = new ArrayList();
    public ArrayList<ICreatorBlock> creators = new ArrayList();
    public ArrayList<ICreatorBlock> serverCreators = new ArrayList();
    public ArrayList<LiveStructure> liveCreators = new ArrayList();
    public ArrayList<Integer> scheduledExplosions = new ArrayList();
    public ArrayList<String> delayedPrints = new ArrayList();
    public LightUpdateThread lightUpdate;
    public long previousTick = 0L;
    public LiveStructure isRiding;
    public YSync ySync;

    public void load() {
        if (!IMSM.updateChecked) {
            IMSM.updateChecked = true;
            UpdateThread updateThread = new UpdateThread();
            updateThread.start();
        }
        this.loadLiveCreators();
        this.loadStructures();
        this.lightUpdate = new LightUpdateThread((World)Minecraft.func_71410_x().field_71441_e, MinecraftServer.func_71276_C().func_130014_f_());
        this.lightUpdate.start();
    }

    @SubscribeEvent
    public void update(TickEvent.ClientTickEvent event) {
        for (int i = 0; i < this.liveCreators.size(); ++i) {
            if (System.currentTimeMillis() <= this.liveCreators.get((int)i).lastTickTime + (long)this.liveCreators.get((int)i).waitTime) continue;
            if (this.liveCreators.get(i).run()) {
                --i;
                continue;
            }
            if (i >= this.liveCreators.size() || this.liveCreators.get(i) == null) continue;
            this.liveCreators.get((int)i).lastTickTime = System.currentTimeMillis();
        }
        try {
            if (this.ySync != null) {
                for (Object playerObject : MinecraftServer.func_71276_C().func_130014_f_().field_73010_i) {
                    EntityPlayerMP player = (EntityPlayerMP)playerObject;
                    if (this.ySync.isVehicle == null || MinecraftServer.func_71276_C().func_130014_f_().func_180495_p(new BlockPos(player.field_70165_t, player.field_70163_u, player.field_70161_v)).func_177230_c() != Blocks.field_150350_a) {
                        player.field_70163_u = this.ySync.getY();
                        if (!player.func_70005_c_().equals(Minecraft.func_71410_x().field_71439_g.func_70005_c_())) continue;
                        Minecraft.func_71410_x().field_71439_g.field_70163_u = this.ySync.getY();
                        continue;
                    }
                    IMSM.eventHandler.ySync.setY(player.field_70163_u);
                }
            }
            for (int i = 0; i < this.creators.size(); ++i) {
                if (this.creators.get(i) instanceof StructureCreator && ((StructureCreator)this.creators.get((int)i)).boundTo.generatedBlocks <= ((StructureCreator)this.creators.get((int)i)).generatedBlocks || !this.creators.get(i).run(false)) continue;
                this.creators.remove(i);
                --i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @SubscribeEvent
    public void update(TickEvent.ServerTickEvent event) {
        int i;
        if (!IMSM.updateChecked && Minecraft.func_71410_x().field_71441_e != null) {
            this.load();
            IMSM.updateChecked = true;
        }
        for (i = 0; i < this.scheduledExplosions.size(); i += 3) {
            MinecraftServer.func_71276_C().func_130014_f_().func_72885_a((Entity)null, (double)this.scheduledExplosions.get(0).intValue(), (double)this.scheduledExplosions.get(1).intValue(), (double)this.scheduledExplosions.get(2).intValue(), 25.0f, true, true);
        }
        this.scheduledExplosions.clear();
        if (this.postProcessors.size() > 0) {
            this.postProcessors.get(0).postProcess();
            this.postProcessors.remove(0);
        }
        for (i = 0; i < this.serverCreators.size(); ++i) {
            if (!this.serverCreators.get(i).run(true)) continue;
            this.serverCreators.remove(i);
            --i;
        }
        for (i = 0; i < this.delayedPrints.size(); ++i) {
            if (MinecraftServer.func_71276_C().func_152345_ab()) {
                Minecraft.func_71410_x().field_71439_g.func_145747_a((IChatComponent)new ChatComponentText(this.delayedPrints.get(i)));
            }
            this.delayedPrints.remove(i);
        }
    }

    private void loadLiveCreators() {
        this.liveCreators.clear();
        int i = 0;
        while (this.fileExists(i + ".txt")) {
            String[] array = new String[10];
            try {
                BufferedReader in = new BufferedReader(new FileReader("saves/" + Minecraft.func_71410_x().func_71401_C().func_71270_I() + "/LiveStructures/" + i + ".txt"));
                for (int j = 0; j < array.length; ++j) {
                    try {
                        array[j] = in.readLine();
                        continue;
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                this.liveCreators.add(new LiveStructure(array[0], (World)Minecraft.func_71410_x().field_71441_e, (World)Minecraft.func_71410_x().func_71401_C().func_71218_a(0), Integer.parseInt(array[1]), Integer.parseInt(array[2]), Integer.parseInt(array[3]), array[4].equals("true"), Integer.parseInt(array[8]), Integer.parseInt(array[9]), i, this.getAnimationFor(array[0]), array[7].equals("true")));
                if (this.liveCreators.get((int)(this.liveCreators.size() - 1)).animation != null) {
                    int some = 3;
                    if (array[0].equals("LiveBoat") || array[0].equals("Live_Bus") || array[0].equals("Live_Bus2")) {
                        some = 2;
                    }
                    try {
                        this.liveCreators.get((int)(this.liveCreators.size() - 1)).animation[some][0] = Integer.parseInt(in.readLine());
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                try {
                    in.close();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
                this.liveCreators.get((int)(this.liveCreators.size() - 1)).animationPhase = Integer.parseInt(array[5]);
                this.liveCreators.get((int)(this.liveCreators.size() - 1)).animationTimes = Integer.parseInt(array[6]);
                if (this.liveCreators.get((int)(this.liveCreators.size() - 1)).animation != null && this.liveCreators.get((int)(this.liveCreators.size() - 1)).waitTime == 2000000000) {
                    this.liveCreators.get(this.liveCreators.size() - 1).removeThisLiveStructure(true);
                    --i;
                }
            }
            catch (FileNotFoundException e1) {
                e1.printStackTrace();
            }
            ++i;
        }
    }

    public int[][] getAnimationFor(String name) {
        if (name.equals("LivePlane")) {
            int[][] animation = new int[][]{{1, 2000000000, 0, 0, 0}, {1, 10000, 0, 0, 0}, {30, 100, -1, 1, 0}, {100, 100, -1, 0, 0}, {31, 100, -1, -1, 0}, {1, 100, 0, 0, 0}};
            return animation;
        }
        if (name.equals("LiveFlyingShip2")) {
            int[][] animation = new int[][]{{1, 2000000000, 0, 0, 0}, {1, 10000, 0, 0, 0}, {30, 500, 1, 1, 0}, {100, 500, 1, 0, 0}, {31, 500, 1, -1, 0}, {1, 500, 0, 0, 0}};
            return animation;
        }
        if (name.equals("LiveFlyingShip1") || name.equals("LiveAirBalloon")) {
            int[][] animation = new int[][]{{1, 2000000000, 0, 0, 0}, {1, 10000, 0, 0, 0}, {30, 500, 0, 1, -1}, {100, 500, 0, 0, -1}, {31, 500, 0, -1, -1}, {1, 500, 0, 0, 0}};
            return animation;
        }
        if (name.equals("Live_Flying_Helicopter")) {
            int[][] animation = new int[][]{{1, 2000000000, 0, 0, 0}, {1, 10000, 0, 0, 0}, {30, 200, 0, 1, -1}, {100, 200, 0, 0, -1}, {31, 200, 0, -1, -1}, {1, 200, 0, 0, 0}};
            return animation;
        }
        if (name.equals("LiveAirplane")) {
            int[][] animation = new int[][]{{1, 2000000000, 0, 0, 0}, {1, 10000, 0, 0, 0}, {30, 300, 0, 1, 1}, {100, 300, 0, 0, 1}, {31, 300, 0, -1, 1}, {1, 300, 0, 0, 0}};
            return animation;
        }
        if (name.equals("LiveBoat") || name.equals("Live_Bus") || name.equals("Live_Bus2")) {
            int[][] animation = new int[][]{{1, 2000000000, 0, 0, 0}, {1, 10000, 0, 0, 0}, {100, 300, 0, 0, 1}, {1, 300, 0, 0, 0}};
            return animation;
        }
        return null;
    }

    private void loadStructures() {
        this.creators.clear();
        int i = 0;
        while (this.fileExists2(i + ".txt")) {
            String[] array = new String[9];
            try {
                BufferedReader in = new BufferedReader(new FileReader("saves/" + Minecraft.func_71410_x().func_71401_C().func_71270_I() + "/Structures/" + i + ".txt"));
                for (int j = 0; j < array.length; ++j) {
                    try {
                        array[j] = in.readLine();
                        continue;
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                try {
                    in.close();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
                this.creators.add(new StructureCreator(array[0], (World)Minecraft.func_71410_x().field_71441_e, Minecraft.func_71410_x().func_71401_C().func_130014_f_(), Integer.parseInt(array[2]), Integer.parseInt(array[3]), Integer.parseInt(array[4]), array[1].equals("true"), i));
                ((StructureCreator)this.creators.get((int)(this.creators.size() - 1))).i = Integer.parseInt(array[5]);
                ((StructureCreator)this.creators.get((int)(this.creators.size() - 1))).j = Integer.parseInt(array[6]);
                ((StructureCreator)this.creators.get((int)(this.creators.size() - 1))).k = Integer.parseInt(array[7]);
                ((StructureCreator)this.creators.get((int)(this.creators.size() - 1))).speedUp = Integer.parseInt(array[8]);
            }
            catch (FileNotFoundException e1) {
                e1.printStackTrace();
            }
            ++i;
        }
    }

    boolean fileExists(String path) {
        File f = new File("saves/" + Minecraft.func_71410_x().func_71401_C().func_71270_I() + "/LiveStructures/" + path);
        return f.exists() && !f.isDirectory();
    }

    boolean fileExists2(String path) {
        File f = new File("saves/" + Minecraft.func_71410_x().func_71401_C().func_71270_I() + "/Structures/" + path);
        return f.exists() && !f.isDirectory();
    }

    public void scheduleExplosion(int i, int j, int k) {
        this.scheduledExplosions.add(i);
        this.scheduledExplosions.add(j);
        this.scheduledExplosions.add(k);
    }
}

