/*
 * Decompiled with CFR 0.152.
 */
package modid.imsm.core;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import modid.imsm.core.IMSM;
import modid.imsm.livestructures.RideStructure;
import modid.imsm.livestructures.YSync;
import modid.imsm.structureloader.SchematicStructure;
import net.minecraft.block.BlockAir;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.BlockPos;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;

public class LiveStructure {
    public World worldIn;
    public int x;
    public int y;
    public int z;
    public boolean doPlaceAir;
    public String structureName;
    public World serverWorld;
    public int amountOfSlides;
    public int waitTime;
    public int currentSlide = 0;
    int[][] animation;
    public long lastTickTime = 0L;
    private int id;
    private int relativeSpawnPointX;
    private int relativeSpawnPointY;
    private int relativeSpawnPointZ;
    private int prevrelativeSpawnPointX = 0;
    private int prevrelativeSpawnPointY = 0;
    private int prevrelativeSpawnPointZ = 0;
    private boolean doLoop;
    public int animationPhase = 0;
    public int animationTimes = 0;
    public RideStructure ride;

    public LiveStructure(String structureName, World worldIn, World worldIn2, int x, int y, int z, boolean doPlaceAir, int amountOfSlides, int waitTime, int id, int[][] animation, boolean doLoop) {
        this.structureName = structureName;
        this.worldIn = worldIn;
        this.serverWorld = worldIn2;
        this.x = x;
        this.y = y;
        this.z = z;
        this.doPlaceAir = doPlaceAir;
        this.amountOfSlides = amountOfSlides;
        this.waitTime = waitTime;
        this.id = id;
        this.doLoop = doLoop;
        this.animation = animation;
        System.out.println("NEW LIVE " + x + ", " + y + ", " + z);
    }

    public boolean run() {
        if (Minecraft.func_71410_x().field_71439_g == null || this.distanceToPlayer(this.x, this.y, this.z) > 100) {
            return false;
        }
        if (this.animation != null) {
            this.waitTime = this.animation[this.animationPhase][1];
            this.relativeSpawnPointX = this.animation[this.animationPhase][2];
            this.relativeSpawnPointY = this.animation[this.animationPhase][3];
            this.relativeSpawnPointZ = this.animation[this.animationPhase][4];
            ++this.animationTimes;
            if (this.animationTimes >= this.animation[this.animationPhase][0]) {
                ++this.animationPhase;
                this.animationTimes = 0;
                if (this.animationPhase >= this.animation.length) {
                    if (this.doLoop) {
                        this.animationPhase = 0;
                    } else {
                        this.removeThisLiveStructure(false);
                        return true;
                    }
                }
            }
        }
        SchematicStructure struct = new SchematicStructure(this.structureName + this.currentSlide + ".structure", true);
        struct.readFromFile();
        if (this.ride == null || this.ride.progress != -1 && this.ride.progress != this.ride.animation[0].length - 1) {
            struct.process(this.serverWorld, this.worldIn, this.x, this.y, this.z);
            IMSM.eventHandler.postProcessors.add(struct);
            this.x += this.relativeSpawnPointX;
            this.y += this.relativeSpawnPointY;
            this.z += this.relativeSpawnPointZ;
            ++this.currentSlide;
            if (this.currentSlide >= this.amountOfSlides) {
                this.currentSlide = 0;
            }
        }
        if (this.structureName.equals("Live_Fair_FreeFall")) {
            if (this.currentSlide == 1) {
                this.waitTime = 500;
            } else if (this.currentSlide == 2) {
                this.waitTime = 3000;
            } else if (this.currentSlide == 3) {
                this.waitTime = 800;
            } else if (this.currentSlide == 11) {
                this.waitTime = (int)(15000.0 * Math.random());
            } else if (this.currentSlide == 12) {
                this.waitTime = 250;
            }
        }
        if (this.animation != null) {
            for (Object playerObject : MinecraftServer.func_71276_C().func_130014_f_().field_73010_i) {
                EntityPlayerMP player = (EntityPlayerMP)playerObject;
                if (this.checkWithinBounds(player, struct.width, struct.height + 5, struct.length)) {
                    double thisY = player.field_70163_u;
                    if (this.relativeSpawnPointY > 0) {
                        if (IMSM.eventHandler.ySync != null) {
                            if (MinecraftServer.func_71276_C().func_130014_f_().func_180495_p(new BlockPos(player.field_70165_t, player.field_70163_u - 1.0, player.field_70161_v)).func_177230_c() != Blocks.field_150350_a || MinecraftServer.func_71276_C().func_130014_f_().func_180495_p(new BlockPos(player.field_70165_t, player.field_70163_u, player.field_70161_v)).func_177230_c() != Blocks.field_150350_a) {
                                thisY = IMSM.eventHandler.ySync.getY() + 1.0;
                            }
                            IMSM.eventHandler.ySync.setY(thisY);
                        } else {
                            IMSM.eventHandler.ySync = new YSync(Minecraft.func_71410_x().field_71439_g.field_70163_u);
                            IMSM.eventHandler.ySync.isVehicle = this;
                        }
                    } else if (IMSM.eventHandler.ySync != null) {
                        if (IMSM.eventHandler.ySync.tickFinal) {
                            IMSM.eventHandler.ySync = null;
                        } else {
                            IMSM.eventHandler.ySync.setY(IMSM.eventHandler.ySync.getY() + 1.0);
                            IMSM.eventHandler.ySync.tickFinal = true;
                        }
                    }
                    this.setPlayerToPosition(player, player.field_70165_t + (double)this.relativeSpawnPointX, thisY, player.field_70161_v + (double)this.relativeSpawnPointZ);
                    continue;
                }
                if (IMSM.eventHandler.ySync == null || IMSM.eventHandler.ySync.isVehicle != this) continue;
                IMSM.eventHandler.ySync = null;
            }
            if (this.relativeSpawnPointX != 0 || this.relativeSpawnPointZ != 0) {
                for (int i = -2; i <= 2; ++i) {
                    int checkx = 0;
                    int checkz = 0;
                    if (this.relativeSpawnPointX != 0) {
                        if (this.relativeSpawnPointX > 0) {
                            checkx = this.x + 1;
                            checkz = this.z - struct.length / 2 + i;
                        } else {
                            checkx = this.x - struct.width - 1;
                            checkz = this.z - struct.length / 2 + i;
                        }
                    } else if (this.relativeSpawnPointZ != 0) {
                        if (this.relativeSpawnPointZ > 0) {
                            checkx = this.x - struct.length / 2 + i + 1;
                            checkz = this.z + 1;
                        } else {
                            checkx = this.x - struct.length / 2 + i;
                            checkz = this.z - struct.width - 1;
                        }
                    }
                    if (this.worldIn.func_180495_p(new BlockPos(checkx, this.y + struct.height / 2, checkz)).func_177230_c() instanceof BlockAir) continue;
                    IMSM.eventHandler.scheduleExplosion(this.x - struct.length / 2, this.y + struct.height / 2, this.z - struct.width / 2);
                    this.removeThisLiveStructure(false);
                    return true;
                }
            }
            if (this.relativeSpawnPointX != 0 || this.prevrelativeSpawnPointX != 0) {
                if (this.relativeSpawnPointX > 0 || this.prevrelativeSpawnPointX > 0) {
                    this.removeStuff(this.x + this.relativeSpawnPointX - struct.length - 1, this.y - this.relativeSpawnPointY, this.z + this.relativeSpawnPointZ, 1, struct.height, struct.width);
                } else {
                    this.removeStuff(this.x + this.relativeSpawnPointX + 3, this.y - this.relativeSpawnPointY, this.z + this.relativeSpawnPointZ, 1, struct.height, struct.width);
                }
            }
            if (this.relativeSpawnPointY != 0 || this.prevrelativeSpawnPointY != 0) {
                if (this.relativeSpawnPointY > 0 || this.prevrelativeSpawnPointY > 0) {
                    this.removeStuff(this.x + this.relativeSpawnPointX, this.y - this.relativeSpawnPointY - 1, this.z + this.relativeSpawnPointZ, struct.length, 1, struct.width);
                } else {
                    this.removeStuff(this.x + this.relativeSpawnPointX, this.y - this.relativeSpawnPointY + struct.height, this.z + this.relativeSpawnPointZ, struct.length, 1, struct.width);
                }
            }
            if (this.relativeSpawnPointZ != 0 || this.prevrelativeSpawnPointZ != 0) {
                if (this.relativeSpawnPointZ > 0 || this.prevrelativeSpawnPointZ > 0) {
                    if (this.structureName.equals("LiveBoat") || this.structureName.equals("LiveAirplane")) {
                        this.removeStuff(this.x + this.relativeSpawnPointX, this.y - this.relativeSpawnPointY + 2, this.z + this.relativeSpawnPointZ - struct.width - 1, struct.length, struct.height, 1);
                    } else {
                        this.removeStuff(this.x + this.relativeSpawnPointX + 1, this.y - this.relativeSpawnPointY, this.z + this.relativeSpawnPointZ - struct.width - 2, struct.length, struct.height, 1);
                    }
                } else {
                    this.removeStuff(this.x + this.relativeSpawnPointX, this.y - this.relativeSpawnPointY, this.z + this.relativeSpawnPointZ + 4, struct.width, struct.height, 1);
                }
            }
            this.prevrelativeSpawnPointX = this.relativeSpawnPointX;
            this.prevrelativeSpawnPointY = this.relativeSpawnPointY;
            this.prevrelativeSpawnPointZ = this.relativeSpawnPointZ;
            this.registerLiveCreator(this, this.id);
        }
        if (this.ride != null) {
            if (this.ride.number == 0) {
                if (this.ride.progress == -2 && this.currentSlide == 1) {
                    ++this.ride.progress;
                } else if (this.ride.progress == -1 && this.distanceToPlayer(this.x - 4, this.y + 1, this.z - 36) == 0) {
                    ++this.ride.progress;
                    IMSM.eventHandler.ySync = new YSync(Minecraft.func_71410_x().field_71439_g.field_70163_u);
                } else if (this.ride.progress >= 0 && this.ride.progress < this.ride.animation[0].length && this.distanceToPlayer((double)(this.x - 4) - 0.5, this.y + 1 + this.ride.animation[0][this.ride.progress], (double)(this.z - 36 - this.ride.animation[1][this.ride.progress]) + 0.5) > 1) {
                    Minecraft.func_71410_x().field_71439_g.func_145747_a((IChatComponent)new ChatComponentText("Thanks for your visit. We hope to see you again soon!"));
                    this.ride = null;
                    IMSM.eventHandler.isRiding = null;
                    IMSM.eventHandler.ySync = null;
                } else if (this.ride.progress >= 0 && this.ride.progress < this.ride.animation[0].length - 1) {
                    ++this.ride.progress;
                    this.setAllPlayersToPosition(Minecraft.func_71410_x().field_71439_g.field_70165_t, this.y + 1 + this.ride.animation[0][this.ride.progress], Minecraft.func_71410_x().field_71439_g.field_70161_v - (double)(this.ride.animation[1][this.ride.progress] - this.ride.animation[1][this.ride.progress - 1]));
                    IMSM.eventHandler.ySync.setY(this.y + 1 + this.ride.animation[0][this.ride.progress]);
                }
            } else if (this.ride.number == 1) {
                if (this.ride.progress == -2 && this.currentSlide == 2) {
                    ++this.ride.progress;
                    this.waitTime = 500;
                } else if (this.ride.progress == -1 && (this.closeTo((double)this.x + 0.5, Minecraft.func_71410_x().field_71439_g.field_70165_t, 0.9) && this.closeTo((double)this.y + 2.75, Minecraft.func_71410_x().field_71439_g.field_70163_u, 1.0) && this.closeTo((double)this.z - 3.0, Minecraft.func_71410_x().field_71439_g.field_70161_v, 2.9) || this.closeTo((double)this.x - 3.0, Minecraft.func_71410_x().field_71439_g.field_70165_t, 2.9) && this.closeTo((double)this.y + 2.75, Minecraft.func_71410_x().field_71439_g.field_70163_u, 1.0) && this.closeTo((double)this.z - 6.5, Minecraft.func_71410_x().field_71439_g.field_70161_v, 0.9) || this.closeTo((double)this.x - 6.5, Minecraft.func_71410_x().field_71439_g.field_70165_t, 0.9) && this.closeTo((double)this.y + 2.75, Minecraft.func_71410_x().field_71439_g.field_70163_u, 1.0) && this.closeTo((double)this.z - 3.0, Minecraft.func_71410_x().field_71439_g.field_70161_v, 2.9) || this.closeTo((double)this.x - 3.0, Minecraft.func_71410_x().field_71439_g.field_70165_t, 2.9) && this.closeTo((double)this.y + 2.75, Minecraft.func_71410_x().field_71439_g.field_70163_u, 1.0) && this.closeTo((double)this.z - 0.5, Minecraft.func_71410_x().field_71439_g.field_70161_v, 0.9))) {
                    ++this.ride.progress;
                    IMSM.eventHandler.ySync = new YSync((double)this.y + 2.5 + (double)this.ride.animation[0][this.ride.progress]);
                } else if (!(this.ride.progress < 0 || this.ride.progress >= this.ride.animation[0].length || this.closeTo((double)this.x + 0.5, Minecraft.func_71410_x().field_71439_g.field_70165_t, 0.9) && this.closeTo((double)this.z - 3.0, Minecraft.func_71410_x().field_71439_g.field_70161_v, 2.9) || this.closeTo((double)this.x - 3.0, Minecraft.func_71410_x().field_71439_g.field_70165_t, 2.9) && this.closeTo((double)this.z - 6.5, Minecraft.func_71410_x().field_71439_g.field_70161_v, 0.9) || this.closeTo((double)this.x - 6.5, Minecraft.func_71410_x().field_71439_g.field_70165_t, 0.9) && this.closeTo((double)this.z - 3.0, Minecraft.func_71410_x().field_71439_g.field_70161_v, 2.9) || this.closeTo((double)this.x - 3.0, Minecraft.func_71410_x().field_71439_g.field_70165_t, 2.9) && this.closeTo((double)this.z - 0.5, Minecraft.func_71410_x().field_71439_g.field_70161_v, 0.9))) {
                    Minecraft.func_71410_x().field_71439_g.func_145747_a((IChatComponent)new ChatComponentText("Thanks for your visit. We hope to see you again soon!"));
                    this.ride = null;
                    IMSM.eventHandler.isRiding = null;
                    IMSM.eventHandler.ySync = null;
                } else if (this.ride.progress >= 0 && this.ride.progress < this.ride.animation[0].length - 1) {
                    ++this.ride.progress;
                    this.setAllPlayersToPosition(Minecraft.func_71410_x().field_71439_g.field_70165_t, (double)this.y + 2.5 + (double)this.ride.animation[0][this.ride.progress], Minecraft.func_71410_x().field_71439_g.field_70161_v);
                    IMSM.eventHandler.ySync.setY((double)this.y + 2.5 + (double)this.ride.animation[0][this.ride.progress]);
                }
            }
        }
        return false;
    }

    private boolean closeTo(double number1, double number2, double howClose) {
        return number2 >= number1 - howClose && number2 <= number1 + howClose;
    }

    public void setAllPlayersToPosition(double x, double y, double z) {
        for (Object playerObject : MinecraftServer.func_71276_C().func_130014_f_().field_73010_i) {
            EntityPlayerMP player = (EntityPlayerMP)playerObject;
            this.setPlayerToPosition(player, x, y, z);
        }
    }

    void setPlayerToPosition(EntityPlayerMP player, double x, double y, double z) {
        player.func_70107_b(x, y, z);
        if (player.func_70005_c_().equals(Minecraft.func_71410_x().field_71439_g.func_70005_c_())) {
            Minecraft.func_71410_x().field_71439_g.func_70107_b(x, y, z);
        }
    }

    private int distanceToPlayer(double x1, double y1, double z1) {
        return (int)Math.sqrt(Math.pow(Minecraft.func_71410_x().field_71439_g.field_70165_t - x1, 2.0) + Math.pow(Minecraft.func_71410_x().field_71439_g.field_70163_u - y1, 2.0) + Math.pow(Minecraft.func_71410_x().field_71439_g.field_70161_v - z1, 2.0));
    }

    private boolean checkWithinBounds(EntityPlayerMP player, int sizex, int sizey, int sizez) {
        int playerX = player.func_180425_c().func_177958_n();
        int playerY = player.func_180425_c().func_177956_o();
        int playerZ = player.func_180425_c().func_177952_p();
        return playerX <= this.x + 1 && playerY >= this.y - 2 && playerZ <= this.z && playerX >= this.x + 1 - sizez && playerY <= this.y + sizey && playerZ >= this.z - sizex;
    }

    public boolean closeTo(int howClose, int x, int y, int z, int sizex, int sizey, int sizez) {
        return x - howClose <= this.x && y + howClose >= this.y && z - howClose <= this.z && x + howClose >= this.x - sizez && y - howClose <= this.y + sizey && z + howClose >= this.z - sizex;
    }

    public boolean closeTo(int howClose, double x, double y, double z, int sizex, int sizey, int sizez) {
        return x - (double)howClose <= (double)this.x && y + (double)howClose >= (double)this.y && z - (double)howClose <= (double)this.z && x + (double)howClose >= (double)(this.x - sizez) && y - (double)howClose <= (double)(this.y + sizey) && z + (double)howClose >= (double)(this.z - sizex);
    }

    void registerLiveCreator(LiveStructure liveStructure, int at) {
        try {
            new File("saves/" + Minecraft.func_71410_x().func_71401_C().func_71270_I() + "/LiveStructures").mkdirs();
            PrintWriter writer = new PrintWriter("saves/" + Minecraft.func_71410_x().func_71401_C().func_71270_I() + "/LiveStructures/" + at + ".txt", "UTF-8");
            writer.println(liveStructure.structureName);
            writer.println(liveStructure.x);
            writer.println(liveStructure.y);
            writer.println(liveStructure.z);
            writer.println(liveStructure.doPlaceAir);
            writer.println(liveStructure.animationPhase);
            writer.println(liveStructure.animationTimes);
            writer.println(liveStructure.doLoop);
            writer.println(liveStructure.amountOfSlides);
            writer.println(liveStructure.waitTime);
            if (this.structureName.equals("LivePlane") || this.structureName.equals("LiveFlyingShip1") || this.structureName.equals("LiveFlyingShip2") || this.structureName.equals("LiveAirplane") || this.structureName.equals("LiveAirBalloon") || this.structureName.equals("Live_Flying_Helicopter")) {
                writer.println(this.animation[3][0]);
            } else if (this.structureName.equals("LiveBoat") || this.structureName.equals("Live_Bus") || this.structureName.equals("Live_Bus2")) {
                writer.println(this.animation[2][0]);
            }
            writer.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
    }

    public void removeThisLiveStructure(boolean renameFiles) {
        int i;
        boolean windows = false;
        for (i = 0; i < IMSM.eventHandler.liveCreators.size(); ++i) {
            if (IMSM.eventHandler.liveCreators.get((int)i).id <= this.id) continue;
            --IMSM.eventHandler.liveCreators.get((int)i).id;
        }
        new File("saves/" + Minecraft.func_71410_x().func_71401_C().func_71270_I() + "/LiveStructures/" + this.id + ".txt").delete();
        if (!windows) {
            for (i = this.id + 1; i < IMSM.eventHandler.liveCreators.size(); ++i) {
                new File("saves/" + Minecraft.func_71410_x().func_71401_C().func_71270_I() + "/LiveStructures/" + i + ".txt").renameTo(new File("saves/" + Minecraft.func_71410_x().func_71401_C().func_71270_I() + "/LiveStructures/" + (i - 1) + ".txt"));
            }
            if (renameFiles) {
                i = this.id + 1;
                while (this.fileExists(i + ".txt")) {
                    new File("saves/" + Minecraft.func_71410_x().func_71401_C().func_71270_I() + "/LiveStructures/" + i + ".txt").renameTo(new File("saves/" + Minecraft.func_71410_x().func_71401_C().func_71270_I() + "/LiveStructures/" + (i - 1) + ".txt"));
                    ++i;
                }
            }
        }
        IMSM.eventHandler.liveCreators.remove(this.id);
    }

    private int getGarbageId() {
        int i = 0;
        while (this.fileExists(i + ".txt")) {
            ++i;
        }
        return i;
    }

    boolean fileExists(String path) {
        File f = new File("saves/" + Minecraft.func_71410_x().func_71401_C().func_71270_I() + "/LiveStructures/" + path);
        return f.exists() && !f.isDirectory();
    }

    public void removeStuff(int posx, int posy, int posz, int removeX, int removeY, int removeZ) {
        for (int x = 0; x < removeX; ++x) {
            for (int y = 0; y < removeY; ++y) {
                for (int z = 0; z < removeZ; ++z) {
                    this.setBlock(this.worldIn, new BlockPos(posx - x, posy + y, posz - z), Blocks.field_150350_a.func_176223_P());
                    this.setBlock(this.serverWorld, new BlockPos(posx - x, posy + y, posz - z), Blocks.field_150350_a.func_176223_P());
                }
            }
        }
    }

    public void setBlock(World world, BlockPos pos, IBlockState state) {
        try {
            Chunk chunk = world.func_175726_f(pos);
            ExtendedBlockStorage storageArray = chunk.func_76587_i()[pos.func_177956_o() >> 4];
            if (storageArray == null) {
                ExtendedBlockStorage extendedBlockStorage = new ExtendedBlockStorage(pos.func_177956_o() >> 4 << 4, !world.field_73011_w.func_177495_o());
                chunk.func_76587_i()[pos.func_177956_o() >> 4] = extendedBlockStorage;
                storageArray = extendedBlockStorage;
            }
            if (storageArray.func_150819_a(pos.func_177958_n() & 0xF, pos.func_177956_o() & 0xF, pos.func_177952_p() & 0xF) != state.func_177230_c()) {
                IBlockState oldState = world.func_180495_p(pos);
                storageArray.func_177484_a(pos.func_177958_n() & 0xF, pos.func_177956_o() & 0xF, pos.func_177952_p() & 0xF, state);
                world.func_175689_h(pos);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

