/*
 * Decompiled with CFR 0.152.
 */
package modid.imsm.structureloader;

import modid.imsm.core.IMSM;
import modid.imsm.structureloader.SchematicStructure;
import net.minecraft.world.World;

public class LiveStructureThread
extends Thread {
    private World worldIn;
    private int x;
    private int y;
    private int z;
    private boolean doPlaceAir;
    private String structureName;
    public World serverWorld;
    private int relativeSpawnPointX;
    private int relativeSpawnPointY;
    private int relativeSpawnPointZ;
    private int amountOfSlides;
    private int waitTime;

    public LiveStructureThread(String structureName, World worldIn, int x, int y, int z, boolean doPlaceAir, int amountOfSlides, int waitTime, int relativeSpawnPointX, int relativeSpawnPointY, int relativeSpawnPointZ) {
        this.structureName = structureName;
        this.worldIn = worldIn;
        this.x = x;
        this.y = y;
        this.z = z;
        this.doPlaceAir = doPlaceAir;
        this.amountOfSlides = amountOfSlides;
        this.relativeSpawnPointX = relativeSpawnPointX;
        this.relativeSpawnPointY = relativeSpawnPointY;
        this.relativeSpawnPointZ = relativeSpawnPointZ;
        this.waitTime = waitTime;
        this.setDaemon(true);
        this.setPriority(4);
    }

    @Override
    public void run() {
        while (true) {
            for (int i = 0; i < this.amountOfSlides; ++i) {
                SchematicStructure struct = new SchematicStructure(this.structureName + (i + 1) + ".structure", true);
                struct.readFromFile();
                if (!this.doPlaceAir) {
                    struct.doNotReplaceAir();
                }
                struct.process(this.serverWorld, this.worldIn, this.x, this.y, this.z);
                IMSM.eventHandler.postProcessors.add(struct);
                try {
                    this.wait(this.waitTime);
                    continue;
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            this.x += this.relativeSpawnPointX;
            this.y += this.relativeSpawnPointY;
            this.z += this.relativeSpawnPointZ;
        }
    }
}

