/*
 * Decompiled with CFR 0.152.
 */
package modid.imsm.structureloader;

import java.io.DataInputStream;
import java.util.zip.GZIPInputStream;
import modid.imsm.core.StructureCreator;
import modid.imsm.structureloader.BlockPlacer;
import modid.imsm.structureloader.Structure;
import modid.imsm.structureloader.StructureUtils;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityList;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class SchematicStructure
extends Structure {
    boolean isLive;
    private Block[][][] blocks;
    private int[][][] blockData;
    private NBTTagCompound[] entities;
    private NBTTagCompound[] tileEntities;
    private int blocksAdded;
    World serverWorld;
    World world;
    int posX;
    int posY;
    int posZ;
    BlockPlacer blockPlacer2;
    BlockPlacer blockPlacer;
    Vec3 harvestPos;

    public SchematicStructure(String fileName, boolean isLive) {
        super(fileName);
        this.isLive = isLive;
    }

    @Override
    public void process(World serverWorld, World world, int posX, int posY, int posZ) {
        BlockPlacer blockPlacer;
        this.serverWorld = serverWorld;
        this.world = world;
        this.posX = posX;
        this.posY = posY;
        this.posZ = posZ;
        Block blk = Blocks.field_150350_a;
        BlockPos pos0 = new BlockPos(posX, posY, posZ);
        IBlockState state0 = blk.func_176223_P();
        serverWorld.func_175656_a(pos0, state0);
        world.func_175656_a(pos0, state0);
        this.blocksAdded = 0;
        Vec3 harvestPos = new Vec3((double)(posX -= this.length / 2 - 1) + 0.5, (double)posY, (double)(posZ -= this.width / 2 - 1) + 0.5);
        BlockPlacer blockPlacer2 = new BlockPlacer(serverWorld, this.isLive);
        this.blockPlacer = blockPlacer = new BlockPlacer(world, this.isLive);
        this.blockPlacer2 = blockPlacer2;
        this.harvestPos = harvestPos;
        for (int y = 0; y < this.height; ++y) {
            for (int z = 0; z < this.width; ++z) {
                for (int x = 0; x < this.length; ++x) {
                    if (this.blockMode.equals("overlay") && this.blocks[y][z][x] == Blocks.field_150350_a) continue;
                    StructureUtils.setBlock(blockPlacer2, this.blocks[y][z][x].func_176203_a(this.blockData[y][z][x]), new BlockPos(x, y, z), this.getCenterPos(), harvestPos);
                    StructureUtils.setBlock(blockPlacer, this.blocks[y][z][x].func_176203_a(this.blockData[y][z][x]), new BlockPos(x, y, z), this.getCenterPos(), harvestPos);
                }
            }
        }
    }

    public void initSingleBlockPlacer(World serverWorld, World world, int posX, int posY, int posZ, boolean server) {
        this.serverWorld = serverWorld;
        this.world = world;
        this.posX = posX;
        this.posY = posY;
        this.posZ = posZ;
        Block blk = Blocks.field_150350_a;
        BlockPos pos0 = new BlockPos(this.posX, this.posY, this.posZ);
        IBlockState state0 = blk.func_176223_P();
        if (server) {
            this.serverWorld.func_175656_a(pos0, state0);
        } else {
            this.world.func_175656_a(pos0, state0);
        }
        this.blocksAdded = 0;
        this.posX -= this.length / 2 - 1;
        this.posZ -= this.width / 2 - 1;
        this.harvestPos = new Vec3((double)this.posX + 0.5, (double)this.posY, (double)this.posZ + 0.5);
        if (server) {
            this.blockPlacer2 = new BlockPlacer(serverWorld, this.isLive);
        } else {
            this.blockPlacer = new BlockPlacer(world, this.isLive);
        }
    }

    public boolean placeBlock(StructureCreator daddy, boolean server) {
        if (!this.blockMode.equals("overlay") || this.blocks[daddy.i][daddy.j][daddy.k] != Blocks.field_150350_a) {
            if (server) {
                StructureUtils.setBlock(this.blockPlacer2, this.blocks[daddy.i][daddy.j][daddy.k].func_176203_a(this.blockData[daddy.i][daddy.j][daddy.k]), new BlockPos(daddy.k, daddy.i, daddy.j), this.getCenterPos(), this.harvestPos);
            } else {
                StructureUtils.setBlock(this.blockPlacer, this.blocks[daddy.i][daddy.j][daddy.k].func_176203_a(this.blockData[daddy.i][daddy.j][daddy.k]), new BlockPos(daddy.k, daddy.i, daddy.j), this.getCenterPos(), this.harvestPos);
            }
        }
        ++daddy.k;
        if (daddy.k >= this.length) {
            daddy.k = 0;
            ++daddy.j;
            if (daddy.j >= this.width) {
                daddy.j = 0;
                ++daddy.i;
                if (daddy.i >= this.height) {
                    return true;
                }
            }
        }
        return false;
    }

    public void postProcess() {
        try {
            for (NBTTagCompound tileEntity : this.tileEntities) {
                StructureUtils.setTileEntity(this.serverWorld, TileEntity.func_145827_c((NBTTagCompound)tileEntity), this.getCenterPos(), this.harvestPos);
            }
            for (NBTTagCompound entity : this.entities) {
                StructureUtils.setEntity(this.serverWorld, EntityList.func_75615_a((NBTTagCompound)entity, (World)this.serverWorld), this.getCenterPos(), this.harvestPos);
            }
            for (NBTTagCompound tileEntity : this.tileEntities) {
                StructureUtils.setTileEntity(this.world, TileEntity.func_145827_c((NBTTagCompound)tileEntity), this.getCenterPos(), this.harvestPos);
            }
            for (NBTTagCompound entity : this.entities) {
                StructureUtils.setEntity(this.world, EntityList.func_75615_a((NBTTagCompound)entity, (World)this.world), this.getCenterPos(), this.harvestPos);
            }
            if (this.blockUpdate) {
                this.blockPlacer.update();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void showOutline(int x, int modifierx, int y, int modifiery, int z, int modifierz, World worldIn) {
        for (int i = 0; i < this.width; ++i) {
            for (int j = 0; j < this.height; ++j) {
                for (int k = 0; k < this.length; ++k) {
                    if (i != 0 && j != 0 && k != 0 || i == modifierx && j == modifiery && k == modifierz) continue;
                    Block blk = Blocks.field_150359_w;
                    BlockPos pos0 = new BlockPos(x - i + modifierx, y + j + modifiery, z - k + modifierz);
                    IBlockState state0 = blk.func_176223_P();
                    worldIn.func_175656_a(pos0, state0);
                }
            }
        }
    }

    public void removeOutline(int x, int modifierx, int y, int modifiery, int z, int modifierz, World worldIn) {
        for (int i = 0; i < this.width; ++i) {
            for (int j = 0; j < this.height; ++j) {
                for (int k = 0; k < this.length; ++k) {
                    if (i != 0 && j != 0 && k != 0 || i == modifierx && j == modifiery && k == modifierz) continue;
                    Block blk = Blocks.field_150350_a;
                    BlockPos pos0 = new BlockPos(x - i + modifierx, y + j + modifiery, z - k + modifierz);
                    IBlockState state0 = blk.func_176223_P();
                    worldIn.func_175656_a(pos0, state0);
                }
            }
        }
    }

    @Override
    public void readFromFile() {
        NBTTagCompound nbtTagCompound = null;
        try {
            DataInputStream dataInputStream = new DataInputStream(new GZIPInputStream(this.fileStream));
            nbtTagCompound = CompressedStreamTools.func_74794_a((DataInputStream)dataInputStream);
            dataInputStream.close();
        }
        catch (Exception e) {
            System.err.println("Instant Massive Structures Mod: Error loading structure '" + this.fileName + "'");
            return;
        }
        this.length = nbtTagCompound.func_74765_d("Width");
        this.width = nbtTagCompound.func_74765_d("Length");
        this.height = nbtTagCompound.func_74765_d("Height");
        int size = this.length * this.width * this.height;
        this.blocks = new Block[this.height][this.width][this.length];
        this.blockData = new int[this.height][this.width][this.length];
        byte[] blockIdsByte = nbtTagCompound.func_74770_j("Blocks");
        byte[] blockDataByte = nbtTagCompound.func_74770_j("Data");
        int x = 1;
        int y = 1;
        int z = 1;
        for (int i = 0; i < blockIdsByte.length; ++i) {
            short blockId = (short)(blockIdsByte[i] & 0xFF);
            this.blocks[y - 1][z - 1][x - 1] = Block.func_149729_e((int)blockId);
            this.blockData[y - 1][z - 1][x - 1] = blockDataByte[i];
            if (++x > this.length) {
                x = 1;
                ++z;
            }
            if (z <= this.width) continue;
            z = 1;
            ++y;
        }
        NBTTagList entityList = nbtTagCompound.func_150295_c("Entities", 10);
        this.entities = new NBTTagCompound[entityList.func_74745_c()];
        for (int i = 0; i < entityList.func_74745_c(); ++i) {
            this.entities[i] = entityList.func_150305_b(i);
        }
        NBTTagList tileEntityList = nbtTagCompound.func_150295_c("TileEntities", 10);
        this.tileEntities = new NBTTagCompound[tileEntityList.func_74745_c()];
        for (int i = 0; i < tileEntityList.func_74745_c(); ++i) {
            this.tileEntities[i] = tileEntityList.func_150305_b(i);
        }
        this.initCenterPos();
    }
}

