/*
 * Decompiled with CFR 0.152.
 */
package modid.imsm.structureloader;

import modid.imsm.structureloader.BlockPlacer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.Vec3;
import net.minecraft.util.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;

public class StructureUtils {
    public static BlockPos getWorldPos(BlockPos structPos, BlockPos structCenter, BlockPos harvestPos) {
        return harvestPos.func_177971_a((Vec3i)structPos).func_177973_b((Vec3i)structCenter);
    }

    public static BlockPos getWorldPos(BlockPos structPos, Vec3 structCenter, Vec3 harvestPos) {
        return new BlockPos(StructureUtils.getWorldPos(new Vec3((double)structPos.func_177958_n() + 0.5, (double)structPos.func_177956_o(), (double)structPos.func_177952_p() + 0.5), structCenter, harvestPos));
    }

    public static Vec3 getWorldPos(Vec3 structPos, Vec3 structCenter, Vec3 harvestPos) {
        return harvestPos.func_178787_e(structPos).func_178788_d(structCenter);
    }

    public static boolean setBlock(BlockPlacer blockPlacer, IBlockState blockState, BlockPos structPos, Vec3 structCenter, Vec3 harvestPos) {
        return blockPlacer.add(blockState, StructureUtils.getWorldPos(structPos, structCenter, harvestPos));
    }

    public static void setTileEntity(World world, NBTTagCompound tileEntity, BlockPos structPos, Vec3 structCenter, Vec3 harvestPos) {
        BlockPos pos = StructureUtils.getWorldPos(structPos, structCenter, harvestPos);
        IBlockState blockState = world.func_180495_p(pos);
        world.func_175713_t(pos);
        BlockPos chunkPos = new BlockPos(pos.func_177958_n() & 0xF, pos.func_177956_o(), pos.func_177952_p() & 0xF);
        TileEntity blockTileEntity = world.func_175726_f(pos).func_177424_a(chunkPos, Chunk.EnumCreateEntityType.CHECK);
        blockTileEntity = blockState.func_177230_c().createTileEntity(world, blockState);
        blockTileEntity.func_145839_a(tileEntity);
        blockTileEntity.func_174878_a(pos);
        blockTileEntity.func_145834_a(world);
        world.func_175690_a(pos, blockTileEntity);
        blockTileEntity.func_145836_u();
    }

    public static void setTileEntity(World world, TileEntity tileEntity, Vec3 structCenter, Vec3 harvestPos) {
        try {
            BlockPos pos = StructureUtils.getWorldPos(tileEntity.func_174877_v(), structCenter, harvestPos);
            world.func_175713_t(pos);
            tileEntity.func_174878_a(pos);
            tileEntity.func_145834_a(world);
            world.func_175690_a(pos, tileEntity);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
    }

    public static void setEntity(World world, Entity entity, Vec3 structCenter, Vec3 harvestPos) {
        Vec3 pos = StructureUtils.getWorldPos(entity.func_174791_d(), structCenter, harvestPos);
        entity.func_70107_b(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c);
        world.func_72838_d(entity);
    }
}

