/*
 * Decompiled with CFR 0.152.
 */
package modid.imsm.worldgeneration;

import modid.imsm.core.CreatorBlocks;
import modid.imsm.core.ICreatorBlock;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;

public class BigWorldCreator
extends CreatorBlocks
implements ICreatorBlock {
    int i;
    int j;
    int k;
    private int nCheckers;
    int checkerSize = 2;
    int direction;

    public BigWorldCreator(int x, int y, int z, int nCheckers, World worldIn, World serverWorld, int checkerSize) {
        this.worldIn[1] = worldIn;
        this.worldIn[0] = serverWorld;
        this.x = x;
        this.y = y;
        this.z = z;
        this.nCheckers = nCheckers;
        this.checkerSize = checkerSize;
    }

    @Override
    public void init() {
        this.direction = 0;
        this.i = 1;
        this.j = 0;
        this.k = 0;
    }

    @Override
    public boolean run(boolean server) {
        switch (this.direction) {
            case 0: {
                this.z += this.checkerSize;
                break;
            }
            case 1: {
                this.x += this.checkerSize;
                break;
            }
            case 2: {
                this.z -= this.checkerSize;
                break;
            }
            case 3: {
                this.x -= this.checkerSize;
            }
        }
        this.createChecker();
        ++this.k;
        if (this.k >= this.i) {
            ++this.direction;
            if (this.direction == 4) {
                this.direction = 0;
            }
            ++this.j;
            this.k = 0;
            if (this.j >= 3) {
                ++this.i;
                this.j = 0;
                if (this.i >= this.nCheckers + 1) {
                    return true;
                }
            }
        }
        return false;
    }

    private void createChecker() {
        for (int l = 0; l < 256; l += this.checkerSize) {
            for (int k = 0; k < 2; ++k) {
                Block replace = this.worldIn[k].func_180495_p(new BlockPos(this.x, l, this.z)).func_177230_c();
                for (int a = 0; a < this.checkerSize; ++a) {
                    for (int b = 0; b < this.checkerSize; ++b) {
                        for (int c = 0; c < this.checkerSize; ++c) {
                            this.createBlock(new BlockPos(this.x + a, l + c, this.z + b), replace.func_176223_P());
                        }
                    }
                }
            }
        }
    }

    public void createBlock(Block blk, int i, int j, int k, int l) {
        BlockPos pos0 = new BlockPos(i, l, j);
        IBlockState state0 = blk.func_176223_P();
        this.worldIn[k].func_175656_a(pos0, state0);
    }

    public void createBlock(BlockPos pos, IBlockState state) {
        try {
            Chunk chunk = this.worldIn[this.k].func_175726_f(pos);
            ExtendedBlockStorage storageArray = chunk.func_76587_i()[pos.func_177956_o() >> 4];
            if (storageArray == null) {
                ExtendedBlockStorage extendedBlockStorage = new ExtendedBlockStorage(pos.func_177956_o() >> 4 << 4, !this.worldIn[this.k].field_73011_w.func_177495_o());
                chunk.func_76587_i()[pos.func_177956_o() >> 4] = extendedBlockStorage;
                storageArray = extendedBlockStorage;
            }
            if (storageArray.func_150819_a(pos.func_177958_n() & 0xF, pos.func_177956_o() & 0xF, pos.func_177952_p() & 0xF) != state.func_177230_c()) {
                IBlockState oldState = this.worldIn[this.k].func_180495_p(pos);
                storageArray.func_177484_a(pos.func_177958_n() & 0xF, pos.func_177956_o() & 0xF, pos.func_177952_p() & 0xF, state);
                this.worldIn[this.k].func_175689_h(pos);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

