/*
 * Decompiled with CFR 0.152.
 */
package modid.imsm.worldgeneration;

import modid.imsm.core.CreatorBlocks;
import modid.imsm.core.ICreatorBlock;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.BlockPos;
import net.minecraft.world.World;

public class CheckerboardCreator
extends CreatorBlocks
implements ICreatorBlock {
    int i;
    int j;
    int k;
    private int nCheckers;
    final int checkerSize = 16;
    int direction;
    boolean color;

    public CheckerboardCreator(int x, int y, int z, int nCheckers, World worldIn, World serverWorld) {
        this.worldIn[1] = worldIn;
        this.worldIn[0] = serverWorld;
        this.x = x;
        this.y = y;
        this.z = z;
        this.nCheckers = nCheckers;
    }

    @Override
    public void init() {
        this.direction = 0;
        this.i = 1;
        this.j = 0;
        this.k = 0;
        this.color = false;
    }

    @Override
    public boolean run(boolean server) {
        switch (this.direction) {
            case 0: {
                this.z += 16;
                break;
            }
            case 1: {
                this.x += 16;
                break;
            }
            case 2: {
                this.z -= 16;
                break;
            }
            case 3: {
                this.x -= 16;
            }
        }
        this.createChecker();
        this.color = !this.color;
        ++this.k;
        if (this.k >= this.i) {
            ++this.direction;
            if (this.direction == 4) {
                this.direction = 0;
            }
            ++this.j;
            this.k = 0;
            if (this.j >= 3) {
                ++this.i;
                this.j = 0;
                if (this.i >= this.nCheckers + 1) {
                    return true;
                }
            }
        }
        return false;
    }

    private void createChecker() {
        for (int i = 0; i < 16; ++i) {
            for (int j = 0; j < 16; ++j) {
                for (int k = 0; k < 2; ++k) {
                    Block blk = Blocks.field_150325_L;
                    if (this.color) {
                        blk = Blocks.field_150402_ci;
                    }
                    this.createBlock(blk, i, j, k);
                }
            }
        }
    }

    public void createBlock(Block blk, int i, int j, int k) {
        BlockPos pos0 = new BlockPos(this.x + i, this.y, this.z + j);
        IBlockState state0 = blk.func_176223_P();
        this.worldIn[k].func_175656_a(pos0, state0);
    }
}

