/*
 * Decompiled with CFR 0.152.
 */
package modid.imsm.worldgeneration;

import modid.imsm.core.CreatorBlocks;
import modid.imsm.core.ICreatorBlock;
import modid.imsm.core.IMSM;
import modid.imsm.core.StructureCreator;
import modid.imsm.structureloader.BlockPlaceHandler;
import modid.imsm.worldgeneration.MazeRunner;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.scoreboard.IScoreObjectiveCriteria;
import net.minecraft.scoreboard.Score;
import net.minecraft.scoreboard.ScoreObjective;
import net.minecraft.scoreboard.Scoreboard;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.BlockPos;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;

public class MazeGenerator
extends CreatorBlocks
implements ICreatorBlock {
    public MazeRunner maze;
    int i = 0;
    int j = 0;
    public int blockSize = 8;
    public int blockHeight = 32;
    int direction = 0;
    int k = 0;
    int l = 0;
    int m = 0;
    int error = 0;
    int generated = 0;
    int n = 0;
    int size;
    int phase;
    boolean isDone = false;
    public Block wallMaterial = Blocks.field_150341_Y;
    Score displayProgress;
    ScoreObjective scoreBoard;
    private boolean initComplete;

    public MazeGenerator(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.maze = new MazeRunner();
    }

    public void startGeneration() {
        Minecraft.func_71410_x().field_71439_g.func_145747_a((IChatComponent)new ChatComponentText("A huge random maze will now be generated at your location!"));
        this.maze.initCollisions(true);
        this.init();
        this.initComplete = true;
    }

    void placeAt(int posX, int posY) {
        if (this.maze.nodeRegister[posX][posY] == 0) {
            BlockPlaceHandler.placeBlocks(this.wallMaterial, this.x + posX * this.blockSize, this.y, this.z + posY * this.blockSize, this.blockSize, this.blockHeight, this.blockSize);
        } else if (this.maze.nodeRegister[posX][posY] == 1) {
            BlockPlaceHandler.placeBlocks(Blocks.field_150350_a, this.x + posX * this.blockSize, this.y, this.z + posY * this.blockSize, this.blockSize, this.blockHeight, this.blockSize);
        } else if (this.maze.nodeRegister[posX][posY] == 3) {
            int xPos = this.x + posX * this.blockSize + (int)(Math.random() * (double)(this.blockSize - 1));
            int zPos = this.z + posY * this.blockSize + (int)(Math.random() * (double)(this.blockSize - 1));
            BlockPlaceHandler.placeBlock((Block)Blocks.field_150486_ae, xPos, this.y, zPos);
            TileEntityChest chest = (TileEntityChest)MinecraftServer.func_71276_C().func_130014_f_().func_175625_s(new BlockPos(xPos, this.y, zPos));
            if (chest != null) {
                this.generateChestContents(chest);
            }
        } else if (this.maze.nodeRegister[posX][posY] == 10 && this.blockSize >= 8) {
            BlockPos newPos = new BlockPos(this.x + posX * this.blockSize, this.y, this.z + posY * this.blockSize);
            IMSM.eventHandler.creators.add(new StructureCreator("FoodWheatNorthEastSouthWest", Minecraft.func_71410_x().func_71401_C().func_130014_f_(), (World)Minecraft.func_71410_x().field_71441_e, this.x + posX * this.blockSize + 16, this.y - 2, this.z + posY * this.blockSize + 16, true, this.getSize(IMSM.eventHandler.creators.size())));
            IMSM.eventHandler.creators.get(IMSM.eventHandler.creators.size() - 1).init();
        } else if (this.maze.nodeRegister[posX][posY] == 9 && this.blockSize >= 8) {
            BlockPos newPos = new BlockPos(this.x + posX * this.blockSize, this.y, this.z + posY * this.blockSize);
            IMSM.eventHandler.creators.add(new StructureCreator("FoodFarmEast", Minecraft.func_71410_x().func_71401_C().func_130014_f_(), (World)Minecraft.func_71410_x().field_71441_e, this.x + posX * this.blockSize + 16, this.y - 2, this.z + posY * this.blockSize + 16, true, this.getSize(IMSM.eventHandler.creators.size())));
            IMSM.eventHandler.creators.get(IMSM.eventHandler.creators.size() - 1).init();
        } else if (this.maze.nodeRegister[posX][posY] == 11 && this.blockSize >= 8) {
            BlockPos newPos = new BlockPos(this.x + posX * this.blockSize, this.y, this.z + posY * this.blockSize);
            IMSM.eventHandler.creators.add(new StructureCreator("ResidentalMedium_DensityRoofWest", Minecraft.func_71410_x().func_71401_C().func_130014_f_(), (World)Minecraft.func_71410_x().field_71441_e, this.x + posX * this.blockSize + 16, this.y - 1, this.z + posY * this.blockSize + 16, true, this.getSize(IMSM.eventHandler.creators.size())));
            IMSM.eventHandler.creators.get(IMSM.eventHandler.creators.size() - 1).init();
        } else if (this.maze.nodeRegister[posX][posY] == 12 && this.blockSize >= 8) {
            BlockPos newPos = new BlockPos(this.x + posX * this.blockSize, this.y, this.z + posY * this.blockSize);
            IMSM.eventHandler.creators.add(new StructureCreator("ResidentalHigh_DensityStoneWest", Minecraft.func_71410_x().func_71401_C().func_130014_f_(), (World)Minecraft.func_71410_x().field_71441_e, this.x + posX * this.blockSize + 16, this.y - 1, this.z + posY * this.blockSize + 16, true, this.getSize(IMSM.eventHandler.creators.size())));
            IMSM.eventHandler.creators.get(IMSM.eventHandler.creators.size() - 1).init();
        } else if (this.maze.nodeRegister[posX][posY] == 20) {
            --this.generated;
        } else if (this.maze.nodeRegister[posX][posY] != 21) {
            BlockPlaceHandler.placeBlocks(Blocks.field_150350_a, this.x + posX * this.blockSize, this.y, this.z + posY * this.blockSize, this.blockSize, this.blockHeight, this.blockSize);
        }
        ++this.generated;
        this.maze.nodeRegister[posX][posY] = 20;
    }

    private int getSize(int size) {
        int totalsize = 0;
        for (int i = 0; i < IMSM.eventHandler.creators.size(); ++i) {
            if (!(IMSM.eventHandler.creators.get(i) instanceof StructureCreator)) continue;
            ++totalsize;
        }
        return totalsize;
    }

    private void generateChestContents(TileEntityChest chest) {
        for (int i = 0; i < 27; ++i) {
            if (!(Math.random() < 0.2)) continue;
            chest.func_70299_a(i, new ItemStack(this.getRandomItem(), 1));
        }
    }

    private Item getRandomItem() {
        int randomItem = (int)(Math.random() * 81.0);
        switch (randomItem) {
            case 0: {
                return Items.field_151033_d;
            }
            case 1: {
                return Items.field_151032_g;
            }
            case 2: {
                return Items.field_151031_f;
            }
            case 3: {
                return Items.field_151034_e;
            }
            case 4: {
                return Items.field_151044_h;
            }
            case 5: {
                return Items.field_151040_l;
            }
            case 6: {
                return Items.field_151041_m;
            }
            case 7: {
                return Items.field_151052_q;
            }
            case 8: {
                return Items.field_151048_u;
            }
            case 9: {
                return Items.field_151010_B;
            }
            case 10: {
                return Items.field_151009_A;
            }
            case 11: {
                return Items.field_151019_K;
            }
            case 12: {
                return Items.field_151015_O;
            }
            case 13: {
                return Items.field_151025_P;
            }
            case 14: {
                return Items.field_151021_T;
            }
            case 15: {
                return Items.field_151027_R;
            }
            case 16: {
                return Items.field_151024_Q;
            }
            case 17: {
                return Items.field_151026_S;
            }
            case 18: {
                return Items.field_151029_X;
            }
            case 19: {
                return Items.field_151023_V;
            }
            case 20: {
                return Items.field_151020_U;
            }
            case 21: {
                return Items.field_151022_W;
            }
            case 22: {
                return Items.field_151028_Y;
            }
            case 23: {
                return Items.field_151030_Z;
            }
            case 24: {
                return Items.field_151165_aa;
            }
            case 25: {
                return Items.field_151167_ab;
            }
            case 26: {
                return Items.field_151161_ac;
            }
            case 27: {
                return Items.field_151163_ad;
            }
            case 28: {
                return Items.field_151173_ae;
            }
            case 29: {
                return Items.field_151175_af;
            }
            case 30: {
                return Items.field_151169_ag;
            }
            case 31: {
                return Items.field_151171_ah;
            }
            case 32: {
                return Items.field_151149_ai;
            }
            case 33: {
                return Items.field_151151_aj;
            }
            case 34: {
                return Items.field_151147_al;
            }
            case 35: {
                return Items.field_151157_am;
            }
            case 36: {
                return Items.field_151153_ao;
            }
            case 37: {
                return Items.field_151120_aE;
            }
            case 38: {
                return Items.field_151141_av;
            }
            case 39: {
                return Items.field_151126_ay;
            }
            case 40: {
                return Items.field_151121_aF;
            }
            case 41: {
                return Items.field_151111_aL;
            }
            case 42: {
                return Items.field_151112_aM;
            }
            case 43: {
                return Items.field_151113_aN;
            }
            case 44: {
                return Items.field_151115_aP;
            }
            case 45: {
                return Items.field_179566_aV;
            }
            case 46: {
                return Items.field_151105_aU;
            }
            case 47: {
                return Items.field_151104_aV;
            }
            case 48: {
                return Items.field_151106_aX;
            }
            case 49: {
                return Items.field_151148_bJ;
            }
            case 50: {
                return Items.field_151082_bd;
            }
            case 51: {
                return Items.field_151083_be;
            }
            case 52: {
                return Items.field_151076_bf;
            }
            case 53: {
                return Items.field_151077_bg;
            }
            case 54: {
                return Items.field_151078_bh;
            }
            case 55: {
                return Items.field_151079_bi;
            }
            case 56: {
                return Items.field_151032_g;
            }
            case 57: {
                return Items.field_151172_bF;
            }
            case 58: {
                return Items.field_151174_bG;
            }
            case 59: {
                return Items.field_151168_bH;
            }
            case 60: {
                return Items.field_151170_bI;
            }
            case 61: {
                return Items.field_151150_bK;
            }
            case 62: {
                return Items.field_151144_bL;
            }
            case 63: {
                return Items.field_151158_bO;
            }
            case 64: {
                return Items.field_179560_bq;
            }
            case 65: {
                return Items.field_179558_bo;
            }
            case 66: {
                return Items.field_151058_ca;
            }
            case 67: {
                return Items.field_179561_bm;
            }
            case 68: {
                return Items.field_179557_bn;
            }
            case 69: {
                return Items.field_151032_g;
            }
            case 70: {
                return Items.field_151032_g;
            }
            case 71: {
                return Items.field_151032_g;
            }
            case 72: {
                return Items.field_151032_g;
            }
            case 73: {
                return Items.field_151032_g;
            }
            case 74: {
                return Items.field_151032_g;
            }
            case 75: {
                return Items.field_151148_bJ;
            }
            case 76: {
                return Items.field_151148_bJ;
            }
            case 77: {
                return Items.field_151148_bJ;
            }
            case 78: {
                return Items.field_151148_bJ;
            }
            case 79: {
                return Items.field_151148_bJ;
            }
            case 80: {
                return Items.field_151148_bJ;
            }
        }
        return null;
    }

    @Override
    public void init() {
        this.scoreBoard = Minecraft.func_71410_x().field_71441_e.func_96441_U().func_96535_a("Score", IScoreObjectiveCriteria.field_96641_b);
        this.scoreBoard.func_178767_a(IScoreObjectiveCriteria.EnumRenderType.INTEGER);
        this.scoreBoard.func_96682_a().func_96530_a(Scoreboard.func_96537_j((String)"sidebar"), this.scoreBoard);
        this.displayProgress = this.scoreBoard.func_96682_a().func_96529_a("Maze Building Progress (%)", this.scoreBoard);
        this.displayProgress.func_96647_c(0);
        this.size = this.maze.nodeRegister[0].length / 2;
        this.x -= this.blockSize * this.maze.nodeRegister[0].length / 2;
        this.z -= this.blockSize * this.maze.nodeRegister[1].length / 2;
        WorldClient worldIn = Minecraft.func_71410_x().field_71441_e;
        World serverWorld = MinecraftServer.func_71276_C().func_130014_f_();
        for (int x = 0; x < this.blockSize * this.maze.nodeRegister[0].length; ++x) {
            for (int y = 0; y < 1; ++y) {
                for (int z = 0; z < this.blockSize * this.maze.nodeRegister[1].length; ++z) {
                    BlockPos pos = new BlockPos(this.x + this.i + x, this.y - 1 + y, this.z + this.j + z);
                    Object block = this.maze.isCloseTo(x / this.blockSize, this.maze.gladeSize - 1, this.maze.numOfColumns / 2) && this.maze.isCloseTo(z / this.blockSize, this.maze.gladeSize - 1, this.maze.numOfColumns / 2) ? Blocks.field_150349_c : Blocks.field_150417_aV;
                    BlockPlaceHandler.setBlock((World)worldIn, pos, block.func_176223_P());
                    BlockPlaceHandler.setBlock(serverWorld, pos, block.func_176223_P());
                }
            }
        }
    }

    @Override
    public boolean run(boolean server) {
        if (this.initComplete) {
            if (!this.isDone) {
                switch (this.direction) {
                    case 0: {
                        ++this.j;
                        break;
                    }
                    case 1: {
                        ++this.i;
                        break;
                    }
                    case 2: {
                        --this.j;
                        break;
                    }
                    case 3: {
                        --this.i;
                    }
                }
                if (this.i + this.size >= 0 && this.j + this.size >= 0 && this.i + this.size < this.maze.nodeRegister.length && this.j + this.size < this.maze.nodeRegister[0].length) {
                    this.placeAt(this.i + this.size, this.j + this.size);
                } else {
                    this.isDone = true;
                    this.i = 0;
                    this.j = 0;
                }
                ++this.k;
                if (this.k >= this.l) {
                    ++this.direction;
                    if (this.direction == 4) {
                        this.direction = 0;
                    }
                    ++this.m;
                    this.k = 0;
                    if (this.m >= 2) {
                        ++this.l;
                        this.m = 0;
                    }
                }
            } else {
                this.placeAt(this.i, this.j);
                ++this.i;
                if (this.i >= this.maze.nodeRegister.length) {
                    ++this.j;
                    this.i = 0;
                    if (this.j >= this.maze.nodeRegister[0].length) {
                        this.scoreBoard.func_96682_a().func_96519_k(this.scoreBoard);
                        Minecraft.func_71410_x().field_71439_g.func_145747_a((IChatComponent)new ChatComponentText("A random maze has been generated!"));
                        return true;
                    }
                }
            }
            this.displayProgress.func_96647_c((int)((double)((float)this.generated / (float)(this.maze.nodeRegister.length * this.maze.nodeRegister[0].length)) * 100.0));
            if (this.generated > this.maze.nodeRegister.length * this.maze.nodeRegister[0].length) {
                this.scoreBoard.func_96682_a().func_96519_k(this.scoreBoard);
                Minecraft.func_71410_x().field_71439_g.func_145747_a((IChatComponent)new ChatComponentText("A random maze has been generated!"));
                return true;
            }
        }
        return false;
    }
}

