/*
 * Decompiled with CFR 0.152.
 */
package modid.imsm.worldgeneration;

public class MazeRunner {
    byte[][] nodeRegister;
    public int numOfColumns = 48;
    public int gladeSize = 9;
    public int amountOfChests = this.numOfColumns * this.numOfColumns / 200;
    public boolean populateGlade = true;

    public void setup() {
        this.initCollisions(true);
        for (int i = 0; i < this.nodeRegister.length; ++i) {
            for (int j = 0; j < this.nodeRegister[0].length; ++j) {
                if (this.nodeRegister[i][j] == 1) {
                    System.out.print(" ");
                    continue;
                }
                if (this.nodeRegister[i][j] == 0) {
                    System.out.print("\u2593");
                    continue;
                }
                if (this.nodeRegister[i][j] == 2) {
                    System.out.print("O");
                    continue;
                }
                if (this.nodeRegister[i][j] == 3) {
                    System.out.print("C");
                    continue;
                }
                if (this.nodeRegister[i][j] == 4) {
                    System.out.print("N");
                    continue;
                }
                System.out.print((char)(this.nodeRegister[i][j] - 9 + 48));
            }
            System.out.println();
        }
    }

    private byte[][][] initMap(float density) {
        this.nodeRegister = new byte[this.numOfColumns + 2][this.numOfColumns + 2];
        byte[][][] kleppen = new byte[this.numOfColumns][this.numOfColumns][4];
        for (int i = 0; i < this.nodeRegister.length; ++i) {
            for (int j = 0; j < this.nodeRegister[0].length; ++j) {
                this.nodeRegister[i][j] = 1;
            }
        }
        for (int j = 0; j < kleppen.length; ++j) {
            for (int k = 0; k < kleppen[0].length; ++k) {
                boolean l = false;
                int randomInt = (int)(Math.random() * 4.0);
                for (int i = 0; i < 4; ++i) {
                    if (!(Math.random() * (double)density < 1.0) && i != randomInt) continue;
                    kleppen[j][k][i] = (byte)(i + 1);
                }
            }
        }
        return kleppen;
    }

    public void populateGlade() {
        int x = this.numOfColumns / 2 - this.gladeSize + 2;
        int y = this.numOfColumns / 2 - this.gladeSize + 2;
        this.nodeRegister[x][y] = 21;
        this.nodeRegister[x][y + 1] = 21;
        this.nodeRegister[x + 1][y + 1] = 21;
        this.nodeRegister[x + 1][y] = 21;
        this.nodeRegister[x][y + 2] = 9;
        this.nodeRegister[x][y + 3] = 21;
        this.nodeRegister[x + 1][y + 3] = 21;
        this.nodeRegister[x + 1][y + 2] = 21;
        this.nodeRegister[x][y + 5] = 10;
        this.nodeRegister[x][y + 6] = 21;
        this.nodeRegister[x + 1][y + 6] = 21;
        this.nodeRegister[x + 1][y + 5] = 21;
        this.nodeRegister[x + this.gladeSize * 2 - 4][y + 11] = 11;
        this.nodeRegister[x + this.gladeSize * 2 - 4][y + 12] = 21;
        this.nodeRegister[x + this.gladeSize * 2 - 3][y + 12] = 21;
        this.nodeRegister[x + this.gladeSize * 2 - 3][y + 11] = 21;
        this.nodeRegister[x + this.gladeSize * 2 - 4][y + 13] = 12;
        this.nodeRegister[x + this.gladeSize * 2 - 4][y + 14] = 21;
        this.nodeRegister[x + this.gladeSize * 2 - 3][y + 14] = 21;
        this.nodeRegister[x + this.gladeSize * 2 - 3][y + 13] = 21;
    }

    private void createOpening(int size, boolean horizontal, boolean left) {
        int randomSpot = (int)(Math.random() * (double)this.numOfColumns) + 1;
        int number = 5;
        for (int i = 0; i < size; ++i) {
            if (horizontal) {
                if (left) {
                    this.nodeRegister[i][randomSpot] = number;
                } else {
                    this.nodeRegister[this.nodeRegister.length - 1 - i][randomSpot] = (byte)(number + 1 * this.booleanToInt(number == 5));
                }
            } else if (left) {
                this.nodeRegister[randomSpot][i] = (byte)(number + 2 * this.booleanToInt(number == 5));
            } else {
                this.nodeRegister[randomSpot][this.nodeRegister[0].length - 1 - i] = (byte)(number + 3 * this.booleanToInt(number == 5));
            }
            if (i != 0) continue;
            number = 1;
        }
    }

    private void createOpeningsInGlade(int size) {
        int randomSpot = this.nodeRegister.length / 2;
        int number = 5;
        for (int i = 0; i < size; ++i) {
            this.nodeRegister[randomSpot - i - this.gladeSize][randomSpot] = number;
            this.nodeRegister[this.numOfColumns - randomSpot + i + this.gladeSize + 1][randomSpot] = (byte)(number + 1 * this.booleanToInt(number == 5));
            this.nodeRegister[randomSpot][randomSpot - i - this.gladeSize] = (byte)(number + 2 * this.booleanToInt(number == 5));
            this.nodeRegister[randomSpot][this.numOfColumns - randomSpot + i + this.gladeSize + 1] = (byte)(number + 3 * this.booleanToInt(number == 5));
            if (i != 0) continue;
            number = 1;
        }
    }

    private int booleanToInt(boolean b) {
        if (b) {
            return 1;
        }
        return 0;
    }

    private void createOutline(int i, int j, int sizex, int sizey) {
        int a = i;
        while (a - i < sizex) {
            int b = j;
            while (b - j < sizey) {
                if (a == i || b == j || a - i == sizex - 1 || b - j == sizey - 1) {
                    this.nodeRegister[a][b] = 0;
                }
                ++b;
            }
            ++a;
        }
    }

    private void fill(int i, int j, int sizex, int sizey) {
        int a = i;
        while (a - i < sizex) {
            int b = j;
            while (b - j < sizey) {
                this.nodeRegister[a][b] = 4;
                ++b;
            }
            ++a;
        }
    }

    boolean isCloseTo(int number, int howCloseTo, int anotherNumber) {
        return anotherNumber <= number + howCloseTo && anotherNumber >= number - howCloseTo;
    }

    byte[][] getNodeMap(int a, int b) {
        byte[][] nodeMap = new byte[][]{{this.nodeRegister[a][b], this.nodeRegister[a][b + 1], this.nodeRegister[a][b + 2]}, {this.nodeRegister[a + 1][b], this.nodeRegister[a + 1][b + 1], this.nodeRegister[a + 1][b + 2]}, {this.nodeRegister[a + 2][b], this.nodeRegister[a + 2][b + 1], this.nodeRegister[a + 2][b + 2]}};
        return nodeMap;
    }

    void initCollisions(boolean doRemoveMiddle) {
        this.writeRandomWalls(this.initMap(2.2f));
        this.createOutsideWall();
        if (doRemoveMiddle) {
            this.createOutline(this.numOfColumns / 2 - this.gladeSize + 1, this.numOfColumns / 2 - this.gladeSize + 1, this.gladeSize * 2, this.gladeSize * 2);
            this.createOpeningsInGlade(3);
            if (this.populateGlade) {
                this.populateGlade();
            }
        } else {
            this.fill(this.numOfColumns / 2 - this.gladeSize + 1, this.numOfColumns / 2 - this.gladeSize + 1, this.gladeSize * 2, this.gladeSize * 2);
        }
        this.createOpening(4, (int)(Math.random() * 2.0) == 0, (int)(Math.random() * 2.0) == 0);
        this.generateChests(this.amountOfChests);
    }

    private void writeRandomWalls(byte[][][] kleppen) {
        int nodeCounter = 0;
        int lineCounter = 0;
        for (int a = 1; a < this.numOfColumns; a += 3) {
            for (int b = 1; b < this.numOfColumns; b += 3) {
                byte[][] temp = this.getNodeMap(a, b);
                if (!this.isCloseTo(a, this.gladeSize, this.numOfColumns / 2) || !this.isCloseTo(b, this.gladeSize, this.numOfColumns / 2)) {
                    temp[1][1] = 0;
                    this.checkContainingKleppen(temp, kleppen[a][b], a, b);
                    ++lineCounter;
                }
                nodeCounter += this.numOfColumns * 3 * 3 - 9;
                this.writeNodeMap(temp, a, b);
            }
            nodeCounter = a * 3;
        }
    }

    private void createOutsideWall() {
        for (int i = 0; i < this.nodeRegister.length; ++i) {
            for (int j = 0; j < this.nodeRegister[0].length; ++j) {
                if (j == 0 || i == 0) {
                    this.nodeRegister[i][j] = 0;
                    continue;
                }
                if (i != this.nodeRegister.length - 1 && j != this.nodeRegister[0].length - 1) continue;
                this.nodeRegister[i][j] = 0;
            }
        }
    }

    private void generateChests(int amount) {
        int spotx = 0;
        int spoty = 0;
        for (int i = 0; i < amount; ++i) {
            while (this.nodeRegister[spotx][spoty] != 1 || this.isCloseTo(spotx, this.gladeSize, this.numOfColumns / 2) && this.isCloseTo(spoty, this.gladeSize, this.numOfColumns / 2)) {
                spotx = (int)(Math.random() * (double)this.nodeRegister.length);
                spoty = (int)(Math.random() * (double)this.nodeRegister[0].length);
            }
            this.nodeRegister[spotx][spoty] = 3;
        }
    }

    void writeNodeMap(byte[][] nodeMap, int a, int b) {
        this.nodeRegister[a][b] = nodeMap[0][0];
        this.nodeRegister[a][b + 1] = nodeMap[0][1];
        this.nodeRegister[a][b + 2] = nodeMap[0][2];
        this.nodeRegister[a + 1][b] = nodeMap[1][0];
        this.nodeRegister[a + 1][b + 1] = nodeMap[1][1];
        this.nodeRegister[a + 1][b + 2] = nodeMap[1][2];
        this.nodeRegister[a + 2][b] = nodeMap[2][0];
        this.nodeRegister[a + 2][b + 1] = nodeMap[2][1];
        this.nodeRegister[a + 2][b + 2] = nodeMap[2][2];
    }

    void checkContainingKleppen(byte[][] nodeMap, byte[] klep, int a, int b) {
        for (int i = 0; i < klep.length; ++i) {
            if (klep[i] == 1) {
                nodeMap[0][1] = 0;
                continue;
            }
            if (klep[i] == 2) {
                nodeMap[1][2] = 0;
                continue;
            }
            if (klep[i] == 3) {
                nodeMap[2][1] = 0;
                continue;
            }
            if (klep[i] != 4) continue;
            nodeMap[1][0] = 0;
        }
    }
}

