/*
 * Decompiled with CFR 0.152.
 */
package mod.lucky.drop.func;

import mod.lucky.drop.DropProperties;
import mod.lucky.drop.func.DropFunction;
import mod.lucky.drop.func.DropProcessData;
import mod.lucky.entity.EntityLuckyProjectile;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.item.EntityFallingBlock;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.entity.projectile.EntityEgg;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.BlockPos;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class DropFuncEntity
extends DropFunction {
    @Override
    public void process(DropProcessData processData) {
        Entity entity;
        DropProperties drop = processData.getDropProperties();
        float posX = drop.getPropertyFloat("posX").floatValue();
        float posY = drop.getPropertyFloat("posY").floatValue();
        float posZ = drop.getPropertyFloat("posZ").floatValue();
        if (posY <= -1.0f) {
            return;
        }
        NBTTagCompound nbtTagCompound = drop.getPropertyNBT("NBTTag") == null ? new NBTTagCompound() : drop.getPropertyNBT("NBTTag");
        String id = drop.getPropertyString("ID");
        if (id.equals("LightningBolt")) {
            processData.getWorld().func_72942_c((Entity)new EntityLightningBolt(processData.getWorld(), (double)posX, (double)posY, (double)posZ));
            return;
        }
        if (!nbtTagCompound.func_74764_b("id")) {
            nbtTagCompound.func_74778_a("id", id);
        }
        if (!nbtTagCompound.func_74764_b("ownerName")) {
            nbtTagCompound.func_74778_a("ownerName", processData.getPlayer().func_70005_c_());
        }
        boolean hasPos = nbtTagCompound.func_74764_b("Pos");
        boolean hasMotion = nbtTagCompound.func_74764_b("Motion");
        boolean hasRotation = nbtTagCompound.func_74764_b("Rotation");
        if (id.equals("ThrownEgg")) {
            entity = new EntityEgg(processData.getWorld(), (double)posX, (double)posY, (double)posZ);
            entity.func_70020_e(nbtTagCompound);
        } else {
            entity = EntityList.func_75615_a((NBTTagCompound)nbtTagCompound, (World)processData.getWorld());
        }
        if (entity instanceof EntityFallingBlock && !nbtTagCompound.func_74764_b("Time")) {
            ((EntityFallingBlock)entity).field_145812_b = 1;
        }
        if (entity == null) {
            System.err.println("Lucky Block: Error loading entity '" + id + "'.");
            return;
        }
        if (!hasPos) {
            entity.field_70165_t = posX;
            entity.field_70163_u = posY;
            entity.field_70161_v = posZ;
        }
        if (entity instanceof EntityThrowable && !hasRotation && hasMotion) {
            float sqrt = MathHelper.func_76133_a((double)(entity.field_70159_w * entity.field_70159_w + entity.field_70179_y * entity.field_70179_y));
            entity.field_70177_z = (float)(Math.atan2(entity.field_70159_w, entity.field_70179_y) * 180.0 / Math.PI);
            entity.field_70125_A = (float)(Math.atan2(entity.field_70181_x, sqrt) * 180.0 / Math.PI);
            entity.field_70133_I = true;
        }
        if (entity instanceof EntityArrow) {
            ((EntityArrow)entity).field_70250_c = processData.getPlayer();
        }
        if (entity instanceof EntityLuckyProjectile) {
            ((EntityLuckyProjectile)entity).field_70250_c = processData.getPlayer();
        }
        for (int y = 0; y < 10; ++y) {
            if (!processData.getWorld().func_175623_d(new BlockPos(entity.field_70165_t, entity.field_70163_u + (double)y, entity.field_70161_v))) continue;
            entity.field_70163_u += (double)y;
            break;
        }
        entity.func_70012_b(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, entity.field_70177_z, entity.field_70125_A);
        if (entity != null && entity instanceof EntityLiving) {
            if (processData.getProcessType() != DropProcessData.EnumProcessType.LUCKY_STRUCT) {
                ((EntityLiving)entity).func_180482_a(processData.getWorld().func_175649_E(new BlockPos(entity)), (IEntityLivingData)null);
            }
            ((EntityLiving)entity).func_70037_a(nbtTagCompound);
        }
        if (drop.hasProperty("NBTTag") && entity != null) {
            processData.getWorld().func_72838_d(entity);
            Entity entity2 = entity;
            NBTTagCompound nbtTagCompoundRider = nbtTagCompound;
            while (nbtTagCompoundRider.func_150297_b("Riding", 10)) {
                Entity ridenOnEntity = EntityList.func_75615_a((NBTTagCompound)nbtTagCompoundRider.func_74775_l("Riding"), (World)processData.getWorld());
                if (ridenOnEntity != null) {
                    ridenOnEntity.func_70012_b(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, entity.field_70177_z, entity.field_70125_A);
                    processData.getWorld().func_72838_d(ridenOnEntity);
                    entity2.func_70078_a(ridenOnEntity);
                }
                entity2 = ridenOnEntity;
                nbtTagCompoundRider = nbtTagCompoundRider.func_74775_l("Riding");
            }
        } else if (entity != null) {
            processData.getWorld().func_72838_d(entity);
        }
    }

    @Override
    public void registerProperties() {
        DropProperties.setDefaultProperty(this.getType(), "NBTTag", NBTTagCompound.class, null);
        DropProperties.setDefaultProperty(this.getType(), "posX", Float.class, Float.valueOf(0.0f));
        DropProperties.setDefaultProperty(this.getType(), "posY", Float.class, Float.valueOf(0.0f));
        DropProperties.setDefaultProperty(this.getType(), "posZ", Float.class, Float.valueOf(0.0f));
        DropProperties.setDefaultProperty(this.getType(), "posOffsetX", Float.class, Float.valueOf(0.0f));
        DropProperties.setDefaultProperty(this.getType(), "posOffsetY", Float.class, Float.valueOf(0.0f));
        DropProperties.setDefaultProperty(this.getType(), "posOffsetZ", Float.class, Float.valueOf(0.0f));
    }

    @Override
    public String getType() {
        return "entity";
    }
}

