/*
 * Decompiled with CFR 0.152.
 */
package mod.lucky.drop.func;

import java.util.UUID;
import mod.lucky.command.LuckyCommandLogic;
import mod.lucky.drop.DropProperties;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.PlayerSelector;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.BlockPos;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class DropProcessData {
    private World world;
    private Entity player;
    private Entity hitEntity;
    private float bowPower = 1.0f;
    private UUID playerUUID;
    private UUID hitEntityUUID;
    private Vec3 harvestPos;
    private DropProperties dropProperties;
    private EnumProcessType processType;

    public DropProcessData(World world) {
        this.world = world;
    }

    public DropProcessData(World world, Entity player, Vec3 harvestPos) {
        this(world, player, harvestPos, null);
    }

    public DropProcessData(World world, Entity player, BlockPos harvestPos) {
        this(world, player, new Vec3((double)harvestPos.func_177958_n() + 0.5, (double)harvestPos.func_177956_o(), (double)harvestPos.func_177952_p() + 0.5), null);
    }

    public DropProcessData(World world, Entity player, Vec3 harvestPos, DropProperties dropProperties) {
        this(world, player, harvestPos, dropProperties, EnumProcessType.NORMAL);
    }

    public DropProcessData(World world, Entity player, Vec3 harvestPos, DropProperties dropProperties, EnumProcessType processType) {
        this(world, player, harvestPos, dropProperties, processType, null);
    }

    public DropProcessData(World world, Entity player, Vec3 harvestPos, DropProperties dropProperties, EnumProcessType processType, Entity hitEntity) {
        this.world = world;
        this.player = player;
        this.harvestPos = harvestPos;
        this.dropProperties = dropProperties;
        this.processType = processType;
        this.hitEntity = hitEntity;
    }

    public World getWorld() {
        return this.world;
    }

    public Entity getPlayer() {
        if (this.player == null) {
            try {
                this.player = MinecraftServer.func_71276_C().func_71203_ab().func_177451_a(this.playerUUID);
                if (this.player == null) {
                    this.player = MinecraftServer.func_71276_C().func_175576_a(this.playerUUID);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.player == null) {
            try {
                LuckyCommandLogic luckyCommandLogic = new LuckyCommandLogic();
                luckyCommandLogic.setWorld(this.world);
                luckyCommandLogic.setPosition(new BlockPos(this.harvestPos));
                this.player = PlayerSelector.func_82386_a((ICommandSender)luckyCommandLogic, (String)"@p");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.player;
    }

    public Entity getHitEntity() {
        if (this.hitEntity == null) {
            this.hitEntity = MinecraftServer.func_71276_C().func_71203_ab().func_177451_a(this.hitEntityUUID);
            if (this.hitEntity == null) {
                this.hitEntity = MinecraftServer.func_71276_C().func_175576_a(this.hitEntityUUID);
            }
        }
        return this.hitEntity;
    }

    public float getBowPower() {
        return this.bowPower;
    }

    public DropProcessData setHitEntity(Entity hitEntity) {
        this.hitEntity = hitEntity;
        return this;
    }

    public DropProcessData setBowPower(float bowPower) {
        this.bowPower = bowPower;
        return this;
    }

    public Vec3 getHarvestPos() {
        return this.harvestPos;
    }

    public BlockPos getHarvestBlockPos() {
        return new BlockPos(this.harvestPos.field_72450_a, this.harvestPos.field_72448_b, this.harvestPos.field_72449_c);
    }

    public DropProperties getDropProperties() {
        return this.dropProperties;
    }

    public EnumProcessType getProcessType() {
        return this.processType;
    }

    public void setProcessType(EnumProcessType processType) {
        this.processType = processType;
    }

    public void setDropProperties(DropProperties properties) {
        this.dropProperties = properties;
    }

    public void setPlayer(Entity player) {
        this.player = player;
    }

    public void setHarvestPos(Vec3 harvestPos) {
        this.harvestPos = harvestPos;
    }

    public void readFromNBT(NBTTagCompound tagCompound) {
        this.dropProperties = new DropProperties();
        this.dropProperties.readFromNBT(tagCompound.func_74775_l("drop"));
        this.harvestPos = new Vec3(tagCompound.func_74769_h("harvestPosX"), tagCompound.func_74769_h("harvestPosY"), tagCompound.func_74769_h("harvestPosZ"));
        this.bowPower = tagCompound.func_74760_g("bowPower");
        if (tagCompound.func_74764_b("playerUUID")) {
            this.playerUUID = UUID.fromString(tagCompound.func_74779_i("playerUUID"));
        }
        if (tagCompound.func_74764_b("hitEntityUUID")) {
            this.hitEntityUUID = UUID.fromString(tagCompound.func_74779_i("hitEntityUUID"));
        }
        this.world = MinecraftServer.func_71276_C().func_130014_f_();
    }

    public NBTTagCompound writeToNBT() {
        NBTTagCompound mainTag = new NBTTagCompound();
        mainTag.func_74782_a("drop", (NBTBase)this.dropProperties.writeToNBT());
        mainTag.func_74780_a("harvestPosX", this.harvestPos.field_72450_a);
        mainTag.func_74780_a("harvestPosY", this.harvestPos.field_72448_b);
        mainTag.func_74780_a("harvestPosZ", this.harvestPos.field_72449_c);
        mainTag.func_74776_a("bowPower", this.bowPower);
        if (this.player != null || this.playerUUID != null) {
            mainTag.func_74778_a("playerUUID", this.player == null ? this.playerUUID.toString() : this.player.func_110124_au().toString());
        }
        if (this.hitEntity != null || this.hitEntityUUID != null) {
            mainTag.func_74778_a("hitEntityUUID", this.hitEntity == null ? this.hitEntityUUID.toString() : this.hitEntity.func_110124_au().toString());
        }
        return mainTag;
    }

    public DropProcessData copy() {
        return new DropProcessData(this.world, this.player, this.harvestPos, this.dropProperties, this.processType, this.hitEntity).setBowPower(this.bowPower);
    }

    public static enum EnumProcessType {
        NORMAL,
        LUCKY_STRUCT;

    }
}

