/*
 * Decompiled with CFR 0.152.
 */
package mod.lucky.entity;

import java.util.List;
import mod.lucky.drop.DropContainer;
import mod.lucky.drop.func.DropProcessData;
import mod.lucky.drop.func.DropProcessor;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S2BPacketChangeGameState;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class EntityLuckyProjectile
extends EntityArrow {
    private int xTile = -1;
    private int yTile = -1;
    private int zTile = -1;
    private Block inTile;
    private int inData;
    private boolean inGround;
    private int ticksInGround;
    private int ticksInAir;
    private EntityItem item;
    private float trailFrequency = 1.0f;
    private boolean hasTrail = false;
    private boolean hasImpact = false;
    private DropProcessor dropProcessorTrail;
    private DropProcessor dropProcessorImpact;

    public EntityLuckyProjectile(World worldIn) {
        super(worldIn);
        this.field_70155_l = 10.0;
        this.func_70105_a(0.5f, 0.5f);
    }

    public EntityLuckyProjectile(World worldIn, double x, double y, double z) {
        super(worldIn, x, y, z);
        this.field_70155_l = 10.0;
        this.func_70105_a(0.5f, 0.5f);
        this.func_70107_b(x, y, z);
    }

    public EntityLuckyProjectile(World worldIn, EntityLivingBase shooter, EntityLivingBase p_i1755_3_, float p_i1755_4_, float p_i1755_5_) {
        super(worldIn, shooter, p_i1755_3_, p_i1755_4_, p_i1755_5_);
    }

    public EntityLuckyProjectile(World worldIn, EntityLivingBase shooter, float p_i1756_3_) {
        super(worldIn, shooter, p_i1756_3_);
        this.field_70155_l = 10.0;
        this.field_70250_c = shooter;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_75682_a(20, (Object)new ItemStack(Items.field_151055_y));
        this.dropProcessorTrail = new DropProcessor();
        this.dropProcessorImpact = new DropProcessor();
    }

    private void luckyImpact(MovingObjectPosition movingObjectPosition) {
        try {
            if (this.hasImpact) {
                if (movingObjectPosition.field_72308_g == null) {
                    this.dropProcessorImpact.processRandomDrop(new DropProcessData(this.func_130014_f_(), this.field_70250_c, movingObjectPosition.field_72307_f), 0);
                } else {
                    this.dropProcessorImpact.processRandomDrop(new DropProcessData(this.func_130014_f_(), this.field_70250_c, movingObjectPosition.field_72308_g.func_174791_d()).setHitEntity(movingObjectPosition.field_72308_g), 0);
                }
            }
        }
        catch (Exception e) {
            System.err.println("The Lucky Bow encountered and error while trying to perform an impact function. Error report below:");
            e.printStackTrace();
        }
    }

    public void func_70071_h_() {
        BlockPos blockpos;
        IBlockState iblockstate;
        Block block;
        try {
            if (this.item == null && this.func_130014_f_().field_72995_K) {
                this.item = new EntityItem(this.func_130014_f_(), this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70180_af.func_82710_f(20));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.func_70030_z();
        if (this.item != null) {
            this.item.func_70071_h_();
        }
        if (this.field_70127_C == 0.0f && this.field_70126_B == 0.0f) {
            float f = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
            this.field_70126_B = this.field_70177_z = (float)(Math.atan2(this.field_70159_w, this.field_70179_y) * 180.0 / Math.PI);
            this.field_70127_C = this.field_70125_A = (float)(Math.atan2(this.field_70181_x, f) * 180.0 / Math.PI);
        }
        if ((block = (iblockstate = this.field_70170_p.func_180495_p(blockpos = new BlockPos(this.xTile, this.yTile, this.zTile))).func_177230_c()).func_149688_o() != Material.field_151579_a) {
            block.func_180654_a((IBlockAccess)this.field_70170_p, blockpos);
            AxisAlignedBB axisalignedbb = block.func_180640_a(this.field_70170_p, blockpos, iblockstate);
            if (axisalignedbb != null && axisalignedbb.func_72318_a(new Vec3(this.field_70165_t, this.field_70163_u, this.field_70161_v))) {
                this.inGround = true;
            }
        }
        if (this.inGround) {
            this.func_70106_y();
        } else {
            float f1;
            int i;
            ++this.ticksInAir;
            Vec3 vec31 = new Vec3(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            Vec3 vec3 = new Vec3(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
            MovingObjectPosition movingobjectposition = this.field_70170_p.func_147447_a(vec31, vec3, false, true, false);
            vec31 = new Vec3(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            vec3 = new Vec3(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
            if (movingobjectposition != null) {
                vec3 = new Vec3(movingobjectposition.field_72307_f.field_72450_a, movingobjectposition.field_72307_f.field_72448_b, movingobjectposition.field_72307_f.field_72449_c);
            }
            Entity entity = null;
            List list = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_72321_a(this.field_70159_w, this.field_70181_x, this.field_70179_y).func_72314_b(1.0, 1.0, 1.0));
            double d0 = 0.0;
            for (i = 0; i < list.size(); ++i) {
                double d1;
                Entity entity1 = (Entity)list.get(i);
                if (!entity1.func_70067_L() || entity1 == this.field_70250_c && this.ticksInAir < 5) continue;
                f1 = 0.3f;
                AxisAlignedBB axisalignedbb1 = entity1.func_174813_aQ().func_72314_b((double)f1, (double)f1, (double)f1);
                MovingObjectPosition movingobjectposition1 = axisalignedbb1.func_72327_a(vec31, vec3);
                if (movingobjectposition1 == null || !((d1 = vec31.func_72438_d(movingobjectposition1.field_72307_f)) < d0) && d0 != 0.0) continue;
                entity = entity1;
                d0 = d1;
            }
            if (entity != null) {
                movingobjectposition = new MovingObjectPosition(entity);
            }
            if (movingobjectposition != null && movingobjectposition.field_72308_g != null && movingobjectposition.field_72308_g instanceof EntityPlayer) {
                EntityPlayer entityplayer = (EntityPlayer)movingobjectposition.field_72308_g;
                if (this.field_70250_c instanceof EntityPlayer && !((EntityPlayer)this.field_70250_c).func_96122_a(entityplayer)) {
                    movingobjectposition = null;
                }
            }
            if (movingobjectposition != null && !this.func_130014_f_().field_72995_K) {
                if (movingobjectposition.field_72308_g != null) {
                    float f2 = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70181_x * this.field_70181_x + this.field_70179_y * this.field_70179_y));
                    int k = MathHelper.func_76143_f((double)((double)f2 * this.func_70242_d()));
                    if (this.func_70241_g()) {
                        k += this.field_70146_Z.nextInt(k / 2 + 2);
                    }
                    this.luckyImpact(movingobjectposition);
                    if (this.func_70027_ad()) {
                        movingobjectposition.field_72308_g.func_70015_d(5);
                    }
                    DamageSource damagesource = null;
                    if (this.func_70242_d() != 0.0) {
                        damagesource = this.field_70250_c == null ? DamageSource.func_76353_a((EntityArrow)this, (Entity)this) : DamageSource.func_76353_a((EntityArrow)this, (Entity)this.field_70250_c);
                    }
                    if (this.func_70242_d() != 0.0) {
                        movingobjectposition.field_72308_g.func_70097_a(damagesource, (float)this.func_70242_d());
                        if (movingobjectposition.field_72308_g instanceof EntityLivingBase) {
                            EntityLivingBase entitylivingbase = (EntityLivingBase)movingobjectposition.field_72308_g;
                            if (this.field_70250_c instanceof EntityLivingBase) {
                                EnchantmentHelper.func_151384_a((EntityLivingBase)entitylivingbase, (Entity)this.field_70250_c);
                                EnchantmentHelper.func_151385_b((EntityLivingBase)((EntityLivingBase)this.field_70250_c), (Entity)entitylivingbase);
                            }
                            if (this.field_70250_c != null && movingobjectposition.field_72308_g != this.field_70250_c && movingobjectposition.field_72308_g instanceof EntityPlayer && this.field_70250_c instanceof EntityPlayerMP) {
                                ((EntityPlayerMP)this.field_70250_c).field_71135_a.func_147359_a((Packet)new S2BPacketChangeGameState(6, 0.0f));
                            }
                        }
                    } else {
                        this.field_70159_w *= (double)-0.1f;
                        this.field_70181_x *= (double)-0.1f;
                        this.field_70179_y *= (double)-0.1f;
                        this.field_70177_z += 180.0f;
                        this.field_70126_B += 180.0f;
                        this.ticksInAir = 0;
                    }
                    this.func_70106_y();
                } else {
                    BlockPos blockpos1 = movingobjectposition.func_178782_a();
                    this.xTile = blockpos1.func_177958_n();
                    this.yTile = blockpos1.func_177956_o();
                    this.zTile = blockpos1.func_177952_p();
                    iblockstate = this.field_70170_p.func_180495_p(blockpos1);
                    this.inTile = iblockstate.func_177230_c();
                    this.inData = this.inTile.func_176201_c(iblockstate);
                    this.field_70159_w = (float)(movingobjectposition.field_72307_f.field_72450_a - this.field_70165_t);
                    this.field_70181_x = (float)(movingobjectposition.field_72307_f.field_72448_b - this.field_70163_u);
                    this.field_70179_y = (float)(movingobjectposition.field_72307_f.field_72449_c - this.field_70161_v);
                    float f3 = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70181_x * this.field_70181_x + this.field_70179_y * this.field_70179_y));
                    this.field_70165_t -= this.field_70159_w / (double)f3 * (double)0.05f;
                    this.field_70163_u -= this.field_70181_x / (double)f3 * (double)0.05f;
                    this.field_70161_v -= this.field_70179_y / (double)f3 * (double)0.05f;
                    this.inGround = true;
                    this.func_70243_d(false);
                    if (this.inTile.func_149688_o() != Material.field_151579_a) {
                        this.luckyImpact(movingobjectposition);
                        this.inTile.func_180634_a(this.field_70170_p, blockpos1, iblockstate, (Entity)this);
                        this.func_70106_y();
                    }
                }
            }
            if (!this.func_130014_f_().field_72995_K && this.hasTrail && this.ticksInAir >= 2) {
                try {
                    if ((double)this.trailFrequency < 1.0 && this.trailFrequency > 0.0f) {
                        int amount = (int)(1.0 / (double)this.trailFrequency);
                        for (i = 0; i < amount; ++i) {
                            this.dropProcessorTrail.processRandomDrop(new DropProcessData(this.func_130014_f_(), this.field_70250_c, new Vec3(this.field_70165_t + this.field_70159_w * (double)i / (double)amount, this.field_70163_u + this.field_70181_x * (double)i / (double)amount, this.field_70161_v + this.field_70179_y * (double)i / (double)amount)), 0, false);
                        }
                    } else if ((this.ticksInAir - 2) % (int)this.trailFrequency == 0) {
                        this.dropProcessorTrail.processRandomDrop(new DropProcessData(this.func_130014_f_(), this.field_70250_c, this.func_174791_d()), 0, false);
                    }
                }
                catch (Exception e) {
                    System.err.println("The Lucky Bow encountered and error while trying to perform a trail function. Error report below:");
                    e.printStackTrace();
                }
            }
            this.field_70165_t += this.field_70159_w;
            this.field_70163_u += this.field_70181_x;
            this.field_70161_v += this.field_70179_y;
            float f2 = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
            this.field_70177_z = (float)(Math.atan2(this.field_70159_w, this.field_70179_y) * 180.0 / Math.PI);
            this.field_70125_A = (float)(Math.atan2(this.field_70181_x, f2) * 180.0 / Math.PI);
            while (this.field_70125_A - this.field_70127_C < -180.0f) {
                this.field_70127_C -= 360.0f;
            }
            while (this.field_70125_A - this.field_70127_C >= 180.0f) {
                this.field_70127_C += 360.0f;
            }
            while (this.field_70177_z - this.field_70126_B < -180.0f) {
                this.field_70126_B -= 360.0f;
            }
            while (this.field_70177_z - this.field_70126_B >= 180.0f) {
                this.field_70126_B += 360.0f;
            }
            this.field_70125_A = this.field_70127_C + (this.field_70125_A - this.field_70127_C) * 0.2f;
            this.field_70177_z = this.field_70126_B + (this.field_70177_z - this.field_70126_B) * 0.2f;
            float f3 = 0.99f;
            f1 = 0.05f;
            if (this.func_70090_H()) {
                for (int l = 0; l < 4; ++l) {
                    float f4 = 0.25f;
                    this.field_70170_p.func_175688_a(EnumParticleTypes.WATER_BUBBLE, this.field_70165_t - this.field_70159_w * (double)f4, this.field_70163_u - this.field_70181_x * (double)f4, this.field_70161_v - this.field_70179_y * (double)f4, this.field_70159_w, this.field_70181_x, this.field_70179_y, new int[0]);
                }
                f3 = 0.6f;
            }
            if (this.func_70026_G()) {
                this.func_70066_B();
            }
            this.field_70159_w *= (double)f3;
            this.field_70181_x *= (double)f3;
            this.field_70179_y *= (double)f3;
            this.field_70181_x -= (double)f1;
            this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            this.func_145775_I();
        }
    }

    public void func_70014_b(NBTTagCompound tagCompound) {
        tagCompound.func_74777_a("xTile", (short)this.xTile);
        tagCompound.func_74777_a("yTile", (short)this.yTile);
        tagCompound.func_74777_a("zTile", (short)this.zTile);
        tagCompound.func_74777_a("life", (short)this.ticksInGround);
        ResourceLocation resourcelocation = (ResourceLocation)Block.field_149771_c.func_177774_c((Object)this.inTile);
        tagCompound.func_74778_a("inTile", resourcelocation == null ? "" : resourcelocation.toString());
        tagCompound.func_74774_a("inData", (byte)this.inData);
        tagCompound.func_74774_a("shake", (byte)this.field_70249_b);
        tagCompound.func_74774_a("inGround", (byte)(this.inGround ? 1 : 0));
        tagCompound.func_74774_a("pickup", (byte)this.field_70251_a);
        tagCompound.func_74780_a("damage", this.func_70242_d());
        if (this.item != null) {
            tagCompound.func_74782_a("item", (NBTBase)this.item.func_92059_d().func_77955_b(new NBTTagCompound()));
        }
        if (this.hasTrail) {
            NBTTagCompound trailTag = new NBTTagCompound();
            trailTag.func_74776_a("frequency", this.trailFrequency);
            NBTTagList drops = new NBTTagList();
            for (int i = 0; i < this.dropProcessorTrail.getDrops().size(); ++i) {
                drops.func_74742_a((NBTBase)new NBTTagString(this.dropProcessorTrail.getDrops().get(i).toString()));
            }
            trailTag.func_74782_a("drops", (NBTBase)drops);
            tagCompound.func_74782_a("trail", (NBTBase)trailTag);
        }
        if (this.hasImpact) {
            NBTTagList drops = new NBTTagList();
            for (int i = 0; i < this.dropProcessorImpact.getDrops().size(); ++i) {
                drops.func_74742_a((NBTBase)new NBTTagString(this.dropProcessorImpact.getDrops().get(i).toString()));
            }
            tagCompound.func_74782_a("impact", (NBTBase)drops);
        }
    }

    public void func_70037_a(NBTTagCompound tagCompound) {
        this.xTile = tagCompound.func_74765_d("xTile");
        this.yTile = tagCompound.func_74765_d("yTile");
        this.zTile = tagCompound.func_74765_d("zTile");
        this.ticksInGround = tagCompound.func_74765_d("life");
        this.inTile = tagCompound.func_150297_b("inTile", 8) ? Block.func_149684_b((String)tagCompound.func_74779_i("inTile")) : Block.func_149729_e((int)(tagCompound.func_74771_c("inTile") & 0xFF));
        this.inData = tagCompound.func_74771_c("inData") & 0xFF;
        this.field_70249_b = tagCompound.func_74771_c("shake") & 0xFF;
        boolean bl = this.inGround = tagCompound.func_74771_c("inGround") == 1;
        if (tagCompound.func_150297_b("damage", 99)) {
            this.func_70239_b(tagCompound.func_74769_h("damage"));
        }
        if (tagCompound.func_150297_b("pickup", 99)) {
            this.field_70251_a = tagCompound.func_74771_c("pickup");
        } else if (tagCompound.func_150297_b("player", 99)) {
            int n = this.field_70251_a = tagCompound.func_74767_n("player") ? 1 : 0;
        }
        if (tagCompound.func_74764_b("item")) {
            tagCompound.func_74782_a("Count", (NBTBase)new NBTTagInt(1));
            this.item = new EntityItem(this.func_130014_f_(), this.field_70165_t, this.field_70163_u, this.field_70161_v, ItemStack.func_77949_a((NBTTagCompound)tagCompound.func_74775_l("item")));
        } else {
            this.item = new EntityItem(this.func_130014_f_(), this.field_70165_t, this.field_70163_u, this.field_70161_v, new ItemStack(Items.field_151055_y));
        }
        this.field_70180_af.func_75692_b(20, (Object)this.item.func_92059_d());
        if (tagCompound.func_74764_b("trail")) {
            NBTTagCompound trailTag = tagCompound.func_74775_l("trail");
            if (trailTag.func_74764_b("frequency")) {
                this.trailFrequency = trailTag.func_74760_g("frequency");
            }
            if (trailTag.func_74764_b("drops")) {
                NBTTagList drops = trailTag.func_150295_c("drops", (int)new NBTTagString().func_74732_a());
                for (int i = 0; i < drops.func_74745_c(); ++i) {
                    DropContainer drop = new DropContainer();
                    drop.readFromString(drops.func_150307_f(i));
                    this.dropProcessorTrail.registerDrop(drop);
                }
            }
            this.hasTrail = true;
        }
        if (tagCompound.func_74764_b("impact")) {
            NBTTagList drops = tagCompound.func_150295_c("impact", (int)new NBTTagString().func_74732_a());
            for (int i = 0; i < drops.func_74745_c(); ++i) {
                DropContainer drop = new DropContainer();
                drop.readFromString(drops.func_150307_f(i));
                this.dropProcessorImpact.registerDrop(drop);
            }
            this.hasImpact = true;
        }
    }

    public void func_70100_b_(EntityPlayer entityIn) {
    }

    public EntityItem getItem() {
        return this.item;
    }

    public static enum EnumRenderType {
        ITEM,
        BLOCK,
        PARTICLE;

    }
}

