/*
 * Decompiled with CFR 0.152.
 */
package mod.lucky.structure.rotation;

import mod.lucky.structure.rotation.ArrayStateRotationHandler;
import mod.lucky.structure.rotation.MultipleStateRotationHandler;
import mod.lucky.structure.rotation.StateRotationHandler;
import mod.lucky.structure.rotation.TileEntityRotationHandler;
import net.minecraft.block.Block;
import net.minecraft.block.BlockAnvil;
import net.minecraft.block.BlockBanner;
import net.minecraft.block.BlockBed;
import net.minecraft.block.BlockButton;
import net.minecraft.block.BlockChest;
import net.minecraft.block.BlockCocoa;
import net.minecraft.block.BlockDispenser;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.BlockDropper;
import net.minecraft.block.BlockEndPortalFrame;
import net.minecraft.block.BlockEnderChest;
import net.minecraft.block.BlockFenceGate;
import net.minecraft.block.BlockFurnace;
import net.minecraft.block.BlockHopper;
import net.minecraft.block.BlockHugeMushroom;
import net.minecraft.block.BlockLadder;
import net.minecraft.block.BlockLever;
import net.minecraft.block.BlockLog;
import net.minecraft.block.BlockPistonBase;
import net.minecraft.block.BlockPistonExtension;
import net.minecraft.block.BlockPistonMoving;
import net.minecraft.block.BlockPumpkin;
import net.minecraft.block.BlockRail;
import net.minecraft.block.BlockRailBase;
import net.minecraft.block.BlockRedstoneComparator;
import net.minecraft.block.BlockRedstoneRepeater;
import net.minecraft.block.BlockRedstoneTorch;
import net.minecraft.block.BlockSkull;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.BlockStandingSign;
import net.minecraft.block.BlockTorch;
import net.minecraft.block.BlockTrapDoor;
import net.minecraft.block.BlockTripWireHook;
import net.minecraft.block.BlockVine;
import net.minecraft.block.BlockWallSign;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntitySkull;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Vec3;

public final class Rotations {
    private static StateRotationHandler[] stateRotationHandlers = new StateRotationHandler[30000];
    private static TileEntityRotationHandler[] tileEntityRotationHandlers = new TileEntityRotationHandler[30000];

    public static Vec3 rotatePos(Vec3 pos, Vec3 centerPos, int rotation) {
        if ((rotation %= 4) < 0) {
            rotation += 4;
        }
        double posX = pos.field_72450_a - centerPos.field_72450_a;
        double posY = pos.field_72448_b - centerPos.field_72448_b;
        double posZ = centerPos.field_72449_c - pos.field_72449_c;
        for (int i = 0; i < rotation; ++i) {
            double z;
            double x = posX;
            posX = z = posZ;
            posZ = -x;
        }
        return new Vec3(posX + centerPos.field_72450_a, posY + centerPos.field_72448_b, centerPos.field_72449_c - posZ);
    }

    public static BlockPos rotatePos(BlockPos blockPos, BlockPos centerPos, int rotation) {
        Vec3 vec3 = Rotations.rotatePos(new Vec3((double)blockPos.func_177958_n(), (double)blockPos.func_177956_o(), (double)blockPos.func_177952_p()), new Vec3((double)centerPos.func_177958_n(), (double)centerPos.func_177956_o(), (double)centerPos.func_177952_p()), rotation);
        return new BlockPos(vec3.field_72450_a, vec3.field_72448_b, vec3.field_72449_c);
    }

    public static BlockPos rotatePos(BlockPos blockPos, Vec3 centerPos, int rotation) {
        Vec3 vec3 = Rotations.rotatePos(new Vec3((double)blockPos.func_177958_n(), (double)blockPos.func_177956_o(), (double)blockPos.func_177952_p()), centerPos, rotation);
        return new BlockPos(vec3.field_72450_a, vec3.field_72448_b, vec3.field_72449_c);
    }

    public static IBlockState rotateState(IBlockState state, int rotation) {
        StateRotationHandler stateRotationHandler;
        if ((rotation %= 4) < 0) {
            rotation += 4;
        }
        if ((stateRotationHandler = stateRotationHandlers[Block.func_149682_b((Block)state.func_177230_c())]) != null) {
            return stateRotationHandler.rotate(state, rotation);
        }
        return state;
    }

    public static NBTTagCompound rotateEntity(NBTTagCompound entityTag, Vec3 centerPos, int rotation) {
        if ((rotation %= 4) < 0) {
            rotation += 4;
        }
        if (entityTag.func_74764_b("Pos")) {
            NBTTagList posList = entityTag.func_150295_c("Pos", 6);
            Vec3 entityPos = new Vec3(posList.func_150309_d(0), posList.func_150309_d(1), posList.func_150309_d(2));
            entityPos = Rotations.rotatePos(entityPos, centerPos, rotation);
            posList = new NBTTagList();
            posList.func_74742_a((NBTBase)new NBTTagDouble(entityPos.field_72450_a));
            posList.func_74742_a((NBTBase)new NBTTagDouble(entityPos.field_72448_b));
            posList.func_74742_a((NBTBase)new NBTTagDouble(entityPos.field_72449_c));
            entityTag.func_74782_a("Pos", (NBTBase)posList);
        }
        if (entityTag.func_74764_b("Motion")) {
            NBTTagList motionList = entityTag.func_150295_c("Motion", 6);
            Vec3 entityMotion = new Vec3(motionList.func_150309_d(0), motionList.func_150309_d(1), motionList.func_150309_d(2));
            entityMotion = Rotations.rotatePos(entityMotion, new Vec3(0.0, 0.0, 0.0), rotation);
            motionList = new NBTTagList();
            motionList.func_74742_a((NBTBase)new NBTTagDouble(entityMotion.field_72450_a));
            motionList.func_74742_a((NBTBase)new NBTTagDouble(entityMotion.field_72448_b));
            motionList.func_74742_a((NBTBase)new NBTTagDouble(entityMotion.field_72449_c));
            entityTag.func_74782_a("Motion", (NBTBase)motionList);
        }
        if (entityTag.func_74764_b("Rotation")) {
            NBTTagList rotationList = entityTag.func_150295_c("Rotation", 5);
            float rotYaw = rotationList.func_150308_e(0);
            float rotPitch = rotationList.func_150308_e(1);
            rotYaw = (rotYaw + (float)rotation * 90.0f) % 360.0f;
            rotationList = new NBTTagList();
            rotationList.func_74742_a((NBTBase)new NBTTagFloat(rotYaw));
            rotationList.func_74742_a((NBTBase)new NBTTagFloat(rotPitch));
            entityTag.func_74782_a("Rotation", (NBTBase)rotationList);
        }
        return entityTag;
    }

    public static Entity rotateEntity(Entity entity, int rotation) {
        if ((rotation %= 4) < 0) {
            rotation += 4;
        }
        Vec3 motion = Rotations.rotatePos(new Vec3(entity.field_70159_w, entity.field_70181_x, entity.field_70179_y), new Vec3(0.0, 0.0, 0.0), rotation);
        entity.field_70159_w = motion.field_72450_a;
        entity.field_70181_x = motion.field_72448_b;
        entity.field_70179_y = motion.field_72449_c;
        entity.field_70177_z = (entity.field_70177_z + (float)rotation * 90.0f) % 360.0f;
        return entity;
    }

    public static TileEntity rotateTileEntity(TileEntity tileEntity, int rotation) {
        TileEntityRotationHandler tileEntityRotationHandler;
        if ((rotation %= 4) < 0) {
            rotation += 4;
        }
        if ((tileEntityRotationHandler = tileEntityRotationHandlers[Block.func_149682_b((Block)tileEntity.func_145838_q())]) != null) {
            tileEntityRotationHandler.rotate(tileEntity, rotation);
        }
        return tileEntity;
    }

    public static void registerRotationHandlers() {
        EnumFacing[] enumFacing = new EnumFacing[]{EnumFacing.NORTH, EnumFacing.EAST, EnumFacing.SOUTH, EnumFacing.WEST};
        Comparable[] intFacing = new Integer[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15};
        Rotations.stateRotationHandlers[Block.func_149682_b((Block)Blocks.field_150364_r)] = new ArrayStateRotationHandler((IProperty)BlockLog.field_176299_a, new Comparable[]{BlockLog.EnumAxis.Z, BlockLog.EnumAxis.X});
        Rotations.stateRotationHandlers[Block.func_149682_b((Block)Blocks.field_150478_aa)] = new ArrayStateRotationHandler((IProperty)BlockTorch.field_176596_a, (Comparable[])enumFacing);
        Rotations.stateRotationHandlers[Block.func_149682_b((Block)Blocks.field_150437_az)] = new ArrayStateRotationHandler((IProperty)BlockRedstoneTorch.field_176596_a, (Comparable[])enumFacing);
        Rotations.stateRotationHandlers[Block.func_149682_b((Block)Blocks.field_150429_aA)] = new ArrayStateRotationHandler((IProperty)BlockRedstoneTorch.field_176596_a, (Comparable[])enumFacing);
        Rotations.stateRotationHandlers[Block.func_149682_b((Block)Blocks.field_150324_C)] = new ArrayStateRotationHandler((IProperty)BlockBed.field_176387_N, (Comparable[])enumFacing);
        Rotations.stateRotationHandlers[Block.func_149682_b((Block)Blocks.field_150331_J)] = new ArrayStateRotationHandler((IProperty)BlockPistonBase.field_176321_a, (Comparable[])enumFacing);
        Rotations.stateRotationHandlers[Block.func_149682_b((Block)Blocks.field_150320_F)] = new ArrayStateRotationHandler((IProperty)BlockPistonBase.field_176321_a, (Comparable[])enumFacing);
        Rotations.stateRotationHandlers[Block.func_149682_b((Block)Blocks.field_150332_K)] = new ArrayStateRotationHandler((IProperty)BlockPistonExtension.field_176326_a, (Comparable[])enumFacing);
        Rotations.stateRotationHandlers[Block.func_149682_b((Block)Blocks.field_180384_M)] = new ArrayStateRotationHandler((IProperty)BlockPistonMoving.field_176426_a, (Comparable[])enumFacing);
        Rotations.stateRotationHandlers[Block.func_149682_b((Block)Blocks.field_150476_ad)] = new ArrayStateRotationHandler((IProperty)BlockStairs.field_176309_a, (Comparable[])enumFacing);
        Rotations.stateRotationHandlers[Block.func_149682_b((Block)Blocks.field_150446_ar)] = new ArrayStateRotationHandler((IProperty)BlockStairs.field_176309_a, (Comparable[])enumFacing);
        Rotations.stateRotationHandlers[Block.func_149682_b((Block)Blocks.field_150389_bf)] = new ArrayStateRotationHandler((IProperty)BlockStairs.field_176309_a, (Comparable[])enumFacing);
        Rotations.stateRotationHandlers[Block.func_149682_b((Block)Blocks.field_150390_bg)] = new ArrayStateRotationHandler((IProperty)BlockStairs.field_176309_a, (Comparable[])enumFacing);
        Rotations.stateRotationHandlers[Block.func_149682_b((Block)Blocks.field_150387_bl)] = new ArrayStateRotationHandler((IProperty)BlockStairs.field_176309_a, (Comparable[])enumFacing);
        Rotations.stateRotationHandlers[Block.func_149682_b((Block)Blocks.field_150372_bz)] = new ArrayStateRotationHandler((IProperty)BlockStairs.field_176309_a, (Comparable[])enumFacing);
        Rotations.stateRotationHandlers[Block.func_149682_b((Block)Blocks.field_150485_bF)] = new ArrayStateRotationHandler((IProperty)BlockStairs.field_176309_a, (Comparable[])enumFacing);
        Rotations.stateRotationHandlers[Block.func_149682_b((Block)Blocks.field_150487_bG)] = new ArrayStateRotationHandler((IProperty)BlockStairs.field_176309_a, (Comparable[])enumFacing);
        Rotations.stateRotationHandlers[Block.func_149682_b((Block)Blocks.field_150481_bH)] = new ArrayStateRotationHandler((IProperty)BlockStairs.field_176309_a, (Comparable[])enumFacing);
        Rotations.stateRotationHandlers[Block.func_149682_b((Block)Blocks.field_150370_cb)] = new ArrayStateRotationHandler((IProperty)BlockStairs.field_176309_a, (Comparable[])enumFacing);
        Rotations.stateRotationHandlers[Block.func_149682_b((Block)Blocks.field_150400_ck)] = new ArrayStateRotationHandler((IProperty)BlockStairs.field_176309_a, (Comparable[])enumFacing);
        Rotations.stateRotationHandlers[Block.func_149682_b((Block)Blocks.field_150401_cl)] = new ArrayStateRotationHandler((IProperty)BlockStairs.field_176309_a, (Comparable[])enumFacing);
        Rotations.stateRotationHandlers[Block.func_149682_b((Block)Blocks.field_180396_cN)] = new ArrayStateRotationHandler((IProperty)BlockStairs.field_176309_a, (Comparable[])enumFacing);
        Rotations.stateRotationHandlers[Block.func_149682_b((Block)Blocks.field_180393_cK)] = new ArrayStateRotationHandler((IProperty)BlockBanner.field_176448_b, intFacing);
        Rotations.stateRotationHandlers[Block.func_149682_b((Block)Blocks.field_180394_cL)] = new ArrayStateRotationHandler((IProperty)BlockStairs.field_176309_a, (Comparable[])enumFacing);
        Rotations.stateRotationHandlers[Block.func_149682_b((Block)Blocks.field_180413_ao)] = new ArrayStateRotationHandler((IProperty)BlockDoor.field_176520_a, (Comparable[])enumFacing);
        Rotations.stateRotationHandlers[Block.func_149682_b((Block)Blocks.field_150454_av)] = new ArrayStateRotationHandler((IProperty)BlockDoor.field_176520_a, (Comparable[])enumFacing);
        Rotations.stateRotationHandlers[Block.func_149682_b((Block)Blocks.field_180414_ap)] = new ArrayStateRotationHandler((IProperty)BlockDoor.field_176520_a, (Comparable[])enumFacing);
        Rotations.stateRotationHandlers[Block.func_149682_b((Block)Blocks.field_180412_aq)] = new ArrayStateRotationHandler((IProperty)BlockDoor.field_176520_a, (Comparable[])enumFacing);
        Rotations.stateRotationHandlers[Block.func_149682_b((Block)Blocks.field_180411_ar)] = new ArrayStateRotationHandler((IProperty)BlockDoor.field_176520_a, (Comparable[])enumFacing);
        Rotations.stateRotationHandlers[Block.func_149682_b((Block)Blocks.field_180410_as)] = new ArrayStateRotationHandler((IProperty)BlockDoor.field_176520_a, (Comparable[])enumFacing);
        Rotations.stateRotationHandlers[Block.func_149682_b((Block)Blocks.field_180409_at)] = new ArrayStateRotationHandler((IProperty)BlockDoor.field_176520_a, (Comparable[])enumFacing);
        ArrayStateRotationHandler railHandler1 = new ArrayStateRotationHandler((IProperty)BlockRail.field_176565_b, new Comparable[]{BlockRailBase.EnumRailDirection.NORTH_SOUTH, BlockRailBase.EnumRailDirection.EAST_WEST});
        ArrayStateRotationHandler railHandler2 = new ArrayStateRotationHandler((IProperty)BlockRail.field_176565_b, new Comparable[]{BlockRailBase.EnumRailDirection.ASCENDING_NORTH, BlockRailBase.EnumRailDirection.ASCENDING_EAST, BlockRailBase.EnumRailDirection.ASCENDING_SOUTH, BlockRailBase.EnumRailDirection.ASCENDING_WEST});
        ArrayStateRotationHandler railHandler3 = new ArrayStateRotationHandler((IProperty)BlockRail.field_176565_b, new Comparable[]{BlockRailBase.EnumRailDirection.NORTH_EAST, BlockRailBase.EnumRailDirection.SOUTH_EAST, BlockRailBase.EnumRailDirection.SOUTH_WEST, BlockRailBase.EnumRailDirection.NORTH_WEST});
        Rotations.stateRotationHandlers[Block.func_149682_b((Block)Blocks.field_150318_D)] = new MultipleStateRotationHandler(railHandler1, railHandler2, railHandler3);
        Rotations.stateRotationHandlers[Block.func_149682_b((Block)Blocks.field_150319_E)] = new MultipleStateRotationHandler(railHandler1, railHandler2, railHandler3);
        Rotations.stateRotationHandlers[Block.func_149682_b((Block)Blocks.field_150448_aq)] = new MultipleStateRotationHandler(railHandler1, railHandler2, railHandler3);
        Rotations.stateRotationHandlers[Block.func_149682_b((Block)Blocks.field_150408_cc)] = new MultipleStateRotationHandler(railHandler1, railHandler2, railHandler3);
        Rotations.stateRotationHandlers[Block.func_149682_b((Block)Blocks.field_150468_ap)] = new ArrayStateRotationHandler((IProperty)BlockLadder.field_176382_a, (Comparable[])enumFacing);
        Rotations.stateRotationHandlers[Block.func_149682_b((Block)Blocks.field_150460_al)] = new ArrayStateRotationHandler((IProperty)BlockFurnace.field_176447_a, (Comparable[])enumFacing);
        Rotations.stateRotationHandlers[Block.func_149682_b((Block)Blocks.field_150470_am)] = new ArrayStateRotationHandler((IProperty)BlockFurnace.field_176447_a, (Comparable[])enumFacing);
        Rotations.stateRotationHandlers[Block.func_149682_b((Block)Blocks.field_150486_ae)] = new ArrayStateRotationHandler((IProperty)BlockChest.field_176459_a, (Comparable[])enumFacing);
        Rotations.stateRotationHandlers[Block.func_149682_b((Block)Blocks.field_150477_bB)] = new ArrayStateRotationHandler((IProperty)BlockEnderChest.field_176437_a, (Comparable[])enumFacing);
        Rotations.stateRotationHandlers[Block.func_149682_b((Block)Blocks.field_150447_bR)] = new ArrayStateRotationHandler((IProperty)BlockChest.field_176459_a, (Comparable[])enumFacing);
        Rotations.stateRotationHandlers[Block.func_149682_b((Block)Blocks.field_150472_an)] = new ArrayStateRotationHandler((IProperty)BlockStandingSign.field_176413_a, intFacing);
        Rotations.stateRotationHandlers[Block.func_149682_b((Block)Blocks.field_150444_as)] = new ArrayStateRotationHandler((IProperty)BlockWallSign.field_176412_a, (Comparable[])enumFacing);
        Rotations.stateRotationHandlers[Block.func_149682_b((Block)Blocks.field_150367_z)] = new ArrayStateRotationHandler((IProperty)BlockDispenser.field_176441_a, (Comparable[])enumFacing);
        Rotations.stateRotationHandlers[Block.func_149682_b((Block)Blocks.field_150409_cd)] = new ArrayStateRotationHandler((IProperty)BlockDropper.field_176441_a, (Comparable[])enumFacing);
        Rotations.stateRotationHandlers[Block.func_149682_b((Block)Blocks.field_150438_bZ)] = new ArrayStateRotationHandler((IProperty)BlockHopper.field_176430_a, (Comparable[])enumFacing);
        ArrayStateRotationHandler leverHandler1 = new ArrayStateRotationHandler((IProperty)BlockLever.field_176360_a, new Comparable[]{BlockLever.EnumOrientation.DOWN_Z, BlockLever.EnumOrientation.DOWN_X});
        ArrayStateRotationHandler leverHandler2 = new ArrayStateRotationHandler((IProperty)BlockLever.field_176360_a, new Comparable[]{BlockLever.EnumOrientation.NORTH, BlockLever.EnumOrientation.EAST, BlockLever.EnumOrientation.SOUTH, BlockLever.EnumOrientation.WEST});
        ArrayStateRotationHandler leverHandler3 = new ArrayStateRotationHandler((IProperty)BlockLever.field_176360_a, new Comparable[]{BlockLever.EnumOrientation.UP_Z, BlockLever.EnumOrientation.UP_X});
        Rotations.stateRotationHandlers[Block.func_149682_b((Block)Blocks.field_150442_at)] = new MultipleStateRotationHandler(leverHandler1, leverHandler2, leverHandler3);
        Rotations.stateRotationHandlers[Block.func_149682_b((Block)Blocks.field_150430_aB)] = new ArrayStateRotationHandler((IProperty)BlockButton.field_176585_a, (Comparable[])enumFacing);
        Rotations.stateRotationHandlers[Block.func_149682_b((Block)Blocks.field_150471_bO)] = new ArrayStateRotationHandler((IProperty)BlockButton.field_176585_a, (Comparable[])enumFacing);
        Rotations.stateRotationHandlers[Block.func_149682_b((Block)Blocks.field_150423_aK)] = new ArrayStateRotationHandler((IProperty)BlockPumpkin.field_176387_N, (Comparable[])enumFacing);
        Rotations.stateRotationHandlers[Block.func_149682_b((Block)Blocks.field_150428_aP)] = new ArrayStateRotationHandler((IProperty)BlockPumpkin.field_176387_N, (Comparable[])enumFacing);
        Rotations.stateRotationHandlers[Block.func_149682_b((Block)Blocks.field_150413_aR)] = new ArrayStateRotationHandler((IProperty)BlockRedstoneRepeater.field_176387_N, (Comparable[])enumFacing);
        Rotations.stateRotationHandlers[Block.func_149682_b((Block)Blocks.field_150416_aS)] = new ArrayStateRotationHandler((IProperty)BlockRedstoneRepeater.field_176387_N, (Comparable[])enumFacing);
        Rotations.stateRotationHandlers[Block.func_149682_b((Block)Blocks.field_150441_bU)] = new ArrayStateRotationHandler((IProperty)BlockRedstoneComparator.field_176387_N, (Comparable[])enumFacing);
        Rotations.stateRotationHandlers[Block.func_149682_b((Block)Blocks.field_150455_bV)] = new ArrayStateRotationHandler((IProperty)BlockRedstoneComparator.field_176387_N, (Comparable[])enumFacing);
        Rotations.stateRotationHandlers[Block.func_149682_b((Block)Blocks.field_150415_aT)] = new ArrayStateRotationHandler((IProperty)BlockTrapDoor.field_176284_a, (Comparable[])enumFacing);
        Rotations.stateRotationHandlers[Block.func_149682_b((Block)Blocks.field_180400_cw)] = new ArrayStateRotationHandler((IProperty)BlockTrapDoor.field_176284_a, (Comparable[])enumFacing);
        ArrayStateRotationHandler mushroomHandler1 = new ArrayStateRotationHandler((IProperty)BlockHugeMushroom.field_176380_a, new Comparable[]{BlockHugeMushroom.EnumType.NORTH, BlockHugeMushroom.EnumType.EAST, BlockHugeMushroom.EnumType.SOUTH, BlockHugeMushroom.EnumType.WEST});
        ArrayStateRotationHandler mushroomHandler2 = new ArrayStateRotationHandler((IProperty)BlockHugeMushroom.field_176380_a, new Comparable[]{BlockHugeMushroom.EnumType.NORTH_EAST, BlockHugeMushroom.EnumType.SOUTH_EAST, BlockHugeMushroom.EnumType.SOUTH_WEST, BlockHugeMushroom.EnumType.NORTH_WEST});
        Rotations.stateRotationHandlers[Block.func_149682_b((Block)Blocks.field_150419_aX)] = new MultipleStateRotationHandler(mushroomHandler1, mushroomHandler2);
        Rotations.stateRotationHandlers[Block.func_149682_b((Block)Blocks.field_150420_aW)] = new MultipleStateRotationHandler(mushroomHandler1, mushroomHandler2);
        Rotations.stateRotationHandlers[Block.func_149682_b((Block)Blocks.field_150395_bd)] = new StateRotationHandler(){

            @Override
            public IBlockState rotate(IBlockState state, int rotation) {
                Boolean oldNorth = (Boolean)state.func_177229_b((IProperty)BlockVine.field_176273_b);
                Boolean oldEast = (Boolean)state.func_177229_b((IProperty)BlockVine.field_176278_M);
                Boolean oldSouth = (Boolean)state.func_177229_b((IProperty)BlockVine.field_176279_N);
                Boolean oldWest = (Boolean)state.func_177229_b((IProperty)BlockVine.field_176280_O);
                for (int i = 0; i < rotation; ++i) {
                    Boolean newNorth = oldWest;
                    Boolean newEast = oldNorth;
                    Boolean newSouth = oldEast;
                    Boolean newWest = oldSouth;
                    oldNorth = newNorth;
                    oldEast = newEast;
                    oldSouth = newSouth;
                    oldWest = newWest;
                }
                return state.func_177226_a((IProperty)BlockVine.field_176273_b, (Comparable)oldNorth).func_177226_a((IProperty)BlockVine.field_176278_M, (Comparable)oldEast).func_177226_a((IProperty)BlockVine.field_176279_N, (Comparable)oldSouth).func_177226_a((IProperty)BlockVine.field_176280_O, (Comparable)oldWest);
            }
        };
        Rotations.stateRotationHandlers[Block.func_149682_b((Block)Blocks.field_180390_bo)] = new ArrayStateRotationHandler((IProperty)BlockFenceGate.field_176387_N, (Comparable[])enumFacing);
        Rotations.stateRotationHandlers[Block.func_149682_b((Block)Blocks.field_180391_bp)] = new ArrayStateRotationHandler((IProperty)BlockFenceGate.field_176387_N, (Comparable[])enumFacing);
        Rotations.stateRotationHandlers[Block.func_149682_b((Block)Blocks.field_180392_bq)] = new ArrayStateRotationHandler((IProperty)BlockFenceGate.field_176387_N, (Comparable[])enumFacing);
        Rotations.stateRotationHandlers[Block.func_149682_b((Block)Blocks.field_180386_br)] = new ArrayStateRotationHandler((IProperty)BlockFenceGate.field_176387_N, (Comparable[])enumFacing);
        Rotations.stateRotationHandlers[Block.func_149682_b((Block)Blocks.field_180385_bs)] = new ArrayStateRotationHandler((IProperty)BlockFenceGate.field_176387_N, (Comparable[])enumFacing);
        Rotations.stateRotationHandlers[Block.func_149682_b((Block)Blocks.field_180387_bt)] = new ArrayStateRotationHandler((IProperty)BlockFenceGate.field_176387_N, (Comparable[])enumFacing);
        Rotations.stateRotationHandlers[Block.func_149682_b((Block)Blocks.field_150378_br)] = new ArrayStateRotationHandler((IProperty)BlockEndPortalFrame.field_176508_a, (Comparable[])enumFacing);
        Rotations.stateRotationHandlers[Block.func_149682_b((Block)Blocks.field_150375_by)] = new ArrayStateRotationHandler((IProperty)BlockCocoa.field_176387_N, (Comparable[])enumFacing);
        Rotations.stateRotationHandlers[Block.func_149682_b((Block)Blocks.field_150479_bC)] = new ArrayStateRotationHandler((IProperty)BlockTripWireHook.field_176264_a, (Comparable[])enumFacing);
        Rotations.stateRotationHandlers[Block.func_149682_b((Block)Blocks.field_150465_bP)] = new ArrayStateRotationHandler((IProperty)BlockSkull.field_176418_a, (Comparable[])enumFacing);
        Rotations.tileEntityRotationHandlers[Block.func_149682_b((Block)Blocks.field_150465_bP)] = new TileEntityRotationHandler(){

            @Override
            public void rotate(TileEntity tileEntity, int rotation) {
                TileEntitySkull tileEntitySkull = (TileEntitySkull)tileEntity;
                tileEntitySkull.func_145903_a((tileEntitySkull.func_145906_b() + rotation * 4) % 16);
            }
        };
        Rotations.stateRotationHandlers[Block.func_149682_b((Block)Blocks.field_150467_bQ)] = new ArrayStateRotationHandler((IProperty)BlockAnvil.field_176506_a, (Comparable[])enumFacing);
    }
}

