/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.opengl.DisplayMode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XRandR {
    private static Screen[] current;
    private static String primaryScreenIdentifier;
    private static Screen[] savedConfiguration;
    private static Map<String, Screen[]> screens;
    private static final Pattern SCREEN_HEADER_PATTERN;
    private static final Pattern SCREEN_MODELINE_PATTERN;
    private static final Pattern FREQ_PATTERN;

    private static void populate() {
        if (screens == null) {
            screens = new HashMap<String, Screen[]>();
            try {
                String line;
                Process p = Runtime.getRuntime().exec(new String[]{"xrandr", "-q"});
                ArrayList<Screen> currentList = new ArrayList<Screen>();
                ArrayList<Screen> possibles = new ArrayList<Screen>();
                String name = null;
                int[] currentScreenPosition = new int[2];
                BufferedReader br = new BufferedReader(new InputStreamReader(p.getInputStream()));
                while ((line = br.readLine()) != null) {
                    String[] sa = (line = line.trim()).split("\\s+");
                    if ("connected".equals(sa[1])) {
                        if (name != null) {
                            screens.put(name, possibles.toArray(new Screen[possibles.size()]));
                            possibles.clear();
                        }
                        name = sa[0];
                        if ("primary".equals(sa[2])) {
                            XRandR.parseScreenHeader(currentScreenPosition, sa[3]);
                            primaryScreenIdentifier = name;
                            continue;
                        }
                        XRandR.parseScreenHeader(currentScreenPosition, sa[2]);
                        continue;
                    }
                    if (!Pattern.matches("\\d*x\\d*", sa[0])) continue;
                    if (sa[1].contains("*")) {
                        XRandR.parseScreenModeline(currentList, name, sa[0], Arrays.copyOfRange(sa, 1, sa.length), currentScreenPosition);
                    }
                    XRandR.parseScreenModeline(possibles, name, sa[0], Arrays.copyOfRange(sa, 1, sa.length), null);
                }
                screens.put(name, possibles.toArray(new Screen[possibles.size()]));
                current = currentList.toArray(new Screen[currentList.size()]);
                if (primaryScreenIdentifier == null) {
                    long totalPixels = Long.MIN_VALUE;
                    for (Screen screen : current) {
                        if (1L * (long)screen.width * (long)screen.height <= totalPixels) continue;
                        primaryScreenIdentifier = screen.name;
                        totalPixels = 1L * (long)screen.width * (long)screen.height;
                    }
                }
            }
            catch (Throwable e) {
                LWJGLUtil.log("Exception in XRandR.populate(): " + e.getMessage());
                screens.clear();
                current = new Screen[0];
            }
        }
    }

    public static Screen[] getConfiguration() {
        XRandR.populate();
        for (Screen screen : current) {
            if (!screen.name.equals(primaryScreenIdentifier)) continue;
            return new Screen[]{screen};
        }
        return (Screen[])current.clone();
    }

    public static void setConfiguration(boolean disableOthers, Screen ... screens) {
        if (screens.length == 0) {
            throw new IllegalArgumentException("Must specify at least one screen");
        }
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add("xrandr");
        if (disableOthers) {
            for (Screen screen : current) {
                boolean found = false;
                for (Screen screen1 : screens) {
                    if (!screen1.name.equals(screen.name)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                cmd.add("--output");
                cmd.add(screen.name);
                cmd.add("--off");
            }
        }
        for (Screen screen : screens) {
            screen.getArgs(cmd);
        }
        try {
            String line;
            Process p = Runtime.getRuntime().exec(cmd.toArray(new String[cmd.size()]));
            BufferedReader br = new BufferedReader(new InputStreamReader(p.getInputStream()));
            while ((line = br.readLine()) != null) {
                LWJGLUtil.log("Unexpected output from xrandr process: " + line);
            }
            current = screens;
        }
        catch (IOException e) {
            LWJGLUtil.log("XRandR exception in setConfiguration(): " + e.getMessage());
        }
    }

    public static void saveConfiguration() {
        savedConfiguration = (Screen[])current.clone();
    }

    public static void restoreConfiguration() {
        if (savedConfiguration != null) {
            XRandR.setConfiguration(true, savedConfiguration);
        }
    }

    public static String[] getScreenNames() {
        XRandR.populate();
        return screens.keySet().toArray(new String[screens.size()]);
    }

    public static Screen[] getResolutions(String name) {
        XRandR.populate();
        return (Screen[])screens.get(name).clone();
    }

    private static void parseScreenModeline(List<Screen> list, String name, String res, String[] freqs, int[] screenPosition) {
        Matcher m = SCREEN_MODELINE_PATTERN.matcher(res);
        if (!m.matches()) {
            LWJGLUtil.log("Did not match: " + res);
            return;
        }
        int width = Integer.parseInt(m.group(1));
        int height = Integer.parseInt(m.group(2));
        int xpos = 0;
        int ypos = 0;
        if (screenPosition != null) {
            xpos = screenPosition[0];
            ypos = screenPosition[1];
        }
        for (String freqS : freqs) {
            m = FREQ_PATTERN.matcher(freqS);
            if (!m.matches()) {
                LWJGLUtil.log("Did not match: " + res);
                return;
            }
            int freq = Integer.parseInt(m.group(1));
            list.add(new Screen(name, width, height, freq, xpos, ypos));
        }
    }

    private static void parseScreenHeader(int[] screenPosition, String resPos) {
        Matcher m = SCREEN_HEADER_PATTERN.matcher(resPos);
        if (!m.matches()) {
            screenPosition[0] = 0;
            screenPosition[1] = 0;
            return;
        }
        screenPosition[0] = Integer.parseInt(m.group(3));
        screenPosition[1] = Integer.parseInt(m.group(4));
    }

    static Screen DisplayModetoScreen(DisplayMode mode) {
        XRandR.populate();
        Screen primary = XRandR.findPrimary(current);
        return new Screen(primary.name, mode.getWidth(), mode.getHeight(), mode.getFrequency(), primary.xPos, primary.yPos);
    }

    static DisplayMode ScreentoDisplayMode(Screen ... screens) {
        XRandR.populate();
        Screen primary = XRandR.findPrimary(screens);
        return new DisplayMode(primary.width, primary.height, 24, primary.freq);
    }

    private static Screen findPrimary(Screen ... screens) {
        for (Screen screen : screens) {
            if (!screen.name.equals(primaryScreenIdentifier)) continue;
            return screen;
        }
        return screens[0];
    }

    static {
        SCREEN_HEADER_PATTERN = Pattern.compile("^(\\d+)x(\\d+)\\+(\\d+)\\+(\\d+)$");
        SCREEN_MODELINE_PATTERN = Pattern.compile("^(\\d+)x(\\d+)$");
        FREQ_PATTERN = Pattern.compile("^(\\d+).(\\d+)\\*?\\+?$");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Screen
    implements Cloneable {
        public final String name;
        public final int width;
        public final int height;
        public final int freq;
        public int xPos;
        public int yPos;

        Screen(String name, int width, int height, int freq, int xPos, int yPos) {
            this.name = name;
            this.width = width;
            this.height = height;
            this.freq = freq;
            this.xPos = xPos;
            this.yPos = yPos;
        }

        private void getArgs(List<String> argList) {
            argList.add("--output");
            argList.add(this.name);
            argList.add("--mode");
            argList.add(this.width + "x" + this.height);
            argList.add("--rate");
            argList.add(this.freq + "");
            argList.add("--pos");
            argList.add(this.xPos + "x" + this.yPos);
        }

        public String toString() {
            return this.name + " " + this.width + "x" + this.height + " @ " + this.xPos + "x" + this.yPos + " with " + this.freq + "Hz";
        }
    }
}

