/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.emc.collector;

import java.util.HashMap;
import java.util.Map;
import moze_intel.projecte.emc.arithmetics.IValueArithmetic;
import moze_intel.projecte.emc.collector.IExtendedMappingCollector;

public abstract class AbstractMappingCollector<T, V extends Comparable<V>, A extends IValueArithmetic>
implements IExtendedMappingCollector<T, V, A> {
    A defaultArithmetic;

    public AbstractMappingCollector(A defaultArithmetic) {
        this.defaultArithmetic = defaultArithmetic;
    }

    @Override
    public void addConversion(int outnumber, T output, Iterable<T> ingredients) {
        this.addConversion(outnumber, output, this.listToMapOfCounts(ingredients));
    }

    @Override
    public void addConversion(int outnumber, T output, Iterable<T> ingredients, A arithmeticForConversion) {
        this.addConversion(outnumber, output, this.listToMapOfCounts(ingredients), arithmeticForConversion);
    }

    protected Map<T, Integer> listToMapOfCounts(Iterable<T> iterable) {
        HashMap<T, Integer> map = new HashMap<T, Integer>();
        for (T ingredient : iterable) {
            if (map.containsKey(ingredient)) {
                int amount = (Integer)map.get(ingredient);
                map.put(ingredient, amount + 1);
                continue;
            }
            map.put(ingredient, 1);
        }
        return map;
    }

    @Override
    public void setValueFromConversion(int outnumber, T something, Iterable<T> ingredients) {
        this.setValueFromConversion(outnumber, something, this.listToMapOfCounts(ingredients));
    }

    @Override
    public abstract void setValueFromConversion(int var1, T var2, Map<T, Integer> var3);

    @Override
    public void addConversion(int outnumber, T output, Map<T, Integer> ingredientsWithAmount) {
        this.addConversion(outnumber, output, ingredientsWithAmount, this.defaultArithmetic);
    }

    @Override
    public abstract void addConversion(int var1, T var2, Map<T, Integer> var3, A var4);

    @Override
    public A getArithmetic() {
        return this.defaultArithmetic;
    }

    @Override
    public void finishCollection() {
    }
}

