/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.blocks;

import moze_intel.projecte.PECore;
import moze_intel.projecte.gameObjs.blocks.BlockDirection;
import moze_intel.projecte.gameObjs.tiles.CollectorMK1Tile;
import moze_intel.projecte.gameObjs.tiles.CollectorMK2Tile;
import moze_intel.projecte.gameObjs.tiles.CollectorMK3Tile;
import moze_intel.projecte.utils.ComparatorHelper;
import moze_intel.projecte.utils.Constants;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class Collector
extends BlockDirection {
    private int tier;

    public Collector(int tier) {
        super(Material.field_151592_s);
        this.func_149663_c("pe_collector_MK" + tier);
        this.func_149715_a(Constants.COLLECTOR_LIGHT_VALS[tier - 1]);
        this.func_149711_c(0.3f);
        this.tier = tier;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumFacing side, float hitX, float hitY, float hitZ) {
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        if (!world.field_72995_K) {
            switch (this.tier) {
                case 1: {
                    player.openGui((Object)PECore.instance, 6, world, x, y, z);
                    break;
                }
                case 2: {
                    player.openGui((Object)PECore.instance, 7, world, x, y, z);
                    break;
                }
                case 3: {
                    player.openGui((Object)PECore.instance, 8, world, x, y, z);
                }
            }
        }
        return true;
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        switch (this.tier) {
            case 3: {
                return new CollectorMK3Tile();
            }
            case 2: {
                return new CollectorMK2Tile();
            }
            case 1: {
                return new CollectorMK1Tile();
            }
        }
        return null;
    }

    public boolean func_149740_M() {
        return true;
    }

    public int func_180641_l(World world, BlockPos pos) {
        return ComparatorHelper.getForCollector(world, pos);
    }

    public boolean isSideSolid(IBlockAccess world, BlockPos pos, EnumFacing side) {
        return true;
    }
}

