/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.blocks;

import java.util.Random;
import moze_intel.projecte.PECore;
import moze_intel.projecte.gameObjs.ObjHandler;
import moze_intel.projecte.gameObjs.blocks.BlockDirection;
import moze_intel.projecte.gameObjs.tiles.DMFurnaceTile;
import moze_intel.projecte.gameObjs.tiles.RMFurnaceTile;
import moze_intel.projecte.gameObjs.tiles.TileEmc;
import moze_intel.projecte.utils.ComparatorHelper;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class MatterFurnace
extends BlockDirection {
    private boolean isActive;
    private boolean isHighTier;
    private static boolean isUpdating;

    public MatterFurnace(boolean active, boolean isRM) {
        super(Material.field_151576_e);
        this.func_149647_a(ObjHandler.cTab);
        this.isActive = active;
        this.isHighTier = isRM;
        this.func_149663_c("pe_" + (this.isHighTier ? "rm" : "dm") + "_furnace");
        if (this.isActive) {
            this.func_149647_a(null);
            this.func_149715_a(0.875f);
        }
    }

    public float func_176195_g(World world, BlockPos pos) {
        return this.isHighTier ? 2000000.0f : 1000000.0f;
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return this.isHighTier ? Item.func_150898_a((Block)ObjHandler.rmFurnaceOff) : Item.func_150898_a((Block)ObjHandler.dmFurnaceOff);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (!world.field_72995_K) {
            if (this.isHighTier) {
                player.openGui((Object)PECore.instance, 4, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            } else {
                player.openGui((Object)PECore.instance, 5, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            }
        }
        return true;
    }

    @Override
    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        if (!isUpdating) {
            super.func_180663_b(world, pos, state);
        }
    }

    public void updateFurnaceBlockState(boolean isActive, World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        TileEntity tile = world.func_175625_s(pos);
        isUpdating = true;
        if (isActive) {
            if (this.isHighTier) {
                world.func_180501_a(pos, ObjHandler.rmFurnaceOn.func_176223_P().func_177226_a(FACING, state.func_177229_b(FACING)), 3);
            } else {
                world.func_180501_a(pos, ObjHandler.dmFurnaceOn.func_176223_P().func_177226_a(FACING, state.func_177229_b(FACING)), 3);
            }
        } else if (this.isHighTier) {
            world.func_180501_a(pos, ObjHandler.rmFurnaceOff.func_176223_P().func_177226_a(FACING, state.func_177229_b(FACING)), 3);
        } else {
            world.func_180501_a(pos, ObjHandler.dmFurnaceOff.func_176223_P().func_177226_a(FACING, state.func_177229_b(FACING)), 3);
        }
        isUpdating = false;
        if (tile != null) {
            tile.func_145829_t();
            world.func_175690_a(pos, tile);
        }
    }

    @Override
    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase entLiving, ItemStack stack) {
        this.setFacingMeta(world, pos, (EntityPlayer)entLiving);
        TileEntity tile = world.func_175625_s(pos);
        if (stack.func_77942_o() && stack.func_77978_p().func_74767_n("ProjectEBlock") && tile instanceof TileEmc) {
            stack.func_77978_p().func_74768_a("x", pos.func_177958_n());
            stack.func_77978_p().func_74768_a("y", pos.func_177956_o());
            stack.func_77978_p().func_74768_a("z", pos.func_177952_p());
            stack.func_77978_p().func_74768_a("EMC", 0);
            stack.func_77978_p().func_74777_a("BurnTime", (short)0);
            stack.func_77978_p().func_74777_a("CookTime", (short)0);
            tile.func_145839_a(stack.func_77978_p());
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(World world, BlockPos pos, IBlockState state, Random rand) {
        if (this.isActive) {
            EnumFacing facing = (EnumFacing)state.func_177229_b(FACING);
            float f = (float)pos.func_177958_n() + 0.5f;
            float f1 = (float)pos.func_177956_o() + 0.0f + rand.nextFloat() * 6.0f / 16.0f;
            float f2 = (float)pos.func_177952_p() + 0.5f;
            float f3 = 0.52f;
            float f4 = rand.nextFloat() * 0.6f - 0.3f;
            switch (facing) {
                case WEST: {
                    world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, (double)(f - f3), (double)f1, (double)(f2 + f4), 0.0, 0.0, 0.0, new int[0]);
                    world.func_175688_a(EnumParticleTypes.FLAME, (double)(f - f3), (double)f1, (double)(f2 + f4), 0.0, 0.0, 0.0, new int[0]);
                    break;
                }
                case EAST: {
                    world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, (double)(f + f3), (double)f1, (double)(f2 + f4), 0.0, 0.0, 0.0, new int[0]);
                    world.func_175688_a(EnumParticleTypes.FLAME, (double)(f + f3), (double)f1, (double)(f2 + f4), 0.0, 0.0, 0.0, new int[0]);
                }
                case NORTH: {
                    world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, (double)(f + f4), (double)f1, (double)(f2 - f3), 0.0, 0.0, 0.0, new int[0]);
                    world.func_175688_a(EnumParticleTypes.FLAME, (double)(f + f4), (double)f1, (double)(f2 - f3), 0.0, 0.0, 0.0, new int[0]);
                }
                case SOUTH: {
                    world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, (double)(f + f4), (double)f1, (double)(f2 + f3), 0.0, 0.0, 0.0, new int[0]);
                    world.func_175688_a(EnumParticleTypes.FLAME, (double)(f + f4), (double)f1, (double)(f2 + f3), 0.0, 0.0, 0.0, new int[0]);
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public Item func_180665_b(World world, BlockPos pos) {
        return this.isHighTier ? Item.func_150898_a((Block)ObjHandler.rmFurnaceOff) : Item.func_150898_a((Block)ObjHandler.dmFurnaceOff);
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        return this.isHighTier ? new RMFurnaceTile() : new DMFurnaceTile();
    }

    public boolean func_149740_M() {
        return true;
    }

    public int func_180641_l(World world, BlockPos pos) {
        return ComparatorHelper.getForMatterFurnace(world, pos);
    }
}

