/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.items;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import moze_intel.projecte.gameObjs.items.CataliticLens;
import moze_intel.projecte.gameObjs.items.ItemCharge;
import moze_intel.projecte.network.PacketHandler;
import moze_intel.projecte.network.packets.ParticlePKT;
import moze_intel.projecte.utils.PlayerHelper;
import moze_intel.projecte.utils.WorldHelper;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.NetworkRegistry;

public class DestructionCatalyst
extends ItemCharge {
    public DestructionCatalyst() {
        super("destruction_catalyst", (byte)3);
        this.setNoRepair();
    }

    protected DestructionCatalyst(String name, byte numCharges) {
        super(name, numCharges);
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        if (world.field_72995_K) {
            return stack;
        }
        MovingObjectPosition mop = this.func_77621_a(world, player, false);
        if (mop != null && mop.field_72313_a.equals((Object)MovingObjectPosition.MovingObjectType.BLOCK)) {
            int numRows = this.calculateDepthFromCharge(stack);
            boolean hasAction = false;
            BlockPos coords = mop.func_178782_a();
            AxisAlignedBB box = WorldHelper.getDeepBox(coords, mop.field_178784_b, --numRows);
            ArrayList drops = Lists.newArrayList();
            for (BlockPos pos : WorldHelper.getPositionsFromBox(box)) {
                List<ItemStack> list;
                Block block = world.func_180495_p(pos).func_177230_c();
                float hardness = block.func_176195_g(world, pos);
                if (block.isAir((IBlockAccess)world, pos) || hardness >= 50.0f || hardness == -1.0f) continue;
                if (!DestructionCatalyst.consumeFuel(player, stack, 8.0, true)) break;
                if (!hasAction) {
                    hasAction = true;
                }
                if (PlayerHelper.hasBreakPermission((EntityPlayerMP)player, pos)) {
                    list = WorldHelper.getBlockDrops(world, player, world.func_180495_p(pos), stack, pos);
                    if (list != null && list.size() > 0) {
                        drops.addAll(list);
                    }
                    world.func_175698_g(pos);
                    if (world.field_73012_v.nextInt(8) == 0) {
                        PacketHandler.sendToAllAround(new ParticlePKT(EnumParticleTypes.SMOKE_LARGE, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()), new NetworkRegistry.TargetPoint(world.field_73011_w.func_177502_q(), (double)pos.func_177958_n(), (double)(pos.func_177956_o() + 1), (double)pos.func_177952_p(), 32.0));
                    }
                }
                if ((list = WorldHelper.getBlockDrops(world, player, world.func_180495_p(pos), stack, pos)) != null && list.size() > 0) {
                    drops.addAll(list);
                }
                world.func_175698_g(pos);
                if (world.field_73012_v.nextInt(8) != 0) continue;
                PacketHandler.sendToAllAround(new ParticlePKT(EnumParticleTypes.SMOKE_LARGE, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()), new NetworkRegistry.TargetPoint(world.field_73011_w.func_177502_q(), (double)pos.func_177958_n(), (double)(pos.func_177956_o() + 1), (double)pos.func_177952_p(), 32.0));
            }
            PlayerHelper.swingItem(player);
            if (hasAction) {
                WorldHelper.createLootDrop(drops, world, mop.func_178782_a());
                world.func_72956_a((Entity)player, "projecte:item.pedestruct", 1.0f, 1.0f);
            }
        }
        return stack;
    }

    protected int calculateDepthFromCharge(ItemStack stack) {
        byte charge = this.getCharge(stack);
        if (charge <= 0) {
            return 1;
        }
        if (this instanceof CataliticLens) {
            return 8 + charge * 8;
        }
        return (int)Math.pow(2.0, 1 + charge);
    }
}

