/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.items.tools;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.Set;
import moze_intel.projecte.config.ProjectEConfig;
import moze_intel.projecte.gameObjs.items.ItemMode;
import moze_intel.projecte.network.PacketHandler;
import moze_intel.projecte.network.packets.ParticlePKT;
import moze_intel.projecte.utils.ItemHelper;
import moze_intel.projecte.utils.MathUtils;
import moze_intel.projecte.utils.PlayerHelper;
import moze_intel.projecte.utils.WorldHelper;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.IShearable;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.UseHoeEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;

public abstract class PEToolBase
extends ItemMode {
    public static final float HAMMER_BASE_ATTACK = 13.0f;
    public static final float DARKSWORD_BASE_ATTACK = 12.0f;
    public static final float REDSWORD_BASE_ATTACK = 16.0f;
    public static final float STAR_BASE_ATTACK = 20.0f;
    public static final float KATAR_BASE_ATTACK = 23.0f;
    protected String pePrimaryToolClass;
    protected String peToolMaterial;
    protected Set<Material> harvestMaterials = Sets.newHashSet();
    protected Set<String> secondaryClasses = Sets.newHashSet();

    public PEToolBase(String unlocalName, byte numCharge, String[] modeDescrp) {
        super(unlocalName, numCharge, modeDescrp);
    }

    public boolean canHarvestBlock(Block block, ItemStack stack) {
        return this.harvestMaterials.contains(block.func_149688_o());
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77662_d() {
        return true;
    }

    public int getHarvestLevel(ItemStack stack, String toolClass) {
        if (this.pePrimaryToolClass.equals(toolClass) || this.secondaryClasses.contains(toolClass)) {
            return 4;
        }
        return -1;
    }

    public float getDigSpeed(ItemStack stack, IBlockState state) {
        if ("dm_tools".equals(this.peToolMaterial)) {
            if (this.canHarvestBlock(state.func_177230_c(), stack)) {
                return 14.0f + 12.0f * (float)this.getCharge(stack);
            }
        } else if ("rm_tools".equals(this.peToolMaterial) && this.canHarvestBlock(state.func_177230_c(), stack)) {
            return 16.0f + 14.0f * (float)this.getCharge(stack);
        }
        return 1.0f;
    }

    protected void clearOdAOE(World world, ItemStack stack, EntityPlayer player, String odName, int emcCost) {
        byte charge = this.getCharge(stack);
        if (charge == 0 || world.field_72995_K || ProjectEConfig.disableAllRadiusMining) {
            return;
        }
        ArrayList drops = Lists.newArrayList();
        int scaled1 = 5 * charge;
        int scaled2 = 10 * charge;
        for (BlockPos pos : WorldHelper.getPositionsFromCorners(new BlockPos((Entity)player).func_177982_a(-scaled1, -scaled2, -scaled1), new BlockPos((Entity)player).func_177982_a(scaled1, scaled2, scaled1))) {
            String oreName;
            IBlockState state = world.func_180495_p(pos);
            Block block = state.func_177230_c();
            if (block.isAir((IBlockAccess)world, pos) || Item.func_150898_a((Block)block) == null) continue;
            ItemStack s = new ItemStack(block);
            int[] oreIds = OreDictionary.getOreIDs((ItemStack)s);
            if (oreIds.length == 0) {
                if (block != Blocks.field_150420_aW && block != Blocks.field_150419_aX) continue;
                oreName = "logWood";
            } else {
                oreName = OreDictionary.getOreName((int)oreIds[0]);
            }
            if (!odName.equals(oreName)) continue;
            List<ItemStack> blockDrops = WorldHelper.getBlockDrops(world, player, state, stack, pos);
            if (!PlayerHelper.hasBreakPermission((EntityPlayerMP)player, pos) || !PEToolBase.consumeFuel(player, stack, emcCost, true)) continue;
            drops.addAll(blockDrops);
            world.func_175698_g(pos);
            if (world.field_73012_v.nextInt(5) != 0) continue;
            PacketHandler.sendToAllAround(new ParticlePKT(EnumParticleTypes.SMOKE_LARGE, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()), new NetworkRegistry.TargetPoint(world.field_73011_w.func_177502_q(), (double)pos.func_177958_n(), (double)(pos.func_177956_o() + 1), (double)pos.func_177952_p(), 32.0));
        }
        WorldHelper.createLootDrop(drops, world, player.field_70165_t, player.field_70163_u, player.field_70161_v);
        PlayerHelper.swingItem(player);
    }

    protected void tillAOE(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing sidehit, int emcCost) {
        byte charge = this.getCharge(stack);
        boolean hasAction = false;
        boolean hasSoundPlayed = false;
        for (BlockPos newPos : WorldHelper.getPositionsFromCorners(pos.func_177982_a((int)(-charge), 0, (int)(-charge)), pos.func_177982_a((int)charge, 0, (int)charge))) {
            Block block = world.func_180495_p(newPos).func_177230_c();
            Block blockAbove = world.func_180495_p(newPos.func_177984_a()).func_177230_c();
            if (blockAbove.func_149662_c() || block != Blocks.field_150349_c && block != Blocks.field_150346_d) continue;
            if (!hasSoundPlayed) {
                world.func_72908_a((double)((float)newPos.func_177958_n() + 0.5f), (double)((float)newPos.func_177956_o() + 0.5f), (double)((float)newPos.func_177952_p() + 0.5f), Blocks.field_150458_ak.field_149762_H.func_150498_e(), (Blocks.field_150458_ak.field_149762_H.func_150497_c() + 1.0f) / 2.0f, Blocks.field_150458_ak.field_149762_H.func_150494_d() * 0.8f);
                hasSoundPlayed = true;
            }
            if (world.field_72995_K) {
                return;
            }
            if (MinecraftForge.EVENT_BUS.post((Event)new UseHoeEvent(player, stack, world, newPos)) || (newPos.func_177958_n() != pos.func_177958_n() || newPos.func_177952_p() != pos.func_177952_p()) && !PEToolBase.consumeFuel(player, stack, emcCost, true)) continue;
            PlayerHelper.checkedReplaceBlock((EntityPlayerMP)player, newPos, Blocks.field_150458_ak.func_176223_P());
            if ((blockAbove.func_149688_o() == Material.field_151585_k || blockAbove.func_149688_o() == Material.field_151582_l) && !(blockAbove instanceof ITileEntityProvider) && PlayerHelper.hasBreakPermission((EntityPlayerMP)player, newPos)) {
                world.func_175655_b(newPos.func_177984_a(), true);
            }
            if (hasAction) continue;
            hasAction = true;
        }
        if (hasAction) {
            player.field_70170_p.func_72956_a((Entity)player, "projecte:item.pecharge", 1.0f, 1.0f);
        }
    }

    protected void digBasedOnMode(ItemStack stack, World world, Block block, BlockPos pos, EntityLivingBase living) {
        if (world.field_72995_K || !(living instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)living;
        byte mode = this.getMode(stack);
        if (mode == 0) {
            return;
        }
        MovingObjectPosition mop = this.func_77621_a(world, player, false);
        if (mop == null || mop.field_72313_a != MovingObjectPosition.MovingObjectType.BLOCK) {
            return;
        }
        EnumFacing direction = mop.field_178784_b;
        BlockPos hitPos = mop.func_178782_a();
        AxisAlignedBB box = new AxisAlignedBB(hitPos, hitPos);
        if (!ProjectEConfig.disableAllRadiusMining) {
            switch (mode) {
                case 1: {
                    box = new AxisAlignedBB(hitPos.func_177967_a(EnumFacing.DOWN, 1), hitPos.func_177967_a(EnumFacing.UP, 1));
                    break;
                }
                case 2: {
                    switch (direction.func_176740_k()) {
                        case X: {
                            box = new AxisAlignedBB(hitPos.func_177972_a(EnumFacing.SOUTH), hitPos.func_177972_a(EnumFacing.NORTH));
                            break;
                        }
                        case Y: {
                            switch (player.func_174811_aO().func_176740_k()) {
                                case X: {
                                    box = new AxisAlignedBB(hitPos.func_177972_a(EnumFacing.SOUTH), hitPos.func_177972_a(EnumFacing.NORTH));
                                    break;
                                }
                                case Z: {
                                    box = new AxisAlignedBB(hitPos.func_177972_a(EnumFacing.WEST), hitPos.func_177972_a(EnumFacing.EAST));
                                }
                            }
                            break;
                        }
                        case Z: {
                            box = new AxisAlignedBB(hitPos.func_177972_a(EnumFacing.WEST), hitPos.func_177972_a(EnumFacing.EAST));
                        }
                    }
                    break;
                }
                case 3: {
                    box = new AxisAlignedBB(hitPos, hitPos.func_177967_a(direction.func_176734_d(), 2));
                }
            }
        }
        ArrayList drops = Lists.newArrayList();
        for (BlockPos digPos : WorldHelper.getPositionsFromBox(box)) {
            IBlockState state = world.func_180495_p(digPos);
            Block b = state.func_177230_c();
            if (b == Blocks.field_150350_a || b.func_176195_g(world, digPos) == -1.0f || !PlayerHelper.hasBreakPermission((EntityPlayerMP)player, digPos) || !this.canHarvestBlock(block, stack) && !ForgeHooks.canToolHarvestBlock((IBlockAccess)world, (BlockPos)digPos, (ItemStack)stack)) continue;
            drops.addAll(WorldHelper.getBlockDrops(world, player, state, stack, digPos));
            world.func_175698_g(digPos);
        }
        WorldHelper.createLootDrop(drops, world, pos);
    }

    protected void digAOE(ItemStack stack, World world, EntityPlayer player, boolean affectDepth, int emcCost) {
        if (world.field_72995_K || this.getCharge(stack) == 0 || ProjectEConfig.disableAllRadiusMining) {
            return;
        }
        MovingObjectPosition mop = this.func_77621_a(world, player, false);
        if (mop == null || mop.field_72313_a != MovingObjectPosition.MovingObjectType.BLOCK) {
            return;
        }
        AxisAlignedBB box = affectDepth ? WorldHelper.getBroadDeepBox(mop.func_178782_a(), mop.field_178784_b, this.getCharge(stack)) : WorldHelper.getFlatYBox(mop.func_178782_a(), this.getCharge(stack));
        ArrayList drops = Lists.newArrayList();
        for (BlockPos pos : WorldHelper.getPositionsFromBox(box)) {
            IBlockState state = world.func_180495_p(pos);
            Block b = state.func_177230_c();
            if (b == Blocks.field_150350_a || b.func_176195_g(world, pos) == -1.0f || !this.canHarvestBlock(b, stack) || !PlayerHelper.hasBreakPermission((EntityPlayerMP)player, pos) || !PEToolBase.consumeFuel(player, stack, emcCost, true)) continue;
            drops.addAll(WorldHelper.getBlockDrops(world, player, state, stack, pos));
            world.func_175698_g(pos);
        }
        WorldHelper.createLootDrop(drops, world, mop.func_178782_a());
        PlayerHelper.swingItem(player);
        if (!drops.isEmpty()) {
            world.func_72956_a((Entity)player, "projecte:item.pedestruct", 1.0f, 1.0f);
        }
    }

    protected void attackWithCharge(ItemStack stack, EntityLivingBase damaged, EntityLivingBase damager, float baseDmg) {
        if (!(damager instanceof EntityPlayer) || damager.field_70170_p.field_72995_K) {
            return;
        }
        DamageSource dmg = DamageSource.func_76365_a((EntityPlayer)((EntityPlayer)damager));
        byte charge = this.getCharge(stack);
        float totalDmg = baseDmg;
        if (charge > 0) {
            dmg.func_76348_h();
            totalDmg += (float)charge;
        }
        damaged.func_70097_a(dmg, totalDmg);
    }

    protected void attackAOE(ItemStack stack, EntityPlayer player, boolean slayAll, float damage, int emcCost) {
        if (player.field_70170_p.field_72995_K) {
            return;
        }
        byte charge = this.getCharge(stack);
        float factor = 2.5f * (float)charge;
        AxisAlignedBB aabb = player.func_174813_aQ().func_72314_b((double)factor, (double)factor, (double)factor);
        List toAttack = player.field_70170_p.func_72839_b((Entity)player, aabb);
        DamageSource src = DamageSource.func_76365_a((EntityPlayer)player);
        src.func_76348_h();
        for (Entity entity : toAttack) {
            if (!PEToolBase.consumeFuel(player, stack, emcCost, true)) continue;
            if (entity instanceof IMob) {
                entity.func_70097_a(src, damage);
                continue;
            }
            if (!(entity instanceof EntityLivingBase) || !slayAll) continue;
            entity.func_70097_a(src, damage);
        }
        player.field_70170_p.func_72956_a((Entity)player, "projecte:item.pecharge", 1.0f, 1.0f);
        PlayerHelper.swingItem(player);
    }

    protected void shearBlock(ItemStack stack, BlockPos pos, EntityPlayer player) {
        IShearable target;
        if (player.field_70170_p.field_72995_K) {
            return;
        }
        Block block = player.field_70170_p.func_180495_p(pos).func_177230_c();
        if (block instanceof IShearable && (target = (IShearable)block).isShearable(stack, (IBlockAccess)player.field_70170_p, pos) && PlayerHelper.hasBreakPermission((EntityPlayerMP)player, pos)) {
            List drops = target.onSheared(stack, (IBlockAccess)player.field_70170_p, pos, EnchantmentHelper.func_77506_a((int)Enchantment.field_77346_s.field_77352_x, (ItemStack)stack));
            Random rand = new Random();
            for (ItemStack drop : drops) {
                float f = 0.7f;
                double d = (double)(rand.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                double d1 = (double)(rand.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                double d2 = (double)(rand.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                EntityItem entityitem = new EntityItem(player.field_70170_p, (double)pos.func_177958_n() + d, (double)pos.func_177956_o() + d1, (double)pos.func_177952_p() + d2, drop);
                entityitem.func_174867_a(10);
                player.field_70170_p.func_72838_d((Entity)entityitem);
            }
            stack.func_77972_a(1, (EntityLivingBase)player);
            player.func_71064_a(StatList.field_75934_C[Block.func_149682_b((Block)block)], 1);
        }
    }

    protected void shearEntityAOE(ItemStack stack, EntityPlayer player, int emcCost) {
        World world = player.field_70170_p;
        if (!world.field_72995_K) {
            byte charge = this.getCharge(stack);
            int offset = (int)Math.pow(2.0, 2 + charge);
            AxisAlignedBB bBox = player.func_174813_aQ().func_72314_b((double)offset, (double)(offset / 2), (double)offset);
            List list = world.func_72872_a(Entity.class, bBox);
            ArrayList drops = Lists.newArrayList();
            for (Entity ent : list) {
                List entDrops;
                if (!(ent instanceof IShearable)) continue;
                IShearable target = (IShearable)ent;
                if (target.isShearable(stack, (IBlockAccess)ent.field_70170_p, new BlockPos(ent)) && PEToolBase.consumeFuel(player, stack, emcCost, true) && !(entDrops = target.onSheared(stack, (IBlockAccess)ent.field_70170_p, new BlockPos(ent), EnchantmentHelper.func_77506_a((int)Enchantment.field_77346_s.field_77352_x, (ItemStack)stack))).isEmpty()) {
                    for (ItemStack drop : entDrops) {
                        drop.field_77994_a *= 2;
                    }
                    drops.addAll(entDrops);
                }
                if (!(Math.random() < 0.01)) continue;
                Entity e = EntityList.func_75620_a((String)EntityList.func_75621_b((Entity)ent), (World)world);
                e.func_180432_n(ent);
                if (e instanceof EntitySheep) {
                    ((EntitySheep)e).func_175512_b(EnumDyeColor.values()[MathUtils.randomIntInRange(0, 15)]);
                }
                if (e instanceof EntityAgeable) {
                    ((EntityAgeable)e).func_70873_a(-24000);
                }
                world.func_72838_d(e);
            }
            WorldHelper.createLootDrop(drops, world, player.field_70165_t, player.field_70163_u, player.field_70161_v);
            PlayerHelper.swingItem(player);
        }
    }

    protected void tryVeinMine(ItemStack stack, EntityPlayer player, MovingObjectPosition mop) {
        if (player.field_70170_p.field_72995_K || ProjectEConfig.disableAllRadiusMining) {
            return;
        }
        AxisAlignedBB aabb = WorldHelper.getBroadDeepBox(mop.func_178782_a(), mop.field_178784_b, this.getCharge(stack));
        IBlockState target = player.field_70170_p.func_180495_p(mop.func_178782_a());
        if (target.func_177230_c().func_176195_g(player.field_70170_p, mop.func_178782_a()) <= -1.0f || !this.canHarvestBlock(target.func_177230_c(), stack) && !ForgeHooks.canToolHarvestBlock((IBlockAccess)player.field_70170_p, (BlockPos)mop.func_178782_a(), (ItemStack)stack)) {
            return;
        }
        ArrayList drops = Lists.newArrayList();
        for (BlockPos pos : WorldHelper.getPositionsFromBox(aabb)) {
            IBlockState state = player.field_70170_p.func_180495_p(pos);
            if (state != target) continue;
            WorldHelper.harvestVein(player.field_70170_p, player, stack, pos, state, drops, 0);
        }
        WorldHelper.createLootDrop(drops, player.field_70170_p, mop.func_178782_a());
        if (!drops.isEmpty()) {
            player.field_70170_p.func_72956_a((Entity)player, "projecte:item.pedestruct", 1.0f, 1.0f);
        }
    }

    protected void mineOreVeinsInAOE(ItemStack stack, EntityPlayer player) {
        if (player.field_70170_p.field_72995_K || ProjectEConfig.disableAllRadiusMining) {
            return;
        }
        int offset = this.getCharge(stack) + 3;
        AxisAlignedBB box = player.func_174813_aQ().func_72314_b((double)offset, (double)offset, (double)offset);
        ArrayList drops = Lists.newArrayList();
        World world = player.field_70170_p;
        for (BlockPos pos : WorldHelper.getPositionsFromBox(box)) {
            IBlockState state = world.func_180495_p(pos);
            if (!ItemHelper.isOre(state) || state.func_177230_c().func_176195_g(player.field_70170_p, pos) == -1.0f || !this.canHarvestBlock(state.func_177230_c(), stack) && !ForgeHooks.canToolHarvestBlock((IBlockAccess)world, (BlockPos)pos, (ItemStack)stack)) continue;
            WorldHelper.harvestVein(world, player, stack, pos, state, drops, 0);
        }
        if (!drops.isEmpty()) {
            WorldHelper.createLootDrop(drops, world, player.field_70165_t, player.field_70163_u, player.field_70161_v);
            PlayerHelper.swingItem(player);
        }
    }
}

