/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.tiles;

import java.util.Arrays;
import moze_intel.projecte.api.item.IItemEmc;
import moze_intel.projecte.api.tile.IEmcAcceptor;
import moze_intel.projecte.api.tile.IEmcProvider;
import moze_intel.projecte.gameObjs.tiles.TileEmc;
import moze_intel.projecte.network.PacketHandler;
import moze_intel.projecte.network.packets.RelaySyncPKT;
import moze_intel.projecte.utils.EMCHelper;
import moze_intel.projecte.utils.ItemHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MathHelper;
import net.minecraftforge.fml.common.network.NetworkRegistry;

public class RelayMK1Tile
extends TileEmc
implements IInventory,
ISidedInventory,
IEmcAcceptor,
IEmcProvider {
    private ItemStack[] inventory;
    private int invBufferSize;
    private final int chargeRate;
    public int displayEmc;
    public double displayChargingEmc;
    public double displayRawEmc;
    private int numUsing;

    public RelayMK1Tile() {
        super(100000);
        this.chargeRate = 64;
        this.inventory = new ItemStack[8];
        this.invBufferSize = 6;
    }

    public RelayMK1Tile(int sizeInv, int maxEmc, int chargeRate) {
        super(maxEmc);
        this.chargeRate = chargeRate;
        this.inventory = new ItemStack[sizeInv + 2];
        this.invBufferSize = sizeInv;
    }

    public void func_73660_a() {
        ItemStack chargeable;
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        this.sendEmc();
        this.sortInventory();
        ItemStack stack = this.inventory[0];
        if (stack != null) {
            if (stack.func_77973_b() instanceof IItemEmc) {
                IItemEmc itemEmc = (IItemEmc)stack.func_77973_b();
                double emcVal = itemEmc.getStoredEmc(stack);
                if (emcVal > (double)this.chargeRate) {
                    emcVal = this.chargeRate;
                }
                if (emcVal > 0.0 && this.getStoredEmc() + emcVal <= this.getMaximumEmc()) {
                    this.addEMC(emcVal);
                    itemEmc.extractEmc(stack, emcVal);
                }
            } else {
                int emcVal = EMCHelper.getEmcValue(stack);
                if (emcVal > 0 && this.getStoredEmc() + (double)emcVal <= this.getMaximumEmc()) {
                    this.addEMC(emcVal);
                    this.func_70298_a(0, 1);
                }
            }
        }
        if ((chargeable = this.inventory[this.func_70302_i_() - 1]) != null && this.getStoredEmc() > 0.0 && chargeable.func_77973_b() instanceof IItemEmc) {
            this.chargeItem(chargeable);
        }
        this.displayEmc = (int)this.getStoredEmc();
        this.displayChargingEmc = this.getChargingEMC();
        this.displayRawEmc = this.getRawEmc();
        if (this.numUsing > 0) {
            PacketHandler.sendToAllAround(new RelaySyncPKT(this.displayEmc, this.displayChargingEmc, this.displayRawEmc, this), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.func_177502_q(), (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), 8.0));
        }
    }

    private void sendEmc() {
        if (this.getStoredEmc() == 0.0) {
            return;
        }
        if (this.getStoredEmc() <= (double)this.chargeRate) {
            this.sendToAllAcceptors(this.getStoredEmc());
        } else {
            this.sendToAllAcceptors(this.chargeRate);
        }
    }

    private void sortInventory() {
        for (int i = 1; i <= this.invBufferSize; ++i) {
            ItemStack current = this.func_70301_a(i);
            if (current == null) continue;
            int nextIndex = i < this.invBufferSize ? i + 1 : 0;
            ItemStack following = this.inventory[nextIndex];
            if (following == null) {
                this.inventory[nextIndex] = current;
                this.func_70298_a(i, current.field_77994_a);
                continue;
            }
            if (!ItemHelper.areItemStacksEqual(current, following) || following.field_77994_a >= following.func_77976_d()) continue;
            int missingForFullStack = following.func_77976_d() - following.field_77994_a;
            if (current.field_77994_a <= missingForFullStack) {
                this.inventory[nextIndex].field_77994_a += current.field_77994_a;
                this.inventory[i] = null;
                continue;
            }
            this.inventory[nextIndex].field_77994_a += missingForFullStack;
            this.func_70298_a(i, missingForFullStack);
        }
    }

    private void chargeItem(ItemStack chargeable) {
        double toSend;
        IItemEmc itemEmc = (IItemEmc)chargeable.func_77973_b();
        double starEmc = itemEmc.getStoredEmc(chargeable);
        double maxStarEmc = itemEmc.getMaximumEmc(chargeable);
        double d = toSend = this.getStoredEmc() < (double)this.chargeRate ? this.getStoredEmc() : (double)this.chargeRate;
        if (starEmc + toSend <= maxStarEmc) {
            itemEmc.addEmc(chargeable, toSend);
            this.removeEMC(toSend);
        } else {
            toSend = maxStarEmc - starEmc;
            itemEmc.addEmc(chargeable, toSend);
            this.removeEMC(toSend);
        }
    }

    public int getEmcScaled(int i) {
        return (int)Math.round((double)(this.displayEmc * i) / this.getMaximumEmc());
    }

    private double getChargingEMC() {
        int index = this.func_70302_i_() - 1;
        if (this.inventory[index] != null && this.inventory[index].func_77973_b() instanceof IItemEmc) {
            return ((IItemEmc)this.inventory[index].func_77973_b()).getStoredEmc(this.inventory[index]);
        }
        return 0.0;
    }

    public int getChargingEMCScaled(int i) {
        int index = this.func_70302_i_() - 1;
        if (this.inventory[index] != null && this.inventory[index].func_77973_b() instanceof IItemEmc) {
            return (int)Math.round(this.displayChargingEmc * (double)i / ((IItemEmc)this.inventory[index].func_77973_b()).getMaximumEmc(this.inventory[index]));
        }
        return 0;
    }

    private double getRawEmc() {
        if (this.inventory[0] == null) {
            return 0.0;
        }
        if (this.inventory[0].func_77973_b() instanceof IItemEmc) {
            return ((IItemEmc)this.inventory[0].func_77973_b()).getStoredEmc(this.inventory[0]);
        }
        return EMCHelper.getEmcValue(this.inventory[0]) * this.inventory[0].field_77994_a;
    }

    public int getRawEmcScaled(int i) {
        if (this.inventory[0] == null) {
            return 0;
        }
        if (this.inventory[0].func_77973_b() instanceof IItemEmc) {
            return (int)Math.round(this.displayRawEmc * (double)i / ((IItemEmc)this.inventory[0].func_77973_b()).getMaximumEmc(this.inventory[0]));
        }
        int emc = EMCHelper.getEmcValue(this.inventory[0]);
        return MathHelper.func_76128_c((double)(this.displayRawEmc * (double)i / (double)(emc * this.inventory[0].func_77976_d())));
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        NBTTagList list = nbt.func_150295_c("Items", 10);
        this.inventory = new ItemStack[this.func_70302_i_()];
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound subNBT = list.func_150305_b(i);
            byte slot = subNBT.func_74771_c("Slot");
            if (slot < 0 || slot >= this.func_70302_i_()) continue;
            this.inventory[slot] = ItemStack.func_77949_a((NBTTagCompound)subNBT);
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        NBTTagList list = new NBTTagList();
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            if (this.inventory[i] == null) continue;
            NBTTagCompound subNBT = new NBTTagCompound();
            subNBT.func_74774_a("Slot", (byte)i);
            this.inventory[i].func_77955_b(subNBT);
            list.func_74742_a((NBTBase)subNBT);
        }
        nbt.func_74782_a("Items", (NBTBase)list);
    }

    public int func_70302_i_() {
        return this.inventory.length;
    }

    public ItemStack func_70301_a(int slot) {
        return this.inventory[slot];
    }

    public ItemStack func_70298_a(int slot, int qty) {
        ItemStack stack = this.inventory[slot];
        if (stack != null) {
            if (stack.field_77994_a <= qty) {
                this.inventory[slot] = null;
            } else {
                stack = stack.func_77979_a(qty);
                if (stack.field_77994_a == 0) {
                    this.inventory[slot] = null;
                }
            }
        }
        return stack;
    }

    public ItemStack func_70304_b(int slot) {
        if (this.inventory[slot] != null) {
            ItemStack stack = this.inventory[slot];
            this.inventory[slot] = null;
            return stack;
        }
        return null;
    }

    public void func_70299_a(int slot, ItemStack stack) {
        this.inventory[slot] = stack;
        if (stack != null && stack.field_77994_a > this.func_70297_j_()) {
            stack.field_77994_a = this.func_70297_j_();
        }
        this.func_70296_d();
    }

    public String func_70005_c_() {
        return "pe.relay.mk1";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public IChatComponent func_145748_c_() {
        return new ChatComponentTranslation(this.func_70005_c_(), new Object[0]);
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer var1) {
        return this.field_145850_b.func_175625_s(this.field_174879_c) != this ? false : var1.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    public void func_174889_b(EntityPlayer player) {
        ++this.numUsing;
    }

    public void func_174886_c(EntityPlayer player) {
        --this.numUsing;
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        return true;
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
        Arrays.fill(this.inventory, null);
    }

    public int[] func_180463_a(EnumFacing side) {
        int[] indexes = new int[this.inventory.length - 2];
        int counter = 0;
        int i = 1;
        while (i < this.inventory.length - 1) {
            indexes[counter] = i++;
            counter = (byte)(counter + 1);
        }
        return indexes;
    }

    public boolean func_180462_a(int slot, ItemStack stack, EnumFacing side) {
        return EMCHelper.doesItemHaveEmc(stack);
    }

    public boolean func_180461_b(int slot, ItemStack stack, EnumFacing side) {
        return false;
    }

    @Override
    public double acceptEMC(EnumFacing side, double toAccept) {
        if (this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(side)) instanceof RelayMK1Tile) {
            return 0.0;
        }
        double toAdd = Math.min(this.maximumEMC - this.currentEMC, toAccept);
        this.currentEMC += toAdd;
        return toAdd;
    }

    @Override
    public double provideEMC(EnumFacing side, double toExtract) {
        double toRemove = Math.min(this.currentEMC, toExtract);
        this.currentEMC -= toRemove;
        return toRemove;
    }
}

