/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.network;

import com.google.common.collect.Lists;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import moze_intel.projecte.network.commands.ChangelogCMD;
import moze_intel.projecte.utils.PELogger;
import net.minecraft.client.Minecraft;
import net.minecraft.event.ClickEvent;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.StatCollector;

public class ThreadCheckUpdate
extends Thread {
    private static boolean hasRunServer = false;
    private static boolean hasRunClient = false;
    private final String changelogURL = "https://raw.githubusercontent.com/sinkillerj/ProjectE/master/ChangelogMC18.txt";
    private final String githubURL = "https://github.com/sinkillerj/ProjectE";
    private final String curseURL = "http://minecraft.curseforge.com/mc-mods/226410-projecte/files";
    private boolean isServerSide;

    public ThreadCheckUpdate(boolean isServer) {
        this.isServerSide = isServer;
        this.setName("ProjectE Update Checker " + (isServer ? "Server" : "Client"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        HttpURLConnection connection = null;
        BufferedReader reader = null;
        try {
            connection = (HttpURLConnection)new URL("https://raw.githubusercontent.com/sinkillerj/ProjectE/master/ChangelogMC18.txt").openConnection();
            connection.connect();
            reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            String line = reader.readLine();
            if (line == null) {
                PELogger.logFatal("Update check failed!");
                throw new IOException("No data from github changelog!");
            }
            ArrayList changes = Lists.newArrayList();
            String latestVersion = line.substring(11);
            latestVersion = latestVersion.trim();
            while ((line = reader.readLine()) != null && !line.startsWith("###Version")) {
                if (line.isEmpty()) continue;
                line = line.substring(1).trim();
                changes.add(line);
            }
            if (!"1.8.9-PE1.1.4".equals(latestVersion)) {
                PELogger.logInfo("Mod is outdated! Check http://minecraft.curseforge.com/mc-mods/226410-projecte/files to get the latest version (" + latestVersion + ").");
                for (String s : changes) {
                    PELogger.logInfo(s);
                }
                if (this.isServerSide) {
                    ChangelogCMD.changelog.addAll(changes);
                } else {
                    Minecraft.func_71410_x().field_71439_g.func_145747_a((IChatComponent)new ChatComponentText(String.format(StatCollector.func_74838_a((String)"pe.update.available"), latestVersion)));
                    Minecraft.func_71410_x().field_71439_g.func_145747_a((IChatComponent)new ChatComponentText(StatCollector.func_74838_a((String)"pe.update.getit")));
                    ChatComponentText link = new ChatComponentText("http://minecraft.curseforge.com/mc-mods/226410-projecte/files");
                    link.func_150256_b().func_150241_a(new ClickEvent(ClickEvent.Action.OPEN_URL, "http://minecraft.curseforge.com/mc-mods/226410-projecte/files"));
                    Minecraft.func_71410_x().field_71439_g.func_145747_a((IChatComponent)link);
                    Minecraft.func_71410_x().field_71439_g.func_145747_a((IChatComponent)new ChatComponentText(StatCollector.func_74838_a((String)"pe.update.changelog")));
                }
            } else {
                PELogger.logInfo("Mod is updated.");
            }
        }
        catch (Exception e) {
            PELogger.logFatal("Caught exception in Update Checker thread!");
            e.printStackTrace();
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    PELogger.logFatal("Caught exception in Update Checker thread!");
                    e.printStackTrace();
                }
            }
            if (connection != null) {
                connection.disconnect();
            }
            if (this.isServerSide) {
                hasRunServer = true;
            } else {
                hasRunClient = true;
            }
        }
    }

    public static boolean hasRunServer() {
        return hasRunServer;
    }

    public static boolean hasRunClient() {
        return hasRunClient;
    }
}

