/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.network.packets;

import io.netty.buffer.ByteBuf;
import moze_intel.projecte.gameObjs.tiles.CondenserTile;
import moze_intel.projecte.utils.PELogger;
import net.minecraft.client.Minecraft;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class CondenserSyncPKT
implements IMessage {
    private int displayEmc;
    private int requiredEmc;
    private BlockPos pos;

    public CondenserSyncPKT() {
    }

    public CondenserSyncPKT(int displayEmc, int requiredEmc, CondenserTile tile) {
        this.displayEmc = displayEmc;
        this.requiredEmc = requiredEmc;
        this.pos = tile.func_174877_v();
    }

    public void fromBytes(ByteBuf buf) {
        this.displayEmc = buf.readInt();
        this.requiredEmc = buf.readInt();
        this.pos = BlockPos.func_177969_a((long)buf.readLong());
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.displayEmc);
        buf.writeInt(this.requiredEmc);
        buf.writeLong(this.pos.func_177986_g());
    }

    public static class Handler
    implements IMessageHandler<CondenserSyncPKT, IMessage> {
        public IMessage onMessage(final CondenserSyncPKT pkt, MessageContext ctx) {
            Minecraft.func_71410_x().func_152344_a(new Runnable(){

                @Override
                public void run() {
                    TileEntity tile = Minecraft.func_71410_x().field_71441_e.func_175625_s(pkt.pos);
                    if (tile == null) {
                        PELogger.logFatal("NULL tile entity reference in condenser update packet! Please report to dev!");
                    } else {
                        CondenserTile cond = (CondenserTile)tile;
                        cond.displayEmc = pkt.displayEmc;
                        cond.requiredEmc = pkt.requiredEmc;
                    }
                }
            });
            return null;
        }
    }
}

