/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.network.packets;

import io.netty.buffer.ByteBuf;
import moze_intel.projecte.gameObjs.tiles.RelayMK1Tile;
import moze_intel.projecte.utils.PELogger;
import net.minecraft.client.Minecraft;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class RelaySyncPKT
implements IMessage {
    private int displayEmc;
    private double displayKleinEmc;
    private double displayRawEmc;
    private BlockPos pos;

    public RelaySyncPKT() {
    }

    public RelaySyncPKT(int displayEmc, double displayKleinEmc, double displayRawEmc, RelayMK1Tile tile) {
        this.displayEmc = displayEmc;
        this.displayKleinEmc = displayKleinEmc;
        this.displayRawEmc = displayRawEmc;
        this.pos = tile.func_174877_v();
    }

    public void fromBytes(ByteBuf buf) {
        this.displayEmc = buf.readInt();
        this.displayKleinEmc = buf.readDouble();
        this.displayRawEmc = buf.readDouble();
        this.pos = BlockPos.func_177969_a((long)buf.readLong());
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.displayEmc);
        buf.writeDouble(this.displayKleinEmc);
        buf.writeDouble(this.displayRawEmc);
        buf.writeLong(this.pos.func_177986_g());
    }

    public static class Handler
    implements IMessageHandler<RelaySyncPKT, IMessage> {
        public IMessage onMessage(final RelaySyncPKT pkt, MessageContext ctx) {
            Minecraft.func_71410_x().func_152344_a(new Runnable(){

                @Override
                public void run() {
                    TileEntity tile = Minecraft.func_71410_x().field_71441_e.func_175625_s(pkt.pos);
                    if (tile == null) {
                        PELogger.logFatal("NULL tile entity reference in Relay sync packet! Please report to dev!");
                    } else {
                        RelayMK1Tile relay = (RelayMK1Tile)tile;
                        relay.displayEmc = pkt.displayEmc;
                        relay.displayChargingEmc = pkt.displayKleinEmc;
                        relay.displayRawEmc = pkt.displayRawEmc;
                    }
                }
            });
            return null;
        }
    }
}

