/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.playerData;

import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import moze_intel.projecte.api.event.PlayerKnowledgeChangeEvent;
import moze_intel.projecte.emc.EMCMapper;
import moze_intel.projecte.emc.SimpleStack;
import moze_intel.projecte.network.PacketHandler;
import moze_intel.projecte.network.packets.KnowledgeSyncPKT;
import moze_intel.projecte.playerData.TransmutationProps;
import moze_intel.projecte.utils.EMCHelper;
import moze_intel.projecte.utils.ItemHelper;
import moze_intel.projecte.utils.PELogger;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;

public final class Transmutation {
    private static final List<ItemStack> CACHED_TOME_KNOWLEDGE = Lists.newArrayList();

    public static void clearCache() {
        CACHED_TOME_KNOWLEDGE.clear();
    }

    public static void cacheFullKnowledge() {
        for (SimpleStack stack : EMCMapper.emc.keySet()) {
            if (!stack.isValid()) continue;
            try {
                ItemStack s = stack.toItemStack();
                s.field_77994_a = 1;
                if (!EMCHelper.doesItemHaveEmc(s) || EMCHelper.getEmcValue(s) <= 0 || ItemHelper.containsItemStack(CACHED_TOME_KNOWLEDGE, s)) continue;
                CACHED_TOME_KNOWLEDGE.add(s);
            }
            catch (Exception e) {
                PELogger.logInfo("Failed to cache knowledge for " + stack + ": " + e.toString());
            }
        }
    }

    public static List<ItemStack> getKnowledge(EntityPlayer player) {
        TransmutationProps data = TransmutationProps.getDataFor(player);
        return data.getKnowledge();
    }

    public static void addKnowledge(ItemStack stack, EntityPlayer player) {
        TransmutationProps data = TransmutationProps.getDataFor(player);
        if (!Transmutation.hasKnowledgeForStack(stack, player)) {
            data.getKnowledge().add(stack);
            if (!player.field_70170_p.field_72995_K) {
                MinecraftForge.EVENT_BUS.post((Event)new PlayerKnowledgeChangeEvent(player));
            }
        }
    }

    public static void removeKnowledge(ItemStack stack, EntityPlayer player) {
        TransmutationProps data = TransmutationProps.getDataFor(player);
        if (Transmutation.hasKnowledgeForStack(stack, player)) {
            Iterator<ItemStack> iter = data.getKnowledge().iterator();
            while (iter.hasNext()) {
                if (!ItemStack.func_77989_b((ItemStack)stack, (ItemStack)iter.next())) continue;
                iter.remove();
                if (player.field_70170_p.field_72995_K) break;
                MinecraftForge.EVENT_BUS.post((Event)new PlayerKnowledgeChangeEvent(player));
                break;
            }
        }
    }

    public static void setInputsAndLocks(ItemStack[] stacks, EntityPlayer player) {
        TransmutationProps data = TransmutationProps.getDataFor(player);
        data.setInputLocks(stacks);
    }

    public static ItemStack[] getInputsAndLock(EntityPlayer player) {
        ItemStack[] locks = TransmutationProps.getDataFor(player).getInputLocks();
        return Arrays.copyOf(locks, locks.length);
    }

    public static boolean hasKnowledgeForStack(ItemStack stack, EntityPlayer player) {
        TransmutationProps data = TransmutationProps.getDataFor(player);
        for (ItemStack s : data.getKnowledge()) {
            if (!ItemHelper.basicAreStacksEqual(s, stack)) continue;
            return true;
        }
        return false;
    }

    public static void setFullKnowledge(EntityPlayer player) {
        TransmutationProps.getDataFor(player).getKnowledge().clear();
        TransmutationProps.getDataFor(player).getKnowledge().addAll(CACHED_TOME_KNOWLEDGE);
        if (!player.field_70170_p.field_72995_K) {
            MinecraftForge.EVENT_BUS.post((Event)new PlayerKnowledgeChangeEvent(player));
        }
    }

    public static void clearKnowledge(EntityPlayer player) {
        TransmutationProps data = TransmutationProps.getDataFor(player);
        data.getKnowledge().clear();
        if (!player.field_70170_p.field_72995_K) {
            MinecraftForge.EVENT_BUS.post((Event)new PlayerKnowledgeChangeEvent(player));
        }
    }

    public static double getEmc(EntityPlayer player) {
        return TransmutationProps.getDataFor(player).getTransmutationEmc();
    }

    public static void setEmc(EntityPlayer player, double emc) {
        TransmutationProps.getDataFor(player).setTransmutationEmc(emc);
    }

    public static void sync(EntityPlayer player) {
        PacketHandler.sendTo(new KnowledgeSyncPKT(TransmutationProps.getDataFor(player).saveForPacket()), (EntityPlayerMP)player);
        PELogger.logDebug("** SENT TRANSMUTATION DATA **");
    }
}

