/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.utils;

import baubles.api.BaublesApi;
import moze_intel.projecte.gameObjs.items.ItemPE;
import moze_intel.projecte.network.PacketHandler;
import moze_intel.projecte.network.packets.SetFlyPKT;
import moze_intel.projecte.network.packets.StepHeightPKT;
import moze_intel.projecte.network.packets.SwingItemPKT;
import moze_intel.projecte.utils.ReflectionHelper;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraft.world.WorldSettings;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.eventhandler.Event;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public final class PlayerHelper {
    public static boolean checkedPlaceBlock(EntityPlayerMP player, BlockPos pos, IBlockState state) {
        if (!PlayerHelper.hasEditPermission(player, pos)) {
            return false;
        }
        World world = player.field_70170_p;
        BlockSnapshot before = BlockSnapshot.getBlockSnapshot((World)world, (BlockPos)pos);
        world.func_175656_a(pos, state);
        BlockEvent.PlaceEvent evt = new BlockEvent.PlaceEvent(before, Blocks.field_150350_a.func_176223_P(), (EntityPlayer)player);
        MinecraftForge.EVENT_BUS.post((Event)evt);
        if (evt.isCanceled()) {
            world.restoringBlockSnapshots = true;
            before.restore(true, false);
            world.restoringBlockSnapshots = false;
            return false;
        }
        return true;
    }

    public static boolean checkedReplaceBlock(EntityPlayerMP player, BlockPos pos, IBlockState state) {
        return PlayerHelper.hasBreakPermission(player, pos) && PlayerHelper.checkedPlaceBlock(player, pos, state);
    }

    public static ItemStack findFirstItem(EntityPlayer player, ItemPE consumeFrom) {
        for (ItemStack s : player.field_71071_by.field_70462_a) {
            if (s == null || s.func_77973_b() != consumeFrom) continue;
            return s;
        }
        return null;
    }

    public static IInventory getBaubles(EntityPlayer player) {
        if (!Loader.isModLoaded((String)"Baubles")) {
            return null;
        }
        return BaublesApi.getBaubles((EntityPlayer)player);
    }

    public static BlockPos getBlockLookingAt(EntityPlayer player, double maxDistance) {
        Pair<Vec3, Vec3> vecs = PlayerHelper.getLookVec(player, maxDistance);
        MovingObjectPosition mop = player.field_70170_p.func_72933_a((Vec3)vecs.getLeft(), (Vec3)vecs.getRight());
        if (mop != null && mop.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
            return mop.func_178782_a();
        }
        return null;
    }

    public static Pair<Vec3, Vec3> getLookVec(EntityPlayer player, double maxDistance) {
        Vec3 look = player.func_70676_i(1.0f);
        Vec3 playerPos = new Vec3(player.field_70165_t, player.field_70163_u + (double)(player.func_70047_e() - player.getDefaultEyeHeight()), player.field_70161_v);
        Vec3 src = playerPos.func_72441_c(0.0, (double)player.func_70047_e(), 0.0);
        Vec3 dest = src.func_72441_c(look.field_72450_a * maxDistance, look.field_72448_b * maxDistance, look.field_72449_c * maxDistance);
        return ImmutablePair.of((Object)src, (Object)dest);
    }

    public static boolean hasBreakPermission(EntityPlayerMP player, BlockPos pos) {
        return PlayerHelper.hasEditPermission(player, pos) && ForgeHooks.onBlockBreakEvent((World)player.field_70170_p, (WorldSettings.GameType)player.field_71134_c.func_73081_b(), (EntityPlayerMP)player, (BlockPos)pos) != -1;
    }

    public static boolean hasEditPermission(EntityPlayerMP player, BlockPos pos) {
        return player.func_175151_a(pos, EnumFacing.NORTH, null) && !MinecraftServer.func_71276_C().func_175579_a(player.field_70170_p, pos, (EntityPlayer)player);
    }

    public static void setPlayerFireImmunity(EntityPlayer player, boolean value) {
        ReflectionHelper.setEntityFireImmunity((Entity)player, value);
    }

    public static void setPlayerWalkSpeed(EntityPlayer player, float value) {
        ReflectionHelper.setPlayerCapabilityWalkspeed(player.field_71075_bZ, value);
    }

    public static void swingItem(EntityPlayer player) {
        if (player instanceof EntityPlayerMP) {
            PacketHandler.sendTo(new SwingItemPKT(), (EntityPlayerMP)player);
        }
    }

    public static void updateClientServerFlight(EntityPlayerMP player, boolean state) {
        PacketHandler.sendTo(new SetFlyPKT(state), player);
        player.field_71075_bZ.field_75101_c = state;
        if (!state) {
            player.field_71075_bZ.field_75100_b = false;
        }
    }

    public static void updateClientServerStepHeight(EntityPlayerMP player, float value) {
        player.field_70138_W = value;
        PacketHandler.sendTo(new StepHeightPKT(value), player);
    }
}

