/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.utils;

import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.BlockColored;
import net.minecraft.block.BlockNewLeaf;
import net.minecraft.block.BlockNewLog;
import net.minecraft.block.BlockOldLeaf;
import net.minecraft.block.BlockOldLog;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.BlockPumpkin;
import net.minecraft.block.BlockSapling;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public final class WorldTransmutations {
    private static final Map<IBlockState, Pair<IBlockState, IBlockState>> MAP;

    private static IBlockState cyclePropertyBackwards(IBlockState state, IProperty property) {
        IBlockState result = state;
        for (int i = 0; i < property.func_177700_c().size() - 1; ++i) {
            result = result.func_177231_a(property);
        }
        return result;
    }

    public static IBlockState getWorldTransmutation(World world, BlockPos pos, boolean isSneaking) {
        return WorldTransmutations.getWorldTransmutation(world.func_180495_p(pos), isSneaking);
    }

    public static IBlockState getWorldTransmutation(IBlockState current, boolean isSneaking) {
        if (MAP.containsKey(current)) {
            Pair<IBlockState, IBlockState> result = MAP.get(current);
            return isSneaking ? (result.getRight() == null ? (IBlockState)result.getLeft() : (IBlockState)result.getRight()) : (IBlockState)result.getLeft();
        }
        return null;
    }

    public static Map<IBlockState, Pair<IBlockState, IBlockState>> getWorldTransmutations() {
        return Collections.unmodifiableMap(MAP);
    }

    public static void register(IBlockState from, IBlockState result, IBlockState altResult) {
        MAP.put(from, (Pair<IBlockState, IBlockState>)ImmutablePair.of((Object)result, (Object)altResult));
    }

    public static void registerDefault(Block from, Block result, Block altResult) {
        MAP.put(from.func_176223_P(), (Pair<IBlockState, IBlockState>)ImmutablePair.of((Object)result.func_176223_P(), (Object)(altResult == null ? null : altResult.func_176223_P())));
    }

    static {
        IBlockState state;
        MAP = Maps.newHashMap();
        WorldTransmutations.registerDefault(Blocks.field_150348_b, Blocks.field_150347_e, (Block)Blocks.field_150349_c);
        WorldTransmutations.registerDefault(Blocks.field_150347_e, Blocks.field_150348_b, (Block)Blocks.field_150349_c);
        WorldTransmutations.registerDefault((Block)Blocks.field_150349_c, (Block)Blocks.field_150354_m, Blocks.field_150347_e);
        WorldTransmutations.registerDefault(Blocks.field_150346_d, (Block)Blocks.field_150354_m, Blocks.field_150347_e);
        WorldTransmutations.registerDefault((Block)Blocks.field_150354_m, (Block)Blocks.field_150349_c, Blocks.field_150347_e);
        WorldTransmutations.registerDefault(Blocks.field_150351_n, Blocks.field_150322_A, null);
        WorldTransmutations.registerDefault(Blocks.field_150322_A, Blocks.field_150351_n, null);
        WorldTransmutations.registerDefault((Block)Blocks.field_150355_j, Blocks.field_150432_aD, null);
        WorldTransmutations.registerDefault(Blocks.field_150432_aD, (Block)Blocks.field_150355_j, null);
        WorldTransmutations.registerDefault((Block)Blocks.field_150353_l, Blocks.field_150343_Z, null);
        WorldTransmutations.registerDefault(Blocks.field_150343_Z, (Block)Blocks.field_150353_l, null);
        WorldTransmutations.register(Blocks.field_150440_ba.func_176223_P(), Blocks.field_150423_aK.func_176223_P().func_177226_a((IProperty)BlockPumpkin.field_176387_N, (Comparable)EnumFacing.SOUTH), null);
        for (EnumFacing enumFacing : EnumFacing.field_176754_o) {
            WorldTransmutations.register(Blocks.field_150423_aK.func_176223_P().func_177226_a((IProperty)BlockPumpkin.field_176387_N, (Comparable)enumFacing), Blocks.field_150440_ba.func_176223_P(), null);
        }
        WorldTransmutations.register(Blocks.field_150364_r.func_176223_P().func_177226_a((IProperty)BlockOldLog.field_176301_b, (Comparable)BlockPlanks.EnumType.OAK), Blocks.field_150364_r.func_176223_P().func_177226_a((IProperty)BlockOldLog.field_176301_b, (Comparable)BlockPlanks.EnumType.SPRUCE), Blocks.field_150363_s.func_176223_P().func_177226_a((IProperty)BlockNewLog.field_176300_b, (Comparable)BlockPlanks.EnumType.DARK_OAK));
        WorldTransmutations.register(Blocks.field_150362_t.func_176223_P().func_177226_a((IProperty)BlockOldLeaf.field_176239_P, (Comparable)BlockPlanks.EnumType.OAK), Blocks.field_150362_t.func_176223_P().func_177226_a((IProperty)BlockOldLeaf.field_176239_P, (Comparable)BlockPlanks.EnumType.SPRUCE), Blocks.field_150361_u.func_176223_P().func_177226_a((IProperty)BlockNewLeaf.field_176240_P, (Comparable)BlockPlanks.EnumType.DARK_OAK));
        for (int i = 1; i < 3; ++i) {
            WorldTransmutations.register(Blocks.field_150364_r.func_176203_a(i), Blocks.field_150364_r.func_176203_a(i + 1), Blocks.field_150364_r.func_176203_a(i - 1));
            WorldTransmutations.register(Blocks.field_150362_t.func_176203_a(i), Blocks.field_150362_t.func_176203_a(i + 1), Blocks.field_150362_t.func_176203_a(i - 1));
        }
        WorldTransmutations.register(Blocks.field_150364_r.func_176223_P().func_177226_a((IProperty)BlockOldLog.field_176301_b, (Comparable)BlockPlanks.EnumType.JUNGLE), Blocks.field_150363_s.func_176223_P().func_177226_a((IProperty)BlockNewLog.field_176300_b, (Comparable)BlockPlanks.EnumType.ACACIA), Blocks.field_150364_r.func_176223_P().func_177226_a((IProperty)BlockOldLog.field_176301_b, (Comparable)BlockPlanks.EnumType.BIRCH));
        WorldTransmutations.register(Blocks.field_150362_t.func_176223_P().func_177226_a((IProperty)BlockOldLeaf.field_176239_P, (Comparable)BlockPlanks.EnumType.JUNGLE), Blocks.field_150361_u.func_176223_P().func_177226_a((IProperty)BlockNewLeaf.field_176240_P, (Comparable)BlockPlanks.EnumType.ACACIA), Blocks.field_150362_t.func_176223_P().func_177226_a((IProperty)BlockOldLeaf.field_176239_P, (Comparable)BlockPlanks.EnumType.BIRCH));
        WorldTransmutations.register(Blocks.field_150363_s.func_176223_P().func_177226_a((IProperty)BlockNewLog.field_176300_b, (Comparable)BlockPlanks.EnumType.ACACIA), Blocks.field_150363_s.func_176223_P().func_177226_a((IProperty)BlockNewLog.field_176300_b, (Comparable)BlockPlanks.EnumType.DARK_OAK), Blocks.field_150364_r.func_176223_P().func_177226_a((IProperty)BlockOldLog.field_176301_b, (Comparable)BlockPlanks.EnumType.JUNGLE));
        WorldTransmutations.register(Blocks.field_150361_u.func_176223_P().func_177226_a((IProperty)BlockNewLeaf.field_176240_P, (Comparable)BlockPlanks.EnumType.ACACIA), Blocks.field_150361_u.func_176223_P().func_177226_a((IProperty)BlockNewLeaf.field_176240_P, (Comparable)BlockPlanks.EnumType.DARK_OAK), Blocks.field_150362_t.func_176223_P().func_177226_a((IProperty)BlockOldLeaf.field_176239_P, (Comparable)BlockPlanks.EnumType.JUNGLE));
        WorldTransmutations.register(Blocks.field_150363_s.func_176223_P().func_177226_a((IProperty)BlockNewLog.field_176300_b, (Comparable)BlockPlanks.EnumType.DARK_OAK), Blocks.field_150364_r.func_176223_P().func_177226_a((IProperty)BlockOldLog.field_176301_b, (Comparable)BlockPlanks.EnumType.OAK), Blocks.field_150363_s.func_176223_P().func_177226_a((IProperty)BlockNewLog.field_176300_b, (Comparable)BlockPlanks.EnumType.ACACIA));
        WorldTransmutations.register(Blocks.field_150361_u.func_176223_P().func_177226_a((IProperty)BlockNewLeaf.field_176240_P, (Comparable)BlockPlanks.EnumType.DARK_OAK), Blocks.field_150362_t.func_176223_P().func_177226_a((IProperty)BlockOldLeaf.field_176239_P, (Comparable)BlockPlanks.EnumType.OAK), Blocks.field_150361_u.func_176223_P().func_177226_a((IProperty)BlockNewLeaf.field_176240_P, (Comparable)BlockPlanks.EnumType.ACACIA));
        for (BlockPlanks.EnumType enumType : BlockPlanks.EnumType.values()) {
            state = Blocks.field_150345_g.func_176223_P().func_177226_a((IProperty)BlockSapling.field_176480_a, (Comparable)enumType);
            WorldTransmutations.register(state, state.func_177231_a((IProperty)BlockSapling.field_176480_a), WorldTransmutations.cyclePropertyBackwards(state, (IProperty)BlockSapling.field_176480_a));
        }
        for (BlockPlanks.EnumType enumType : EnumDyeColor.values()) {
            state = Blocks.field_150325_L.func_176223_P().func_177226_a((IProperty)BlockColored.field_176581_a, (Comparable)enumType);
            WorldTransmutations.register(state, state.func_177231_a((IProperty)BlockColored.field_176581_a), WorldTransmutations.cyclePropertyBackwards(state, (IProperty)BlockColored.field_176581_a));
        }
    }
}

