/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.model;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.EnumMap;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nullable;
import javax.vecmath.Matrix4f;
import javax.vecmath.Tuple4f;
import javax.vecmath.Vector4f;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.PerspectiveMapWrapper;
import net.minecraftforge.client.model.pipeline.UnpackedBakedQuad;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;
import org.apache.commons.lang3.tuple.Pair;

public final class ItemLayerModel
implements IModel {
    public static final ItemLayerModel INSTANCE = new ItemLayerModel((ImmutableList<nf>)ImmutableList.of());
    private static final fa[] HORIZONTALS = new fa[]{fa.b, fa.a};
    private static final fa[] VERTICALS = new fa[]{fa.e, fa.f};
    private final ImmutableList<nf> textures;
    private final bwa overrides;

    public ItemLayerModel(ImmutableList<nf> textures) {
        this(textures, bwa.a);
    }

    public ItemLayerModel(ImmutableList<nf> textures, bwa overrides) {
        this.textures = textures;
        this.overrides = overrides;
    }

    public ItemLayerModel(bvu model) {
        this(ItemLayerModel.getTextures(model), model.g());
    }

    private static ImmutableList<nf> getTextures(bvu model) {
        ImmutableList.Builder builder = ImmutableList.builder();
        int i2 = 0;
        while (model.b("layer" + i2)) {
            builder.add((Object)new nf(model.c("layer" + i2)));
            ++i2;
        }
        return builder.build();
    }

    @Override
    public Collection<nf> getTextures() {
        return this.textures;
    }

    @Override
    public ItemLayerModel retexture(ImmutableMap<String, String> textures) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (int i2 = 0; i2 < textures.size() + this.textures.size(); ++i2) {
            if (textures.containsKey((Object)("layer" + i2))) {
                builder.add((Object)new nf((String)textures.get((Object)("layer" + i2))));
                continue;
            }
            if (i2 >= this.textures.size()) continue;
            builder.add(this.textures.get(i2));
        }
        return new ItemLayerModel((ImmutableList<nf>)builder.build(), this.overrides);
    }

    @Override
    public cfy bake(IModelState state, cea format, Function<nf, cdq> bakedTextureGetter) {
        ImmutableList.Builder builder = ImmutableList.builder();
        Optional<TRSRTransformation> transform = state.apply(Optional.empty());
        for (int i2 = 0; i2 < this.textures.size(); ++i2) {
            cdq sprite = bakedTextureGetter.apply((nf)this.textures.get(i2));
            builder.addAll(ItemLayerModel.getQuadsForSprite(i2, sprite, format, transform));
        }
        cdq particle = bakedTextureGetter.apply(this.textures.isEmpty() ? new nf("missingno") : (nf)this.textures.get(0));
        ImmutableMap<bwc.b, TRSRTransformation> map = PerspectiveMapWrapper.getTransforms(state);
        return new BakedItemModel((ImmutableList<bvp>)builder.build(), particle, map, this.overrides, null);
    }

    public static ImmutableList<bvp> getQuadsForSprite(int tint, cdq sprite, cea format, Optional<TRSRTransformation> transform) {
        int off;
        int off2;
        boolean face;
        boolean building;
        int u;
        int v;
        ImmutableList.Builder builder = ImmutableList.builder();
        int uMax = sprite.c();
        int vMax = sprite.d();
        FaceData faceData = new FaceData(uMax, vMax);
        for (int f = 0; f < sprite.k(); ++f) {
            int[] pixels = sprite.a(f)[0];
            boolean[] ptv = new boolean[uMax];
            Arrays.fill(ptv, true);
            for (v = 0; v < vMax; ++v) {
                boolean ptu = true;
                for (int u2 = 0; u2 < uMax; ++u2) {
                    boolean t = ItemLayerModel.isTransparent(pixels, uMax, vMax, u2, v);
                    if (ptu && !t) {
                        faceData.set(fa.e, u2, v);
                    }
                    if (!ptu && t) {
                        faceData.set(fa.f, u2 - 1, v);
                    }
                    if (ptv[u2] && !t) {
                        faceData.set(fa.b, u2, v);
                    }
                    if (!ptv[u2] && t) {
                        faceData.set(fa.a, u2, v - 1);
                    }
                    ptu = t;
                    ptv[u2] = t;
                }
                if (ptu) continue;
                faceData.set(fa.f, uMax - 1, v);
            }
            for (u = 0; u < uMax; ++u) {
                if (ptv[u]) continue;
                faceData.set(fa.a, u, vMax - 1);
            }
        }
        for (fa facing : HORIZONTALS) {
            for (v = 0; v < vMax; ++v) {
                int uStart = 0;
                building = false;
                for (int u3 = 0; u3 < uMax; ++u3) {
                    face = faceData.get(facing, u3, v);
                    if (building && !face) {
                        off2 = facing == fa.a ? 1 : 0;
                        builder.add((Object)ItemLayerModel.buildSideQuad(format, transform, facing, tint, sprite, uStart, v + off2, u3 - uStart));
                        building = false;
                        continue;
                    }
                    if (building || !face) continue;
                    building = true;
                    uStart = u3;
                }
                if (!building) continue;
                off = facing == fa.a ? 1 : 0;
                builder.add((Object)ItemLayerModel.buildSideQuad(format, transform, facing, tint, sprite, uStart, v + off, uMax - uStart));
            }
        }
        for (fa facing : VERTICALS) {
            for (u = 0; u < uMax; ++u) {
                int vStart = 0;
                building = false;
                for (int v2 = 0; v2 < vMax; ++v2) {
                    face = faceData.get(facing, u, v2);
                    if (building && !face) {
                        off2 = facing == fa.f ? 1 : 0;
                        builder.add((Object)ItemLayerModel.buildSideQuad(format, transform, facing, tint, sprite, u + off2, vStart, v2 - vStart));
                        building = false;
                        continue;
                    }
                    if (building || !face) continue;
                    building = true;
                    vStart = v2;
                }
                if (!building) continue;
                off = facing == fa.f ? 1 : 0;
                builder.add((Object)ItemLayerModel.buildSideQuad(format, transform, facing, tint, sprite, u + off, vStart, vMax - vStart));
            }
        }
        builder.add((Object)ItemLayerModel.buildQuad(format, transform, fa.c, sprite, tint, 0.0f, 0.0f, 0.46875f, sprite.e(), sprite.h(), 0.0f, 1.0f, 0.46875f, sprite.e(), sprite.g(), 1.0f, 1.0f, 0.46875f, sprite.f(), sprite.g(), 1.0f, 0.0f, 0.46875f, sprite.f(), sprite.h()));
        builder.add((Object)ItemLayerModel.buildQuad(format, transform, fa.d, sprite, tint, 0.0f, 0.0f, 0.53125f, sprite.e(), sprite.h(), 1.0f, 0.0f, 0.53125f, sprite.f(), sprite.h(), 1.0f, 1.0f, 0.53125f, sprite.f(), sprite.g(), 0.0f, 1.0f, 0.53125f, sprite.e(), sprite.g()));
        return builder.build();
    }

    private static boolean isTransparent(int[] pixels, int uMax, int vMax, int u, int v) {
        return (pixels[u + (vMax - 1 - v) * uMax] >> 24 & 0xFF) == 0;
    }

    private static bvp buildSideQuad(cea format, Optional<TRSRTransformation> transform, fa side, int tint, cdq sprite, int u, int v, int size) {
        float eps0 = 3.0E-4f;
        float eps1 = 4.5E-4f;
        float eps2 = 0.5f;
        float eps3 = 0.5f;
        float x0 = (float)u / (float)sprite.c();
        float y0 = (float)v / (float)sprite.d();
        float x1 = x0;
        float y1 = y0;
        float z1 = 0.4683f;
        float z2 = 0.5317f;
        switch (side) {
            case e: {
                z1 = 0.5317f;
                z2 = 0.4683f;
            }
            case f: {
                y1 = (float)(v + size) / (float)sprite.d();
                break;
            }
            case a: {
                z1 = 0.5317f;
                z2 = 0.4683f;
            }
            case b: {
                x1 = (float)(u + size) / (float)sprite.c();
                break;
            }
            default: {
                throw new IllegalArgumentException("can't handle z-oriented side");
            }
        }
        float u0 = 16.0f * (x0 - (float)side.n().p() * 0.5f / (float)sprite.c());
        float u1 = 16.0f * (x1 - (float)side.n().p() * 0.5f / (float)sprite.c());
        float v0 = 16.0f * (1.0f - y0 - (float)side.n().q() * 0.5f / (float)sprite.d());
        float v1 = 16.0f * (1.0f - y1 - (float)side.n().q() * 0.5f / (float)sprite.d());
        switch (side) {
            case e: 
            case f: {
                y0 -= 4.5E-4f;
                y1 += 4.5E-4f;
                v0 -= 0.5f / (float)sprite.d();
                v1 += 0.5f / (float)sprite.d();
                break;
            }
            case a: 
            case b: {
                x0 -= 4.5E-4f;
                x1 += 4.5E-4f;
                u0 += 0.5f / (float)sprite.c();
                u1 -= 0.5f / (float)sprite.c();
                break;
            }
            default: {
                throw new IllegalArgumentException("can't handle z-oriented side");
            }
        }
        switch (side) {
            case e: {
                x0 += 3.0E-4f;
                x1 += 3.0E-4f;
                break;
            }
            case f: {
                x0 -= 3.0E-4f;
                x1 -= 3.0E-4f;
                break;
            }
            case a: {
                y0 -= 3.0E-4f;
                y1 -= 3.0E-4f;
                break;
            }
            case b: {
                y0 += 3.0E-4f;
                y1 += 3.0E-4f;
                break;
            }
            default: {
                throw new IllegalArgumentException("can't handle z-oriented side");
            }
        }
        return ItemLayerModel.buildQuad(format, transform, side.d(), sprite, tint, x0, y0, z1, sprite.a((double)u0), sprite.b((double)v0), x1, y1, z1, sprite.a((double)u1), sprite.b((double)v1), x1, y1, z2, sprite.a((double)u1), sprite.b((double)v1), x0, y0, z2, sprite.a((double)u0), sprite.b((double)v0));
    }

    private static final bvp buildQuad(cea format, Optional<TRSRTransformation> transform, fa side, cdq sprite, int tint, float x0, float y0, float z0, float u0, float v0, float x1, float y1, float z1, float u1, float v1, float x2, float y2, float z2, float u2, float v2, float x3, float y3, float z3, float u3, float v3) {
        UnpackedBakedQuad.Builder builder = new UnpackedBakedQuad.Builder(format);
        builder.setQuadTint(tint);
        builder.setQuadOrientation(side);
        builder.setTexture(sprite);
        ItemLayerModel.putVertex(builder, format, transform, side, x0, y0, z0, u0, v0);
        ItemLayerModel.putVertex(builder, format, transform, side, x1, y1, z1, u1, v1);
        ItemLayerModel.putVertex(builder, format, transform, side, x2, y2, z2, u2, v2);
        ItemLayerModel.putVertex(builder, format, transform, side, x3, y3, z3, u3, v3);
        return builder.build();
    }

    private static void putVertex(UnpackedBakedQuad.Builder builder, cea format, Optional<TRSRTransformation> transform, fa side, float x, float y, float z, float u, float v) {
        Vector4f vec = new Vector4f();
        block6: for (int e = 0; e < format.i(); ++e) {
            switch (format.c(e).b()) {
                case a: {
                    if (transform.isPresent()) {
                        vec.x = x;
                        vec.y = y;
                        vec.z = z;
                        vec.w = 1.0f;
                        transform.get().getMatrix().transform((Tuple4f)vec);
                        builder.put(e, vec.x, vec.y, vec.z, vec.w);
                        continue block6;
                    }
                    builder.put(e, x, y, z, 1.0f);
                    continue block6;
                }
                case c: {
                    builder.put(e, 1.0f, 1.0f, 1.0f, 1.0f);
                    continue block6;
                }
                case d: {
                    if (format.c(e).d() == 0) {
                        builder.put(e, u, v, 0.0f, 1.0f);
                        continue block6;
                    }
                }
                case b: {
                    builder.put(e, side.g(), side.h(), side.i(), 0.0f);
                    continue block6;
                }
                default: {
                    builder.put(e, new float[0]);
                }
            }
        }
    }

    public static enum Loader implements ICustomModelLoader
    {
        INSTANCE;


        public void a(cep resourceManager) {
        }

        @Override
        public boolean accepts(nf modelLocation) {
            return modelLocation.b().equals("forge") && (modelLocation.a().equals("item-layer") || modelLocation.a().equals("models/block/item-layer") || modelLocation.a().equals("models/item/item-layer"));
        }

        @Override
        public IModel loadModel(nf modelLocation) {
            return INSTANCE;
        }
    }

    private static class FaceData {
        private final EnumMap<fa, BitSet> data = new EnumMap(fa.class);
        private final int vMax;

        FaceData(int uMax, int vMax) {
            this.vMax = vMax;
            this.data.put(fa.e, new BitSet(uMax * vMax));
            this.data.put(fa.f, new BitSet(uMax * vMax));
            this.data.put(fa.b, new BitSet(uMax * vMax));
            this.data.put(fa.a, new BitSet(uMax * vMax));
        }

        public void set(fa facing, int u, int v) {
            this.data.get(facing).set(this.getIndex(u, v));
        }

        public boolean get(fa facing, int u, int v) {
            return this.data.get(facing).get(this.getIndex(u, v));
        }

        private int getIndex(int u, int v) {
            return v * this.vMax + u;
        }
    }

    private static final class BakedItemModel
    implements cfy {
        private final ImmutableList<bvp> quads;
        private final cdq particle;
        private final ImmutableMap<bwc.b, TRSRTransformation> transforms;
        private final cfy otherModel;
        private final boolean isCulled;
        private final bwa overrides;

        public BakedItemModel(ImmutableList<bvp> quads, cdq particle, ImmutableMap<bwc.b, TRSRTransformation> transforms, bwa overrides, @Nullable cfy otherModel) {
            this.quads = quads;
            this.particle = particle;
            this.transforms = transforms;
            this.overrides = overrides;
            if (otherModel != null) {
                this.otherModel = otherModel;
                this.isCulled = true;
            } else {
                ImmutableList.Builder builder = ImmutableList.builder();
                for (bvp quad : quads) {
                    if (quad.e() != fa.d) continue;
                    builder.add((Object)quad);
                }
                this.otherModel = new BakedItemModel((ImmutableList<bvp>)builder.build(), particle, transforms, overrides, this);
                this.isCulled = false;
            }
        }

        public boolean a() {
            return true;
        }

        public boolean b() {
            return false;
        }

        public boolean c() {
            return false;
        }

        public cdq d() {
            return this.particle;
        }

        public bwa f() {
            return this.overrides;
        }

        public List<bvp> a(@Nullable awt state, @Nullable fa side, long rand) {
            if (side == null) {
                return this.quads;
            }
            return ImmutableList.of();
        }

        public Pair<? extends cfy, Matrix4f> handlePerspective(bwc.b type) {
            Pair<? extends cfy, Matrix4f> pair = PerspectiveMapWrapper.handlePerspective((cfy)this, this.transforms, type);
            if (type == bwc.b.g && !this.isCulled && pair.getRight() == null) {
                return Pair.of((Object)this.otherModel, null);
            }
            if (type != bwc.b.g && this.isCulled) {
                return Pair.of((Object)this.otherModel, (Object)pair.getRight());
            }
            return pair;
        }
    }
}

