/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.model;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nullable;
import javax.vecmath.Matrix4f;
import javax.vecmath.Quat4f;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ItemLayerModel;
import net.minecraftforge.client.model.ItemTextureQuadConverter;
import net.minecraftforge.client.model.ModelStateComposition;
import net.minecraftforge.client.model.PerspectiveMapWrapper;
import net.minecraftforge.client.model.SimpleModelState;
import net.minecraftforge.common.model.IModelPart;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import org.apache.commons.lang3.tuple.Pair;

public final class ModelDynBucket
implements IModel {
    public static final cgd LOCATION = new cgd(new nf("forge", "dynbucket"), "inventory");
    private static final float NORTH_Z_BASE = 0.4685f;
    private static final float SOUTH_Z_BASE = 0.5315f;
    private static final float NORTH_Z_FLUID = 0.468625f;
    private static final float SOUTH_Z_FLUID = 0.531375f;
    public static final IModel MODEL = new ModelDynBucket();
    @Nullable
    private final nf baseLocation;
    @Nullable
    private final nf liquidLocation;
    @Nullable
    private final nf coverLocation;
    @Nullable
    private final Fluid fluid;
    private final boolean flipGas;

    public ModelDynBucket() {
        this(null, null, null, null, false);
    }

    public ModelDynBucket(@Nullable nf baseLocation, @Nullable nf liquidLocation, @Nullable nf coverLocation, @Nullable Fluid fluid, boolean flipGas) {
        this.baseLocation = baseLocation;
        this.liquidLocation = liquidLocation;
        this.coverLocation = coverLocation;
        this.fluid = fluid;
        this.flipGas = flipGas;
    }

    @Override
    public Collection<nf> getTextures() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        if (this.baseLocation != null) {
            builder.add((Object)this.baseLocation);
        }
        if (this.liquidLocation != null) {
            builder.add((Object)this.liquidLocation);
        }
        if (this.coverLocation != null) {
            builder.add((Object)this.coverLocation);
        }
        return builder.build();
    }

    @Override
    public cfy bake(IModelState state, cea format, Function<nf, cdq> bakedTextureGetter) {
        ImmutableMap<bwc.b, TRSRTransformation> transformMap = PerspectiveMapWrapper.getTransforms(state);
        if (this.flipGas && this.fluid != null && this.fluid.isGaseous()) {
            state = new ModelStateComposition(state, TRSRTransformation.blockCenterToCorner(new TRSRTransformation(null, new Quat4f(0.0f, 0.0f, 1.0f, 0.0f), null, null)));
        }
        TRSRTransformation transform = state.apply(Optional.empty()).orElse(TRSRTransformation.identity());
        cdq fluidSprite = null;
        ImmutableList.Builder builder = ImmutableList.builder();
        if (this.fluid != null) {
            fluidSprite = bakedTextureGetter.apply(this.fluid.getStill());
        }
        if (this.baseLocation != null) {
            cfy model = new ItemLayerModel((ImmutableList<nf>)ImmutableList.of((Object)this.baseLocation)).bake(state, format, bakedTextureGetter);
            builder.addAll((Iterable)model.a(null, null, 0L));
        }
        if (this.liquidLocation != null && fluidSprite != null) {
            cdq liquid = bakedTextureGetter.apply(this.liquidLocation);
            builder.addAll(ItemTextureQuadConverter.convertTexture(format, transform, liquid, fluidSprite, 0.468625f, fa.c, this.fluid.getColor()));
            builder.addAll(ItemTextureQuadConverter.convertTexture(format, transform, liquid, fluidSprite, 0.531375f, fa.d, this.fluid.getColor()));
        }
        if (this.coverLocation != null) {
            cdq base = bakedTextureGetter.apply(this.coverLocation);
            builder.add((Object)ItemTextureQuadConverter.genQuad(format, transform, 0.0f, 0.0f, 16.0f, 16.0f, 0.4685f, base, fa.c, -1));
            builder.add((Object)ItemTextureQuadConverter.genQuad(format, transform, 0.0f, 0.0f, 16.0f, 16.0f, 0.5315f, base, fa.d, -1));
        }
        return new BakedDynBucket(this, (ImmutableList<bvp>)builder.build(), fluidSprite, format, (ImmutableMap<bwc.b, TRSRTransformation>)Maps.immutableEnumMap(transformMap), Maps.newHashMap());
    }

    @Override
    public ModelDynBucket process(ImmutableMap<String, String> customData) {
        String fluidName = (String)customData.get((Object)"fluid");
        Fluid fluid = FluidRegistry.getFluid(fluidName);
        if (fluid == null) {
            fluid = this.fluid;
        }
        boolean flip = this.flipGas;
        if (customData.containsKey((Object)"flipGas")) {
            String flipStr = (String)customData.get((Object)"flipGas");
            if (flipStr.equals("true")) {
                flip = true;
            } else if (flipStr.equals("false")) {
                flip = false;
            } else {
                throw new IllegalArgumentException(String.format("DynBucket custom data \"flipGas\" must have value 'true' or 'false' (was '%s')", flipStr));
            }
        }
        return new ModelDynBucket(this.baseLocation, this.liquidLocation, this.coverLocation, fluid, flip);
    }

    @Override
    public ModelDynBucket retexture(ImmutableMap<String, String> textures) {
        nf base = this.baseLocation;
        nf liquid = this.liquidLocation;
        nf cover = this.coverLocation;
        if (textures.containsKey((Object)"base")) {
            base = new nf((String)textures.get((Object)"base"));
        }
        if (textures.containsKey((Object)"fluid")) {
            liquid = new nf((String)textures.get((Object)"fluid"));
        }
        if (textures.containsKey((Object)"cover")) {
            cover = new nf((String)textures.get((Object)"cover"));
        }
        return new ModelDynBucket(base, liquid, cover, this.fluid, this.flipGas);
    }

    private static final class BakedDynBucket
    implements cfy {
        private final ModelDynBucket parent;
        private final Map<String, cfy> cache;
        private final ImmutableMap<bwc.b, TRSRTransformation> transforms;
        private final ImmutableList<bvp> quads;
        private final cdq particle;
        private final cea format;

        public BakedDynBucket(ModelDynBucket parent, ImmutableList<bvp> quads, cdq particle, cea format, ImmutableMap<bwc.b, TRSRTransformation> transforms, Map<String, cfy> cache) {
            this.quads = quads;
            this.particle = particle;
            this.format = format;
            this.parent = parent;
            this.transforms = transforms;
            this.cache = cache;
        }

        public bwa f() {
            return BakedDynBucketOverrideHandler.INSTANCE;
        }

        public Pair<? extends cfy, Matrix4f> handlePerspective(bwc.b cameraTransformType) {
            return PerspectiveMapWrapper.handlePerspective((cfy)this, this.transforms, cameraTransformType);
        }

        public List<bvp> a(@Nullable awt state, @Nullable fa side, long rand) {
            if (side == null) {
                return this.quads;
            }
            return ImmutableList.of();
        }

        public boolean a() {
            return true;
        }

        public boolean b() {
            return false;
        }

        public boolean c() {
            return false;
        }

        public cdq d() {
            return this.particle;
        }
    }

    private static final class BakedDynBucketOverrideHandler
    extends bwa {
        public static final BakedDynBucketOverrideHandler INSTANCE = new BakedDynBucketOverrideHandler();

        private BakedDynBucketOverrideHandler() {
            super((List)ImmutableList.of());
        }

        public cfy handleItemState(cfy originalModel, aip stack, @Nullable amu world, @Nullable vp entity) {
            FluidStack fluidStack = FluidUtil.getFluidContained(stack);
            if (fluidStack == null) {
                return originalModel;
            }
            BakedDynBucket model = (BakedDynBucket)originalModel;
            Fluid fluid = fluidStack.getFluid();
            String name = fluid.getName();
            if (!model.cache.containsKey(name)) {
                IModel parent = model.parent.process(ImmutableMap.of((Object)"fluid", (Object)name));
                Function<nf, cdq> textureGetter = location -> bib.z().R().a(location.toString());
                cfy bakedModel = parent.bake(new SimpleModelState((ImmutableMap<? extends IModelPart, TRSRTransformation>)model.transforms), model.format, textureGetter);
                model.cache.put(name, bakedModel);
                return bakedModel;
            }
            return (cfy)model.cache.get(name);
        }
    }

    public static enum LoaderDynBucket implements ICustomModelLoader
    {
        INSTANCE;


        @Override
        public boolean accepts(nf modelLocation) {
            return modelLocation.b().equals("forge") && modelLocation.a().contains("forgebucket");
        }

        @Override
        public IModel loadModel(nf modelLocation) {
            return MODEL;
        }

        public void a(cep resourceManager) {
        }
    }
}

