/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common;

import com.google.common.collect.Lists;
import com.google.common.collect.Queues;
import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraftforge.common.ForgeModContainer;
import net.minecraftforge.common.ISpecialArmor;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.event.AnvilUpdateEvent;
import net.minecraftforge.event.DifficultyChangeEvent;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.ServerChatEvent;
import net.minecraftforge.event.entity.EntityTravelToDimensionEvent;
import net.minecraftforge.event.entity.ThrowableImpactEvent;
import net.minecraftforge.event.entity.item.ItemTossEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.LivingSetAttackTargetEvent;
import net.minecraftforge.event.entity.living.LootingLevelEvent;
import net.minecraftforge.event.entity.player.AnvilRepairEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.CriticalHitEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.NoteBlockEvent;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.LoaderState;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.network.handshake.NetworkDispatcher;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryManager;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;

public class ForgeHooks {
    static final List<SeedEntry> seedList = new ArrayList<SeedEntry>();
    private static boolean toolInit = false;
    static final Pattern URL_PATTERN;
    private static ThreadLocal<aed> craftingPlayer;
    private static ThreadLocal<Deque<LootTableContext>> lootContext;
    private static final ClassValue<String> registryNames;

    @Nonnull
    public static aip getGrassSeed(Random rand, int fortune) {
        if (seedList.size() == 0) {
            return aip.a;
        }
        SeedEntry entry = (SeedEntry)rs.a((Random)rand, seedList);
        if (entry == null || entry.seed.b()) {
            return aip.a;
        }
        return entry.getStack(rand, fortune);
    }

    public static boolean canHarvestBlock(@Nonnull aow block, @Nonnull aed player, @Nonnull amy world, @Nonnull et pos) {
        awt state = world.o(pos);
        if ((state = state.u().d(state, world, pos)).a().l()) {
            return true;
        }
        aip stack = player.co();
        String tool = block.getHarvestTool(state);
        if (stack.b() || tool == null) {
            return player.c(state);
        }
        int toolLevel = stack.c().getHarvestLevel(stack, tool, player, state);
        if (toolLevel < 0) {
            return player.c(state);
        }
        return toolLevel >= block.getHarvestLevel(state);
    }

    public static boolean canToolHarvestBlock(amy world, et pos, @Nonnull aip stack) {
        awt state = world.o(pos);
        state = state.u().d(state, world, pos);
        String tool = state.u().getHarvestTool(state);
        if (stack.b() || tool == null) {
            return false;
        }
        return stack.c().getHarvestLevel(stack, tool, null, null) >= state.u().getHarvestLevel(state);
    }

    public static float blockStrength(@Nonnull awt state, @Nonnull aed player, @Nonnull amu world, @Nonnull et pos) {
        float hardness = state.b(world, pos);
        if (hardness < 0.0f) {
            return 0.0f;
        }
        if (!ForgeHooks.canHarvestBlock(state.u(), player, (amy)world, pos)) {
            return player.getDigSpeed(state, pos) / hardness / 100.0f;
        }
        return player.getDigSpeed(state, pos) / hardness / 30.0f;
    }

    public static boolean isToolEffective(amy world, et pos, @Nonnull aip stack) {
        awt state = world.o(pos);
        state = state.u().d(state, world, pos);
        for (String type : stack.c().getToolClasses(stack)) {
            if (!state.u().isToolEffective(type, state)) continue;
            return true;
        }
        return false;
    }

    static void initTools() {
        aow[] oreBlocks;
        if (toolInit) {
            return;
        }
        toolInit = true;
        Set blocks = (Set)ReflectionHelper.getPrivateValue(ajb.class, null, 0);
        for (aow block : blocks) {
            block.setHarvestLevel("pickaxe", 0);
        }
        blocks = (Set)ReflectionHelper.getPrivateValue(ajn.class, null, 0);
        for (aow block : blocks) {
            block.setHarvestLevel("shovel", 0);
        }
        blocks = (Set)ReflectionHelper.getPrivateValue(agy.class, null, 0);
        for (aow block : blocks) {
            block.setHarvestLevel("axe", 0);
        }
        aox.Z.setHarvestLevel("pickaxe", 3);
        aox.bC.setHarvestLevel("pickaxe", 0);
        for (aow block : oreBlocks = new aow[]{aox.bP, aox.bT, aox.ag, aox.ah, aox.o, aox.R, aox.aC, aox.aD}) {
            block.setHarvestLevel("pickaxe", 2);
        }
        aox.p.setHarvestLevel("pickaxe", 1);
        aox.S.setHarvestLevel("pickaxe", 1);
        aox.x.setHarvestLevel("pickaxe", 1);
        aox.y.setHarvestLevel("pickaxe", 1);
        aox.co.setHarvestLevel("pickaxe", 0);
    }

    public static int getTotalArmorValue(aed player) {
        int ret = player.cg();
        for (int x = 0; x < player.bv.b.size(); ++x) {
            aip stack = (aip)player.bv.b.get(x);
            if (!(stack.c() instanceof ISpecialArmor)) continue;
            ret += ((ISpecialArmor)stack.c()).getArmorDisplay(player, stack, x);
        }
        return ret;
    }

    public static boolean onPickBlock(bhc target, aed player, amu world) {
        aip result;
        boolean isCreative = player.bO.d;
        avj te = null;
        if (target.a == bhc.a.b) {
            awt state = world.o(target.a());
            if (state.u().isAir(state, (amy)world, target.a())) {
                return false;
            }
            if (isCreative && blk.r() && state.u().hasTileEntity(state)) {
                te = world.r(target.a());
            }
            result = state.u().getPickBlock(state, target, world, target.a(), player);
        } else {
            if (target.a != bhc.a.c || target.d == null || !isCreative) {
                return false;
            }
            result = target.d.getPickedResult(target);
        }
        if (result.b()) {
            return false;
        }
        if (te != null) {
            bib.z().a(result, te);
        }
        if (isCreative) {
            player.bv.a(result);
            bib.z().c.a(player.b(ub.a), 36 + player.bv.d);
            return true;
        }
        int slot = player.bv.b(result);
        if (slot != -1) {
            if (aec.e((int)slot)) {
                player.bv.d = slot;
            } else {
                bib.z().c.a(slot);
            }
            return true;
        }
        return false;
    }

    public static void onDifficultyChange(tz difficulty, tz oldDifficulty) {
        MinecraftForge.EVENT_BUS.post(new DifficultyChangeEvent(difficulty, oldDifficulty));
    }

    public static void onLivingSetAttackTarget(vp entity, vp target) {
        MinecraftForge.EVENT_BUS.post(new LivingSetAttackTargetEvent(entity, target));
    }

    public static boolean onLivingUpdate(vp entity) {
        return MinecraftForge.EVENT_BUS.post(new LivingEvent.LivingUpdateEvent(entity));
    }

    public static boolean onLivingAttack(vp entity, ur src, float amount) {
        return !MinecraftForge.EVENT_BUS.post(new LivingAttackEvent(entity, src, amount));
    }

    public static float onLivingHurt(vp entity, ur src, float amount) {
        LivingHurtEvent event = new LivingHurtEvent(entity, src, amount);
        return MinecraftForge.EVENT_BUS.post(event) ? 0.0f : event.getAmount();
    }

    public static boolean onLivingDeath(vp entity, ur src) {
        return MinecraftForge.EVENT_BUS.post(new LivingDeathEvent(entity, src));
    }

    public static boolean onLivingDrops(vp entity, ur source, ArrayList<acl> drops, int lootingLevel, boolean recentlyHit) {
        return MinecraftForge.EVENT_BUS.post(new LivingDropsEvent(entity, source, drops, lootingLevel, recentlyHit));
    }

    @Nullable
    public static float[] onLivingFall(vp entity, float distance, float damageMultiplier) {
        float[] fArray;
        LivingFallEvent event = new LivingFallEvent(entity, distance, damageMultiplier);
        if (MinecraftForge.EVENT_BUS.post(event)) {
            fArray = null;
        } else {
            float[] fArray2 = new float[2];
            fArray2[0] = event.getDistance();
            fArray = fArray2;
            fArray2[1] = event.getDamageMultiplier();
        }
        return fArray;
    }

    public static int getLootingLevel(vg target, @Nullable vg killer, ur cause) {
        int looting = 0;
        if (killer instanceof vp) {
            looting = alm.g((vp)((vp)killer));
        }
        if (target instanceof vp) {
            looting = ForgeHooks.getLootingLevel((vp)target, cause, looting);
        }
        return looting;
    }

    public static int getLootingLevel(vp target, ur cause, int level) {
        LootingLevelEvent event = new LootingLevelEvent(target, cause, level);
        MinecraftForge.EVENT_BUS.post(event);
        return event.getLootingLevel();
    }

    public static double getPlayerVisibilityDistance(aed player, double xzDistance, double maxXZDistance) {
        PlayerEvent.Visibility event = new PlayerEvent.Visibility(player);
        MinecraftForge.EVENT_BUS.post(event);
        double value = event.getVisibilityModifier() * xzDistance;
        return value >= maxXZDistance ? maxXZDistance : value;
    }

    public static boolean isLivingOnLadder(@Nonnull awt state, @Nonnull amu world, @Nonnull et pos, @Nonnull vp entity) {
        boolean isSpectator;
        boolean bl = isSpectator = entity instanceof aed && ((aed)entity).y();
        if (isSpectator) {
            return false;
        }
        if (!ForgeModContainer.fullBoundingBoxLadders) {
            return state.u().isLadder(state, (amy)world, pos, entity);
        }
        bhb bb = entity.bw();
        int mX = rk.c((double)bb.a);
        int mY = rk.c((double)bb.b);
        int mZ = rk.c((double)bb.c);
        int y2 = mY;
        while ((double)y2 < bb.e) {
            int x2 = mX;
            while ((double)x2 < bb.d) {
                int z2 = mZ;
                while ((double)z2 < bb.f) {
                    et tmp = new et(x2, y2, z2);
                    state = world.o(tmp);
                    if (state.u().isLadder(state, (amy)world, tmp, entity)) {
                        return true;
                    }
                    ++z2;
                }
                ++x2;
            }
            ++y2;
        }
        return false;
    }

    public static void onLivingJump(vp entity) {
        MinecraftForge.EVENT_BUS.post(new LivingEvent.LivingJumpEvent(entity));
    }

    @Nullable
    public static acl onPlayerTossEvent(@Nonnull aed player, @Nonnull aip item, boolean includeName) {
        player.captureDrops = true;
        acl ret = player.a(item, false, includeName);
        player.capturedDrops.clear();
        player.captureDrops = false;
        if (ret == null) {
            return null;
        }
        ItemTossEvent event = new ItemTossEvent(ret, player);
        if (MinecraftForge.EVENT_BUS.post(event)) {
            return null;
        }
        if (!player.l.G) {
            player.e().a((vg)event.getEntityItem());
        }
        return event.getEntityItem();
    }

    public static float getEnchantPower(@Nonnull amu world, @Nonnull et pos) {
        return world.o(pos).u().getEnchantPowerBonus(world, pos);
    }

    @Nullable
    public static hh onServerChatEvent(pa net, String raw, hh comp) {
        ServerChatEvent event = new ServerChatEvent(net.b, raw, comp);
        if (MinecraftForge.EVENT_BUS.post(event)) {
            return null;
        }
        return event.getComponent();
    }

    public static hh newChatWithLinks(String string) {
        return ForgeHooks.newChatWithLinks(string, true);
    }

    public static hh newChatWithLinks(String string, boolean allowMissingHeader) {
        ho ichat = null;
        Matcher matcher = URL_PATTERN.matcher(string);
        int lastEnd = 0;
        while (matcher.find()) {
            ho link;
            String url;
            block13: {
                int start = matcher.start();
                int end = matcher.end();
                String part = string.substring(lastEnd, start);
                if (part.length() > 0) {
                    if (ichat == null) {
                        ichat = new ho(part);
                    } else {
                        ichat.a(part);
                    }
                }
                lastEnd = end;
                url = string.substring(start, end);
                link = new ho(url);
                try {
                    if (new URI(url).getScheme() != null) break block13;
                    if (!allowMissingHeader) {
                        if (ichat == null) {
                            ichat = new ho(url);
                            continue;
                        }
                        ichat.a(url);
                        continue;
                    }
                    url = "http://" + url;
                }
                catch (URISyntaxException e) {
                    if (ichat == null) {
                        ichat = new ho(url);
                        continue;
                    }
                    ichat.a(url);
                    continue;
                }
            }
            hg click = new hg(hg.a.a, url);
            link.b().a(click);
            link.b().d(Boolean.valueOf(true));
            link.b().a(a.j);
            if (ichat == null) {
                ichat = link;
                continue;
            }
            ichat.a((hh)link);
        }
        String end = string.substring(lastEnd);
        if (ichat == null) {
            ichat = new ho(end);
        } else if (end.length() > 0) {
            ichat.a(string.substring(lastEnd));
        }
        return ichat;
    }

    public static int onBlockBreakEvent(amu world, ams gameType, oq entityPlayer, et pos) {
        boolean preCancelEvent = false;
        aip itemstack = entityPlayer.co();
        if (gameType.d() && !itemstack.b() && !itemstack.c().canDestroyBlockInCreative(world, pos, itemstack, (aed)entityPlayer)) {
            preCancelEvent = true;
        }
        if (gameType.c()) {
            if (gameType == ams.e) {
                preCancelEvent = true;
            }
            if (!(entityPlayer.dk() || !itemstack.b() && itemstack.a(world.o(pos).u()))) {
                preCancelEvent = true;
            }
        }
        if (world.r(pos) == null) {
            ij packet = new ij(world, pos);
            packet.b = aox.a.t();
            entityPlayer.a.a((ht)packet);
        }
        awt state = world.o(pos);
        BlockEvent.BreakEvent event = new BlockEvent.BreakEvent(world, pos, state, (aed)entityPlayer);
        event.setCanceled(preCancelEvent);
        MinecraftForge.EVENT_BUS.post(event);
        if (event.isCanceled()) {
            ih pkt;
            entityPlayer.a.a((ht)new ij(world, pos));
            avj tileentity = world.r(pos);
            if (tileentity != null && (pkt = tileentity.c()) != null) {
                entityPlayer.a.a((ht)pkt);
            }
        }
        return event.isCanceled() ? -1 : event.getExpToDrop();
    }

    public static ud onPlaceItemIntoWorld(@Nonnull aip itemstack, @Nonnull aed player, @Nonnull amu world, @Nonnull et pos, @Nonnull fa side, float hitX, float hitY, float hitZ, @Nonnull ub hand) {
        int meta = itemstack.i();
        int size = itemstack.E();
        fy nbt = null;
        if (itemstack.p() != null) {
            nbt = itemstack.p().g();
        }
        if (!(itemstack.c() instanceof ahi)) {
            world.captureBlockSnapshots = true;
        }
        ud ret = itemstack.c().a(player, world, pos, hand, side, hitX, hitY, hitZ);
        world.captureBlockSnapshots = false;
        if (ret == ud.a) {
            int newMeta = itemstack.i();
            int newSize = itemstack.E();
            fy newNBT = null;
            if (itemstack.p() != null) {
                newNBT = itemstack.p().g();
            }
            BlockEvent.PlaceEvent placeEvent = null;
            List blockSnapshots = (List)world.capturedBlockSnapshots.clone();
            world.capturedBlockSnapshots.clear();
            itemstack.b(meta);
            itemstack.e(size);
            if (nbt != null) {
                itemstack.b(nbt);
            }
            if (blockSnapshots.size() > 1) {
                placeEvent = ForgeEventFactory.onPlayerMultiBlockPlace(player, blockSnapshots, side, hand);
            } else if (blockSnapshots.size() == 1) {
                placeEvent = ForgeEventFactory.onPlayerBlockPlace(player, (BlockSnapshot)blockSnapshots.get(0), side, hand);
            }
            if (placeEvent != null && placeEvent.isCanceled()) {
                ret = ud.c;
                for (BlockSnapshot blocksnapshot : Lists.reverse((List)blockSnapshots)) {
                    world.restoringBlockSnapshots = true;
                    blocksnapshot.restore(true, false);
                    world.restoringBlockSnapshots = false;
                }
            } else {
                itemstack.b(newMeta);
                itemstack.e(newSize);
                if (nbt != null) {
                    itemstack.b(newNBT);
                }
                for (BlockSnapshot snap : blockSnapshots) {
                    int updateFlag = snap.getFlag();
                    awt oldBlock = snap.getReplacedBlock();
                    awt newBlock = world.o(snap.getPos());
                    if (!newBlock.u().hasTileEntity(newBlock)) {
                        newBlock.u().c(world, snap.getPos(), newBlock);
                    }
                    world.markAndNotifyBlock(snap.getPos(), null, oldBlock, newBlock, updateFlag);
                }
                player.b(qs.b((ain)itemstack.c()));
            }
        }
        world.capturedBlockSnapshots.clear();
        return ret;
    }

    public static boolean onAnvilChange(afs container, @Nonnull aip left, @Nonnull aip right, tv outputSlot, String name, int baseCost) {
        AnvilUpdateEvent e = new AnvilUpdateEvent(left, right, name, baseCost);
        if (MinecraftForge.EVENT_BUS.post(e)) {
            return false;
        }
        if (e.getOutput().b()) {
            return true;
        }
        outputSlot.a(0, e.getOutput());
        container.a = e.getCost();
        container.k = e.getMaterialCost();
        return false;
    }

    public static float onAnvilRepair(aed player, @Nonnull aip output, @Nonnull aip left, @Nonnull aip right) {
        AnvilRepairEvent e = new AnvilRepairEvent(player, left, right, output);
        MinecraftForge.EVENT_BUS.post(e);
        return e.getBreakChance();
    }

    public static boolean onNoteChange(avz te, byte old) {
        NoteBlockEvent.Change e = new NoteBlockEvent.Change(te.D(), te.w(), te.D().o(te.w()), old, te.a);
        if (MinecraftForge.EVENT_BUS.post(e)) {
            te.a = old;
            return false;
        }
        te.a = (byte)e.getVanillaNoteId();
        return true;
    }

    public static fi<aip> defaultRecipeGetRemainingItems(afy inv) {
        fi ret = fi.a((int)inv.w_(), (Object)aip.a);
        for (int i2 = 0; i2 < ret.size(); ++i2) {
            ret.set(i2, (Object)ForgeHooks.getContainerItem(inv.a(i2)));
        }
        return ret;
    }

    public static void setCraftingPlayer(aed player) {
        craftingPlayer.set(player);
    }

    public static aed getCraftingPlayer() {
        return craftingPlayer.get();
    }

    @Nonnull
    public static aip getContainerItem(@Nonnull aip stack) {
        if (stack.c().hasContainerItem(stack)) {
            if (!(stack = stack.c().getContainerItem(stack)).b() && stack.f() && stack.j() > stack.k()) {
                ForgeEventFactory.onPlayerDestroyItem(craftingPlayer.get(), stack, null);
                return aip.a;
            }
            return stack;
        }
        return aip.a;
    }

    public static boolean isInsideOfMaterial(bcz material, vg entity, et pos) {
        awt state = entity.l.o(pos);
        aow block = state.u();
        double eyes = entity.q + (double)entity.by();
        double filled = 1.0;
        if (block instanceof IFluidBlock) {
            filled = ((IFluidBlock)block).getFilledPercentage(entity.l, pos);
        } else if (block instanceof aru) {
            filled = aru.b((int)block.e(state));
        }
        if (filled < 0.0) {
            return eyes > (double)(pos.q() + 1) + (1.0 - (filled *= -1.0));
        }
        return eyes < (double)(pos.q() + 1) + filled;
    }

    public static boolean onPlayerAttackTarget(aed player, vg target) {
        if (MinecraftForge.EVENT_BUS.post(new AttackEntityEvent(player, target))) {
            return false;
        }
        aip stack = player.co();
        return stack.b() || !stack.c().onLeftClickEntity(stack, player, target);
    }

    public static boolean onTravelToDimension(vg entity, int dimension) {
        EntityTravelToDimensionEvent event = new EntityTravelToDimensionEvent(entity, dimension);
        MinecraftForge.EVENT_BUS.post(event);
        if (event.isCanceled() && entity instanceof afh) {
            ((afh)entity).b = true;
        }
        return !event.isCanceled();
    }

    @Nullable
    public static bhc rayTraceEyes(vp entity, double length) {
        bhe startPos = new bhe(entity.p, entity.q + (double)entity.by(), entity.r);
        bhe endPos = startPos.e(new bhe(entity.aJ().b * length, entity.aJ().c * length, entity.aJ().d * length));
        return entity.l.a(startPos, endPos);
    }

    @Nullable
    public static bhe rayTraceEyeHitVec(vp entity, double length) {
        bhc git = ForgeHooks.rayTraceEyes(entity, length);
        return git == null ? null : git.c;
    }

    public static ud onInteractEntityAt(aed player, vg entity, bhc ray, ub hand) {
        bhe vec3d = new bhe(ray.c.b - entity.p, ray.c.c - entity.q, ray.c.d - entity.r);
        return ForgeHooks.onInteractEntityAt(player, entity, vec3d, hand);
    }

    public static ud onInteractEntityAt(aed player, vg entity, bhe vec3d, ub hand) {
        PlayerInteractEvent.EntityInteractSpecific evt = new PlayerInteractEvent.EntityInteractSpecific(player, hand, entity, vec3d);
        MinecraftForge.EVENT_BUS.post(evt);
        return evt.isCanceled() ? evt.getCancellationResult() : null;
    }

    public static ud onInteractEntity(aed player, vg entity, ub hand) {
        PlayerInteractEvent.EntityInteract evt = new PlayerInteractEvent.EntityInteract(player, hand, entity);
        MinecraftForge.EVENT_BUS.post(evt);
        return evt.isCanceled() ? evt.getCancellationResult() : null;
    }

    public static ud onItemRightClick(aed player, ub hand) {
        PlayerInteractEvent.RightClickItem evt = new PlayerInteractEvent.RightClickItem(player, hand);
        MinecraftForge.EVENT_BUS.post(evt);
        return evt.isCanceled() ? evt.getCancellationResult() : null;
    }

    public static PlayerInteractEvent.LeftClickBlock onLeftClickBlock(aed player, et pos, fa face, bhe hitVec) {
        PlayerInteractEvent.LeftClickBlock evt = new PlayerInteractEvent.LeftClickBlock(player, pos, face, hitVec);
        MinecraftForge.EVENT_BUS.post(evt);
        return evt;
    }

    public static PlayerInteractEvent.RightClickBlock onRightClickBlock(aed player, ub hand, et pos, fa face, bhe hitVec) {
        PlayerInteractEvent.RightClickBlock evt = new PlayerInteractEvent.RightClickBlock(player, hand, pos, face, hitVec);
        MinecraftForge.EVENT_BUS.post(evt);
        return evt;
    }

    public static void onEmptyClick(aed player, ub hand) {
        MinecraftForge.EVENT_BUS.post(new PlayerInteractEvent.RightClickEmpty(player, hand));
    }

    public static void onEmptyLeftClick(aed player) {
        MinecraftForge.EVENT_BUS.post(new PlayerInteractEvent.LeftClickEmpty(player));
    }

    private static LootTableContext getLootTableContext() {
        LootTableContext ctx = lootContext.get().peek();
        if (ctx == null) {
            throw new JsonParseException("Invalid call stack, could not grab json context!");
        }
        return ctx;
    }

    @Nullable
    public static bfs loadLootTable(Gson gson, nf name, String data, boolean custom, bfv lootTableManager) {
        ArrayDeque que = lootContext.get();
        if (que == null) {
            que = Queues.newArrayDeque();
            lootContext.set(que);
        }
        bfs ret = null;
        try {
            que.push(new LootTableContext(name, custom));
            ret = (bfs)gson.fromJson(data, bfs.class);
            que.pop();
        }
        catch (JsonParseException e) {
            que.pop();
            throw e;
        }
        if (!custom) {
            ret = ForgeEventFactory.loadLootTable(name, ret, lootTableManager);
        }
        if (ret != null) {
            ret.freeze();
        }
        return ret;
    }

    public static String readPoolName(JsonObject json) {
        LootTableContext ctx = ForgeHooks.getLootTableContext();
        ctx.resetPoolCtx();
        if (json.has("name")) {
            return rc.h((JsonObject)json, (String)"name");
        }
        if (ctx.custom) {
            return "custom#" + json.hashCode();
        }
        ++ctx.poolCount;
        if (!ctx.vanilla) {
            throw new JsonParseException("Loot Table \"" + ctx.name.toString() + "\" Missing `name` entry for pool #" + (ctx.poolCount - 1));
        }
        return ctx.poolCount == 1 ? "main" : "pool" + (ctx.poolCount - 1);
    }

    public static String readLootEntryName(JsonObject json, String type) {
        LootTableContext ctx = ForgeHooks.getLootTableContext();
        ++ctx.entryCount;
        if (json.has("entryName")) {
            return ctx.validateEntryName(rc.h((JsonObject)json, (String)"entryName"));
        }
        if (ctx.custom) {
            return "custom#" + json.hashCode();
        }
        String name = null;
        if ("item".equals(type)) {
            name = rc.h((JsonObject)json, (String)"name");
        } else if ("loot_table".equals(type)) {
            name = rc.h((JsonObject)json, (String)"name");
        } else if ("empty".equals(type)) {
            name = "empty";
        }
        return ctx.validateEntryName(name);
    }

    public static bfr deserializeJsonLootEntry(String type, JsonObject json, int weight, int quality, bgl[] conditions) {
        return null;
    }

    public static String getLootEntryType(bfr entry) {
        return null;
    }

    public static boolean onThrowableImpact(aev throwable, bhc ray) {
        return MinecraftForge.EVENT_BUS.post(new ThrowableImpactEvent(throwable, ray));
    }

    public static boolean onCropsGrowPre(amu worldIn, et pos, awt state, boolean def) {
        BlockEvent.CropGrowEvent.Pre ev = new BlockEvent.CropGrowEvent.Pre(worldIn, pos, state);
        MinecraftForge.EVENT_BUS.post(ev);
        return ev.getResult() == Event.Result.ALLOW || ev.getResult() == Event.Result.DEFAULT && def;
    }

    public static void onCropsGrowPost(amu worldIn, et pos, awt state, awt blockState) {
        MinecraftForge.EVENT_BUS.post(new BlockEvent.CropGrowEvent.Post(worldIn, pos, state, worldIn.o(pos)));
    }

    public static String getRegistryName(Class<? extends avj> type) {
        return registryNames.get(type);
    }

    public static boolean loadAdvancements(Map<nf, i.a> map) {
        boolean errored = false;
        ForgeHooks.setActiveModContainer(null);
        for (ModContainer mod : Loader.instance().getActiveModList()) {
            errored |= !ForgeHooks.loadAdvancements(map, mod);
        }
        ForgeHooks.setActiveModContainer(null);
        return errored;
    }

    @Nullable
    public static CriticalHitEvent getCriticalHit(aed player, vg target, boolean vanillaCritical, float damageModifier) {
        CriticalHitEvent hitResult = new CriticalHitEvent(player, target, damageModifier, vanillaCritical);
        MinecraftForge.EVENT_BUS.post(hitResult);
        if (hitResult.getResult() == Event.Result.ALLOW || vanillaCritical && hitResult.getResult() == Event.Result.DEFAULT) {
            return hitResult;
        }
        return null;
    }

    private static void setActiveModContainer(ModContainer mod) {
        if (Loader.instance().getLoaderState() != LoaderState.NOINIT) {
            Loader.instance().setActiveModContainer(mod);
        }
    }

    private static boolean loadAdvancements(Map<nf, i.a> map, ModContainer mod) {
        return CraftingHelper.findFiles(mod, "assets/" + mod.getModId() + "/advancements", null, (root, file) -> {
            String relative = root.relativize((Path)file).toString();
            if (!"json".equals(FilenameUtils.getExtension((String)file.toString())) || relative.startsWith("_")) {
                return true;
            }
            String name = FilenameUtils.removeExtension((String)relative).replaceAll("\\\\", "/");
            nf key = new nf(mod.getModId(), name);
            if (!map.containsKey(key)) {
                BufferedReader reader = null;
                try {
                    reader = Files.newBufferedReader(file);
                    i.a builder = (i.a)rc.a((Gson)ns.b, (Reader)reader, i.a.class);
                    map.put(key, builder);
                }
                catch (JsonParseException jsonparseexception) {
                    FMLLog.log.error("Parsing error loading built-in advancement " + key, (Throwable)jsonparseexception);
                    Boolean bl = false;
                    return bl;
                }
                catch (IOException ioexception) {
                    FMLLog.log.error("Couldn't read advancement " + key + " from " + file, (Throwable)ioexception);
                    Boolean bl = false;
                    return bl;
                }
                finally {
                    IOUtils.closeQuietly((Reader)reader);
                }
            }
            return true;
        }, true, true);
    }

    public static void sendRecipeBook(pa connection, js.a state, List<akt> recipes, List<akt> display, boolean isGuiOpen, boolean isFilteringCraftable) {
        NetworkDispatcher.ConnectionType type;
        NetworkDispatcher disp = NetworkDispatcher.get(connection.a());
        NetworkDispatcher.ConnectionType connectionType = type = disp == null || disp.getConnectionType() == null ? NetworkDispatcher.ConnectionType.MODDED : disp.getConnectionType();
        if (type == NetworkDispatcher.ConnectionType.VANILLA) {
            IForgeRegistry<akt> vanilla = RegistryManager.VANILLA.getRegistry(akt.class);
            if (recipes.size() > 0) {
                recipes = recipes.stream().filter(e -> vanilla.containsValue((akt)e)).collect(Collectors.toList());
            }
            if (display.size() > 0) {
                display = display.stream().filter(e -> vanilla.containsValue((akt)e)).collect(Collectors.toList());
            }
        }
        if (recipes.size() > 0 || display.size() > 0) {
            connection.a((ht)new js(state, recipes, display, isGuiOpen, isFilteringCraftable));
        }
    }

    static {
        seedList.add(new SeedEntry(new aip(air.Q), 10){

            @Override
            @Nonnull
            public aip getStack(Random rand, int fortune) {
                return new aip(air.Q, 1 + rand.nextInt(fortune * 2 + 1));
            }
        });
        ForgeHooks.initTools();
        URL_PATTERN = Pattern.compile("((?:[a-z0-9]{2,}:\\/\\/)?(?:(?:[0-9]{1,3}\\.){3}[0-9]{1,3}|(?:[-\\w_]{1,}\\.[a-z]{2,}?))(?::[0-9]{1,5})?.*?(?=[!\"\u00a7 \n]|$))", 2);
        craftingPlayer = new ThreadLocal();
        lootContext = new ThreadLocal();
        registryNames = new ClassValue<String>(){

            @Override
            protected String computeValue(Class<?> type) {
                return String.valueOf(avj.a(type));
            }
        };
    }

    private static class LootTableContext {
        public final nf name;
        private final boolean vanilla;
        public final boolean custom;
        public int poolCount = 0;
        public int entryCount = 0;
        private HashSet<String> entryNames = Sets.newHashSet();

        private LootTableContext(nf name, boolean custom) {
            this.name = name;
            this.custom = custom;
            this.vanilla = "minecraft".equals(this.name.b());
        }

        private void resetPoolCtx() {
            this.entryCount = 0;
            this.entryNames.clear();
        }

        public String validateEntryName(@Nullable String name) {
            if (name != null && !this.entryNames.contains(name)) {
                this.entryNames.add(name);
                return name;
            }
            if (!this.vanilla) {
                throw new JsonParseException("Loot Table \"" + this.name.toString() + "\" Duplicate entry name \"" + name + "\" for pool #" + (this.poolCount - 1) + " entry #" + (this.entryCount - 1));
            }
            int x = 0;
            while (this.entryNames.contains(name + "#" + x)) {
                ++x;
            }
            name = name + "#" + x;
            this.entryNames.add(name);
            return name;
        }
    }

    static class SeedEntry
    extends rs.a {
        @Nonnull
        public final aip seed;

        public SeedEntry(@Nonnull aip seed, int weight) {
            super(weight);
            this.seed = seed;
        }

        @Nonnull
        public aip getStack(Random rand, int fortune) {
            return this.seed.l();
        }
    }
}

