/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common;

import java.util.ArrayList;
import java.util.List;

public class WorldWorkerManager {
    private static List<IWorker> workers = new ArrayList<IWorker>();
    private static long startTime = -1L;

    public static void tick(boolean start) {
        if (start) {
            startTime = System.currentTimeMillis();
            return;
        }
        IWorker task = WorldWorkerManager.getNext();
        if (task == null) {
            return;
        }
        long time = 50L - (System.currentTimeMillis() - startTime);
        if (time < 10L) {
            time = 10L;
        }
        time += System.currentTimeMillis();
        while (System.currentTimeMillis() < time) {
            task.work();
            if (task.hasWork()) continue;
            time = 0L;
            WorldWorkerManager.remove(task);
        }
    }

    public static synchronized void addWorker(IWorker worker) {
        workers.add(worker);
    }

    private static synchronized IWorker getNext() {
        return workers.size() > 0 ? workers.get(0) : null;
    }

    private static synchronized void remove(IWorker worker) {
        workers.remove(worker);
    }

    public static synchronized void clear() {
        workers.clear();
    }

    public static interface IWorker {
        public boolean hasWork();

        public void work();
    }
}

