/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common.capabilities;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.function.Function;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.discovery.ASMDataTable;
import org.objectweb.asm.Type;

public enum CapabilityManager {
    INSTANCE;

    private IdentityHashMap<String, Capability<?>> providers = Maps.newIdentityHashMap();
    private IdentityHashMap<String, List<Function<Capability<?>, Object>>> callbacks = Maps.newIdentityHashMap();

    public <T> void register(Class<T> type, Capability.IStorage<T> storage, Class<? extends T> implementation) {
        Preconditions.checkArgument((implementation != null ? 1 : 0) != 0, (Object)"Attempted to register a capability with no default implementation");
        this.register(type, storage, () -> {
            try {
                return implementation.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new RuntimeException(e);
            }
        });
    }

    public <T> void register(Class<T> type, Capability.IStorage<T> storage, Callable<? extends T> factory) {
        Preconditions.checkArgument((type != null ? 1 : 0) != 0, (Object)"Attempted to register a capability with invalid type");
        Preconditions.checkArgument((storage != null ? 1 : 0) != 0, (Object)"Attempted to register a capability with no storage implementation");
        Preconditions.checkArgument((factory != null ? 1 : 0) != 0, (Object)"Attempted to register a capability with no default implementation factory");
        String realName = type.getName().intern();
        Preconditions.checkState((!this.providers.containsKey(realName) ? 1 : 0) != 0, (String)"Can not register a capability implementation multiple times: %s", (Object)realName);
        Capability<? extends T> cap = new Capability<T>(realName, storage, factory);
        this.providers.put(realName, cap);
        List<Function<Capability<?>, Object>> list = this.callbacks.get(realName);
        if (list != null) {
            for (Function<Capability<?>, Object> func : list) {
                func.apply(cap);
            }
        }
    }

    public void injectCapabilities(ASMDataTable data) {
        for (ASMDataTable.ASMData entry : data.getAll(CapabilityInject.class.getName())) {
            final String targetClass = entry.getClassName();
            final String targetName = entry.getObjectName();
            Type type = (Type)entry.getAnnotationInfo().get("value");
            if (type == null) {
                FMLLog.log.warn("Unable to inject capability at {}.{} (Invalid Annotation)", (Object)targetClass, (Object)targetName);
                continue;
            }
            final String capabilityName = type.getInternalName().replace('/', '.').intern();
            List list = this.callbacks.computeIfAbsent(capabilityName, k -> Lists.newArrayList());
            if (entry.getObjectName().indexOf(40) > 0) {
                list.add(new Function<Capability<?>, Object>(){

                    @Override
                    public Object apply(Capability<?> input) {
                        try {
                            for (Method mtd : Class.forName(targetClass).getDeclaredMethods()) {
                                if (!targetName.equals(mtd.getName() + Type.getMethodDescriptor((Method)mtd))) continue;
                                if ((mtd.getModifiers() & 8) != 8) {
                                    FMLLog.log.warn("Unable to inject capability {} at {}.{} (Non-Static)", (Object)capabilityName, (Object)targetClass, (Object)targetName);
                                    return null;
                                }
                                mtd.setAccessible(true);
                                mtd.invoke(null, input);
                                return null;
                            }
                            FMLLog.log.warn("Unable to inject capability {} at {}.{} (Method Not Found)", (Object)capabilityName, (Object)targetClass, (Object)targetName);
                        }
                        catch (Exception e) {
                            FMLLog.log.warn("Unable to inject capability {} at {}.{}", (Object)capabilityName, (Object)targetClass, (Object)targetName, (Object)e);
                        }
                        return null;
                    }
                });
                continue;
            }
            list.add(new Function<Capability<?>, Object>(){

                @Override
                public Object apply(Capability<?> input) {
                    try {
                        Field field = Class.forName(targetClass).getDeclaredField(targetName);
                        if ((field.getModifiers() & 8) != 8) {
                            FMLLog.log.warn("Unable to inject capability {} at {}.{} (Non-Static)", (Object)capabilityName, (Object)targetClass, (Object)targetName);
                            return null;
                        }
                        EnumHelper.setFailsafeFieldValue(field, null, input);
                    }
                    catch (Exception e) {
                        FMLLog.log.warn("Unable to inject capability {} at {}.{}", (Object)capabilityName, (Object)targetClass, (Object)targetName, (Object)e);
                    }
                    return null;
                }
            });
        }
    }
}

